// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/overlay.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace Overlay {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Overlay";
const char Metainfo::commandPrefix[] = "Overlay.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(GridHighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("areaBorderColor", m_areaBorderColor),
    CRDTP_DESERIALIZE_FIELD_OPT("cellBorderColor", m_cellBorderColor),
    CRDTP_DESERIALIZE_FIELD_OPT("cellBorderDash", m_cellBorderDash),
    CRDTP_DESERIALIZE_FIELD_OPT("columnGapColor", m_columnGapColor),
    CRDTP_DESERIALIZE_FIELD_OPT("columnHatchColor", m_columnHatchColor),
    CRDTP_DESERIALIZE_FIELD_OPT("columnLineColor", m_columnLineColor),
    CRDTP_DESERIALIZE_FIELD_OPT("columnLineDash", m_columnLineDash),
    CRDTP_DESERIALIZE_FIELD_OPT("gridBackgroundColor", m_gridBackgroundColor),
    CRDTP_DESERIALIZE_FIELD_OPT("gridBorderColor", m_gridBorderColor),
    CRDTP_DESERIALIZE_FIELD_OPT("gridBorderDash", m_gridBorderDash),
    CRDTP_DESERIALIZE_FIELD_OPT("rowGapColor", m_rowGapColor),
    CRDTP_DESERIALIZE_FIELD_OPT("rowHatchColor", m_rowHatchColor),
    CRDTP_DESERIALIZE_FIELD_OPT("rowLineColor", m_rowLineColor),
    CRDTP_DESERIALIZE_FIELD_OPT("rowLineDash", m_rowLineDash),
    CRDTP_DESERIALIZE_FIELD_OPT("showAreaNames", m_showAreaNames),
    CRDTP_DESERIALIZE_FIELD_OPT("showGridExtensionLines", m_showGridExtensionLines),
    CRDTP_DESERIALIZE_FIELD_OPT("showLineNames", m_showLineNames),
    CRDTP_DESERIALIZE_FIELD_OPT("showNegativeLineNumbers", m_showNegativeLineNumbers),
    CRDTP_DESERIALIZE_FIELD_OPT("showPositiveLineNumbers", m_showPositiveLineNumbers),
    CRDTP_DESERIALIZE_FIELD_OPT("showTrackSizes", m_showTrackSizes),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(GridHighlightConfig)
    CRDTP_SERIALIZE_FIELD("showGridExtensionLines", m_showGridExtensionLines);
    CRDTP_SERIALIZE_FIELD("showPositiveLineNumbers", m_showPositiveLineNumbers);
    CRDTP_SERIALIZE_FIELD("showNegativeLineNumbers", m_showNegativeLineNumbers);
    CRDTP_SERIALIZE_FIELD("showAreaNames", m_showAreaNames);
    CRDTP_SERIALIZE_FIELD("showLineNames", m_showLineNames);
    CRDTP_SERIALIZE_FIELD("showTrackSizes", m_showTrackSizes);
    CRDTP_SERIALIZE_FIELD("gridBorderColor", m_gridBorderColor);
    CRDTP_SERIALIZE_FIELD("cellBorderColor", m_cellBorderColor);
    CRDTP_SERIALIZE_FIELD("rowLineColor", m_rowLineColor);
    CRDTP_SERIALIZE_FIELD("columnLineColor", m_columnLineColor);
    CRDTP_SERIALIZE_FIELD("gridBorderDash", m_gridBorderDash);
    CRDTP_SERIALIZE_FIELD("cellBorderDash", m_cellBorderDash);
    CRDTP_SERIALIZE_FIELD("rowLineDash", m_rowLineDash);
    CRDTP_SERIALIZE_FIELD("columnLineDash", m_columnLineDash);
    CRDTP_SERIALIZE_FIELD("rowGapColor", m_rowGapColor);
    CRDTP_SERIALIZE_FIELD("rowHatchColor", m_rowHatchColor);
    CRDTP_SERIALIZE_FIELD("columnGapColor", m_columnGapColor);
    CRDTP_SERIALIZE_FIELD("columnHatchColor", m_columnHatchColor);
    CRDTP_SERIALIZE_FIELD("areaBorderColor", m_areaBorderColor);
    CRDTP_SERIALIZE_FIELD("gridBackgroundColor", m_gridBackgroundColor);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FlexContainerHighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("columnGapSpace", m_columnGapSpace),
    CRDTP_DESERIALIZE_FIELD_OPT("containerBorder", m_containerBorder),
    CRDTP_DESERIALIZE_FIELD_OPT("crossAlignment", m_crossAlignment),
    CRDTP_DESERIALIZE_FIELD_OPT("crossDistributedSpace", m_crossDistributedSpace),
    CRDTP_DESERIALIZE_FIELD_OPT("itemSeparator", m_itemSeparator),
    CRDTP_DESERIALIZE_FIELD_OPT("lineSeparator", m_lineSeparator),
    CRDTP_DESERIALIZE_FIELD_OPT("mainDistributedSpace", m_mainDistributedSpace),
    CRDTP_DESERIALIZE_FIELD_OPT("rowGapSpace", m_rowGapSpace),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FlexContainerHighlightConfig)
    CRDTP_SERIALIZE_FIELD("containerBorder", m_containerBorder);
    CRDTP_SERIALIZE_FIELD("lineSeparator", m_lineSeparator);
    CRDTP_SERIALIZE_FIELD("itemSeparator", m_itemSeparator);
    CRDTP_SERIALIZE_FIELD("mainDistributedSpace", m_mainDistributedSpace);
    CRDTP_SERIALIZE_FIELD("crossDistributedSpace", m_crossDistributedSpace);
    CRDTP_SERIALIZE_FIELD("rowGapSpace", m_rowGapSpace);
    CRDTP_SERIALIZE_FIELD("columnGapSpace", m_columnGapSpace);
    CRDTP_SERIALIZE_FIELD("crossAlignment", m_crossAlignment);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FlexItemHighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("baseSizeBorder", m_baseSizeBorder),
    CRDTP_DESERIALIZE_FIELD_OPT("baseSizeBox", m_baseSizeBox),
    CRDTP_DESERIALIZE_FIELD_OPT("flexibilityArrow", m_flexibilityArrow),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FlexItemHighlightConfig)
    CRDTP_SERIALIZE_FIELD("baseSizeBox", m_baseSizeBox);
    CRDTP_SERIALIZE_FIELD("baseSizeBorder", m_baseSizeBorder);
    CRDTP_SERIALIZE_FIELD("flexibilityArrow", m_flexibilityArrow);
CRDTP_END_SERIALIZER();



const char* LineStyle::PatternEnum::Dashed = "dashed";
const char* LineStyle::PatternEnum::Dotted = "dotted";
CRDTP_BEGIN_DESERIALIZER(LineStyle)
    CRDTP_DESERIALIZE_FIELD_OPT("color", m_color),
    CRDTP_DESERIALIZE_FIELD_OPT("pattern", m_pattern),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LineStyle)
    CRDTP_SERIALIZE_FIELD("color", m_color);
    CRDTP_SERIALIZE_FIELD("pattern", m_pattern);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(BoxStyle)
    CRDTP_DESERIALIZE_FIELD_OPT("fillColor", m_fillColor),
    CRDTP_DESERIALIZE_FIELD_OPT("hatchColor", m_hatchColor),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BoxStyle)
    CRDTP_SERIALIZE_FIELD("fillColor", m_fillColor);
    CRDTP_SERIALIZE_FIELD("hatchColor", m_hatchColor);
CRDTP_END_SERIALIZER();


namespace ContrastAlgorithmEnum {
const char Aa[] = "aa";
const char Aaa[] = "aaa";
const char Apca[] = "apca";
} // namespace ContrastAlgorithmEnum


CRDTP_BEGIN_DESERIALIZER(HighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("borderColor", m_borderColor),
    CRDTP_DESERIALIZE_FIELD_OPT("colorFormat", m_colorFormat),
    CRDTP_DESERIALIZE_FIELD_OPT("containerQueryContainerHighlightConfig", m_containerQueryContainerHighlightConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("contentColor", m_contentColor),
    CRDTP_DESERIALIZE_FIELD_OPT("contrastAlgorithm", m_contrastAlgorithm),
    CRDTP_DESERIALIZE_FIELD_OPT("cssGridColor", m_cssGridColor),
    CRDTP_DESERIALIZE_FIELD_OPT("eventTargetColor", m_eventTargetColor),
    CRDTP_DESERIALIZE_FIELD_OPT("flexContainerHighlightConfig", m_flexContainerHighlightConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("flexItemHighlightConfig", m_flexItemHighlightConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("gridHighlightConfig", m_gridHighlightConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("marginColor", m_marginColor),
    CRDTP_DESERIALIZE_FIELD_OPT("paddingColor", m_paddingColor),
    CRDTP_DESERIALIZE_FIELD_OPT("shapeColor", m_shapeColor),
    CRDTP_DESERIALIZE_FIELD_OPT("shapeMarginColor", m_shapeMarginColor),
    CRDTP_DESERIALIZE_FIELD_OPT("showAccessibilityInfo", m_showAccessibilityInfo),
    CRDTP_DESERIALIZE_FIELD_OPT("showExtensionLines", m_showExtensionLines),
    CRDTP_DESERIALIZE_FIELD_OPT("showInfo", m_showInfo),
    CRDTP_DESERIALIZE_FIELD_OPT("showRulers", m_showRulers),
    CRDTP_DESERIALIZE_FIELD_OPT("showStyles", m_showStyles),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(HighlightConfig)
    CRDTP_SERIALIZE_FIELD("showInfo", m_showInfo);
    CRDTP_SERIALIZE_FIELD("showStyles", m_showStyles);
    CRDTP_SERIALIZE_FIELD("showRulers", m_showRulers);
    CRDTP_SERIALIZE_FIELD("showAccessibilityInfo", m_showAccessibilityInfo);
    CRDTP_SERIALIZE_FIELD("showExtensionLines", m_showExtensionLines);
    CRDTP_SERIALIZE_FIELD("contentColor", m_contentColor);
    CRDTP_SERIALIZE_FIELD("paddingColor", m_paddingColor);
    CRDTP_SERIALIZE_FIELD("borderColor", m_borderColor);
    CRDTP_SERIALIZE_FIELD("marginColor", m_marginColor);
    CRDTP_SERIALIZE_FIELD("eventTargetColor", m_eventTargetColor);
    CRDTP_SERIALIZE_FIELD("shapeColor", m_shapeColor);
    CRDTP_SERIALIZE_FIELD("shapeMarginColor", m_shapeMarginColor);
    CRDTP_SERIALIZE_FIELD("cssGridColor", m_cssGridColor);
    CRDTP_SERIALIZE_FIELD("colorFormat", m_colorFormat);
    CRDTP_SERIALIZE_FIELD("gridHighlightConfig", m_gridHighlightConfig);
    CRDTP_SERIALIZE_FIELD("flexContainerHighlightConfig", m_flexContainerHighlightConfig);
    CRDTP_SERIALIZE_FIELD("flexItemHighlightConfig", m_flexItemHighlightConfig);
    CRDTP_SERIALIZE_FIELD("contrastAlgorithm", m_contrastAlgorithm);
    CRDTP_SERIALIZE_FIELD("containerQueryContainerHighlightConfig", m_containerQueryContainerHighlightConfig);
CRDTP_END_SERIALIZER();


namespace ColorFormatEnum {
const char Rgb[] = "rgb";
const char Hsl[] = "hsl";
const char Hwb[] = "hwb";
const char Hex[] = "hex";
} // namespace ColorFormatEnum


CRDTP_BEGIN_DESERIALIZER(ContainerQueryContainerHighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("containerBorder", m_containerBorder),
    CRDTP_DESERIALIZE_FIELD_OPT("descendantBorder", m_descendantBorder),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ContainerQueryContainerHighlightConfig)
    CRDTP_SERIALIZE_FIELD("containerBorder", m_containerBorder);
    CRDTP_SERIALIZE_FIELD("descendantBorder", m_descendantBorder);
CRDTP_END_SERIALIZER();


namespace InspectModeEnum {
const char SearchForNode[] = "searchForNode";
const char SearchForUAShadowDOM[] = "searchForUAShadowDOM";
const char CaptureAreaScreenshot[] = "captureAreaScreenshot";
const char None[] = "none";
} // namespace InspectModeEnum


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::InspectNodeRequested(int backendNodeId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("backendNodeId"), backendNodeId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Overlay.inspectNodeRequested", serializer.Finish()));
}

void Frontend::NodeHighlightRequested(int nodeId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Overlay.nodeHighlightRequested", serializer.Finish()));
}

void Frontend::ScreenshotRequested(std::unique_ptr<protocol::Page::Viewport> viewport)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("viewport"), viewport);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Overlay.screenshotRequested", serializer.Finish()));
}

void Frontend::InspectModeCanceled()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Overlay.inspectModeCanceled"));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void setInspectMode(const crdtp::Dispatchable& dispatchable);
    void setPausedInDebuggerMessage(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("setInspectMode"),
          &DomainDispatcherImpl::setInspectMode
    },
    {
          crdtp::SpanFrom("setPausedInDebuggerMessage"),
          &DomainDispatcherImpl::setPausedInDebuggerMessage
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct setInspectModeParams : public crdtp::DeserializableProtocolObject<setInspectModeParams> {
    String mode;
    std::unique_ptr<protocol::Overlay::HighlightConfig> highlightConfig;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setInspectModeParams)
    CRDTP_DESERIALIZE_FIELD_OPT("highlightConfig", highlightConfig),
    CRDTP_DESERIALIZE_FIELD("mode", mode),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setInspectMode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setInspectModeParams params;
    if (!setInspectModeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetInspectMode(params.mode, std::move(params.highlightConfig));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setInspectMode"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setPausedInDebuggerMessageParams : public crdtp::DeserializableProtocolObject<setPausedInDebuggerMessageParams> {
    std::optional<String> message;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setPausedInDebuggerMessageParams)
    CRDTP_DESERIALIZE_FIELD_OPT("message", message),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setPausedInDebuggerMessage(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setPausedInDebuggerMessageParams params;
    if (!setPausedInDebuggerMessageParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetPausedInDebuggerMessage(std::move(params.message));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setPausedInDebuggerMessage"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Overlay"), SortedRedirects(), std::move(dispatcher));
}

} // Overlay
} // namespace content
} // namespace protocol
