// components/services/storage/public/mojom/service_worker_storage_control.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-shared-internal.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom-shared.h"
#include "components/services/storage/public/mojom/storage_policy_update.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace storage::mojom {
class ServiceWorkerLiveVersionInfoDataView;

class ServiceWorkerFindRegistrationResultDataView;

class ServiceWorkerUserDataDataView;



}  // storage::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::ServiceWorkerLiveVersionInfoDataView> {
  using Data = ::storage::mojom::internal::ServiceWorkerLiveVersionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::ServiceWorkerFindRegistrationResultDataView> {
  using Data = ::storage::mojom::internal::ServiceWorkerFindRegistrationResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::ServiceWorkerUserDataDataView> {
  using Data = ::storage::mojom::internal::ServiceWorkerUserData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {


enum class ServiceWorkerStorageStorageKeyState : int32_t {
  
  kKeep = 0,
  
  kDelete = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ServiceWorkerStorageStorageKeyState value);
inline bool IsKnownEnumValue(ServiceWorkerStorageStorageKeyState value) {
  return internal::ServiceWorkerStorageStorageKeyState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ServiceWorkerLiveVersionRefInterfaceBase {};

using ServiceWorkerLiveVersionRefPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerLiveVersionRefInterfaceBase>;
using ServiceWorkerLiveVersionRefRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerLiveVersionRefInterfaceBase>;
using ServiceWorkerLiveVersionRefAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerLiveVersionRefInterfaceBase>;
using ServiceWorkerLiveVersionRefAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerLiveVersionRefInterfaceBase>;
class ServiceWorkerResourceReaderInterfaceBase {};

using ServiceWorkerResourceReaderPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerResourceReaderInterfaceBase>;
using ServiceWorkerResourceReaderRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerResourceReaderInterfaceBase>;
using ServiceWorkerResourceReaderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerResourceReaderInterfaceBase>;
using ServiceWorkerResourceReaderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerResourceReaderInterfaceBase>;
class ServiceWorkerResourceWriterInterfaceBase {};

using ServiceWorkerResourceWriterPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerResourceWriterInterfaceBase>;
using ServiceWorkerResourceWriterRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerResourceWriterInterfaceBase>;
using ServiceWorkerResourceWriterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerResourceWriterInterfaceBase>;
using ServiceWorkerResourceWriterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerResourceWriterInterfaceBase>;
class ServiceWorkerResourceMetadataWriterInterfaceBase {};

using ServiceWorkerResourceMetadataWriterPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerResourceMetadataWriterInterfaceBase>;
using ServiceWorkerResourceMetadataWriterRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerResourceMetadataWriterInterfaceBase>;
using ServiceWorkerResourceMetadataWriterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerResourceMetadataWriterInterfaceBase>;
using ServiceWorkerResourceMetadataWriterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerResourceMetadataWriterInterfaceBase>;
class ServiceWorkerStorageControlInterfaceBase {};

using ServiceWorkerStorageControlPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerStorageControlInterfaceBase>;
using ServiceWorkerStorageControlRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerStorageControlInterfaceBase>;
using ServiceWorkerStorageControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerStorageControlInterfaceBase>;
using ServiceWorkerStorageControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerStorageControlInterfaceBase>;


class ServiceWorkerLiveVersionInfoDataView {
 public:
  ServiceWorkerLiveVersionInfoDataView() = default;

  ServiceWorkerLiveVersionInfoDataView(
      internal::ServiceWorkerLiveVersionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetPurgeableResourcesDataView(
      mojo::ArrayDataView<int64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPurgeableResources(UserType* output) {
    
    auto* pointer = data_->purgeable_resources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int64_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReference() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::storage::mojom::ServiceWorkerLiveVersionRefInterfaceBase>>(
            &data_->reference, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ServiceWorkerLiveVersionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerFindRegistrationResultDataView {
 public:
  ServiceWorkerFindRegistrationResultDataView() = default;

  ServiceWorkerFindRegistrationResultDataView(
      internal::ServiceWorkerFindRegistrationResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeVersionReference() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::storage::mojom::ServiceWorkerLiveVersionRefInterfaceBase>>(
            &data_->version_reference, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetRegistrationDataView(
      ::storage::mojom::ServiceWorkerRegistrationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistration(UserType* output) {
    
    auto* pointer = data_->registration.Get();
    return mojo::internal::Deserialize<::storage::mojom::ServiceWorkerRegistrationDataDataView>(
        pointer, output, message_);
  }
  inline void GetResourcesDataView(
      mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResources(UserType* output) {
    
    auto* pointer = data_->resources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerFindRegistrationResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerUserDataDataView {
 public:
  ServiceWorkerUserDataDataView() = default;

  ServiceWorkerUserDataDataView(
      internal::ServiceWorkerUserData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t registration_id() const {
    return data_->registration_id;
  }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerUserData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_DATA_VIEW_H_