// components/paint_preview/common/mojom/paint_preview_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/paint_preview/common/mojom/paint_preview_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-params-data.h"
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared-message-ids.h"

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-import-headers.h"
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-test-utils.h"


namespace paint_preview::mojom {
SerializedRecordingPtr
SerializedRecording::NewFile(
    ::base::File value) {
  return SerializedRecordingPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFile)>,
      std::move(value));
}

SerializedRecordingPtr
SerializedRecording::NewBuffer(
    ::mojo_base::BigBuffer value) {
  return SerializedRecordingPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBuffer)>,
      std::move(value));
}

SerializedRecording::SerializedRecording(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    ::base::File value)
    : tag_(Tag::kFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFile)>,
            std::move(value)) {}

SerializedRecording::SerializedRecording(
    std::in_place_index_t<static_cast<size_t>(Tag::kBuffer)>,
    ::mojo_base::BigBuffer value)
    : tag_(Tag::kBuffer),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBuffer)>,
            std::move(value)) {}
SerializedRecording::~SerializedRecording() {
  DestroyActive();
}

void SerializedRecording::set_file(::base::File file) {
  if (tag_ == Tag::kFile) {
    data_.file = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::kFile;
    new (&data_.file) ::base::File(
        std::move(file));
  }
}

void SerializedRecording::set_buffer(::mojo_base::BigBuffer buffer) {
  if (tag_ == Tag::kBuffer) {
    data_.buffer = std::move(buffer);
  } else {
    DestroyActive();
    tag_ = Tag::kBuffer;
    new (&data_.buffer) ::mojo_base::BigBuffer(
        std::move(buffer));
  }
}


SerializedRecording::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    ::base::File value)
    : file(std::move(value)) {}

SerializedRecording::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBuffer)>,
    ::mojo_base::BigBuffer value)
    : buffer(std::move(value)) {}

void SerializedRecording::DestroyActive() {
  switch (tag_) {

    case Tag::kFile:
      std::destroy_at(&data_.file);
      break;
    case Tag::kBuffer:
      std::destroy_at(&data_.buffer);
      break;
  }
}

bool SerializedRecording::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // paint_preview::mojom


namespace mojo {

// static
bool UnionTraits<::paint_preview::mojom::SerializedRecording::DataView, ::paint_preview::mojom::SerializedRecordingPtr>::Read(
    ::paint_preview::mojom::SerializedRecording::DataView input,
    ::paint_preview::mojom::SerializedRecordingPtr* output) {
  using UnionType = ::paint_preview::mojom::SerializedRecording;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFile: {
      ::base::File result_file{};
      if (!input.ReadFile(&result_file))
        return false;

      *output = UnionType::NewFile(
          std::move(result_file));
      break;
    }
    case Tag::kBuffer: {
      ::mojo_base::BigBuffer result_buffer{};
      if (!input.ReadBuffer(&result_buffer))
        return false;

      *output = UnionType::NewBuffer(
          std::move(result_buffer));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace paint_preview::mojom {




}  // paint_preview::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif