// components/download/public/common/download_stream.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_DATA_VIEW_H_
#define COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/download/public/common/download_stream.mojom-shared-internal.h"


namespace download::mojom {
class DownloadStreamHandleDataView;



}  // download::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::download::mojom::DownloadStreamHandleDataView> {
  using Data = ::download::mojom::internal::DownloadStreamHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace download::mojom {


enum class NetworkRequestStatus : int32_t {
  
  OK = 0,
  
  NETWORK_TIMEOUT = 1,
  
  NETWORK_DISCONNECTED = 2,
  
  NETWORK_SERVER_DOWN = 3,
  
  SERVER_NO_RANGE = 4,
  
  SERVER_CONTENT_LENGTH_MISMATCH = 5,
  
  SERVER_UNREACHABLE = 6,
  
  SERVER_CERT_PROBLEM = 7,
  
  USER_CANCELED = 8,
  
  NETWORK_FAILED = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(MOJOM_SHARED_COMPONENTS_DOWNLOAD_EXPORT) std::ostream& operator<<(std::ostream& os, NetworkRequestStatus value);
inline bool IsKnownEnumValue(NetworkRequestStatus value) {
  return internal::NetworkRequestStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DownloadStreamClientInterfaceBase {};

using DownloadStreamClientPtrDataView =
    mojo::InterfacePtrDataView<DownloadStreamClientInterfaceBase>;
using DownloadStreamClientRequestDataView =
    mojo::InterfaceRequestDataView<DownloadStreamClientInterfaceBase>;
using DownloadStreamClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DownloadStreamClientInterfaceBase>;
using DownloadStreamClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DownloadStreamClientInterfaceBase>;


class DownloadStreamHandleDataView {
 public:
  DownloadStreamHandleDataView() = default;

  DownloadStreamHandleDataView(
      internal::DownloadStreamHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedDataPipeConsumerHandle TakeStream() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::download::mojom::DownloadStreamClientInterfaceBase>>(
            &data_->client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::DownloadStreamHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // download::mojom

#endif  // COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_DATA_VIEW_H_