// components/autofill/content/common/mojom/autofill_driver.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/autofill/content/common/mojom/autofill_driver.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/autofill/content/common/mojom/autofill_driver.mojom-params-data.h"
namespace autofill {
namespace mojom {

namespace internal {


// static
bool AutofillDriver_FormsSeen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_FormsSeen_Params_Data* object =
      static_cast<const AutofillDriver_FormsSeen_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updated_forms, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& updated_forms_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->updated_forms, validation_context,
                                         &updated_forms_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->removed_forms, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& removed_forms_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->removed_forms, validation_context,
                                         &removed_forms_validate_params)) {
    return false;
  }

  return true;
}

AutofillDriver_FormsSeen_Params_Data::AutofillDriver_FormsSeen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_FormSubmitted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_FormSubmitted_Params_Data* object =
      static_cast<const AutofillDriver_FormSubmitted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;


  if (!::autofill::mojom::internal::SubmissionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

AutofillDriver_FormSubmitted_Params_Data::AutofillDriver_FormSubmitted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_CaretMovedInFormField_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_CaretMovedInFormField_Params_Data* object =
      static_cast<const AutofillDriver_CaretMovedInFormField_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->caret_bounds, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->caret_bounds, validation_context))
    return false;

  return true;
}

AutofillDriver_CaretMovedInFormField_Params_Data::AutofillDriver_CaretMovedInFormField_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_TextFieldValueChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_TextFieldValueChanged_Params_Data* object =
      static_cast<const AutofillDriver_TextFieldValueChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  return true;
}

AutofillDriver_TextFieldValueChanged_Params_Data::AutofillDriver_TextFieldValueChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_DidEndTextFieldEditing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_DidEndTextFieldEditing_Params_Data* object =
      static_cast<const AutofillDriver_DidEndTextFieldEditing_Params_Data*>(data);

  return true;
}

AutofillDriver_DidEndTextFieldEditing_Params_Data::AutofillDriver_DidEndTextFieldEditing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_TextFieldDidScroll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_TextFieldDidScroll_Params_Data* object =
      static_cast<const AutofillDriver_TextFieldDidScroll_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_id, validation_context))
    return false;

  return true;
}

AutofillDriver_TextFieldDidScroll_Params_Data::AutofillDriver_TextFieldDidScroll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_SelectControlSelectionChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_SelectControlSelectionChanged_Params_Data* object =
      static_cast<const AutofillDriver_SelectControlSelectionChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_id, validation_context))
    return false;

  return true;
}

AutofillDriver_SelectControlSelectionChanged_Params_Data::AutofillDriver_SelectControlSelectionChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_SelectFieldOptionsDidChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_SelectFieldOptionsDidChange_Params_Data* object =
      static_cast<const AutofillDriver_SelectFieldOptionsDidChange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;

  return true;
}

AutofillDriver_SelectFieldOptionsDidChange_Params_Data::AutofillDriver_SelectFieldOptionsDidChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_FocusOnFormField_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_FocusOnFormField_Params_Data* object =
      static_cast<const AutofillDriver_FocusOnFormField_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_id, validation_context))
    return false;

  return true;
}

AutofillDriver_FocusOnFormField_Params_Data::AutofillDriver_FocusOnFormField_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_FocusOnNonFormField_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_FocusOnNonFormField_Params_Data* object =
      static_cast<const AutofillDriver_FocusOnNonFormField_Params_Data*>(data);

  return true;
}

AutofillDriver_FocusOnNonFormField_Params_Data::AutofillDriver_FocusOnNonFormField_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_AskForValuesToFill_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_AskForValuesToFill_Params_Data* object =
      static_cast<const AutofillDriver_AskForValuesToFill_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->caret_bounds, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->caret_bounds, validation_context))
    return false;


  if (!::autofill::mojom::internal::AutofillSuggestionTriggerSource_Data
        ::Validate(object->trigger_source, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->password_request, validation_context))
    return false;

  return true;
}

AutofillDriver_AskForValuesToFill_Params_Data::AutofillDriver_AskForValuesToFill_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_HidePopup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_HidePopup_Params_Data* object =
      static_cast<const AutofillDriver_HidePopup_Params_Data*>(data);

  return true;
}

AutofillDriver_HidePopup_Params_Data::AutofillDriver_HidePopup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_DidFillAutofillFormData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_DidFillAutofillFormData_Params_Data* object =
      static_cast<const AutofillDriver_DidFillAutofillFormData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  return true;
}

AutofillDriver_DidFillAutofillFormData_Params_Data::AutofillDriver_DidFillAutofillFormData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillDriver_JavaScriptChangedAutofilledValue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillDriver_JavaScriptChangedAutofilledValue_Params_Data* object =
      static_cast<const AutofillDriver_JavaScriptChangedAutofilledValue_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->old_value, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->old_value, validation_context))
    return false;

  return true;
}

AutofillDriver_JavaScriptChangedAutofilledValue_Params_Data::AutofillDriver_JavaScriptChangedAutofilledValue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_PasswordFormsParsed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_PasswordFormsParsed_Params_Data* object =
      static_cast<const PasswordManagerDriver_PasswordFormsParsed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->forms_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& forms_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->forms_data, validation_context,
                                         &forms_data_validate_params)) {
    return false;
  }

  return true;
}

PasswordManagerDriver_PasswordFormsParsed_Params_Data::PasswordManagerDriver_PasswordFormsParsed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_PasswordFormsRendered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_PasswordFormsRendered_Params_Data* object =
      static_cast<const PasswordManagerDriver_PasswordFormsRendered_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_forms_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& visible_forms_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->visible_forms_data, validation_context,
                                         &visible_forms_data_validate_params)) {
    return false;
  }

  return true;
}

PasswordManagerDriver_PasswordFormsRendered_Params_Data::PasswordManagerDriver_PasswordFormsRendered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_PasswordFormSubmitted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_PasswordFormSubmitted_Params_Data* object =
      static_cast<const PasswordManagerDriver_PasswordFormSubmitted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  return true;
}

PasswordManagerDriver_PasswordFormSubmitted_Params_Data::PasswordManagerDriver_PasswordFormSubmitted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_InformAboutUserInput_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_InformAboutUserInput_Params_Data* object =
      static_cast<const PasswordManagerDriver_InformAboutUserInput_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  return true;
}

PasswordManagerDriver_InformAboutUserInput_Params_Data::PasswordManagerDriver_InformAboutUserInput_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_DynamicFormSubmission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_DynamicFormSubmission_Params_Data* object =
      static_cast<const PasswordManagerDriver_DynamicFormSubmission_Params_Data*>(data);


  if (!::autofill::mojom::internal::SubmissionIndicatorEvent_Data
        ::Validate(object->submission_indication_event, validation_context))
    return false;

  return true;
}

PasswordManagerDriver_DynamicFormSubmission_Params_Data::PasswordManagerDriver_DynamicFormSubmission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_PasswordFormCleared_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_PasswordFormCleared_Params_Data* object =
      static_cast<const PasswordManagerDriver_PasswordFormCleared_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  return true;
}

PasswordManagerDriver_PasswordFormCleared_Params_Data::PasswordManagerDriver_PasswordFormCleared_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_RecordSavePasswordProgress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_RecordSavePasswordProgress_Params_Data* object =
      static_cast<const PasswordManagerDriver_RecordSavePasswordProgress_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->log, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& log_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->log, validation_context,
                                         &log_validate_params)) {
    return false;
  }

  return true;
}

PasswordManagerDriver_RecordSavePasswordProgress_Params_Data::PasswordManagerDriver_RecordSavePasswordProgress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_UserModifiedPasswordField_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_UserModifiedPasswordField_Params_Data* object =
      static_cast<const PasswordManagerDriver_UserModifiedPasswordField_Params_Data*>(data);

  return true;
}

PasswordManagerDriver_UserModifiedPasswordField_Params_Data::PasswordManagerDriver_UserModifiedPasswordField_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_UserModifiedNonPasswordField_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_UserModifiedNonPasswordField_Params_Data* object =
      static_cast<const PasswordManagerDriver_UserModifiedNonPasswordField_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

PasswordManagerDriver_UserModifiedNonPasswordField_Params_Data::PasswordManagerDriver_UserModifiedNonPasswordField_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_ShowPasswordSuggestions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_ShowPasswordSuggestions_Params_Data* object =
      static_cast<const PasswordManagerDriver_ShowPasswordSuggestions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

PasswordManagerDriver_ShowPasswordSuggestions_Params_Data::PasswordManagerDriver_ShowPasswordSuggestions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_CheckSafeBrowsingReputation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_CheckSafeBrowsingReputation_Params_Data* object =
      static_cast<const PasswordManagerDriver_CheckSafeBrowsingReputation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_action, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_url, validation_context))
    return false;

  return true;
}

PasswordManagerDriver_CheckSafeBrowsingReputation_Params_Data::PasswordManagerDriver_CheckSafeBrowsingReputation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_FocusedInputChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_FocusedInputChanged_Params_Data* object =
      static_cast<const PasswordManagerDriver_FocusedInputChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->focused_field_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->focused_field_id, validation_context))
    return false;


  if (!::autofill::mojom::internal::FocusedFieldType_Data
        ::Validate(object->focused_field_type, validation_context))
    return false;

  return true;
}

PasswordManagerDriver_FocusedInputChanged_Params_Data::PasswordManagerDriver_FocusedInputChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordManagerDriver_LogFirstFillingResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordManagerDriver_LogFirstFillingResult_Params_Data* object =
      static_cast<const PasswordManagerDriver_LogFirstFillingResult_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_renderer_id, validation_context))
    return false;

  return true;
}

PasswordManagerDriver_LogFirstFillingResult_Params_Data::PasswordManagerDriver_LogFirstFillingResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordGenerationDriver_AutomaticGenerationAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordGenerationDriver_AutomaticGenerationAvailable_Params_Data* object =
      static_cast<const PasswordGenerationDriver_AutomaticGenerationAvailable_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_generation_ui_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_generation_ui_data, validation_context))
    return false;

  return true;
}

PasswordGenerationDriver_AutomaticGenerationAvailable_Params_Data::PasswordGenerationDriver_AutomaticGenerationAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordGenerationDriver_PresaveGeneratedPassword_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordGenerationDriver_PresaveGeneratedPassword_Params_Data* object =
      static_cast<const PasswordGenerationDriver_PresaveGeneratedPassword_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_value, validation_context))
    return false;

  return true;
}

PasswordGenerationDriver_PresaveGeneratedPassword_Params_Data::PasswordGenerationDriver_PresaveGeneratedPassword_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordGenerationDriver_PasswordNoLongerGenerated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordGenerationDriver_PasswordNoLongerGenerated_Params_Data* object =
      static_cast<const PasswordGenerationDriver_PasswordNoLongerGenerated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  return true;
}

PasswordGenerationDriver_PasswordNoLongerGenerated_Params_Data::PasswordGenerationDriver_PasswordNoLongerGenerated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordGenerationDriver_ShowPasswordEditingPopup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordGenerationDriver_ShowPasswordEditingPopup_Params_Data* object =
      static_cast<const PasswordGenerationDriver_ShowPasswordEditingPopup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_renderer_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_value, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_value, validation_context))
    return false;

  return true;
}

PasswordGenerationDriver_ShowPasswordEditingPopup_Params_Data::PasswordGenerationDriver_ShowPasswordEditingPopup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordGenerationDriver_PasswordGenerationRejectedByTyping_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordGenerationDriver_PasswordGenerationRejectedByTyping_Params_Data* object =
      static_cast<const PasswordGenerationDriver_PasswordGenerationRejectedByTyping_Params_Data*>(data);

  return true;
}

PasswordGenerationDriver_PasswordGenerationRejectedByTyping_Params_Data::PasswordGenerationDriver_PasswordGenerationRejectedByTyping_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordGenerationDriver_FrameWasScrolled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordGenerationDriver_FrameWasScrolled_Params_Data* object =
      static_cast<const PasswordGenerationDriver_FrameWasScrolled_Params_Data*>(data);

  return true;
}

PasswordGenerationDriver_FrameWasScrolled_Params_Data::PasswordGenerationDriver_FrameWasScrolled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordGenerationDriver_GenerationElementLostFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordGenerationDriver_GenerationElementLostFocus_Params_Data* object =
      static_cast<const PasswordGenerationDriver_GenerationElementLostFocus_Params_Data*>(data);

  return true;
}

PasswordGenerationDriver_GenerationElementLostFocus_Params_Data::PasswordGenerationDriver_GenerationElementLostFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace autofill