// components/services/storage/public/mojom/cache_storage_control.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/storage/public/mojom/cache_storage_control.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/cache_storage_control.mojom-params-data.h"
namespace storage {
namespace mojom {

NOINLINE static const char* CacheStorageOwnerToStringHelper(CacheStorageOwner value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CacheStorageOwner::kCacheAPI:
      return "kCacheAPI";
    case CacheStorageOwner::kBackgroundFetch:
      return "kBackgroundFetch";
    default:
      return nullptr;
  }
}

std::string CacheStorageOwnerToString(CacheStorageOwner value) {
  const char *str = CacheStorageOwnerToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CacheStorageOwner value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CacheStorageOwner value) {
  return os << CacheStorageOwnerToString(value);
}

namespace internal {


// static
bool CacheStorageObserver_OnCacheListChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageObserver_OnCacheListChanged_Params_Data* object =
      static_cast<const CacheStorageObserver_OnCacheListChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bucket_locator, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bucket_locator, validation_context))
    return false;

  return true;
}

CacheStorageObserver_OnCacheListChanged_Params_Data::CacheStorageObserver_OnCacheListChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageObserver_OnCacheContentChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageObserver_OnCacheContentChanged_Params_Data* object =
      static_cast<const CacheStorageObserver_OnCacheContentChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bucket_locator, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bucket_locator, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cache_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cache_name, validation_context,
                                         &cache_name_validate_params)) {
    return false;
  }

  return true;
}

CacheStorageObserver_OnCacheContentChanged_Params_Data::CacheStorageObserver_OnCacheContentChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageControl_AddReceiver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageControl_AddReceiver_Params_Data* object =
      static_cast<const CacheStorageControl_AddReceiver_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cross_origin_embedder_policy, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cross_origin_embedder_policy, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->coep_reporter,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_isolation_policy, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_isolation_policy, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->dip_reporter,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bucket_locator, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bucket_locator, validation_context))
    return false;


  if (!::storage::mojom::internal::CacheStorageOwner_Data
        ::Validate(object->owner, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CacheStorageControl_AddReceiver_Params_Data::CacheStorageControl_AddReceiver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageControl_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageControl_AddObserver_Params_Data* object =
      static_cast<const CacheStorageControl_AddObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CacheStorageControl_AddObserver_Params_Data::CacheStorageControl_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageControl_ApplyPolicyUpdates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageControl_ApplyPolicyUpdates_Params_Data* object =
      static_cast<const CacheStorageControl_ApplyPolicyUpdates_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_updates, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& policy_updates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->policy_updates, validation_context,
                                         &policy_updates_validate_params)) {
    return false;
  }

  return true;
}

CacheStorageControl_ApplyPolicyUpdates_Params_Data::CacheStorageControl_ApplyPolicyUpdates_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage

namespace perfetto {

// static
void TraceFormatTraits<::storage::mojom::CacheStorageOwner>::WriteIntoTrace(
   perfetto::TracedValue context, ::storage::mojom::CacheStorageOwner value) {
  return std::move(context).WriteString(::storage::mojom::CacheStorageOwnerToString(value));
}

} // namespace perfetto