
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "tabwidget_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

// Wrappers
#include "tabstackedwidget_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_TabWidget_Type = nullptr;
static PyTypeObject *Sbk_TabWidget_TypeF(void)
{
    return _Sbk_TabWidget_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void TabWidgetWrapper::pysideInitQtMetaTypes()
{
}

void TabWidgetWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

TabWidgetWrapper::TabWidgetWrapper(::BrowserWindow * window, ::QWidget * parent) : TabWidget(window, parent)
{
}

void TabWidgetWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabWidget", funcName, gil, pyOverride, signal);
}

void TabWidgetWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("TabWidget", funcName, gil, pyOverride, event);
}

int TabWidgetWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("TabWidget", funcName, gil, pyOverride);
}

void TabWidgetWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabWidget", funcName, gil, pyOverride, signal);
}

void TabWidgetWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("TabWidget", funcName, gil, pyOverride, event);
}

bool TabWidgetWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return WebViewWrapper::sbk_o_event("TabWidget", funcName, gil, pyOverride, event);
}

bool TabWidgetWrapper::eventFilter(::QObject * obj, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabStackedWidget::eventFilter(obj, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("TabWidget", funcName, gil, pyOverride, obj, event);
}

void TabWidgetWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("TabWidget", funcName, gil, pyOverride, event);
}

bool TabWidgetWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("TabWidget", funcName, gil, pyOverride, next);
}

void TabWidgetWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("TabWidget", funcName, gil, pyOverride, event);
}

bool TabWidgetWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("TabWidget", funcName, gil, pyOverride);
}

int TabWidgetWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("TabWidget", funcName, gil, pyOverride, arg__1);
}

void TabWidgetWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("TabWidget", funcName, gil, pyOverride, painter);
}

void TabWidgetWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("TabWidget", funcName, gil, pyOverride, event);
}

::QVariant TabWidgetWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("TabWidget", funcName, gil, pyOverride, arg__1);
}

void TabWidgetWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("TabWidget", funcName, gil, pyOverride, event);
}

int TabWidgetWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("TabWidget", funcName, gil, pyOverride, arg__1);
}

::QSize TabWidgetWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabWidget", funcName, gil, pyOverride);
}

void TabWidgetWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("TabWidget", funcName, gil, pyOverride, event);
}

bool TabWidgetWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("TabWidget", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * TabWidgetWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("TabWidget", funcName, gil, pyOverride);
}

void TabWidgetWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("TabWidget", funcName, gil, pyOverride, event);
}

::QPaintDevice * TabWidgetWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("TabWidget", funcName, gil, pyOverride, offset);
}

void TabWidgetWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("TabWidget", funcName, gil, pyOverride, visible);
}

::QPainter * TabWidgetWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("TabWidget", funcName, gil, pyOverride);
}

void TabWidgetWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("TabWidget", funcName, gil, pyOverride, event);
}

::QSize TabWidgetWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabWidget", funcName, gil, pyOverride);
}

void TabWidgetWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("TabWidget", funcName, gil, pyOverride, event);
}

void TabWidgetWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabWidget_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("TabWidget", funcName, gil, pyOverride, event);
}

const QMetaObject *TabWidgetWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return TabWidget::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int TabWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = TabWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *TabWidgetWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< TabWidgetWrapper *>(this));
    }
    return TabWidget::qt_metacast(_clname);
}

TabWidgetWrapper::~TabWidgetWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_TabWidget_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_TabWidget_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::TabWidget >()))
        return -1;

    TabWidgetWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:TabWidget", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: TabWidget::TabWidget(BrowserWindow*,QWidget*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // TabWidget(BrowserWindow*,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 0; // TabWidget(BrowserWindow*,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // TabWidget(BrowserWindow*,QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) TabWidgetWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new TabWidgetWrapper(cppArg0, cppArg1);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< TabWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
    };


    return 1;
}

static PyObject *Sbk_TabWidgetFunc_addTabFromClipboard(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // addTabFromClipboard()
        cppSelf->addTabFromClipboard();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_addView(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[6];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 6));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addView", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOO:addView", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabWidget::addView(WebTab*,QFlags<Qz::NewTabPositionFlag>)->int
    // 1: TabWidget::addView(LoadRequest,QFlags<Qz::NewTabPositionFlag>,bool=,bool=)->int
    // 2: TabWidget::addView(LoadRequest,const QString&=,const QFlags<Qz::NewTabPositionFlag>&=,bool=,int=,bool=)->int
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // addView(LoadRequest,QString,QFlags<Qz::NewTabPositionFlag>,bool,int,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // addView(LoadRequest,QString,QFlags<Qz::NewTabPositionFlag>,bool,int,bool)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QFlags_Qz_NewTabPositionFlag_IDX])))->flagsConverter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // addView(LoadRequest,QString,QFlags<Qz::NewTabPositionFlag>,bool,int,bool)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 2; // addView(LoadRequest,QString,QFlags<Qz::NewTabPositionFlag>,bool,int,bool)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 2; // addView(LoadRequest,QString,QFlags<Qz::NewTabPositionFlag>,bool,int,bool)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[5])))) {
                            overloadId = 2; // addView(LoadRequest,QString,QFlags<Qz::NewTabPositionFlag>,bool,int,bool)
                        }
                    }
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QFlags_Qz_NewTabPositionFlag_IDX])))->flagsConverter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // addView(LoadRequest,QFlags<Qz::NewTabPositionFlag>,bool,bool)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // addView(LoadRequest,QFlags<Qz::NewTabPositionFlag>,bool,bool)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
                    overloadId = 1; // addView(LoadRequest,QFlags<Qz::NewTabPositionFlag>,bool,bool)
                }
            }
        }
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QFlags_Qz_NewTabPositionFlag_IDX])))->flagsConverter, (pyArgs[1])))) {
        overloadId = 0; // addView(WebTab*,QFlags<Qz::NewTabPositionFlag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addView", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addView(WebTab *tab, const QFlags<Qz::NewTabPositionFlag> &openFlags)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addView", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::WebTab *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<Qz::NewTabPositionFlag> cppArg1 = QFlags<Qz::NewTabPositionFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addView(WebTab*,QFlags<Qz::NewTabPositionFlag>)
                int cppResult = cppSelf->addView(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // addView(const LoadRequest &req, const QFlags<Qz::NewTabPositionFlag> &openFlags, bool selectLine, bool pinned)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"selectLine", 2}, {"pinned", 3}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "addView", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::LoadRequest cppArg0_local;
            ::LoadRequest *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QFlags<Qz::NewTabPositionFlag> cppArg1 = QFlags<Qz::NewTabPositionFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            bool cppArg2 = false;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            bool cppArg3 = false;
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addView(LoadRequest,QFlags<Qz::NewTabPositionFlag>,bool,bool)
                int cppResult = cppSelf->addView(*cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 2: // addView(const LoadRequest &req, const QString &title, const QFlags<Qz::NewTabPositionFlag> &openFlags, bool selectLine, int position, bool pinned)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[5] = {{"title", 1}, {"openFlags", 2}, {"selectLine", 3}, {"position", 4}, {"pinned", 5}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 5, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QFlags_Qz_NewTabPositionFlag_IDX])))->flagsConverter, (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                    || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[5]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "addView", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::LoadRequest cppArg0_local;
            ::LoadRequest *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1 = TabWidget::tr("New tab");
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qz::NewTabPositionFlag> cppArg2(Qz::NT_SelectedTab);
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            bool cppArg3 = false;
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);
            bool cppArg5 = false;
            if (pythonToCpp[5])
                pythonToCpp[5](pyArgs[5], &cppArg5);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addView(LoadRequest,QString,QFlags<Qz::NewTabPositionFlag>,bool,int,bool)
                int cppResult = cppSelf->addView(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_allTabs(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "allTabs", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    if (PyArg_ParseTuple(args, "|O:allTabs", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabWidget::allTabs(bool=)->QList<WebTab*>
    if (numArgs == 0) {
        overloadId = 0; // allTabs(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // allTabs(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "allTabs", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"withPinned", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "allTabs", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // allTabs(bool)
            QList<WebTab*> cppResult = cppSelf->allTabs(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_WebTabPTR_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_browserWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // browserWindow()const
        BrowserWindow * cppResult = const_cast<const TabWidgetWrapper *>(cppSelf)->browserWindow();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_buttonClosedTabs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // buttonClosedTabs()const
        ToolButton * cppResult = const_cast<const TabWidgetWrapper *>(cppSelf)->buttonClosedTabs();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_canRestoreTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // canRestoreTab()const
        bool cppResult = const_cast<const TabWidgetWrapper *>(cppSelf)->canRestoreTab();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_clearClosedTabsList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearClosedTabsList()
        cppSelf->clearClosedTabsList();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_closeAllButCurrent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::closeAllButCurrent(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // closeAllButCurrent(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "closeAllButCurrent", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // closeAllButCurrent(int)
            cppSelf->closeAllButCurrent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_closeTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "closeTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    if (PyArg_ParseTuple(args, "|O:closeTab", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabWidget::closeTab(int=)
    if (numArgs == 0) {
        overloadId = 0; // closeTab(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // closeTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "closeTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"index", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "closeTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // closeTab(int)
            cppSelf->closeTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_closeToLeft(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::closeToLeft(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // closeToLeft(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "closeToLeft", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // closeToLeft(int)
            cppSelf->closeToLeft(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_closeToRight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::closeToRight(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // closeToRight(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "closeToRight", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // closeToRight(int)
            cppSelf->closeToRight(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_currentTabChanged(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::currentTabChanged(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // currentTabChanged(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "currentTabChanged", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // currentTabChanged(int)
            cppSelf->currentTabChanged(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_detachTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::detachTab(WebTab*)
    // 1: TabWidget::detachTab(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // detachTab(int)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), (pyArg)))) {
        overloadId = 0; // detachTab(WebTab*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "detachTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // detachTab(WebTab *tab)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::WebTab *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // detachTab(WebTab*)
                cppSelf->detachTab(cppArg0);
            }
            break;
        }
        case 1: // detachTab(int index)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // detachTab(int)
                cppSelf->detachTab(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_duplicateTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::duplicateTab(int)->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // duplicateTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "duplicateTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // duplicateTab(int)
            int cppResult = cppSelf->duplicateTab(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_extraReservedWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // extraReservedWidth()const
        int cppResult = const_cast<const TabWidgetWrapper *>(cppSelf)->extraReservedWidth();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_insertView(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "insertView", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabWidget::insertView(int,WebTab*,QFlags<Qz::NewTabPositionFlag>)->int
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QFlags_Qz_NewTabPositionFlag_IDX])))->flagsConverter, (pyArgs[2])))) {
        overloadId = 0; // insertView(int,WebTab*,QFlags<Qz::NewTabPositionFlag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "insertView", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::WebTab *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<Qz::NewTabPositionFlag> cppArg2 = QFlags<Qz::NewTabPositionFlag>(0);
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // insertView(int,WebTab*,QFlags<Qz::NewTabPositionFlag>)
            int cppResult = cppSelf->insertView(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_isCurrentTabFresh(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isCurrentTabFresh()const
        bool cppResult = const_cast<const TabWidgetWrapper *>(cppSelf)->isCurrentTabFresh();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("keyPressEvent(QKeyEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_keyReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyReleaseEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyReleaseEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyReleaseEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("keyReleaseEvent(QKeyEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_loadTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::loadTab(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // loadTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "loadTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // loadTab(int)
            cppSelf->loadTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_locationBars(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // locationBars()const
        QStackedWidget * cppResult = const_cast<const TabWidgetWrapper *>(cppSelf)->locationBars();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStackedWidget_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_moveAddTabButton(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::moveAddTabButton(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // moveAddTabButton(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "moveAddTabButton", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // moveAddTabButton(int)
            cppSelf->moveAddTabButton(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_moveTab(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "moveTab", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabStackedWidget::moveTab(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // moveTab(int,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "moveTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // moveTab(int,int)
            cppSelf->moveTab(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_nextTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // nextTab()
        cppSelf->nextTab();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_normalTabsCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // normalTabsCount()const
        int cppResult = const_cast<const TabWidgetWrapper *>(cppSelf)->normalTabsCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_pinUnPinTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "pinUnPinTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    if (PyArg_ParseTuple(args, "|OO:pinUnPinTab", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabStackedWidget::pinUnPinTab(int,const QString&=)->int
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // pinUnPinTab(int,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // pinUnPinTab(int,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "pinUnPinTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"title", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "pinUnPinTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // pinUnPinTab(int,QString)
            int cppResult = cppSelf->pinUnPinTab(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_pinnedTabsCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pinnedTabsCount()const
        int cppResult = const_cast<const TabWidgetWrapper *>(cppSelf)->pinnedTabsCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_previousTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // previousTab()
        cppSelf->previousTab();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_reloadAllTabs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reloadAllTabs()
        cppSelf->reloadAllTabs();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_reloadTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::reloadTab(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // reloadTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "reloadTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // reloadTab(int)
            cppSelf->reloadTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_requestCloseTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "requestCloseTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    if (PyArg_ParseTuple(args, "|O:requestCloseTab", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabWidget::requestCloseTab(int=)
    if (numArgs == 0) {
        overloadId = 0; // requestCloseTab(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // requestCloseTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "requestCloseTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"index", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "requestCloseTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // requestCloseTab(int)
            cppSelf->requestCloseTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_restoreAllClosedTabs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // restoreAllClosedTabs()
        cppSelf->restoreAllClosedTabs();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_restoreClosedTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "restoreClosedTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    if (PyArg_ParseTuple(args, "|O:restoreClosedTab", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabWidget::restoreClosedTab(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // restoreClosedTab(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // restoreClosedTab(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "restoreClosedTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"obj", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "restoreClosedTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // restoreClosedTab(QObject*)
            cppSelf->restoreClosedTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_setCurrentIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabStackedWidget::setCurrentIndex(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentIndex(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentIndex", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentIndex(int)
            cppSelf->setCurrentIndex(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_setCurrentTabFresh(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::setCurrentTabFresh(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setCurrentTabFresh(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentTabFresh", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentTabFresh(bool)
            cppSelf->setCurrentTabFresh(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_stopTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::stopTab(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // stopTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "stopTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // stopTab(int)
            cppSelf->stopTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_tabBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabBar()const
        TabBar * cppResult = const_cast<const TabWidgetWrapper *>(cppSelf)->tabBar();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabWidgetFunc_tabBarOverFlowChanged(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::tabBarOverFlowChanged(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // tabBarOverFlowChanged(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabBarOverFlowChanged", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabBarOverFlowChanged(bool)
            cppSelf->tabBarOverFlowChanged(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_unloadTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabWidget::unloadTab(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // unloadTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unloadTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unloadTab(int)
            cppSelf->unloadTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabWidgetFunc_webTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabWidgetWrapper *>(reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "webTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    if (PyArg_ParseTuple(args, "|O:webTab", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabWidget::webTab(int=)const->WebTab*
    if (numArgs == 0) {
        overloadId = 0; // webTab(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // webTab(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "webTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"index", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "webTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]);
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // webTab(int)const
            WebTab * cppResult = const_cast<const TabWidgetWrapper *>(cppSelf)->webTab(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), cppResult);
            // Ownership transferences (return value heuristics).
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_TabWidget_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_TabWidget_methods[] = {
    {"addTabFromClipboard", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_addTabFromClipboard), METH_NOARGS, nullptr},
    {"addView", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_addView), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"allTabs", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_allTabs), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"browserWindow", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_browserWindow), METH_NOARGS, nullptr},
    {"buttonClosedTabs", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_buttonClosedTabs), METH_NOARGS, nullptr},
    {"canRestoreTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_canRestoreTab), METH_NOARGS, nullptr},
    {"clearClosedTabsList", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_clearClosedTabsList), METH_NOARGS, nullptr},
    {"closeAllButCurrent", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_closeAllButCurrent), METH_O, nullptr},
    {"closeTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_closeTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"closeToLeft", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_closeToLeft), METH_O, nullptr},
    {"closeToRight", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_closeToRight), METH_O, nullptr},
    {"currentTabChanged", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_currentTabChanged), METH_O, nullptr},
    {"detachTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_detachTab), METH_O, nullptr},
    {"duplicateTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_duplicateTab), METH_O, nullptr},
    {"extraReservedWidth", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_extraReservedWidth), METH_NOARGS, nullptr},
    {"insertView", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_insertView), METH_VARARGS, nullptr},
    {"isCurrentTabFresh", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_isCurrentTabFresh), METH_NOARGS, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_keyPressEvent), METH_O, nullptr},
    {"keyReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_keyReleaseEvent), METH_O, nullptr},
    {"loadTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_loadTab), METH_O, nullptr},
    {"locationBars", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_locationBars), METH_NOARGS, nullptr},
    {"moveAddTabButton", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_moveAddTabButton), METH_O, nullptr},
    {"moveTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_moveTab), METH_VARARGS, nullptr},
    {"nextTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_nextTab), METH_NOARGS, nullptr},
    {"normalTabsCount", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_normalTabsCount), METH_NOARGS, nullptr},
    {"pinUnPinTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_pinUnPinTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"pinnedTabsCount", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_pinnedTabsCount), METH_NOARGS, nullptr},
    {"previousTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_previousTab), METH_NOARGS, nullptr},
    {"reloadAllTabs", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_reloadAllTabs), METH_NOARGS, nullptr},
    {"reloadTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_reloadTab), METH_O, nullptr},
    {"requestCloseTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_requestCloseTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"restoreAllClosedTabs", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_restoreAllClosedTabs), METH_NOARGS, nullptr},
    {"restoreClosedTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_restoreClosedTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setCurrentIndex", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_setCurrentIndex), METH_O, nullptr},
    {"setCurrentTabFresh", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_setCurrentTabFresh), METH_O, nullptr},
    {"stopTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_stopTab), METH_O, nullptr},
    {"tabBar", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_tabBar), METH_NOARGS, nullptr},
    {"tabBarOverFlowChanged", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_tabBarOverFlowChanged), METH_O, nullptr},
    {"unloadTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_unloadTab), METH_O, nullptr},
    {"webTab", reinterpret_cast<PyCFunction>(Sbk_TabWidgetFunc_webTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_TabWidget_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::TabWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<TabWidgetWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_TabWidget_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_TabWidget_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_TabWidgetSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::TabWidget *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]))
        return static_cast< ::TabStackedWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_TabWidget_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_TabWidget_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_TabWidget_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_TabWidget_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_TabWidget_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_TabWidget_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_TabWidget_spec = {
    "1:PyFalkon.TabWidget",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_TabWidget_slots
};

} //extern "C"

static void *Sbk_TabWidget_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::TabWidget *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::TabWidget *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::TabWidget *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void TabWidget_PythonToCpp_TabWidget_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_TabWidget_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_TabWidget_PythonToCpp_TabWidget_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_TabWidget_TypeF()))
        return TabWidget_PythonToCpp_TabWidget_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *TabWidget_PTR_CppToPython_TabWidget(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::TabWidget *>(const_cast<void *>(cppIn)), Sbk_TabWidget_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *TabWidget_SignatureStrings[] = {
    "PyFalkon.TabWidget(self,window:PyFalkon.BrowserWindow,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.TabWidget.addTabFromClipboard(self)",
    "2:PyFalkon.TabWidget.addView(self,tab:PyFalkon.WebTab,openFlags:PyFalkon.Qz.NewTabPositionFlag)->int",
    "1:PyFalkon.TabWidget.addView(self,req:typing.Union[PyFalkon.LoadRequest, PySide6.QtCore.QUrl],openFlags:PyFalkon.Qz.NewTabPositionFlag,selectLine:bool=false,pinned:bool=false)->int",
    R"CPP(0:PyFalkon.TabWidget.addView(self,req:typing.Union[PyFalkon.LoadRequest, PySide6.QtCore.QUrl],title:QString=TabWidget.tr("New tab"),openFlags:PyFalkon.Qz.NewTabPositionFlag=Qz.NT_SelectedTab,selectLine:bool=false,position:int=-1,pinned:bool=false)->int)CPP",
    "PyFalkon.TabWidget.allTabs(self,withPinned:bool=true)->QList[PyFalkon.WebTab]",
    "PyFalkon.TabWidget.browserWindow(self)->PyFalkon.BrowserWindow",
    "PyFalkon.TabWidget.buttonClosedTabs(self)->PyFalkon.ToolButton",
    "PyFalkon.TabWidget.canRestoreTab(self)->bool",
    "PyFalkon.TabWidget.clearClosedTabsList(self)",
    "PyFalkon.TabWidget.closeAllButCurrent(self,index:int)",
    "PyFalkon.TabWidget.closeTab(self,index:int=-1)",
    "PyFalkon.TabWidget.closeToLeft(self,index:int)",
    "PyFalkon.TabWidget.closeToRight(self,index:int)",
    "PyFalkon.TabWidget.currentTabChanged(self,index:int)",
    "1:PyFalkon.TabWidget.detachTab(self,tab:PyFalkon.WebTab)",
    "0:PyFalkon.TabWidget.detachTab(self,index:int)",
    "PyFalkon.TabWidget.duplicateTab(self,index:int)->int",
    "PyFalkon.TabWidget.extraReservedWidth(self)->int",
    "PyFalkon.TabWidget.insertView(self,index:int,tab:PyFalkon.WebTab,openFlags:PyFalkon.Qz.NewTabPositionFlag)->int",
    "PyFalkon.TabWidget.isCurrentTabFresh(self)->bool",
    "PyFalkon.TabWidget.keyPressEvent(self,event:PySide6.QtGui.QKeyEvent)",
    "PyFalkon.TabWidget.keyReleaseEvent(self,event:PySide6.QtGui.QKeyEvent)",
    "PyFalkon.TabWidget.loadTab(self,index:int)",
    "PyFalkon.TabWidget.locationBars(self)->PySide6.QtWidgets.QStackedWidget",
    "PyFalkon.TabWidget.moveAddTabButton(self,posX:int)",
    "PyFalkon.TabWidget.moveTab(self,from:int,to:int)",
    "PyFalkon.TabWidget.nextTab(self)",
    "PyFalkon.TabWidget.normalTabsCount(self)->int",
    "PyFalkon.TabWidget.pinUnPinTab(self,index:int,title:QString=QString())->int",
    "PyFalkon.TabWidget.pinnedTabsCount(self)->int",
    "PyFalkon.TabWidget.previousTab(self)",
    "PyFalkon.TabWidget.reloadAllTabs(self)",
    "PyFalkon.TabWidget.reloadTab(self,index:int)",
    "PyFalkon.TabWidget.requestCloseTab(self,index:int=-1)",
    "PyFalkon.TabWidget.restoreAllClosedTabs(self)",
    "PyFalkon.TabWidget.restoreClosedTab(self,obj:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.TabWidget.setCurrentIndex(self,index:int)",
    "PyFalkon.TabWidget.setCurrentTabFresh(self,currentTabFresh:bool)",
    "PyFalkon.TabWidget.stopTab(self,index:int)",
    "PyFalkon.TabWidget.tabBar(self)->PyFalkon.TabBar",
    "PyFalkon.TabWidget.tabBarOverFlowChanged(self,overflowed:bool)",
    "PyFalkon.TabWidget.unloadTab(self,index:int)",
    "PyFalkon.TabWidget.webTab(self,index:int=-1)->PyFalkon.WebTab",
    nullptr}; // Sentinel
#else
static constexpr size_t TabWidget_SignatureByteSize = 734;
static constexpr uint8_t TabWidget_SignatureBytes[734] = {
    0x78, 0xda, 0xb5, 0x56, 0xdd, 0x4f, 0xdb, 0x30, 0x10, 0x7f, 0xef, 0x5f, 0x81, 0x78, 0x22, 0x52,
    0x88, 0xc6, 0x1e, 0xf6, 0x10, 0xa9, 0x48, 0x10, 0xad, 0xd3, 0xb4, 0x6a, 0x34, 0x2d, 0x1d, 0x93,
    0x10, 0x9a, 0x9c, 0xe6, 0xda, 0x1a, 0x8c, 0x1d, 0x6c, 0xa7, 0xa1, 0xfb, 0xeb, 0x77, 0xb1, 0xdb,
    0xa4, 0x1f, 0x4e, 0x08, 0xda, 0xf6, 0x04, 0x39, 0xdf, 0xef, 0xbe, 0xef, 0x77, 0x1d, 0xad, 0x07,
    0x84, 0x3d, 0x09, 0x1e, 0xdc, 0x92, 0xe4, 0x8e, 0xa6, 0x0b, 0xd0, 0x67, 0x0a, 0xd8, 0xdc, 0x2f,
    0x28, 0x4f, 0x45, 0x11, 0x8e, 0xb6, 0xcf, 0xd7, 0x52, 0x14, 0x0a, 0xe4, 0x9d, 0x11, 0xfb, 0x19,
    0x91, 0xc0, 0x35, 0xbe, 0x4e, 0x68, 0x0a, 0x9f, 0x82, 0x58, 0x5b, 0xa8, 0x0a, 0x62, 0xfb, 0x4f,
    0x9f, 0xe7, 0x8c, 0x65, 0x5a, 0x7a, 0xbd, 0xd1, 0x91, 0xfd, 0x80, 0xa4, 0x29, 0x7e, 0x0c, 0xa4,
    0x78, 0x8e, 0x18, 0xcd, 0x12, 0x41, 0x64, 0x6a, 0x7c, 0x7a, 0xbd, 0x8f, 0xa1, 0x5b, 0xfd, 0x07,
    0x85, 0xc2, 0x86, 0xa5, 0x49, 0x52, 0xeb, 0xdc, 0x41, 0x82, 0x6a, 0xbe, 0xc8, 0x80, 0x0f, 0x18,
    0x59, 0xa8, 0xfa, 0x25, 0xfe, 0x1d, 0x7c, 0x87, 0x02, 0x1f, 0x47, 0x42, 0x51, 0x4d, 0x85, 0x79,
    0xf7, 0xce, 0x2f, 0x29, 0xd7, 0xbd, 0x8b, 0x37, 0x9d, 0x48, 0x78, 0x09, 0xf5, 0x3a, 0xa3, 0x7c,
    0x11, 0x4c, 0x39, 0x82, 0xef, 0x2b, 0xc0, 0x50, 0x90, 0x74, 0x0c, 0x2f, 0x39, 0x28, 0xed, 0x9f,
    0xd4, 0xd9, 0x47, 0x42, 0x42, 0x10, 0x4f, 0x25, 0x7b, 0xe8, 0x1c, 0x8c, 0x8f, 0x9e, 0x60, 0xa6,
    0x87, 0x94, 0x43, 0x98, 0x08, 0xc1, 0xfa, 0x73, 0xc2, 0x14, 0xf8, 0xe8, 0x94, 0x43, 0xba, 0x23,
    0xd9, 0x04, 0xfd, 0xe1, 0xbf, 0x06, 0xad, 0xa9, 0x66, 0x10, 0xc6, 0x13, 0x2d, 0x11, 0xde, 0xaf,
    0x1d, 0x68, 0x79, 0x76, 0x8a, 0xa1, 0x9f, 0x60, 0xd5, 0x4f, 0xbd, 0xce, 0xa9, 0xf5, 0x4b, 0xe9,
    0xed, 0xaf, 0x89, 0x49, 0x10, 0xca, 0x5e, 0x37, 0x25, 0xbb, 0x01, 0x85, 0x98, 0x61, 0xff, 0xfc,
    0xa2, 0x31, 0x79, 0x57, 0xea, 0x8c, 0xe1, 0x87, 0xda, 0xce, 0xaa, 0x5e, 0x8e, 0x76, 0xb0, 0x5a,
    0xe6, 0x25, 0x34, 0x1e, 0x52, 0xa5, 0xef, 0x0f, 0xa6, 0xe5, 0xc1, 0x65, 0x2d, 0xd9, 0x1d, 0x6e,
    0x3b, 0x8b, 0xe7, 0x97, 0xee, 0xd1, 0x77, 0xc2, 0x73, 0xad, 0x05, 0x8f, 0x98, 0x50, 0x26, 0x5b,
    0x75, 0x64, 0xe1, 0x16, 0xa3, 0xba, 0x36, 0x4a, 0x2e, 0xf8, 0x8c, 0xf0, 0x31, 0xf6, 0x06, 0xdb,
    0x81, 0xb2, 0x2d, 0xb6, 0x4c, 0xc4, 0xa9, 0xcc, 0x80, 0xc8, 0xda, 0x55, 0x99, 0xe2, 0x66, 0x79,
    0x9c, 0xca, 0xa8, 0x77, 0xc5, 0x4a, 0xdf, 0x51, 0x2e, 0xcb, 0x95, 0xb5, 0x05, 0xc3, 0x4c, 0xe0,
    0xb5, 0xac, 0x7a, 0x33, 0x6a, 0x1b, 0x4a, 0xad, 0x8b, 0x1d, 0x6a, 0x51, 0x17, 0x43, 0x98, 0xbf,
    0xc3, 0xba, 0x18, 0xd3, 0xc5, 0xb2, 0x9b, 0xbe, 0x0d, 0x1c, 0x05, 0xd1, 0x92, 0xf0, 0x05, 0xa4,
    0x47, 0x20, 0xe7, 0x42, 0xa7, 0xa0, 0xc9, 0x6c, 0x59, 0x65, 0xe1, 0xe0, 0x0d, 0xcf, 0xbd, 0x54,
    0x07, 0xc0, 0xf6, 0xe0, 0xd2, 0x3c, 0x63, 0x74, 0x46, 0xb4, 0xa3, 0x5c, 0xcd, 0xb3, 0x0b, 0xaf,
    0x5a, 0x12, 0xec, 0x38, 0xc8, 0x15, 0xa4, 0x28, 0xd3, 0xcb, 0x6d, 0xd3, 0x1b, 0x00, 0x94, 0xa3,
    0xae, 0xae, 0x57, 0xbd, 0xf2, 0xf1, 0x2f, 0xe8, 0xd0, 0xe5, 0x4f, 0x45, 0x55, 0xd1, 0x07, 0x12,
    0xd4, 0xf2, 0xad, 0xa1, 0x7c, 0x82, 0xf5, 0x08, 0xf5, 0xd4, 0xe7, 0x55, 0x35, 0x62, 0xb0, 0xda,
    0x3f, 0x10, 0x5f, 0x72, 0x1a, 0xc4, 0xdf, 0x60, 0x6d, 0x54, 0xbc, 0x06, 0x23, 0x63, 0xa4, 0x09,
    0xa2, 0xe0, 0xaf, 0xcc, 0x30, 0x64, 0xbb, 0x8e, 0xdd, 0x63, 0x02, 0x5b, 0x87, 0xd5, 0xb8, 0x26,
    0x72, 0x67, 0x67, 0x8f, 0x4e, 0xda, 0x04, 0x07, 0xe2, 0xc9, 0x74, 0x0a, 0xbf, 0x5d, 0x76, 0x9e,
    0xc5, 0x0a, 0xae, 0xcc, 0x51, 0xb3, 0x4b, 0x6e, 0x7d, 0x23, 0xbb, 0xfd, 0x6c, 0x74, 0x5d, 0x42,
    0xaa, 0x28, 0xe7, 0x78, 0x0a, 0x6d, 0x3b, 0x45, 0x23, 0x80, 0xe3, 0xd4, 0x54, 0xf4, 0xe0, 0x54,
    0x10, 0xf2, 0x99, 0x18, 0x52, 0x8c, 0x44, 0xbe, 0x29, 0x5f, 0x73, 0x8b, 0x91, 0x6a, 0xa7, 0x1c,
    0x39, 0xf3, 0xb8, 0x52, 0x07, 0xc7, 0x60, 0xf3, 0xf7, 0xcc, 0x6b, 0xb5, 0xc5, 0x2d, 0x1b, 0x75,
    0xf2, 0x2c, 0x61, 0x45, 0x45, 0xae, 0x5a, 0x93, 0x91, 0x50, 0xb6, 0xf1, 0x6a, 0x87, 0xe4, 0x5b,
    0xd4, 0x3a, 0x76, 0x5b, 0xda, 0x13, 0x18, 0xbd, 0x8f, 0xdd, 0xa4, 0x65, 0x66, 0x0c, 0xe5, 0x90,
    0xdf, 0x5b, 0xb4, 0x2b, 0x55, 0xeb, 0x44, 0x24, 0x8f, 0xe1, 0xe1, 0xdd, 0xbd, 0x49, 0x1e, 0xf1,
    0x22, 0xb6, 0xfe, 0x4e, 0x52, 0xb0, 0x65, 0xed, 0xaf, 0x65, 0x94, 0x5d, 0x72, 0xac, 0x21, 0x7b,
    0xab, 0xeb, 0xcf, 0xf6, 0x85, 0xe6, 0x4c, 0xba, 0x0d, 0x68, 0x91, 0x75, 0xac, 0x27, 0x72, 0x0f,
    0x2e, 0xce, 0xf1, 0xad, 0x33, 0xe2, 0x66, 0xc0, 0xcd, 0x0a, 0xe4, 0x80, 0x89, 0x62, 0x8f, 0xcd,
    0x71, 0x1b, 0xe4, 0x1c, 0x85, 0x9b, 0x0b, 0xee, 0xf4, 0x97, 0xf3, 0x77, 0x34, 0xbb, 0x30, 0x5c,
    0xe8, 0xe8, 0xf1, 0x4e, 0xa4, 0x96, 0x2f, 0x7b, 0x7f, 0x00, 0xd2, 0x16, 0x04, 0x2c
};
#endif

PyTypeObject *init_TabWidget(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_TabWidget_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_TabWidget_IDX].type;

    Shiboken::AutoDecRef Sbk_TabWidget_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]))));

    _Sbk_TabWidget_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "TabWidget",
        "TabWidget*",
        &Sbk_TabWidget_spec,
        &Shiboken::callCppDestructor< TabWidget >,
        Sbk_TabWidget_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_TabWidget_TypeF(); // references _Sbk_TabWidget_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, TabWidget_SignatureStrings);
#else
    InitSignatureBytes(pyType, TabWidget_SignatureBytes, TabWidget_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_TabWidget_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_TabWidget_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        TabWidget_PythonToCpp_TabWidget_PTR,
        is_TabWidget_PythonToCpp_TabWidget_PTR_Convertible,
        TabWidget_PTR_CppToPython_TabWidget);

    Shiboken::Conversions::registerConverterName(converter, "TabWidget");
    Shiboken::Conversions::registerConverterName(converter, "TabWidget*");
    Shiboken::Conversions::registerConverterName(converter, "TabWidget&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::TabWidget).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(TabWidgetWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_TabWidget_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_TabWidget_TypeF(), &Sbk_TabWidgetSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_TabWidget_TypeF(), &Sbk_TabWidget_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::TabWidget::staticMetaObject);
    TabWidgetWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::TabWidget::staticMetaObject, sizeof(TabWidgetWrapper));

    return pyType;
}
