/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.internal.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.solr.internal.csv.CharBuffer;

class ExtendedBufferedReader
extends BufferedReader {
    public static final int END_OF_STREAM = -1;
    public static final int UNDEFINED = -2;
    private int lookaheadChar = -2;
    private int lastChar = -2;
    private int lineCounter = 0;
    private CharBuffer line = new CharBuffer();

    public ExtendedBufferedReader(Reader r) {
        super(r);
    }

    public ExtendedBufferedReader(Reader r, int bufSize) {
        super(r, bufSize);
    }

    @Override
    public int read() throws IOException {
        if (this.lookaheadChar == -2) {
            this.lookaheadChar = super.read();
        }
        this.lastChar = this.lookaheadChar;
        this.lookaheadChar = super.ready() ? super.read() : -2;
        if (this.lastChar == 10) {
            ++this.lineCounter;
        }
        return this.lastChar;
    }

    public int readAgain() {
        return this.lastChar;
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.lookaheadChar == -2) {
            if (this.ready()) {
                this.lookaheadChar = super.read();
            } else {
                return -1;
            }
        }
        if (this.lookaheadChar == -1) {
            return -1;
        }
        int cOff = off;
        while (len > 0 && this.ready()) {
            if (this.lookaheadChar == -1) {
                return cOff - off;
            }
            buf[cOff++] = (char)this.lookaheadChar;
            if (this.lookaheadChar == 10) {
                ++this.lineCounter;
            }
            this.lastChar = this.lookaheadChar;
            this.lookaheadChar = super.read();
            --len;
        }
        return cOff - off;
    }

    public String readUntil(char c) throws IOException {
        if (this.lookaheadChar == -2) {
            this.lookaheadChar = super.read();
        }
        this.line.clear();
        while (this.lookaheadChar != c && this.lookaheadChar != -1) {
            this.line.append((char)this.lookaheadChar);
            if (this.lookaheadChar == 10) {
                ++this.lineCounter;
            }
            this.lastChar = this.lookaheadChar;
            this.lookaheadChar = super.read();
        }
        return this.line.toString();
    }

    @Override
    public String readLine() throws IOException {
        if (this.lookaheadChar == -2) {
            this.lookaheadChar = super.read();
        }
        this.line.clear();
        if (this.lookaheadChar == -1) {
            return null;
        }
        char laChar = (char)this.lookaheadChar;
        if (laChar == '\n' || laChar == '\r') {
            this.lastChar = this.lookaheadChar;
            this.lookaheadChar = super.read();
            if ((char)this.lookaheadChar == '\n') {
                this.lastChar = this.lookaheadChar;
                this.lookaheadChar = super.read();
            }
            ++this.lineCounter;
            return this.line.toString();
        }
        this.line.append(laChar);
        String restOfLine = super.readLine();
        this.lastChar = this.lookaheadChar;
        this.lookaheadChar = super.read();
        if (restOfLine != null) {
            this.line.append(restOfLine);
        }
        ++this.lineCounter;
        return this.line.toString();
    }

    @Override
    public long skip(long n) throws IllegalArgumentException, IOException {
        if (this.lookaheadChar == -2) {
            this.lookaheadChar = super.read();
        }
        if (n < 0L) {
            throw new IllegalArgumentException("negative argument not supported");
        }
        if (n == 0L || this.lookaheadChar == -1) {
            return 0L;
        }
        long skiped = 0L;
        if (n > 1L) {
            skiped = super.skip(n - 1L);
        }
        this.lookaheadChar = super.read();
        this.lineCounter = Integer.MIN_VALUE;
        return skiped + 1L;
    }

    public long skipUntil(char c) throws IllegalArgumentException, IOException {
        if (this.lookaheadChar == -2) {
            this.lookaheadChar = super.read();
        }
        long counter = 0L;
        while (this.lookaheadChar != c && this.lookaheadChar != -1) {
            if (this.lookaheadChar == 10) {
                ++this.lineCounter;
            }
            this.lookaheadChar = super.read();
            ++counter;
        }
        return counter;
    }

    public int lookAhead() throws IOException {
        if (this.lookaheadChar == -2) {
            this.lookaheadChar = super.read();
        }
        return this.lookaheadChar;
    }

    public int getLineNumber() {
        if (this.lineCounter > -1) {
            return this.lineCounter;
        }
        return -1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

