/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.thread;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.thread.AbstractPythonLock;
import com.oracle.graal.python.builtins.objects.thread.CommonLockBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.thread.CommonLockBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.thread.CommonLockBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.builtins.objects.thread.PRLock;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PLock, PythonBuiltinClassType.PRLock})
public final class CommonLockBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = CommonLockBuiltinsSlotsGen.SLOTS;
    public static final boolean DEFAULT_BLOCKING = true;
    public static final double UNSET_TIMEOUT = -1.0;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CommonLockBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprLockNode
    extends PythonUnaryBuiltinNode {
        ReprLockNode() {
        }

        @Specialization
        static TruffleString repr(PLock self, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<%s %s object at %d>", self.locked() ? "locked" : "unlocked", TypeNodes.GetNameNode.executeUncached(GetClassNode.GetPythonObjectClassNode.executeUncached(self)), self.hashCode());
        }

        @Specialization
        static TruffleString repr(PRLock self, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<%s %s object owner=%d count=%d at %d>", self.locked() ? "locked" : "unlocked", TypeNodes.GetNameNode.executeUncached(GetClassNode.GetPythonObjectClassNode.executeUncached(self)), self.getOwnerId(), self.getCount(), self.hashCode());
        }
    }

    @Builtin(name="locked", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsLockedLockNode
    extends PythonUnaryBuiltinNode {
        IsLockedLockNode() {
        }

        @Specialization
        static boolean isLocked(PLock self) {
            return self.locked();
        }
    }

    @Builtin(name="__exit__", minNumOfPositionalArgs=4)
    @GenerateNodeFactory
    static abstract class ExitLockNode
    extends PythonBuiltinNode {
        ExitLockNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object exit(AbstractPythonLock self, Object type, Object value, Object traceback) {
            self.release();
            return PNone.NONE;
        }
    }

    @Builtin(name="release", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReleaseLockNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doRelease(PLock self) {
            self.release();
            return PNone.NONE;
        }

        @Specialization
        static Object doRelease(PRLock self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            if (!self.isOwned()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.LOCK_NOT_HELD);
            }
            self.release();
            return PNone.NONE;
        }
    }

    @Builtin(name="__enter__", minNumOfPositionalArgs=1, parameterNames={"self", "blocking", "timeout"})
    @GenerateNodeFactory
    static abstract class EnterLockNode
    extends PythonTernaryBuiltinNode {
        EnterLockNode() {
        }

        @Specialization
        static Object acquire(VirtualFrame frame, AbstractPythonLock self, Object blocking, Object timeout, @Cached AcquireLockNode acquireLockNode) {
            return acquireLockNode.execute(frame, self, blocking, timeout);
        }
    }

    @Builtin(name="acquire_lock", minNumOfPositionalArgs=1, parameterNames={"self", "blocking", "timeout"})
    @GenerateNodeFactory
    public static abstract class AcquireLockLockNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object acquire(VirtualFrame frame, PLock self, Object blocking, Object timeout, @Cached AcquireLockNode acquireLockNode) {
            return acquireLockNode.execute(frame, self, blocking, timeout);
        }
    }

    @Builtin(name="acquire", minNumOfPositionalArgs=1, parameterNames={"self", "blocking", "timeout"})
    @ArgumentsClinic(value={@ArgumentClinic(name="blocking", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="CommonLockBuiltins.DEFAULT_BLOCKING", useDefaultForNone=true), @ArgumentClinic(name="timeout", conversion=ArgumentClinic.ClinicConversion.Double, defaultValue="CommonLockBuiltins.UNSET_TIMEOUT", useDefaultForNone=true)})
    @ImportStatic(value={CommonLockBuiltins.class, AbstractPythonLock.class})
    @GenerateNodeFactory
    public static abstract class AcquireLockNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CommonLockBuiltinsClinicProviders.AcquireLockNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!invalidArgs(blocking, timeout)", "!blocking"})
        static boolean nonBlocking(PLock self, boolean blocking, double timeout) {
            return self.acquireNonBlocking();
        }

        @Specialization(guards={"!invalidArgs(blocking, timeout)", "!blocking"})
        static boolean nonBlocking(PRLock self, boolean blocking, double timeout) {
            return self.acquireNonBlocking();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!invalidArgs(blocking, timeout)", "timeout == UNSET_TIMEOUT", "blocking"})
        boolean acBlocking(PLock self, boolean blocking, double timeout, @Cached.Shared(value="g") @Cached GilNode gil) {
            gil.release(true);
            try {
                boolean bl = self.acquireBlocking(this);
                return bl;
            }
            finally {
                gil.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!invalidArgs(blocking, timeout)", "timeout == UNSET_TIMEOUT", "blocking"})
        boolean acBlocking(PRLock self, boolean blocking, double timeout, @Cached.Shared(value="g") @Cached GilNode gil) {
            gil.release(true);
            try {
                boolean bl = self.acquireBlocking(this);
                return bl;
            }
            finally {
                gil.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!invalidArgs(blocking, timeout)", "timeout != UNSET_TIMEOUT", "blocking"})
        boolean acTimeOut(AbstractPythonLock self, boolean blocking, double timeout, @Cached.Shared(value="g") @Cached GilNode gil) {
            gil.release(true);
            try {
                boolean bl = self.acquireTimeout((Node)this, timeout);
                return bl;
            }
            finally {
                gil.acquire();
            }
        }

        @Specialization(guards={"invalidArgs(blocking, timeout)", "timeout != UNSET_TIMEOUT", "!blocking"})
        static boolean err1(AbstractPythonLock self, boolean blocking, double timeout, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.CANT_SPECIFY_TIMEOUT_FOR_NONBLOCKING);
        }

        @Specialization(guards={"invalidArgs(blocking, timeout)", "timeout != UNSET_TIMEOUT", "isNeg(timeout)"})
        static boolean err2(AbstractPythonLock self, boolean blocking, double timeout, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.TIMEOUT_VALUE_MUST_BE_POSITIVE);
        }

        @Specialization(guards={"invalidArgs(blocking, timeout)", "timeout != UNSET_TIMEOUT", "timeout > TIMEOUT_MAX"})
        static boolean err3(AbstractPythonLock self, boolean blocking, double timeout, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.TIMEOUT_VALUE_TOO_LARGE);
        }

        protected static boolean invalidArgs(boolean blocking, double timeout) {
            return timeout != -1.0 && (!blocking || timeout < 0.0 || timeout > AbstractPythonLock.TIMEOUT_MAX);
        }

        protected boolean isNeg(double timeout) {
            return timeout < 0.0;
        }
    }
}

