/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;

@DefaultLogger(value="oracle.net")
@Supports(value={Feature.NET})
class DNVerifier {
    private static final int SSL_CERT_SAN_TYPE_DNS_NAME = 2;
    private static final int SSL_CERT_SAN_TYPE_IP_ADDR = 7;
    private final ConnOption connOption;
    private final boolean isDNmatchEnabled;
    private SecurityInformation.DNMatchStatus dnMatchStatus;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    DNVerifier(ConnOption connOption, boolean isDNmatchEnabled) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, DNVerifier.class, $$$methodRef$$$14, null, connOption, isDNmatchEnabled);
            }
            this.dnMatchStatus = SecurityInformation.DNMatchStatus.NOT_VERIFIED;
            this.connOption = connOption;
            this.isDNmatchEnabled = isDNmatchEnabled;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, DNVerifier.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DNVerifier.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DNVerifier.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    SecurityInformation.DNMatchStatus verify(X509Certificate x509Certificate) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void serverCert;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DNVerifier.class, $$$methodRef$$$0, this, x509Certificate);
            }
            if (!this.isDNmatchEnabled) {
                if (bl) {
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "Server DN verification is disabled and connection is not secure.Enable DN verification through Connection Property 'oracle.net.ssl_server_dn_match' or through URL parameter 'SSL_SERVER_DN_MATCH'");
                }
                SecurityInformation.DNMatchStatus dNMatchStatus = SecurityInformation.DNMatchStatus.NOT_VERIFIED;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DNVerifier.class, $$$methodRef$$$0, this, (Object)dNMatchStatus);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DNVerifier.class, $$$methodRef$$$0, this, null);
                }
                return dNMatchStatus;
            }
            SecurityInformation.DNMatchStatus dNMatchStatus = this.verifyServerCertificate((X509Certificate)serverCert);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DNVerifier.class, $$$methodRef$$$0, this, (Object)dNMatchStatus);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DNVerifier.class, $$$methodRef$$$0, this, null);
            }
            return dNMatchStatus;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DNVerifier.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isWeakDNMatchAllowed() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DNVerifier.class, $$$methodRef$$$1, this, new Object[0]);
            }
            ConnOption originalConnOption = this.connOption.getOriginalConnOption();
            boolean bl3 = bl2 = originalConnOption.sslAllowWeakDNMatch != null && (originalConnOption.sslAllowWeakDNMatch.equalsIgnoreCase("on") || originalConnOption.sslAllowWeakDNMatch.equalsIgnoreCase("true") || originalConnOption.sslAllowWeakDNMatch.equalsIgnoreCase("yes"));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DNVerifier.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DNVerifier.class, $$$methodRef$$$1, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DNVerifier.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SecurityInformation.DNMatchStatus verifyServerCertificate(X509Certificate x509Certificate) throws NetException, IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void serverCertificate;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DNVerifier.class, $$$methodRef$$$2, this, x509Certificate);
            }
            ConnOption originalConnOption = this.connOption.getOriginalConnOption();
            if (originalConnOption.sslServerCertDN != null) {
                SecurityInformation.DNMatchStatus dNMatchStatus = this.verifyConfiguredDN((X509Certificate)serverCertificate, originalConnOption.sslServerCertDN);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DNVerifier.class, $$$methodRef$$$2, this, (Object)dNMatchStatus);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DNVerifier.class, $$$methodRef$$$2, this, null);
                }
                return dNMatchStatus;
            }
            SecurityInformation.DNMatchStatus dNMatchStatus = this.verifyHostOrServiceName((X509Certificate)serverCertificate);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DNVerifier.class, $$$methodRef$$$2, this, (Object)dNMatchStatus);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DNVerifier.class, $$$methodRef$$$2, this, null);
            }
            return dNMatchStatus;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DNVerifier.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SecurityInformation.DNMatchStatus verifyConfiguredDN(X509Certificate x509Certificate, String string) throws NetException, IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dnToMatch;
            void serverCertificate;
            String serverCertDN;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DNVerifier.class, $$$methodRef$$$3, this, x509Certificate, string);
            }
            if (this.doFullDNMatch(serverCertDN = serverCertificate.getSubjectDN().getName(), (String)dnToMatch)) {
                SecurityInformation.DNMatchStatus dNMatchStatus = SecurityInformation.DNMatchStatus.VERIFIED_MATCHING_CONFIG;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DNVerifier.class, $$$methodRef$$$3, this, (Object)dNMatchStatus);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DNVerifier.class, $$$methodRef$$$3, this, null);
                }
                return dNMatchStatus;
            }
            NetException netException = new NetException(405, null, false, dnToMatch, serverCertDN);
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, DNVerifier.class, $$$methodRef$$$3, this, netException);
            }
            throw netException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DNVerifier.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SecurityInformation.DNMatchStatus verifyHostOrServiceName(X509Certificate x509Certificate) throws NetException, IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void serverCertificate;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DNVerifier.class, $$$methodRef$$$4, this, x509Certificate);
            }
            ConnOption originalConnOption = this.connOption.getOriginalConnOption();
            String hostNameForDNMatch = this.connOption.host;
            String originalHostNameForDNMatch = originalConnOption.host;
            if (this.matchCNAndSANs((X509Certificate)serverCertificate, hostNameForDNMatch) || this.matchCNAndSANs((X509Certificate)serverCertificate, originalHostNameForDNMatch)) {
                SecurityInformation.DNMatchStatus dNMatchStatus = SecurityInformation.DNMatchStatus.VERIFIED_MATCHING_HOSTNAME;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DNVerifier.class, $$$methodRef$$$4, this, (Object)dNMatchStatus);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DNVerifier.class, $$$methodRef$$$4, this, null);
                }
                return dNMatchStatus;
            }
            boolean isAllowWeakDNMatchEnabled = this.isWeakDNMatchAllowed();
            String originalServiceNameForDNMatch = originalConnOption.service_name;
            if (!isAllowWeakDNMatchEnabled || originalServiceNameForDNMatch == null) {
                NetException netException = new NetException(416, null, false, originalHostNameForDNMatch, hostNameForDNMatch, this.getCNValue((X509Certificate)serverCertificate), Optional.ofNullable(this.getDNSSubjectAlts((X509Certificate)serverCertificate)).map(Arrays::toString).orElse("null"));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, DNVerifier.class, $$$methodRef$$$4, this, netException);
                }
                throw netException;
            }
            if (this.matchSANs((X509Certificate)serverCertificate, originalServiceNameForDNMatch) || this.matchCN((X509Certificate)serverCertificate, originalServiceNameForDNMatch)) {
                SecurityInformation.DNMatchStatus dNMatchStatus = SecurityInformation.DNMatchStatus.VERIFIED_MATCHING_SERVICENAME;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DNVerifier.class, $$$methodRef$$$4, this, (Object)dNMatchStatus);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DNVerifier.class, $$$methodRef$$$4, this, null);
                }
                return dNMatchStatus;
            }
            NetException netException = new NetException(417, null, false, originalHostNameForDNMatch, hostNameForDNMatch, originalServiceNameForDNMatch, this.getCNValue((X509Certificate)serverCertificate), Optional.ofNullable(this.getDNSSubjectAlts((X509Certificate)serverCertificate)).map(Arrays::toString).orElse("null"));
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, DNVerifier.class, $$$methodRef$$$4, this, netException);
            }
            throw netException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DNVerifier.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean doFullDNMatch(String string, String string2) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block9: {
                void matchDN;
                void serverDN;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, DNVerifier.class, $$$methodRef$$$5, this, string, string2);
                }
                if (serverDN == null || matchDN == null) {
                    boolean bl3 = false;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DNVerifier.class, $$$methodRef$$$5, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DNVerifier.class, $$$methodRef$$$5, this, null);
                    }
                    return false;
                }
                try {
                    LdapName serverLdapName = new LdapName((String)serverDN);
                    LdapName userLdapName = new LdapName((String)matchDN);
                    bl2 = serverLdapName.equals(userLdapName);
                    if (!bl) break block9;
                }
                catch (InvalidNameException e2) {
                    IOException iOException = new IOException(e2);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, DNVerifier.class, $$$methodRef$$$5, this, iOException);
                    }
                    throw iOException;
                }
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DNVerifier.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DNVerifier.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DNVerifier.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean matchCNAndSANs(X509Certificate x509Certificate, String string) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void serverCertificate;
            void hostName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, DNVerifier.class, $$$methodRef$$$6, this, x509Certificate, string);
            }
            if (hostName != null && (this.matchSANs((X509Certificate)serverCertificate, (String)hostName) || this.matchCN((X509Certificate)serverCertificate, (String)hostName))) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DNVerifier.class, $$$methodRef$$$6, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DNVerifier.class, $$$methodRef$$$6, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DNVerifier.class, $$$methodRef$$$6, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DNVerifier.class, $$$methodRef$$$6, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DNVerifier.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean matchCN(X509Certificate x509Certificate, String string) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void matchStr;
            void serverCert;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, DNVerifier.class, $$$methodRef$$$7, this, x509Certificate, string);
            }
            String serverCN = this.getCNValue((X509Certificate)serverCert);
            boolean bl2 = this.compare(serverCN, (String)matchStr);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DNVerifier.class, $$$methodRef$$$7, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DNVerifier.class, $$$methodRef$$$7, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DNVerifier.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean matchSANs(X509Certificate x509Certificate, String string) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void serverCert;
            String[] altNames;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, DNVerifier.class, $$$methodRef$$$8, this, x509Certificate, string);
            }
            if ((altNames = this.getDNSSubjectAlts((X509Certificate)serverCert)) != null) {
                for (String altName : altNames) {
                    void matchStr;
                    if (!this.compare(altName, (String)matchStr)) continue;
                    boolean bl2 = true;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, DNVerifier.class, $$$methodRef$$$8, this, bl2);
                        ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DNVerifier.class, $$$methodRef$$$8, this, null);
                    }
                    return true;
                }
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, DNVerifier.class, $$$methodRef$$$8, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DNVerifier.class, $$$methodRef$$$8, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DNVerifier.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String[] getDNSSubjectAlts(X509Certificate x509Certificate) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String[] stringArray;
            block11: {
                Collection<List<?>> altNames;
                LinkedList<String> subjectAltList;
                block9: {
                    String[] stringArray2;
                    block10: {
                        String[] stringArray3;
                        void serverCert;
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, DNVerifier.class, $$$methodRef$$$9, this, x509Certificate);
                        }
                        subjectAltList = new LinkedList<String>();
                        altNames = serverCert.getSubjectAlternativeNames();
                        if (altNames != null) break block9;
                        stringArray2 = stringArray3 = null;
                        if (!bl) break block10;
                        ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DNVerifier.class, $$$methodRef$$$9, this, stringArray3);
                        ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DNVerifier.class, $$$methodRef$$$9, this, null);
                    }
                    return stringArray2;
                }
                try {
                    for (List<?> altName : altNames) {
                        Integer type = (Integer)altName.get(0);
                        if (type != 2 && type != 7) continue;
                        subjectAltList.add((String)altName.get(1));
                    }
                    stringArray = subjectAltList.toArray(new String[subjectAltList.size()]);
                    if (!bl) break block11;
                }
                catch (CertificateParsingException cpe) {
                    IOException iOException = new IOException(cpe);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, DNVerifier.class, $$$methodRef$$$9, this, iOException);
                    }
                    throw iOException;
                }
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DNVerifier.class, $$$methodRef$$$9, this, stringArray);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DNVerifier.class, $$$methodRef$$$9, this, null);
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DNVerifier.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getCNValue(X509Certificate x509Certificate) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, DNVerifier.class, $$$methodRef$$$10, this, x509Certificate);
                }
                try {
                    void serverCert;
                    string = this.getCNValue(new LdapName(serverCert.getSubjectDN().getName()));
                    if (!bl) break block7;
                }
                catch (InvalidNameException invalidNameException) {
                    IOException iOException = new IOException(invalidNameException);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, DNVerifier.class, $$$methodRef$$$10, this, iOException);
                    }
                    throw iOException;
                }
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DNVerifier.class, $$$methodRef$$$10, this, string);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DNVerifier.class, $$$methodRef$$$10, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DNVerifier.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getCNValue(LdapName ldapName) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void ldapName2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, DNVerifier.class, $$$methodRef$$$11, this, ldapName);
            }
            for (Rdn rdn : ldapName2.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                String string = (String)rdn.getValue();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DNVerifier.class, $$$methodRef$$$11, this, string);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DNVerifier.class, $$$methodRef$$$11, this, null);
                }
                return string;
            }
            String string = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DNVerifier.class, $$$methodRef$$$11, this, string);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DNVerifier.class, $$$methodRef$$$11, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DNVerifier.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    private boolean compare(String string, String string2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String matchValRemaining;
            String certValRemaining;
            String matchValue;
            String certValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, DNVerifier.class, $$$methodRef$$$12, this, string, string2);
            }
            if ((certValue = certValue.toLowerCase()).equals(matchValue = matchValue.toLowerCase())) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DNVerifier.class, $$$methodRef$$$12, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DNVerifier.class, $$$methodRef$$$12, this, null);
                }
                return true;
            }
            int certLeftLblEndIndex = certValue.indexOf(46);
            int matchLeftLblEndIndex = matchValue.indexOf(46);
            if (certLeftLblEndIndex > 0 && matchLeftLblEndIndex > 0 && (certValRemaining = certValue.substring(certLeftLblEndIndex)).equals(matchValRemaining = matchValue.substring(matchLeftLblEndIndex))) {
                String certValLeftLbl = certValue.substring(0, certLeftLblEndIndex);
                String matchValLeftLbl = matchValue.substring(0, matchLeftLblEndIndex);
                boolean bl3 = this.wildcardCompare(certValLeftLbl, matchValLeftLbl);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DNVerifier.class, $$$methodRef$$$12, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DNVerifier.class, $$$methodRef$$$12, this, null);
                }
                return bl3;
            }
            boolean bl4 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DNVerifier.class, $$$methodRef$$$12, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DNVerifier.class, $$$methodRef$$$12, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DNVerifier.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean wildcardCompare(String string, String string2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            void matchLftLbl;
            void certLftLbl;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, string, string2);
            }
            if (certLftLbl.equals("*")) {
                boolean bl3;
                boolean bl4 = bl3 = !matchLftLbl.isEmpty();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, null);
                }
                return bl4;
            }
            int wildcardCharIndex = certLftLbl.indexOf(42);
            if (wildcardCharIndex == -1) {
                boolean bl5 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, bl5);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, null);
                }
                return false;
            }
            if (wildcardCharIndex == certLftLbl.length() - 1) {
                boolean bl6 = matchLftLbl.startsWith(certLftLbl.substring(0, certLftLbl.length() - 1));
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, bl6);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, null);
                }
                return bl6;
            }
            if (wildcardCharIndex == 0) {
                boolean bl7 = matchLftLbl.endsWith(certLftLbl.substring(1));
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, bl7);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, null);
                }
                return bl7;
            }
            String startPattern = certLftLbl.substring(0, wildcardCharIndex);
            String endPattern = certLftLbl.substring(wildcardCharIndex + 1);
            boolean bl8 = bl2 = matchLftLbl.startsWith(startPattern) && matchLftLbl.endsWith(endPattern);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, null);
            }
            return bl8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DNVerifier.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$14 = DNVerifier.class.getDeclaredConstructor(ConnOption.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$13 = DNVerifier.class.getDeclaredMethod("wildcardCompare", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$12 = DNVerifier.class.getDeclaredMethod("compare", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$11 = DNVerifier.class.getDeclaredMethod("getCNValue", LdapName.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$10 = DNVerifier.class.getDeclaredMethod("getCNValue", X509Certificate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$9 = DNVerifier.class.getDeclaredMethod("getDNSSubjectAlts", X509Certificate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$8 = DNVerifier.class.getDeclaredMethod("matchSANs", X509Certificate.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$7 = DNVerifier.class.getDeclaredMethod("matchCN", X509Certificate.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$6 = DNVerifier.class.getDeclaredMethod("matchCNAndSANs", X509Certificate.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$5 = DNVerifier.class.getDeclaredMethod("doFullDNMatch", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$4 = DNVerifier.class.getDeclaredMethod("verifyHostOrServiceName", X509Certificate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$3 = DNVerifier.class.getDeclaredMethod("verifyConfiguredDN", X509Certificate.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$2 = DNVerifier.class.getDeclaredMethod("verifyServerCertificate", X509Certificate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$1 = DNVerifier.class.getDeclaredMethod("isWeakDNMatchAllowed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$0 = DNVerifier.class.getDeclaredMethod("verify", X509Certificate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
    }
}

