\name{LevelSetMotionRegistrationFilter}
\alias{LevelSetMotionRegistrationFilter}
\title{LevelSetMotionRegistrationFilter}
\Rdversion{1.1}
\docType{class}
\description{
Deformably register two images using level set motion.
LevelSetMotionRegistrationFilter}
\details{
LevelSetMotionFilter implements a deformable registration algorithm
that aligns a fixed and a moving image under level set motion. The
equations of motion are similar to those of the DemonsRegistrationFilter . The main differences are: (1) Gradients of the moving image are
calculated on a smoothed image while intensity difference are measured
on the original images (2) Magnitude of the motion vector is a
function of the differences in intensity between the fixed and moving
pixel. An adaptive timestep is calculated based on the maximum motion
vector over the entire field to ensure stability. The timestep also
implicitly converts the motion vector measured in units of intensity
to a vector measured in physical units. Demons, on the other hand,
defines its motion vectors as function of both the intensity
differences and gradient magnitude at each respective pixel. Consider
two separate pixels with the same intensity differences between the
corresponding fixed and moving pixel pairs. In demons, the motion
vector of the pixel over a low gradient region will be larger than the
motion vector of the pixel over a large gradient region. This leads to
an unstable vector field. In the levelset approach, the motion vectors
will be proportional to the gradients, scaled by the maximum gradient
over the entire field. The pixel with at the lower gradient position
will more less than the pixel at the higher gradient position. (3)
Gradients are calculated using minmod finite difference instead of
using central differences.
A deformation field is represented as a image whose pixel type is some
vector type with at least N elements, where N is the dimension of the
fixed image. The vector type must support element access via operator
[]. It is assumed that the vector elements behave like floating point
scalars.
This class is templated over the fixed image type, moving image type
and the deformation field type.
The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial deformation field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.
The algorithm has one parameters: the number of iteration to be
performed.
The output deformation field can be obtained via methods GetOutput or
GetDisplacementField.
This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in LevelSetMotionFunction.
WARNING:
This filter assumes that the fixed image type, moving image type and
deformation field type all have the same number of dimensions.
 Ref: B.C. Vemuri, J. Ye, Y. Chen, C.M. Leonard. " Image registration via level-set motion: applications to atlas-based
segmentation". Medical Image Analysis. Vol. 7. pp. 1-20. 2003.
See:
LevelSetMotionRegistrationFunction
DemonsRegistrationFilter
itk::LevelSetMotionRegistrationFilter for the Doxygen on the original ITK class.
LevelSetMotionRegistrationFilter}
%C++ includes: sitkLevelSetMotionRegistrationFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &fixedImage, const Image &movingImage):}{}
\item{Image Execute(const Image &fixedImage, const Image &movingImage, const Image &initialDisplacementField):}{
Execute the filter on the input image
}
\item{double GetAlpha() const:}{}
\item{uint32_t GetElapsedIterations() const:}{
Number of iterations run.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetGradientMagnitudeThreshold() const:}{}
\item{double GetGradientSmoothingStandardDeviations() const:}{}
\item{double GetIntensityDifferenceThreshold() const:}{}
\item{double GetMaximumError() const:}{
Set/Get the desired maximum error of the Guassian kernel approximate.
}
\item{unsigned int GetMaximumKernelWidth() const:}{
Set/Get the desired limits of the Gaussian kernel width.
}
\item{double GetMaximumRMSError() const:}{}
\item{double GetMetric() const:}{
Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the the overlapping region between the two images. This
is value is only available for the previous iteration and NOT the
current iteration.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetRMSChange() const:}{
The Root Mean Square of the levelset upon termination.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{bool GetSmoothDisplacementField() const:}{
Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()
}
\item{bool GetSmoothUpdateField() const:}{
Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()
}
\item{std::vector< double > GetStandardDeviations() const:}{
Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.
}
\item{std::vector< double > GetUpdateFieldStandardDeviations() const:}{
Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.
}
\item{bool GetUseImageSpacing() const:}{}
\item{ LevelSetMotionRegistrationFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetAlpha(double Alpha):}{
Set/Get the parameter alpha. Alpha is added to the calculated gradient
magnitude prior to normalizing the gradient to protect against
numerical instability as the gradient magnitude approaches zero. This
should be set as a small fraction of the intensity dynamic range, for
instance 0.04\%. Default is the absolute (not percentage) value of 0.1.
}
\item{Self SetGradientMagnitudeThreshold(double GradientMagnitudeThreshold):}{
Set/Get the threshold below which the gradient magnitude is considered
the zero vector. Default is 1e-9.
}
\item{Self SetGradientSmoothingStandardDeviations(double GradientSmoothingStandardDeviations):}{
Set/Get the standard deviation used for smoothing the moving image
prior to calculating gradients. The standard deviation is measured in
physical units (for instance mm). Note that this smoothing value is
not to be confused with the PDEDeformableRegistrationFilter::SetStandardDeviations() method. The method in PDEDeformableRegistrationFilter is for setting the smoothing parameters for regularizing the
deformation field between iterations. Those smoothing parameters are
set in pixel units not physical units. Deformation field smoothing is
not done by default in LevelSetMotionRegistration. This smoothing
parameter is to condition the gradient calculation and parameter is
specified in physical units.
}
\item{Self SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold):}{
Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.
}
\item{Self SetMaximumError(double MaximumError):}{
Set/Get the desired maximum error of the Guassian kernel approximate.
}
\item{Self SetMaximumKernelWidth(unsigned int MaximumKernelWidth):}{
Set/Get the desired limits of the Gaussian kernel width.
}
\item{Self SetMaximumRMSError(double MaximumRMSError):}{}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetSmoothDisplacementField(bool SmoothDisplacementField):}{
Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()
}
\item{Self SetSmoothUpdateField(bool SmoothUpdateField):}{
Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()
}
\item{Self SetStandardDeviations(double value):}{
Set the values of the StandardDeviations vector all to value
}
\item{Self SetStandardDeviations(std::vector< double > StandardDeviations):}{
Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.
}
\item{Self SetUpdateFieldStandardDeviations(double value):}{
Set the values of the UpdateFieldStandardDeviations vector all to
value
}
\item{Self SetUpdateFieldStandardDeviations(std::vector< double > UpdateFieldStandardDeviations):}{
Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{}
\item{Self SmoothDisplacementFieldOff():}{}
\item{Self SmoothDisplacementFieldOn():}{
Set the value of SmoothDisplacementField to true or false
respectfully.
}
\item{Self SmoothUpdateFieldOff():}{}
\item{Self SmoothUpdateFieldOn():}{
Set the value of SmoothUpdateField to true or false respectfully.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~LevelSetMotionRegistrationFilter():}{
Destructor
}
}
}
