/***************************************************************************
  qgsqmlwidgetwrapper.h

 ---------------------
 begin                : 25.6.2018
 copyright            : (C) 2018 by Matthias Kuhn
 email                : matthias@opengis.ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef QGSQMLWIDGETWRAPPER_H
#define QGSQMLWIDGETWRAPPER_H

#include "qgswidgetwrapper.h"
#include "qgis_sip.h"
#include "qgis_gui.h"

#include <QQuickWidget>

/**
 * \ingroup gui
 * \brief Wraps a QQuickWidget to display QML code.
 * \since QGIS 3.4
 */
class GUI_EXPORT QgsQmlWidgetWrapper : public QgsWidgetWrapper
{
    Q_OBJECT

  public:
    /**
     * Create a qml widget wrapper
     *
     * \param layer     The layer on which the feature is
     * \param editor    An editor widget. Can be NULLPTR if one should be autogenerated.
     * \param parent    A parent widget
     */
    QgsQmlWidgetWrapper( QgsVectorLayer *layer, QWidget *editor, QWidget *parent );

    bool valid() const override;

    QWidget *createWidget( QWidget *parent ) override;

    void initWidget( QWidget *editor ) override;

    //! Clears the content and makes new initialization
    void reinitWidget();

    //! writes the \a qmlCode into a temporary file
    void setQmlCode( const QString &qmlCode );

  public slots:
    void setFeature( const QgsFeature &feature ) override;

  private slots:
    //! sets the qml context with the current values
    void setQmlContext();

  private:
    QTemporaryFile mQmlFile;
    QString mQmlCode;
    QQuickWidget *mWidget = nullptr;
    QgsFeature mFeature;
    QgsFeature mFormFeature;
    bool mRequiresFormScope = false;
};


#ifndef SIP_RUN
///@cond PRIVATE

/**
 * \ingroup gui
 * \brief To pass the QgsExpression functionality and it's context to the context of the QQuickWidget
 * \since QGIS 3.4
 */
class QmlExpression : public QObject
{
    Q_OBJECT

  public:
    //! set the \a context of the expression
    void setExpressionContext( const QgsExpressionContext &context );

    //! evaluates the value regarding the \a expression and the context
    Q_INVOKABLE QVariant evaluate( const QString &expression ) const;

  private:
    QgsExpressionContext mExpressionContext;
};
///@endcond
#endif //SIP_RUN

#endif // QGSQMLWIDGETWRAPPER_H
