/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.cluster.ClusterStatsResponse;
import org.opensearch.client.opensearch.cluster.stats.IndexMetric;
import org.opensearch.client.opensearch.cluster.stats.Metric;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class ClusterStatsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, ClusterStatsRequest> {
    @Nullable
    private final Boolean flatSettings;
    @Nonnull
    private final List<IndexMetric> indexMetric;
    @Nonnull
    private final List<Metric> metric;
    @Nonnull
    private final List<String> nodeId;
    @Nullable
    private final Time timeout;
    public static final Endpoint<ClusterStatsRequest, ClusterStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ClusterStatsRequest, ClusterStatsResponse>(request -> "GET", request -> {
        boolean _indexMetric = true;
        int _metric = 2;
        int _nodeId = 4;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.indexMetric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 2;
        }
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= 4;
        }
        if (propsSet == 0) {
            return "/_cluster/stats";
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster/stats/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexMetric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            buf.append("/nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            return buf.toString();
        }
        if (propsSet == 6) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster/stats/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            buf.append("/nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            return buf.toString();
        }
        if (propsSet == 4) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster/stats/nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, ClusterStatsResponse._DESERIALIZER);

    private ClusterStatsRequest(Builder builder) {
        super(builder);
        this.flatSettings = builder.flatSettings;
        this.indexMetric = ApiTypeHelper.unmodifiable(builder.indexMetric);
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.timeout = builder.timeout;
    }

    public static ClusterStatsRequest of(Function<Builder, ObjectBuilder<ClusterStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nonnull
    public final List<IndexMetric> indexMetric() {
        return this.indexMetric;
    }

    @Nonnull
    public final List<Metric> metric() {
        return this.metric;
    }

    @Nonnull
    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.flatSettings != null) {
            params.put("flat_settings", String.valueOf(this.flatSettings));
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.flatSettings);
        result = 31 * result + Objects.hashCode(this.indexMetric);
        result = 31 * result + Objects.hashCode(this.metric);
        result = 31 * result + Objects.hashCode(this.nodeId);
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStatsRequest other = (ClusterStatsRequest)o;
        return Objects.equals(this.flatSettings, other.flatSettings) && Objects.equals(this.indexMetric, other.indexMetric) && Objects.equals(this.metric, other.metric) && Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ClusterStatsRequest> {
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private List<IndexMetric> indexMetric;
        @Nullable
        private List<Metric> metric;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(ClusterStatsRequest o) {
            super(o);
            this.flatSettings = o.flatSettings;
            this.indexMetric = Builder._listCopy(o.indexMetric);
            this.metric = Builder._listCopy(o.metric);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.flatSettings = o.flatSettings;
            this.indexMetric = Builder._listCopy(o.indexMetric);
            this.metric = Builder._listCopy(o.metric);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        @Nonnull
        public final Builder indexMetric(List<IndexMetric> list) {
            this.indexMetric = Builder._listAddAll(this.indexMetric, list);
            return this;
        }

        @Nonnull
        public final Builder indexMetric(IndexMetric value, IndexMetric ... values) {
            this.indexMetric = Builder._listAdd(this.indexMetric, value, values);
            return this;
        }

        @Nonnull
        public final Builder metric(List<Metric> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        @Nonnull
        public final Builder metric(Metric value, Metric ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        @Nonnull
        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        @Nonnull
        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public ClusterStatsRequest build() {
            this._checkSingleUse();
            return new ClusterStatsRequest(this);
        }
    }
}

