/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.reroute;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RerouteParameters
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RerouteParameters> {
    private final boolean allowPrimary;
    @Nullable
    private final String fromNode;
    @Nonnull
    private final String index;
    @Nonnull
    private final String node;
    private final int shard;
    @Nullable
    private final String toNode;
    public static final JsonpDeserializer<RerouteParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteParameters::setupRerouteParametersDeserializer);

    private RerouteParameters(Builder builder) {
        this.allowPrimary = ApiTypeHelper.requireNonNull(builder.allowPrimary, this, "allowPrimary");
        this.fromNode = builder.fromNode;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.shard = ApiTypeHelper.requireNonNull(builder.shard, this, "shard");
        this.toNode = builder.toNode;
    }

    public static RerouteParameters of(Function<Builder, ObjectBuilder<RerouteParameters>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean allowPrimary() {
        return this.allowPrimary;
    }

    @Nullable
    public final String fromNode() {
        return this.fromNode;
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final String node() {
        return this.node;
    }

    public final int shard() {
        return this.shard;
    }

    @Nullable
    public final String toNode() {
        return this.toNode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allow_primary");
        generator.write(this.allowPrimary);
        if (this.fromNode != null) {
            generator.writeKey("from_node");
            generator.write(this.fromNode);
        }
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("shard");
        generator.write(this.shard);
        if (this.toNode != null) {
            generator.writeKey("to_node");
            generator.write(this.toNode);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRerouteParametersDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowPrimary, JsonpDeserializer.booleanDeserializer(), "allow_primary");
        op.add(Builder::fromNode, JsonpDeserializer.stringDeserializer(), "from_node");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
        op.add(Builder::toNode, JsonpDeserializer.stringDeserializer(), "to_node");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Boolean.hashCode(this.allowPrimary);
        result = 31 * result + Objects.hashCode(this.fromNode);
        result = 31 * result + this.index.hashCode();
        result = 31 * result + this.node.hashCode();
        result = 31 * result + Integer.hashCode(this.shard);
        result = 31 * result + Objects.hashCode(this.toNode);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RerouteParameters other = (RerouteParameters)o;
        return this.allowPrimary == other.allowPrimary && Objects.equals(this.fromNode, other.fromNode) && this.index.equals(other.index) && this.node.equals(other.node) && this.shard == other.shard && Objects.equals(this.toNode, other.toNode);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RerouteParameters> {
        private Boolean allowPrimary;
        @Nullable
        private String fromNode;
        private String index;
        private String node;
        private Integer shard;
        @Nullable
        private String toNode;

        public Builder() {
        }

        private Builder(RerouteParameters o) {
            this.allowPrimary = o.allowPrimary;
            this.fromNode = o.fromNode;
            this.index = o.index;
            this.node = o.node;
            this.shard = o.shard;
            this.toNode = o.toNode;
        }

        private Builder(Builder o) {
            this.allowPrimary = o.allowPrimary;
            this.fromNode = o.fromNode;
            this.index = o.index;
            this.node = o.node;
            this.shard = o.shard;
            this.toNode = o.toNode;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder allowPrimary(boolean value) {
            this.allowPrimary = value;
            return this;
        }

        @Nonnull
        public final Builder fromNode(@Nullable String value) {
            this.fromNode = value;
            return this;
        }

        @Nonnull
        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        @Nonnull
        public final Builder shard(int value) {
            this.shard = value;
            return this;
        }

        @Nonnull
        public final Builder toNode(@Nullable String value) {
            this.toNode = value;
            return this;
        }

        @Override
        @Nonnull
        public RerouteParameters build() {
            this._checkSingleUse();
            return new RerouteParameters(this);
        }
    }
}

