/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.io;

import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceException;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.provenance.io.FlatMarshalledProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.BooleanProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.ByteProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.CharProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DoubleProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.EnumProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.FileProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.FloatProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.HashProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.IntProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.LongProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.ShortProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.TimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.URLProvenance;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Objects;

public final class SimpleMarshalledProvenance
implements FlatMarshalledProvenance {
    private final String key;
    private final String value;
    private final String additional;
    private final String provenanceClassName;
    private final boolean isReference;

    public <E extends Enum> SimpleMarshalledProvenance(EnumProvenance<E> enumProv) {
        this(enumProv.getKey(), ((Enum)enumProv.getValue()).toString(), enumProv.getClass().getName(), false, enumProv.getEnumClass());
    }

    public SimpleMarshalledProvenance(HashProvenance provenance) {
        this(provenance.getKey(), provenance.getValue(), provenance.getClass().getName(), false, provenance.getType().toString());
    }

    public <T> SimpleMarshalledProvenance(PrimitiveProvenance<T> provenance) {
        this(provenance.getKey(), provenance.getValue().toString(), provenance.getClass().getName(), false, "");
    }

    public SimpleMarshalledProvenance(String key, String value, ObjectProvenance provenance) {
        this(key, value, provenance.getClass().getName(), true, "");
    }

    public SimpleMarshalledProvenance(String key, String value, String provenanceClassName, boolean isReference, String additional) {
        this.key = key;
        this.value = value;
        this.provenanceClassName = provenanceClassName;
        this.isReference = isReference;
        this.additional = additional;
    }

    public String toString() {
        return "SimpleMarshalledProvenance{key='" + this.key + '\'' + ", value='" + this.value + '\'' + ", additional='" + this.additional + '\'' + ", provenanceClassName='" + this.provenanceClassName + '\'' + ", isReference=" + this.isReference + '}';
    }

    public <T> PrimitiveProvenance<T> unmarshallPrimitive() {
        if (this.isReference) {
            throw new ProvenanceException("Attempted to unmarshall a reference via 'unmarshallPrimitive'");
        }
        try {
            PrimitiveProvenance<Boolean> unmarshalled;
            Class<?> provClass = Class.forName(this.provenanceClassName);
            if (provClass.equals(BooleanProvenance.class)) {
                unmarshalled = new BooleanProvenance(this.key, Boolean.parseBoolean(this.value));
            } else if (provClass.equals(ByteProvenance.class)) {
                unmarshalled = new ByteProvenance(this.key, Byte.parseByte(this.value));
            } else if (provClass.equals(CharProvenance.class)) {
                unmarshalled = new CharProvenance(this.key, this.value.charAt(0));
            } else if (provClass.equals(DateProvenance.class)) {
                unmarshalled = new DateProvenance(this.key, LocalDate.parse(this.value));
            } else if (provClass.equals(DateTimeProvenance.class)) {
                unmarshalled = new DateTimeProvenance(this.key, OffsetDateTime.parse(this.value));
            } else if (provClass.equals(DoubleProvenance.class)) {
                unmarshalled = new DoubleProvenance(this.key, Double.parseDouble(this.value));
            } else if (provClass.equals(EnumProvenance.class)) {
                Class<?> enumClass = Class.forName(this.additional);
                Object enumValue = Enum.valueOf(enumClass, this.value);
                unmarshalled = new EnumProvenance(this.key, enumValue);
            } else if (provClass.equals(FileProvenance.class)) {
                unmarshalled = new FileProvenance(this.key, new File(this.value));
            } else if (provClass.equals(FloatProvenance.class)) {
                unmarshalled = new FloatProvenance(this.key, Float.parseFloat(this.value));
            } else if (provClass.equals(HashProvenance.class)) {
                unmarshalled = new HashProvenance(ProvenanceUtil.HashType.valueOf(this.additional), this.key, this.value);
            } else if (provClass.equals(IntProvenance.class)) {
                unmarshalled = new IntProvenance(this.key, Integer.parseInt(this.value));
            } else if (provClass.equals(LongProvenance.class)) {
                unmarshalled = new LongProvenance(this.key, Long.parseLong(this.value));
            } else if (provClass.equals(ShortProvenance.class)) {
                unmarshalled = new ShortProvenance(this.key, Short.parseShort(this.value));
            } else if (provClass.equals(StringProvenance.class)) {
                unmarshalled = new StringProvenance(this.key, this.value);
            } else if (provClass.equals(TimeProvenance.class)) {
                unmarshalled = new TimeProvenance(this.key, OffsetTime.parse(this.value));
            } else if (provClass.equals(URLProvenance.class)) {
                unmarshalled = new URLProvenance(this.key, new URL(this.value));
            } else {
                throw new ProvenanceException("Unknown Provenance subclass, found " + provClass.getName());
            }
            return unmarshalled;
        }
        catch (MalformedURLException e) {
            throw new ProvenanceException("Failed to parse url for provenance " + this.key + ".", e);
        }
        catch (NumberFormatException e) {
            throw new ProvenanceException("Failed to parse number for provenance " + this.key + ".", e);
        }
        catch (IllegalArgumentException e) {
            throw new ProvenanceException("Failed to parse enum constant for provenance " + this.key + ".", e);
        }
        catch (ClassNotFoundException e) {
            throw new ProvenanceException("Failed to load class for " + this.provenanceClassName, e);
        }
    }

    public boolean isReference() {
        return this.isReference;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getProvenanceClassName() {
        return this.provenanceClassName;
    }

    public String getAdditional() {
        return this.additional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleMarshalledProvenance)) {
            return false;
        }
        SimpleMarshalledProvenance that = (SimpleMarshalledProvenance)o;
        return this.isReference == that.isReference && this.key.equals(that.key) && this.value.equals(that.value) && this.provenanceClassName.equals(that.provenanceClassName);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.provenanceClassName);
    }
}

