/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.CitationsConfig;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentFormat;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentBlock> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(DocumentBlock.getter(DocumentBlock::formatAsString)).setter(DocumentBlock.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DocumentBlock.getter(DocumentBlock::name)).setter(DocumentBlock.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<DocumentSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(DocumentBlock.getter(DocumentBlock::source)).setter(DocumentBlock.setter(Builder::source)).constructor(DocumentSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("context").getter(DocumentBlock.getter(DocumentBlock::context)).setter(DocumentBlock.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()}).build();
    private static final SdkField<CitationsConfig> CITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("citations").getter(DocumentBlock.getter(DocumentBlock::citations)).setter(DocumentBlock.setter(Builder::citations)).constructor(CitationsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAME_FIELD, SOURCE_FIELD, CONTEXT_FIELD, CITATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String format;
    private final String name;
    private final DocumentSource source;
    private final String context;
    private final CitationsConfig citations;

    private DocumentBlock(BuilderImpl builder) {
        this.format = builder.format;
        this.name = builder.name;
        this.source = builder.source;
        this.context = builder.context;
        this.citations = builder.citations;
    }

    public final DocumentFormat format() {
        return DocumentFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String name() {
        return this.name;
    }

    public final DocumentSource source() {
        return this.source;
    }

    public final String context() {
        return this.context;
    }

    public final CitationsConfig citations() {
        return this.citations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.citations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentBlock)) {
            return false;
        }
        DocumentBlock other = (DocumentBlock)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.context(), other.context()) && Objects.equals(this.citations(), other.citations());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentBlock").add("Format", (Object)this.formatAsString()).add("Name", (Object)this.name()).add("Source", (Object)this.source()).add("Context", (Object)this.context()).add("Citations", (Object)this.citations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "citations": {
                return Optional.ofNullable(clazz.cast(this.citations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("format", FORMAT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("citations", CITATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentBlock, T> g) {
        return obj -> g.apply((DocumentBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String name;
        private DocumentSource source;
        private String context;
        private CitationsConfig citations;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentBlock model) {
            this.format(model.format);
            this.name(model.name);
            this.source(model.source);
            this.context(model.context);
            this.citations(model.citations);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(DocumentFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DocumentSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(DocumentSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(DocumentSource source) {
            this.source = source;
            return this;
        }

        public final String getContext() {
            return this.context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final CitationsConfig.Builder getCitations() {
            return this.citations != null ? this.citations.toBuilder() : null;
        }

        public final void setCitations(CitationsConfig.BuilderImpl citations) {
            this.citations = citations != null ? citations.build() : null;
        }

        @Override
        public final Builder citations(CitationsConfig citations) {
            this.citations = citations;
            return this;
        }

        public DocumentBlock build() {
            return new DocumentBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentBlock> {
        public Builder format(String var1);

        public Builder format(DocumentFormat var1);

        public Builder name(String var1);

        public Builder source(DocumentSource var1);

        default public Builder source(Consumer<DocumentSource.Builder> source) {
            return this.source((DocumentSource)((DocumentSource.Builder)DocumentSource.builder().applyMutation(source)).build());
        }

        public Builder context(String var1);

        public Builder citations(CitationsConfig var1);

        default public Builder citations(Consumer<CitationsConfig.Builder> citations) {
            return this.citations((CitationsConfig)((CitationsConfig.Builder)CitationsConfig.builder().applyMutation(citations)).build());
        }
    }
}

