/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class MemoryStatsBase
implements PlainJsonSerializable {
    @Nullable
    private final String free;
    @Nullable
    private final Long freeInBytes;
    @Nullable
    private final String total;
    @Nullable
    private final Long totalInBytes;
    @Nullable
    private final String used;
    @Nullable
    private final Long usedInBytes;

    protected MemoryStatsBase(AbstractBuilder<?> builder) {
        this.free = ((AbstractBuilder)builder).free;
        this.freeInBytes = ((AbstractBuilder)builder).freeInBytes;
        this.total = ((AbstractBuilder)builder).total;
        this.totalInBytes = ((AbstractBuilder)builder).totalInBytes;
        this.used = ((AbstractBuilder)builder).used;
        this.usedInBytes = ((AbstractBuilder)builder).usedInBytes;
    }

    @Nullable
    public final String free() {
        return this.free;
    }

    @Nullable
    public final Long freeInBytes() {
        return this.freeInBytes;
    }

    @Nullable
    public final String total() {
        return this.total;
    }

    @Nullable
    public final Long totalInBytes() {
        return this.totalInBytes;
    }

    @Nullable
    public final String used() {
        return this.used;
    }

    @Nullable
    public final Long usedInBytes() {
        return this.usedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.free != null) {
            generator.writeKey("free");
            generator.write(this.free);
        }
        if (this.freeInBytes != null) {
            generator.writeKey("free_in_bytes");
            generator.write(this.freeInBytes.longValue());
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        if (this.totalInBytes != null) {
            generator.writeKey("total_in_bytes");
            generator.write(this.totalInBytes.longValue());
        }
        if (this.used != null) {
            generator.writeKey("used");
            generator.write(this.used);
        }
        if (this.usedInBytes != null) {
            generator.writeKey("used_in_bytes");
            generator.write(this.usedInBytes.longValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMemoryStatsBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::free, JsonpDeserializer.stringDeserializer(), "free");
        op.add(AbstractBuilder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(AbstractBuilder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(AbstractBuilder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
        op.add(AbstractBuilder::used, JsonpDeserializer.stringDeserializer(), "used");
        op.add(AbstractBuilder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.free);
        result = 31 * result + Objects.hashCode(this.freeInBytes);
        result = 31 * result + Objects.hashCode(this.total);
        result = 31 * result + Objects.hashCode(this.totalInBytes);
        result = 31 * result + Objects.hashCode(this.used);
        result = 31 * result + Objects.hashCode(this.usedInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryStatsBase other = (MemoryStatsBase)o;
        return Objects.equals(this.free, other.free) && Objects.equals(this.freeInBytes, other.freeInBytes) && Objects.equals(this.total, other.total) && Objects.equals(this.totalInBytes, other.totalInBytes) && Objects.equals(this.used, other.used) && Objects.equals(this.usedInBytes, other.usedInBytes);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String free;
        @Nullable
        private Long freeInBytes;
        @Nullable
        private String total;
        @Nullable
        private Long totalInBytes;
        @Nullable
        private String used;
        @Nullable
        private Long usedInBytes;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(MemoryStatsBase o) {
            this.free = o.free;
            this.freeInBytes = o.freeInBytes;
            this.total = o.total;
            this.totalInBytes = o.totalInBytes;
            this.used = o.used;
            this.usedInBytes = o.usedInBytes;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.free = o.free;
            this.freeInBytes = o.freeInBytes;
            this.total = o.total;
            this.totalInBytes = o.totalInBytes;
            this.used = o.used;
            this.usedInBytes = o.usedInBytes;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT free(@Nullable String value) {
            this.free = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT freeInBytes(@Nullable Long value) {
            this.freeInBytes = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT total(@Nullable String value) {
            this.total = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT totalInBytes(@Nullable Long value) {
            this.totalInBytes = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT used(@Nullable String value) {
            this.used = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT usedInBytes(@Nullable Long value) {
            this.usedInBytes = value;
            return this.self();
        }
    }
}

