"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTitle = void 0;
var common_1 = require("../../../../../utils/common");
var dimensions_1 = require("../../../../../utils/dimensions");
var axis_type_utils_1 = require("../../../utils/axis_type_utils");
var axis_utils_1 = require("../../../utils/axis_utils");
var text_1 = require("../primitives/text");
var debug_1 = require("../utils/debug");
var panel_title_1 = require("./panel_title");
function renderTitle(ctx, props) {
    if (!props.axisSpec.title || !props.axisStyle.axisTitle.visible) {
        return;
    }
    var _a = props.size, width = _a.width, height = _a.height, _b = props.axisSpec, position = _b.position, hideAxis = _b.hide, title = _b.title, _c = props.dimension, maxLabelBboxWidth = _c.maxLabelBboxWidth, maxLabelBboxHeight = _c.maxLabelBboxHeight, _d = props.axisStyle, axisTitle = _d.axisTitle, axisPanelTitle = _d.axisPanelTitle, tickLine = _d.tickLine, tickLabel = _d.tickLabel, anchorPoint = props.anchorPoint, debug = props.debug, panelTitle = props.panelTitle;
    var font = panel_title_1.getFontStyle(axisTitle);
    var titlePadding = dimensions_1.getSimplePadding(axisTitle.visible && title ? axisTitle.padding : 0);
    var panelTitleDimension = panelTitle ? axis_utils_1.getTitleDimension(axisPanelTitle) : 0;
    var tickDimension = axis_utils_1.shouldShowTicks(tickLine, hideAxis) ? tickLine.size + tickLine.padding : 0;
    var labelPadding = dimensions_1.getSimplePadding(tickLabel.padding);
    var horizontal = axis_type_utils_1.isHorizontalAxis(props.axisSpec.position);
    var maxLabelBoxSize = horizontal ? maxLabelBboxHeight : maxLabelBboxWidth;
    var labelSize = tickLabel.visible ? maxLabelBoxSize + labelPadding.outer + labelPadding.inner : 0;
    var offset = position === common_1.Position.Left || position === common_1.Position.Top
        ? titlePadding.outer
        : labelSize + tickDimension + titlePadding.inner + panelTitleDimension;
    var left = anchorPoint.x + (horizontal ? 0 : offset);
    var top = anchorPoint.y + (horizontal ? offset : height);
    if (debug) {
        debug_1.renderDebugRect(ctx, { x: left, y: top, width: horizontal ? width : height, height: font.fontSize }, undefined, undefined, horizontal ? 0 : -90);
    }
    text_1.renderText(ctx, { x: left + (horizontal ? width : font.fontSize) / 2, y: top + (horizontal ? font.fontSize : -height) / 2 }, title !== null && title !== void 0 ? title : '', font, horizontal ? 0 : -90);
}
exports.renderTitle = renderTitle;
//# sourceMappingURL=global_title.js.map