/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

final class NIOHeader
implements Diagnosable {
    private static final String CLASS_NAME = NIOHeader.class.getName();
    int length;
    int packetChecksum;
    int flags;
    int headerChecksum;
    int type;
    final SessionAtts session;

    NIOHeader(SessionAtts session) {
        this.session = session;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.session.getDiagnosable();
    }

    final void readHeaderBuffer() throws IOException, NetException {
        this.session.headerBufferForRead = this.session.readBuffer.slice();
        this.session.headerBufferForRead.clear();
        this.session.headerBufferForRead.limit(8);
        this.session.headerBufferForRead.rewind();
        this.readNSHeader();
    }

    final void readNSHeader() throws IOException {
        if (this.session.isLargeSDU && (this.type == 6 || this.type == 12 || this.type == 15 || this.type == 14)) {
            this.length = this.session.headerBufferForRead.getInt() & 0xFFFFFFFF;
        } else {
            this.length = this.session.headerBufferForRead.getShort() & 0xFFFF;
            this.packetChecksum = this.session.headerBufferForRead.getShort() & 0xFFFF;
        }
        this.type = this.session.headerBufferForRead.get() & 0xFF;
        this.flags = this.session.headerBufferForRead.get() & 0xFF;
        this.headerChecksum = this.session.headerBufferForRead.getShort() & 0xFFFF;
    }

    final void fillHeaderBuffer() throws IOException {
        this.session.headerBufferForWrite.clear();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "fillHeaderBuffer", "HeaderBuffer : {0}", (String)null, null, (Object)this.session.headerBufferForWrite);
        if (this.session.isLargeSDU && (this.type == 6 || this.type == 12 || this.type == 15 || this.type == 14)) {
            this.session.headerBufferForWrite.putInt(this.length);
        } else {
            this.session.headerBufferForWrite.putShort((short)this.length);
            this.session.headerBufferForWrite.putShort((short)0);
        }
        this.session.headerBufferForWrite.put((byte)this.type);
        this.session.headerBufferForWrite.put((byte)this.flags);
        this.session.headerBufferForWrite.putShort((short)0);
    }
}

