/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.InstrumenterVertxTracer;
import io.vertx.core.MultiMap;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class OpenTelemetryVertxTracer
implements VertxTracer<SpanOperation, SpanOperation> {
    private final List<InstrumenterVertxTracer<?, ?>> instrumenterVertxTracers;

    public OpenTelemetryVertxTracer(List<InstrumenterVertxTracer<?, ?>> instrumenterVertxTracers) {
        this.instrumenterVertxTracers = Collections.unmodifiableList(instrumenterVertxTracers);
    }

    public <R> SpanOperation receiveRequest(io.vertx.core.Context context, SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        return (SpanOperation)this.getTracer(request, tagExtractor).receiveRequest(context, kind, policy, request, operation, headers, tagExtractor);
    }

    public <R> void sendResponse(io.vertx.core.Context context, R response, SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        this.getTracer(spanOperation, tagExtractor).sendResponse(context, response, (Object)spanOperation, failure, tagExtractor);
    }

    public <R> SpanOperation sendRequest(io.vertx.core.Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        return (SpanOperation)this.getTracer(request, tagExtractor).sendRequest(context, kind, policy, request, operation, headers, tagExtractor);
    }

    public <R> void receiveResponse(io.vertx.core.Context context, R response, SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        this.getTracer(spanOperation, tagExtractor).receiveResponse(context, response, (Object)spanOperation, failure, tagExtractor);
    }

    private <R> VertxTracer<SpanOperation, SpanOperation> getTracer(R request, TagExtractor<R> tagExtractor) {
        for (InstrumenterVertxTracer<?, ?> instrumenterVertxTracer : this.instrumenterVertxTracers) {
            if (!instrumenterVertxTracer.canHandle(request, tagExtractor)) continue;
            return instrumenterVertxTracer;
        }
        return NOOP;
    }

    private <R> VertxTracer<SpanOperation, SpanOperation> getTracer(SpanOperation spanOperation, TagExtractor<R> tagExtractor) {
        return spanOperation != null ? this.getTracer(spanOperation.getRequest(), tagExtractor) : NOOP;
    }

    static class SpanOperation {
        private final io.vertx.core.Context context;
        private final Object request;
        private final MultiMap headers;
        private final Context spanContext;
        private final Scope scope;

        public SpanOperation(io.vertx.core.Context context, Object request, MultiMap headers, Context spanContext, Scope scope) {
            this.context = context;
            this.request = request;
            this.headers = headers;
            this.spanContext = spanContext;
            this.scope = scope;
        }

        public io.vertx.core.Context getContext() {
            return this.context;
        }

        public Object getRequest() {
            return this.request;
        }

        public MultiMap getHeaders() {
            return this.headers;
        }

        public Context getSpanContext() {
            return this.spanContext;
        }

        public Scope getScope() {
            return this.scope;
        }

        static SpanOperation span(io.vertx.core.Context context, Object request, MultiMap headers, Context spanContext, Scope scope) {
            return new SpanOperation(context, request, headers, spanContext, scope);
        }
    }
}

