/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import io.github.dmlloyd.classfile.ClassFileTransform;
import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.CodeElement;
import io.github.dmlloyd.classfile.impl.TransformImpl;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

@FunctionalInterface
public interface CodeTransform
extends ClassFileTransform<CodeTransform, CodeElement, CodeBuilder> {
    public static final CodeTransform ACCEPT_ALL = new CodeTransform(){

        @Override
        public void accept(CodeBuilder builder, CodeElement element) {
            builder.with(element);
        }
    };

    public static CodeTransform ofStateful(Supplier<CodeTransform> supplier) {
        return new TransformImpl.SupplierCodeTransform(Objects.requireNonNull(supplier));
    }

    public static CodeTransform endHandler(final Consumer<CodeBuilder> finisher) {
        Objects.requireNonNull(finisher);
        return new CodeTransform(){

            @Override
            public void accept(CodeBuilder builder, CodeElement element) {
                builder.with(element);
            }

            @Override
            public void atEnd(CodeBuilder builder) {
                finisher.accept(builder);
            }
        };
    }

    @Override
    default public CodeTransform andThen(CodeTransform t) {
        return new TransformImpl.ChainedCodeTransform(this, Objects.requireNonNull(t));
    }
}

