/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class ContainsValueMultimapOperation
extends RetryOnFailureOperation<Boolean> {
    protected final byte[] value;
    private final long lifespan;
    private final long maxIdle;
    private final TimeUnit lifespanTimeUnit;
    private final TimeUnit maxIdleTimeUnit;
    private final boolean supportsDuplicates;

    protected ContainsValueMultimapOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, boolean supportsDuplicates) {
        super((short)119, (short)120, codec, channelFactory, cacheName, clientTopology, flags, cfg, null, null);
        this.value = value;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
        this.supportsDuplicates = supportsDuplicates;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        this.sendValueOperation(channel);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExist(status)) {
            this.complete(Boolean.FALSE);
        } else {
            this.complete(buf.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void sendValueOperation(Channel channel) {
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + this.codec.estimateExpirationSize(this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit) + ByteBufUtil.estimateArraySize(this.value) + this.codec.estimateSizeMultimapSupportsDuplicated());
        this.codec.writeHeader(buf, this.header);
        this.codec.writeExpirationParams(buf, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        ByteBufUtil.writeArray(buf, this.value);
        this.codec.writeMultimapSupportDuplicates(buf, this.supportsDuplicates);
        channel.writeAndFlush((Object)buf);
    }
}

