/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;

public class OwnershipStatistics {
    private final List<Address> nodes;
    private final Map<Address, Integer> nodesMap;
    private final int[] primaryOwned;
    private final int[] owned;
    private int sumPrimary;
    private int sumOwned;

    public OwnershipStatistics(List<Address> nodes) {
        this.nodes = nodes;
        this.nodesMap = new HashMap<Address, Integer>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            this.nodesMap.put(nodes.get(i), i);
        }
        if (this.nodesMap.size() != nodes.size()) {
            throw new IllegalArgumentException("Nodes are not distinct: " + String.valueOf(nodes));
        }
        this.primaryOwned = new int[nodes.size()];
        this.owned = new int[nodes.size()];
    }

    public OwnershipStatistics(ConsistentHash ch, List<Address> activeNodes) {
        this(activeNodes);
        for (int i = 0; i < ch.getNumSegments(); ++i) {
            List<Address> owners = ch.locateOwnersForSegment(i);
            for (int j = 0; j < owners.size(); ++j) {
                Address address = owners.get(j);
                Integer nodeIndex = this.nodesMap.get(address);
                if (nodeIndex == null) continue;
                if (j == 0) {
                    int n = nodeIndex;
                    this.primaryOwned[n] = this.primaryOwned[n] + 1;
                    ++this.sumPrimary;
                }
                int n = nodeIndex;
                this.owned[n] = this.owned[n] + 1;
                ++this.sumOwned;
            }
        }
    }

    public OwnershipStatistics(ConsistentHash ch) {
        this(ch, ch.getMembers());
    }

    public OwnershipStatistics(OwnershipStatistics other) {
        this.nodes = other.nodes;
        this.nodesMap = other.nodesMap;
        this.primaryOwned = Arrays.copyOf(other.primaryOwned, other.primaryOwned.length);
        this.owned = Arrays.copyOf(other.owned, other.owned.length);
        this.sumPrimary = other.sumPrimary;
        this.sumOwned = other.sumOwned;
    }

    public int getPrimaryOwned(Address a) {
        Integer i = this.nodesMap.get(a);
        if (i == null) {
            return 0;
        }
        return this.primaryOwned[i];
    }

    public int getOwned(Address a) {
        Integer i = this.nodesMap.get(a);
        if (i == null) {
            return 0;
        }
        return this.owned[i];
    }

    public void incPrimaryOwned(Address a) {
        Integer i = this.nodesMap.get(a);
        if (i == null) {
            throw new IllegalArgumentException("Trying to modify statistics for a node that doesn't exist: " + String.valueOf(a));
        }
        int n = i;
        this.primaryOwned[n] = this.primaryOwned[n] + 1;
        ++this.sumPrimary;
    }

    public void incOwned(Address a) {
        Integer i = this.nodesMap.get(a);
        if (i == null) {
            throw new IllegalArgumentException("Trying to modify statistics for a node that doesn't exist: " + String.valueOf(a));
        }
        int n = i;
        this.owned[n] = this.owned[n] + 1;
        ++this.sumOwned;
    }

    public void decPrimaryOwned(Address a) {
        Integer i = this.nodesMap.get(a);
        if (i == null) {
            throw new IllegalArgumentException("Trying to modify statistics for a node that doesn't exist: " + String.valueOf(a));
        }
        int n = i;
        this.primaryOwned[n] = this.primaryOwned[n] - 1;
        --this.sumPrimary;
    }

    public void decOwned(Address a) {
        Integer i = this.nodesMap.get(a);
        if (i == null) {
            throw new IllegalArgumentException("Trying to modify statistics for a node that doesn't exist: " + String.valueOf(a));
        }
        int n = i;
        this.owned[n] = this.owned[n] - 1;
        --this.sumOwned;
    }

    public int getPrimaryOwned(int nodeIndex) {
        return this.primaryOwned[nodeIndex];
    }

    public int getOwned(int nodeIndex) {
        return this.owned[nodeIndex];
    }

    public void incPrimaryOwned(int nodeIndex) {
        int n = nodeIndex;
        this.primaryOwned[n] = this.primaryOwned[n] + 1;
        ++this.sumPrimary;
    }

    public void incOwned(int nodeIndex) {
        int n = nodeIndex;
        this.owned[n] = this.owned[n] + 1;
        ++this.sumOwned;
    }

    public void incOwned(int nodeIndex, boolean primary) {
        int n = nodeIndex;
        this.owned[n] = this.owned[n] + 1;
        ++this.sumOwned;
        if (primary) {
            this.incPrimaryOwned(nodeIndex);
        }
    }

    public void decPrimaryOwned(int nodeIndex) {
        int n = nodeIndex;
        this.primaryOwned[n] = this.primaryOwned[n] - 1;
        --this.sumPrimary;
    }

    public void decOwned(int nodeIndex) {
        int n = nodeIndex;
        this.owned[n] = this.owned[n] - 1;
        --this.sumOwned;
    }

    public int sumPrimaryOwned() {
        return this.sumPrimary;
    }

    public int sumOwned() {
        return this.sumOwned;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OwnershipStatistics{");
        boolean isFirst = true;
        for (Address node : this.nodes) {
            if (!isFirst) {
                sb.append(", ");
            }
            Integer index = this.nodesMap.get(node);
            sb.append(node).append(": ").append(this.owned[index]).append('(').append(this.primaryOwned[index]).append("p)");
            isFirst = false;
        }
        sb.append('}');
        return sb.toString();
    }
}

