/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.ProjectTaskContext;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.GradleImprovedHotswapOutput;

@ApiStatus.Experimental
public final class GradleImprovedHotswapDetection {
    private GradleImprovedHotswapDetection() {
    }

    public static void processInitScriptOutput(ProjectTaskContext context, @Nullable Path outputPathsFile) {
        if (outputPathsFile == null) {
            return;
        }
        Collection<GradleImprovedHotswapOutput> outputs = GradleImprovedHotswapOutput.parseOutputFile(outputPathsFile);
        outputs.stream().filter(output -> !StringUtil.isEmpty((String)output.getPath())).forEach(output -> context.fileGenerated(output.getRoot(), output.getPath()));
        Set dirtyRoots = outputs.stream().filter(output -> StringUtil.isEmpty((String)output.getPath())).map(GradleImprovedHotswapOutput::getRoot).collect(Collectors.toSet());
        context.addDirtyOutputPathsProvider(() -> dirtyRoots);
    }

    public static boolean isEnabled() {
        return Registry.is((String)"gradle.improved.hotswap.detection", (boolean)false);
    }
}

