/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.function.Function;
import javax.swing.Icon;
import org.jungrapht.visualization.LayeredIcon;
import org.jungrapht.visualization.renderers.Checkmark;

public class SelectionIconListener<V>
implements ItemListener {
    Function<V, Icon> imager;
    Icon checked;

    public SelectionIconListener(Function<V, Icon> imager) {
        this.imager = imager;
        this.checked = new Checkmark(Color.red);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() instanceof Collection) {
            ((Collection)e.getItem()).forEach(n -> this.updatePickIcon(n, e.getStateChange()));
        } else {
            this.updatePickIcon(e.getItem(), e.getStateChange());
        }
    }

    private void updatePickIcon(V n, int stateChange) {
        Icon icon = this.imager.apply(n);
        if (icon instanceof LayeredIcon) {
            if (stateChange == 1) {
                ((LayeredIcon)icon).add(this.checked);
            } else {
                ((LayeredIcon)icon).remove(this.checked);
            }
        }
    }
}

