/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.timeoverview.timetype;

import docking.DialogComponentProvider;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.debug.gui.timeoverview.TimeOverviewColorComponent;
import ghidra.app.plugin.core.debug.gui.timeoverview.TimeOverviewColorPlugin;
import ghidra.app.plugin.core.debug.gui.timeoverview.TimeOverviewColorService;
import ghidra.app.plugin.core.debug.gui.timeoverview.timetype.TimeType;
import ghidra.app.plugin.core.debug.gui.timeoverview.timetype.TimeTypeOverviewLegendPanel;
import ghidra.app.plugin.core.overview.OverviewColorLegendDialog;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.ColorUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.apache.commons.lang3.tuple.Pair;

public class TimeTypeOverviewColorService
implements TimeOverviewColorService {
    private static final String OPTIONS_NAME = "Time Overview";
    private static final Color DEFAULT_UNDEFINED_COLOR = Color.LIGHT_GRAY;
    private static final Color DEFAULT_UNINITIALIZED_COLOR = Color.GRAY;
    Map<TimeType, Color> colorMap = new HashMap<TimeType, Color>();
    Color undefinedColor = DEFAULT_UNDEFINED_COLOR;
    Color uninitializedColor = DEFAULT_UNINITIALIZED_COLOR;
    private Trace trace;
    protected TimeOverviewColorComponent overviewComponent;
    private PluginTool tool;
    private DialogComponentProvider legendDialog;
    private TimeTypeOverviewLegendPanel legendPanel;
    private TimeOverviewColorPlugin plugin;
    protected Map<Integer, Long> indexToSnap = new HashMap<Integer, Long>();
    protected Map<Long, Integer> snapToIndex = new HashMap<Long, Integer>();
    protected Lifespan bounds;

    @Override
    public String getName() {
        return "Trace Overview";
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("DebuggerTimeOverviewPlugin", "plugin");
    }

    @Override
    public Color getColor(Long snap) {
        Set<Pair<TimeType, String>> types = this.plugin.getTypes(snap);
        Object c = GThemeDefaults.Colors.BACKGROUND;
        for (Pair<TimeType, String> pair : types) {
            c = ColorUtils.addColors((Color)c, (Color)((TimeType)((Object)pair.getLeft())).getDefaultColor());
        }
        return c;
    }

    @Override
    public String getToolTipText(Long snap) {
        if (snap == null) {
            return "";
        }
        TraceSchedule.TimeRadix radix = this.trace == null ? TraceSchedule.TimeRadix.DEFAULT : this.trace.getTimeManager().getTimeRadix();
        Set<Pair<TimeType, String>> types = this.plugin.getTypes(snap);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<b>");
        buffer.append(HTMLUtilities.escapeHTML((String)this.getName()));
        buffer.append(" (");
        buffer.append(radix.format(snap.longValue()));
        buffer.append(")");
        buffer.append("</b>\n");
        for (Pair<TimeType, String> pair : types) {
            TimeType tt = (TimeType)((Object)pair.getLeft());
            String key = (String)pair.getRight();
            buffer.append(tt.getDescription() + " : " + key + "\n");
        }
        return HTMLUtilities.toWrappedHTML((String)buffer.toString(), (int)0);
    }

    @Override
    public List<DockingActionIf> getActions() {
        ArrayList<DockingActionIf> actions = new ArrayList<DockingActionIf>();
        actions.add((DockingActionIf)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Show Legend", this.getName()).popupMenuPath(new String[]{"Show Legend"})).description("Show types and associated colors")).helpLocation(this.getHelpLocation())).enabledWhen(c -> c.getContextObject() == this.overviewComponent)).onAction(c -> this.tool.showDialog(this.getLegendDialog()))).build());
        return actions;
    }

    @Override
    public void setTrace(Trace trace) {
        this.trace = trace;
    }

    @Override
    public void initialize(PluginTool pluginTool) {
        this.tool = pluginTool;
    }

    @Override
    public void setOverviewComponent(TimeOverviewColorComponent component) {
        this.overviewComponent = component;
    }

    public Color getColor(TimeType timeType) {
        Color color = this.colorMap.get((Object)timeType);
        if (color == null) {
            this.colorMap.put(timeType, timeType.getDefaultColor());
        }
        return color;
    }

    public void setColor(TimeType type, Color newColor) {
        ToolOptions options = this.tool.getOptions(OPTIONS_NAME);
        options.setColor(type.getDescription(), newColor);
    }

    private DialogComponentProvider getLegendDialog() {
        if (this.legendDialog == null) {
            this.legendPanel = new TimeTypeOverviewLegendPanel(this);
            this.legendDialog = new OverviewColorLegendDialog("Overview Legend", (JComponent)this.legendPanel, this.getHelpLocation());
        }
        return this.legendDialog;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public void setPlugin(TimeOverviewColorPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Long getSnap(int pixelIndex) {
        BigInteger bigHeight = BigInteger.valueOf(this.overviewComponent.getOverviewPixelCount());
        BigInteger bigPixelIndex = BigInteger.valueOf(pixelIndex);
        BigInteger span = BigInteger.valueOf(this.indexToSnap.size());
        BigInteger offset = span.multiply(bigPixelIndex).divide(bigHeight);
        return this.indexToSnap.get(offset.intValue());
    }

    @Override
    public void setIndices(TreeSet<Long> set) {
        this.snapToIndex = new HashMap<Long, Integer>();
        this.indexToSnap = new HashMap<Integer, Long>();
        int index = 0;
        for (Long snap : set) {
            this.snapToIndex.put(snap, index);
            this.indexToSnap.put(index, snap);
            ++index;
        }
    }

    @Override
    public Lifespan getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Lifespan bounds) {
        this.bounds = bounds;
    }
}

