/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import ghidra.framework.main.datatree.VersionControlDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.SystemUtilities;
import ghidra.util.task.Task;
import java.awt.Component;
import java.util.List;

public abstract class VersionControlTask
extends Task {
    protected List<DomainFile> list;
    protected int actionID;
    protected boolean keepCheckedOut;
    protected boolean createKeep;
    protected String comments;
    protected boolean filesInUse;
    protected PluginTool tool;
    protected boolean wasCanceled;
    protected Component parent;

    protected VersionControlTask(String title, PluginTool tool, List<DomainFile> list, Component parent) {
        super(title, true, true, true);
        this.tool = tool;
        this.list = list;
        this.parent = parent;
    }

    protected void showDialog(boolean addToVersionControl, DomainFile file) {
        Runnable r = () -> {
            VersionControlDialog vcDialog = new VersionControlDialog(addToVersionControl);
            vcDialog.setCurrentFileName(file.getName());
            vcDialog.setMultiFiles(this.list.size() > 1);
            if (file.isLinkFile()) {
                vcDialog.setKeepCheckboxEnabled(false, false, "Link file may not be Checked Out");
            } else {
                this.checkFilesInUse();
                if (this.filesInUse) {
                    vcDialog.setKeepCheckboxEnabled(false, true, "Must keep Checked Out because the file is in use");
                }
            }
            this.actionID = vcDialog.showDialog(this.tool, this.parent);
            this.keepCheckedOut = vcDialog.keepCheckedOut();
            this.createKeep = vcDialog.shouldCreateKeepFile();
            this.comments = vcDialog.getComments();
            if (this.comments.length() == 0) {
                this.comments = null;
            }
        };
        SystemUtilities.runSwingNow((Runnable)r);
    }

    protected void checkFilesInUse() {
        this.filesInUse = false;
        for (DomainFile df : this.list) {
            if (df.getConsumers().size() <= 0) continue;
            this.filesInUse = true;
            return;
        }
    }

    protected boolean checkFilesForUnsavedChanges() {
        for (DomainFile df : this.list) {
            if (!df.modifiedSinceCheckout()) continue;
            return true;
        }
        return false;
    }
}

