/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.util.Msg;
import ghidra.util.NamingUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Random;

public class LockFile {
    private static final int DEFAULT_MAX_LOCK_LEASE_PERIOD_MS = 15000;
    private static final int DEFAULT_LOCK_RENEWAL_PERIOD = 13000;
    private static final int DEFAULT_TIMEOUT_MS = 30000;
    private static final int MAX_DELETE_TRIES = 3;
    private int maxLockLeasePeriod = 15000;
    private int lockRenewalPeriod = 13000;
    private int lockTimeout = 30000;
    private static final String LOCK = "lock";
    public static int nextInstanceId;
    private int instanceId;
    private static int debugId;
    private File lockFile;
    private long deltaTime = Long.MAX_VALUE;
    private Object waitLock = new Object();
    private GTimerMonitor waitTimerMonitor;
    private WaitForLockRunnable waitTask;
    private Object holdLock = new Object();
    private GTimerMonitor holdTimerMonitor;
    private int lockCount = 0;
    private long myLockTime = 0L;

    private static int getDebugId() {
        int id = new Random().nextInt();
        if (id < 0) {
            id = -id;
        }
        return id;
    }

    LockFile(File dir, String name, int maxLockLeasePeriod, int lockRenewalPeriod, int lockTimeout) {
        this(dir, name, "");
        this.maxLockLeasePeriod = maxLockLeasePeriod;
        this.lockRenewalPeriod = lockRenewalPeriod;
        this.lockTimeout = lockTimeout;
    }

    public LockFile(File dir, String name) {
        this(dir, name, "");
    }

    public LockFile(File dir, String name, String lockType) {
        if (lockType.indexOf(46) >= 0) {
            throw new AssertException("Illegal lockType");
        }
        this.lockFile = new File(dir, NamingUtilities.mangle(name) + "." + lockType + LOCK);
        this.instanceId = LockFile.getNextInstanceId();
        Msg.trace((Object)this, (Object)("Instantiated lock: " + this.getLockID()));
    }

    public LockFile(File file) {
        this.lockFile = new File(file.getParentFile(), file.getName() + ".lock");
        this.instanceId = LockFile.getNextInstanceId();
        Msg.trace((Object)this, (Object)("Instantiated lock: " + this.getLockID()));
    }

    private static boolean hasAnyLock(File dir, final String mangledName) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fname = pathname.getName();
                if (fname.startsWith(mangledName) && fname.endsWith(LockFile.LOCK)) {
                    String s = fname.substring(mangledName.length(), fname.length() - LockFile.LOCK.length());
                    return s.indexOf(46) == 0 && s.indexOf(46, 1) < 0;
                }
                return false;
            }
        };
        File[] files = dir.listFiles(filter);
        return files != null && files.length != 0;
    }

    public static boolean isLocked(File dir, String name) {
        return LockFile.hasAnyLock(dir, NamingUtilities.mangle(name));
    }

    public static boolean isLocked(File file) {
        return LockFile.hasAnyLock(file.getParentFile(), file.getName());
    }

    public static boolean containsLock(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!(files[i].isDirectory() ? LockFile.containsLock(files[i]) : files[i].getName().endsWith(LOCK))) continue;
            return true;
        }
        return false;
    }

    private static synchronized int getNextInstanceId() {
        return nextInstanceId++;
    }

    private static synchronized int getNextDebugId() {
        return ++debugId;
    }

    public boolean haveLock() {
        return this.lockCount != 0;
    }

    public boolean haveLock(boolean verify) {
        if (this.lockCount != 0) {
            if (!verify || this.myLockTime == this.lockFile.lastModified()) {
                return true;
            }
            Msg.trace((Object)this, (Object)("lock was stolen : " + this.getLockID()));
            this.lockCount = 0;
        }
        return false;
    }

    private boolean renewLock() {
        if (this.haveLock(true) && this.setLockOwner()) {
            this.myLockTime = this.lockFile.lastModified();
            return true;
        }
        return false;
    }

    public String getLockOwner() {
        return this.getLockOwner(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLockOwner(boolean includeId) {
        String owner = null;
        FileInputStream fin = null;
        try {
            int spaceIndex;
            fin = new FileInputStream(this.lockFile);
            byte[] bytes = new byte[32];
            int cnt = fin.read(bytes);
            owner = new String(bytes, 0, cnt);
            if (!includeId && (spaceIndex = owner.indexOf(32)) > 0) {
                owner = owner.substring(0, spaceIndex);
            }
        }
        catch (Exception e) {
            owner = "<Unknown>";
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
        return owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setLockOwner() {
        Msg.trace((Object)this, (Object)("writing lock data : " + this.getLockID()));
        FilterOutputStream fout = null;
        boolean success = false;
        try {
            fout = new BufferedOutputStream(new FileOutputStream(this.lockFile, false));
            fout.write((SystemUtilities.getUserName() + " " + LockFile.getNextDebugId()).getBytes());
            success = true;
        }
        catch (Exception exception) {
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
            if (!success) {
                this.lockFile.delete();
            }
        }
        return success;
    }

    private String getLockID() {
        return this.lockFile.getName() + "(" + this.instanceId + "," + Thread.currentThread().getName() + ")";
    }

    public String toString() {
        return this.getLockID();
    }

    public synchronized void removeLock() {
        if (this.haveLock(true)) {
            if (--this.lockCount == 0) {
                this.holdLock(false);
                Msg.trace((Object)this, (Object)("removing lock : " + this.getLockID()));
                int tryCnt = 3;
                while (tryCnt-- > 0 && !this.lockFile.delete()) {
                    Msg.warn((Object)this, (Object)("Failed to remove lock file : " + this.getLockID()));
                }
            } else {
                Msg.trace((Object)this, (Object)("lock count reduced (" + this.lockCount + "): " + this.getLockID()));
            }
        } else {
            Msg.trace((Object)this, (Object)("attempted to remove lock which I do not own " + this.getLockOwner(true) + ": " + this.getLockID()));
            try {
                throw new AssertException("Lock time = " + this.lockFile.lastModified());
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean createLock() {
        return this.createLock(this.lockTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean createLock(int timeout, boolean hold) {
        Object object = this.waitLock;
        synchronized (object) {
            if (this.lockCount != 0 && this.renewLock()) {
                ++this.lockCount;
                Msg.trace((Object)this, (Object)("increased lock count (" + this.lockCount + "): " + this.getLockID()));
                if (hold) {
                    this.holdLock(true);
                }
                return true;
            }
            try {
                if (this.createLockFileNoWait(true)) {
                    if (this.waitTask != null) {
                        this.waitTask.abort = true;
                    }
                    ++this.lockCount;
                    Msg.trace((Object)this, (Object)("increased lock count (" + this.lockCount + "): " + this.getLockID()));
                    if (hold) {
                        this.holdLock(true);
                    }
                    return true;
                }
            }
            catch (IOException e) {
                Msg.showError((Object)this, null, (String)"Lock Failure", (Object)("Unable to write to lock file: " + this.lockFile.getAbsolutePath()), (Throwable)e);
                return false;
            }
            Msg.trace((Object)this, (Object)("wait for lock...: " + this.getLockID()));
            this.startWaitTimer(timeout != 0);
            if (timeout == 0) {
                return false;
            }
        }
        if (this.waitTask != null && timeout > 0) {
            object = this.waitTask;
            synchronized (object) {
                try {
                    this.waitTask.wait(timeout);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        object = this.waitLock;
        synchronized (object) {
            if (this.waitTask != null) {
                WaitForLockRunnable waitForLockRunnable = this.waitTask;
                synchronized (waitForLockRunnable) {
                    this.waitTask.create = false;
                }
            }
            if (this.lockCount != 0) {
                if (hold) {
                    this.holdLock(true);
                }
                return true;
            }
            Msg.trace((Object)this, (Object)("failed to obtain lock...: " + this.getLockID()));
            return false;
        }
    }

    private boolean createLockFileNoWait(boolean testLock) throws IOException {
        Msg.trace((Object)this, (Object)("attempt lock creation...: " + this.getLockID()));
        boolean lockCreated = this.lockFile.createNewFile();
        if (!lockCreated && testLock) {
            long ltime = this.lockFile.lastModified();
            if (ltime != 0L) {
                if (this.deltaTime == Long.MAX_VALUE) {
                    File testFile = File.createTempFile("test", ".tmp", this.lockFile.getParentFile());
                    this.deltaTime = new Date().getTime() - testFile.lastModified();
                    testFile.delete();
                }
                if (ltime < new Date().getTime() - (long)this.maxLockLeasePeriod - this.deltaTime) {
                    this.lockFile.delete();
                    Msg.warn((Object)this, (Object)("Forcefully removing lock owned by " + this.getLockOwner(true) + ": " + this.getLockID()));
                    lockCreated = this.lockFile.createNewFile();
                }
            } else {
                lockCreated = this.lockFile.createNewFile();
            }
        }
        if (!lockCreated || !this.setLockOwner()) {
            Msg.trace((Object)this, (Object)("lock denied by " + this.getLockOwner(true) + ": " + this.getLockID()));
            return false;
        }
        Msg.trace((Object)this, (Object)("lock created (" + debugId + "): " + this.getLockID()));
        this.myLockTime = this.lockFile.lastModified();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWaitTimer(boolean create) {
        Object object = this.waitLock;
        synchronized (object) {
            if (this.waitTask == null) {
                this.waitTask = new WaitForLockRunnable(create, 1000);
                this.waitTimerMonitor = GTimer.scheduleRepeatingRunnable((long)500L, (long)1000L, (Runnable)this.waitTask);
            } else {
                this.waitTask.create = create;
            }
        }
    }

    private void endWaitTimer() {
        this.waitTimerMonitor.cancel();
        this.waitTimerMonitor = null;
        this.waitTask = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void holdLock(boolean hold) {
        Object object = this.holdLock;
        synchronized (object) {
            if (this.holdTimerMonitor != null) {
                if (!hold) {
                    this.holdTimerMonitor.cancel();
                    this.holdTimerMonitor = null;
                }
            } else if (hold) {
                this.holdTimerMonitor = GTimer.scheduleRepeatingRunnable((long)this.lockRenewalPeriod, (long)this.lockRenewalPeriod, (Runnable)new HoldLockRunnable());
            }
        }
    }

    public synchronized void dispose() {
        this.holdLock(false);
        if (this.waitTimerMonitor != null) {
            this.waitTimerMonitor.cancel();
            this.waitTimerMonitor = null;
            this.waitTask = null;
        }
        if (this.lockCount != 0) {
            this.removeLock();
        }
    }

    protected void finalize() {
        this.dispose();
    }

    static {
        debugId = LockFile.getDebugId();
    }

    private class WaitForLockRunnable
    implements Runnable {
        private int interval;
        private boolean create;
        private long lastModTime;
        private int maxLeaseTime;
        private boolean abort = false;

        WaitForLockRunnable(boolean create, int interval) {
            this.interval = interval;
            this.create = create;
            this.maxLeaseTime = LockFile.this.maxLockLeasePeriod;
            this.lastModTime = LockFile.this.lockFile.lastModified();
        }

        private synchronized void terminate() {
            LockFile.this.endWaitTimer();
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LockFile.this.waitLock;
            synchronized (object) {
                if (this.abort) {
                    this.terminate();
                    return;
                }
                this.maxLeaseTime -= this.interval;
                long mt = LockFile.this.lockFile.lastModified();
                if (mt != 0L) {
                    if (mt != this.lastModTime) {
                        if (!this.create) {
                            this.terminate();
                        } else {
                            this.maxLeaseTime = LockFile.this.maxLockLeasePeriod;
                            this.lastModTime = mt;
                            Msg.trace((Object)this, (Object)(LockFile.this.getLockOwner(true) + " grabbed lock before I could: " + LockFile.this.getLockID()));
                        }
                        return;
                    }
                    Msg.trace((Object)this, (Object)(LockFile.this.getLockOwner(true) + " has held lock for " + (LockFile.this.maxLockLeasePeriod - this.maxLeaseTime) / 1000 + " seconds: " + LockFile.this.getLockID()));
                    if (this.maxLeaseTime > 0) {
                        return;
                    }
                    LockFile.this.lockFile.delete();
                    Msg.warn((Object)this, (Object)("Forcefully removing lock owned by " + LockFile.this.getLockOwner(true) + ": " + LockFile.this.getLockID()));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        this.create = false;
                    }
                }
                if (this.create) {
                    try {
                        if (LockFile.this.createLockFileNoWait(false)) {
                            Msg.trace((Object)this, (Object)(String.valueOf(new Date()) + " LockFile: lock granted after wait: " + LockFile.this.getLockID()));
                            ++LockFile.this.lockCount;
                        } else {
                            this.maxLeaseTime = LockFile.this.maxLockLeasePeriod;
                            return;
                        }
                        this.terminate();
                    }
                    catch (IOException e) {
                        Msg.showError((Object)this, null, (String)"Lock Failure", (Object)("Unable to write to lock file: " + LockFile.this.lockFile.getAbsolutePath()), (Throwable)e);
                        this.terminate();
                    }
                }
                this.lastModTime = 0L;
            }
        }
    }

    private class HoldLockRunnable
    implements Runnable {
        private HoldLockRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LockFile.this.holdLock;
            synchronized (object) {
                if (LockFile.this.holdTimerMonitor == null) {
                    return;
                }
                if (!LockFile.this.renewLock()) {
                    LockFile.this.holdTimerMonitor.cancel();
                    LockFile.this.holdTimerMonitor = null;
                }
            }
        }
    }
}

