/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.security.auth.callback.Callback;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.DSAKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.util.Strings;

public class SSHSignatureCallback
implements Callback,
Serializable {
    public static final long serialVersionUID = 1L;
    private final byte[] token;
    private final byte[] serverSignature;
    private byte[] signature;

    public SSHSignatureCallback(byte[] token, byte[] serverSignature) {
        this.token = token;
        this.serverSignature = serverSignature;
    }

    public byte[] getToken() {
        return this.token == null ? null : (byte[])this.token.clone();
    }

    public byte[] getSignature() {
        return this.signature == null ? null : (byte[])this.signature.clone();
    }

    public byte[] getServerSignature() {
        return this.serverSignature;
    }

    public boolean isSigned() {
        return this.signature != null;
    }

    private static void sshBuilderWriteUInt32(int value, ByteArrayOutputStream out) {
        byte[] tmp = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        out.writeBytes(tmp);
    }

    private static void sshBuilderWriteBlock(byte[] value, ByteArrayOutputStream out) {
        SSHSignatureCallback.sshBuilderWriteUInt32(value.length, out);
        out.writeBytes(value);
    }

    private static void sshBuilderWriteString(String str, ByteArrayOutputStream out) {
        SSHSignatureCallback.sshBuilderWriteBlock(Strings.toByteArray((String)str), out);
    }

    public void sign(Object privateKeyParameters) throws IOException {
        block4: {
            try {
                if (privateKeyParameters instanceof RSAKeyParameters) {
                    RSAKeyParameters cipherParams = (RSAKeyParameters)privateKeyParameters;
                    RSADigestSigner signer = new RSADigestSigner((Digest)new SHA1Digest());
                    signer.init(true, (CipherParameters)cipherParams);
                    signer.update(this.token, 0, this.token.length);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    SSHSignatureCallback.sshBuilderWriteString("ssh-rsa", out);
                    SSHSignatureCallback.sshBuilderWriteBlock(signer.generateSignature(), out);
                    this.signature = out.toByteArray();
                    break block4;
                }
                if (privateKeyParameters instanceof DSAKeyParameters) {
                    DSAKeyParameters cipherParams = (DSAKeyParameters)privateKeyParameters;
                    DSADigestSigner signer = new DSADigestSigner((DSA)new DSASigner(), (Digest)new SHA1Digest());
                    signer.init(true, (CipherParameters)cipherParams);
                    signer.update(this.token, 0, this.token.length);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    SSHSignatureCallback.sshBuilderWriteString("ssh-dss", out);
                    SSHSignatureCallback.sshBuilderWriteBlock(signer.generateSignature(), out);
                    this.signature = out.toByteArray();
                    break block4;
                }
                throw new IllegalArgumentException("Unsupported SSH private key");
            }
            catch (CryptoException | DataLengthException e) {
                throw new IOException("Cannot generate SSH signature: " + e.getMessage(), e);
            }
        }
    }
}

