/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.AbstractStmt;
import ghidra.pcode.struct.LoopStmt;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;

class ForStmt
extends LoopStmt {
    private final AbstractStmt init;
    private final AbstractStmt step;

    protected ForStmt(StructuredSleigh ctx, StructuredSleigh.Stmt init, StructuredSleigh.RVal cond, StructuredSleigh.Stmt step, AbstractStmt stmt) {
        super(ctx, cond, stmt);
        this.init = ((AbstractStmt)init).reparent(this);
        this.step = ((AbstractStmt)step).reparent(this);
    }

    @Override
    protected StringTree generate(StructuredSleigh.Label next, StructuredSleigh.Label fall) {
        StructuredSleigh.FreshLabel lTest = new StructuredSleigh.FreshLabel(this.ctx);
        StructuredSleigh.FreshLabel lBegin = new StructuredSleigh.FreshLabel(this.ctx);
        StructuredSleigh.Label lExit = this.lBreak = next.freshOrBorrow();
        this.lContinue = new StructuredSleigh.FreshLabel(this.ctx);
        StructuredSleigh.FreshLabel lStep = this.lContinue;
        StringTree initGen = this.init.generate(lTest, lTest);
        StringTree testGen = lExit.genGoto(this.cond.notb(), lBegin);
        StringTree stmtGen = this.stmt.generate(lStep, lStep);
        StringTree stepGen = this.step.generate(lTest, fall);
        StringTree st = new StringTree();
        st.append(initGen);
        st.append(lTest.genAnchor());
        st.append(testGen);
        st.append(lBegin.genAnchor());
        st.append(stmtGen);
        st.append(lStep.genAnchor());
        st.append(stepGen);
        st.append(lExit.genAnchor());
        return st;
    }
}

