/*
 * Decompiled with CFR 0.152.
 */
package sarif.handlers.result;

import com.contrastsecurity.sarif.Edge;
import com.contrastsecurity.sarif.Graph;
import com.contrastsecurity.sarif.Node;
import com.contrastsecurity.sarif.PropertyBag;
import ghidra.program.model.address.Address;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.EmptyGraphType;
import ghidra.service.graph.GraphType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sarif.handlers.SarifResultHandler;

public class SarifGraphResultHandler
extends SarifResultHandler {
    @Override
    public String getKey() {
        return "Graphs";
    }

    @Override
    public List<AttributedGraph> parse() {
        ArrayList<AttributedGraph> res = new ArrayList<AttributedGraph>();
        Set graphs = this.result.getGraphs();
        if (graphs != null) {
            for (Graph g : graphs) {
                res.add(this.parseGraph(g));
            }
        }
        return res;
    }

    private AttributedGraph parseGraph(Graph g) {
        AttributedGraph graph = new AttributedGraph(this.controller.getProgram().getDescription(), (GraphType)new EmptyGraphType());
        HashMap<String, AttributedVertex> nodeMap = new HashMap<String, AttributedVertex>();
        for (Node n : g.getNodes()) {
            Map additional;
            Address addr = this.controller.locationToAddress(this.run, n.getLocation());
            String text = n.getLabel().getText();
            AttributedVertex vertex = graph.addVertex(n.getId(), addr.toString());
            PropertyBag properties = n.getProperties();
            if (properties != null && (additional = properties.getAdditionalProperties()) != null) {
                for (Map.Entry entry : additional.entrySet()) {
                    vertex.setAttribute((String)entry.getKey(), entry.getValue().toString());
                }
            }
            vertex.setAttribute("Label", text);
            vertex.setAttribute("Address", addr.toString(true));
            nodeMap.put(n.getId(), vertex);
        }
        for (Edge e : g.getEdges()) {
            graph.addEdge((AttributedVertex)nodeMap.get(e.getSourceNodeId()), (AttributedVertex)nodeMap.get(e.getTargetNodeId()));
        }
        return graph;
    }
}

