/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import ghidra.app.services.StringValidatorService;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.util.SystemUtilities;
import java.util.Set;

record EncodedStringsOptions(AbstractStringDataType stringDT, Settings settings, String charsetName, Set<Character.UnicodeScript> requiredScripts, Set<Character.UnicodeScript> allowedScripts, boolean excludeStringsWithErrors, boolean excludeNonStdCtrlChars, boolean alignStartOfString, int charSize, int minStringLength, boolean breakOnRef, StringValidatorService stringValidator, boolean requireValidString) {
    boolean equivalentStringCreationOptions(EncodedStringsOptions other) {
        return other != null && this.stringDT.equals((Object)other.stringDT) && EncodedStringsOptions.equalValues(this.settings, other.settings) && this.charsetName.equals(other.charsetName) && this.alignStartOfString == other.alignStartOfString && this.charSize == other.charSize && this.stringValidator == other.stringValidator && this.breakOnRef == other.breakOnRef;
    }

    private static boolean equalValues(Settings s1, Settings s2) {
        Set<String> s2names;
        Set<String> s1names = Set.of(s1.getNames());
        if (!s1names.equals(s2names = Set.of(s2.getNames()))) {
            return false;
        }
        for (String name : s1.getNames()) {
            Object s2val;
            Object s1val = s1.getValue(name);
            if (SystemUtilities.isEqual((Object)s1val, (Object)(s2val = s2.getValue(name)))) continue;
            return false;
        }
        return true;
    }
}

