/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.symbol.Reference;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

abstract class EditReferencePanel
extends JPanel {
    EditReferencePanel(String name) {
        this.setName(name);
    }

    abstract void initialize(CodeUnit var1, Reference var2);

    abstract boolean initialize(CodeUnit var1, int var2, int var3);

    abstract boolean applyReference();

    abstract void cleanup();

    abstract boolean setOpIndex(int var1);

    abstract boolean isValidContext();

    protected void showInputErr(String error) {
        Msg.showError((Object)this, (Component)this, (String)"Reference Input Error", (Object)error);
    }

    @Override
    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                kfm.focusNextComponent(EditReferencePanel.this);
            }
        });
    }

    protected long parseLongInput(String str) throws NumberFormatException {
        if (str == null) {
            throw new NumberFormatException();
        }
        str = str.trim().toLowerCase();
        try {
            boolean neg;
            int ix = 0;
            char c = str.charAt(0);
            boolean bl = neg = c == '-';
            if (neg || c == '+') {
                ++ix;
            }
            if (str.substring(ix).startsWith("0x")) {
                long val = NumericUtilities.parseHexLong((String)str.substring(ix + 2));
                return neg ? -val : val;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new NumberFormatException();
        }
        return Long.parseLong(str);
    }
}

