/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import ghidra.app.plugin.core.osgi.OSGiException;
import ghidra.app.plugin.core.osgi.OSGiUtils;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class GhidraBundleException
extends OSGiException {
    private final Bundle bundle;
    private final String bundleLocation;

    public GhidraBundleException(Bundle bundle, String msg, BundleException cause) {
        super(msg + ": " + GhidraBundleException.parsedCause(cause), cause);
        this.bundle = bundle;
        this.bundleLocation = bundle.getLocation();
    }

    public GhidraBundleException(String bundleLocation, String msg, BundleException cause) {
        super(msg + ": " + GhidraBundleException.parsedCause(cause), cause);
        this.bundle = null;
        this.bundleLocation = bundleLocation;
    }

    public GhidraBundleException(String bundleLocation, String msg) {
        super(msg);
        this.bundle = null;
        this.bundleLocation = bundleLocation;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getBundleLocation() {
        return this.bundleLocation != null ? this.bundleLocation : this.bundle.getLocation();
    }

    private static String parsedCause(Throwable e) {
        if (e == null) {
            return "";
        }
        if (e instanceof BundleException) {
            BundleException bundleException = (BundleException)e;
            switch (bundleException.getType()) {
                default: {
                    return "No exception type";
                }
                case 0: {
                    return e.getMessage();
                }
                case 1: {
                    return "UNSUPPORTED_OPERATION";
                }
                case 2: {
                    return "INVALID_OPERATION";
                }
                case 3: {
                    return "MANIFEST_ERROR";
                }
                case 4: {
                    String message = bundleException.getMessage();
                    if (message.startsWith("Unable to acquire global lock")) {
                        return message;
                    }
                    String packages = OSGiUtils.extractPackageNamesFromFailedResolution(bundleException.getMessage()).stream().distinct().collect(Collectors.joining("\n"));
                    return "RESOLVE_ERROR - \n" + packages;
                }
                case 5: {
                    return "ACTIVATOR_ERROR";
                }
                case 6: {
                    return "SECURITY_ERROR";
                }
                case 7: {
                    return "STATECHANGE_ERROR";
                }
                case 8: {
                    return "NATIVECODE_ERROR";
                }
                case 9: {
                    return "DUPLICATE_BUNDLE_ERROR";
                }
                case 10: {
                    return "START_TRANSIENT_ERROR";
                }
                case 11: {
                    return "READ_ERROR";
                }
                case 12: 
            }
            return "REJECTED_BY_HOOK";
        }
        return e.getCause().getMessage();
    }
}

