/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.feature.vt.gui.task.RejectMatchTask;
import ghidra.util.HelpLocation;
import java.util.List;
import javax.swing.Icon;

public class RejectMatchAction
extends DockingAction {
    private static final String MENU_GROUP = "A_VT_Edit_1";
    private static final Icon ICON = new GIcon("icon.version.tracking.action.match.reject");
    private final VTController controller;

    public RejectMatchAction(VTController controller) {
        super("Reject", VTPlugin.OWNER);
        this.controller = controller;
        this.setToolBarData(new ToolBarData(ICON, MENU_GROUP));
        this.setPopupMenuData(new MenuData(new String[]{"Reject"}, ICON, MENU_GROUP));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Reject_Match"));
    }

    public void actionPerformed(ActionContext context) {
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        VTSession session = this.controller.getSession();
        RejectMatchTask task = new RejectMatchTask(session, matches);
        this.controller.runVTTask(task);
        this.controller.refresh();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof VTMatchContext)) {
            return false;
        }
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        return matches.size() != 0;
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }
}

