/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ModelChange {

    public static interface Listener {
        public void modelChanged();
    }

    public static class SupportImpl
    implements Support {
        Logger log = LoggerFactory.getLogger(SupportImpl.class);
        protected boolean fireEvents = true;
        protected List<Listener> modelChangeListeners = Collections.synchronizedList(new ArrayList());

        private SupportImpl() {
        }

        @Override
        public boolean isFireEvents() {
            return this.fireEvents;
        }

        @Override
        public void setFireEvents(boolean fireEvents) {
            this.fireEvents = fireEvents;
            if (fireEvents) {
                this.log.trace("fireModelChanged");
                this.fireModelChanged();
            }
        }

        @Override
        public void addModelChangeListener(Listener l) {
            this.modelChangeListeners.add(l);
        }

        @Override
        public void removeModelChangeListener(Listener l) {
            this.modelChangeListeners.remove(l);
        }

        @Override
        public List<Listener> getModelChangeListeners() {
            return this.modelChangeListeners;
        }

        @Override
        public void fireModelChanged() {
            if (this.fireEvents) {
                for (int i = this.modelChangeListeners.size() - 1; i >= 0; --i) {
                    this.modelChangeListeners.get(i).modelChanged();
                }
            }
        }
    }

    public static interface Support {
        public static Support create() {
            return new SupportImpl();
        }

        public boolean isFireEvents();

        public void setFireEvents(boolean var1);

        public void addModelChangeListener(Listener var1);

        public void removeModelChangeListener(Listener var1);

        public List<Listener> getModelChangeListeners();

        public void fireModelChanged();
    }

    public static interface Producer {
        public Support getModelChangeSupport();
    }
}

