/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.Counted;
import clojure.lang.IChunk;
import clojure.lang.IChunkedSeq;
import clojure.lang.IDrop;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Numbers;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Range;
import clojure.lang.Reduced;
import clojure.lang.Repeat;
import clojure.lang.Sequential;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongRange
extends ASeq
implements Counted,
IChunkedSeq,
IReduce,
IDrop {
    private static final long serialVersionUID = -1467242400566893909L;
    final long start;
    final long end;
    final long step;
    final int count;
    private static final int CHUNK_SIZE = 32;

    private LongRange(long start2, long end, long step, int count2) {
        this.start = start2;
        this.end = end;
        this.step = step;
        this.count = count2;
    }

    private LongRange(IPersistentMap meta, long start2, long end, long step, int count2) {
        super(meta);
        this.start = start2;
        this.end = end;
        this.step = step;
        this.count = count2;
    }

    static long rangeCount(long start2, long end, long step) {
        return Numbers.add(Numbers.add(Numbers.minus(end, start2), step), step > 0L ? -1L : 1L) / step;
    }

    public static ISeq create(long end) {
        if (end > 0L) {
            try {
                return new LongRange(0L, end, 1L, Math.toIntExact(LongRange.rangeCount(0L, end, 1L)));
            }
            catch (ArithmeticException e2) {
                return Range.create(end);
            }
        }
        return PersistentList.EMPTY;
    }

    public static ISeq create(long start2, long end) {
        if (start2 >= end) {
            return PersistentList.EMPTY;
        }
        try {
            return new LongRange(start2, end, 1L, Math.toIntExact(LongRange.rangeCount(start2, end, 1L)));
        }
        catch (ArithmeticException e2) {
            return Range.create(start2, end);
        }
    }

    public static ISeq create(long start2, long end, long step) {
        if (step > 0L) {
            if (end <= start2) {
                return PersistentList.EMPTY;
            }
            try {
                return new LongRange(start2, end, step, Math.toIntExact(LongRange.rangeCount(start2, end, step)));
            }
            catch (ArithmeticException e2) {
                return Range.create(start2, end, step);
            }
        }
        if (step < 0L) {
            if (end >= start2) {
                return PersistentList.EMPTY;
            }
            try {
                return new LongRange(start2, end, step, Math.toIntExact(LongRange.rangeCount(start2, end, step)));
            }
            catch (ArithmeticException e3) {
                return Range.create(start2, end, step);
            }
        }
        if (end == start2) {
            return PersistentList.EMPTY;
        }
        return Repeat.create(start2);
    }

    @Override
    public Obj withMeta(IPersistentMap meta) {
        if (meta == this._meta) {
            return this;
        }
        return new LongRange(meta, this.start, this.end, this.step, this.count);
    }

    @Override
    public Object first() {
        return this.start;
    }

    @Override
    public ISeq next() {
        if (this.count > 1) {
            return new LongRange(this.start + this.step, this.end, this.step, this.count - 1);
        }
        return null;
    }

    @Override
    public IChunk chunkedFirst() {
        return new LongChunk(this.start, this.step, Math.min(this.count, 32));
    }

    @Override
    public ISeq chunkedNext() {
        return this.chunkedMore().seq();
    }

    @Override
    public ISeq chunkedMore() {
        if (this.count <= 32) {
            return PersistentList.EMPTY;
        }
        return LongRange.create(this.start + this.step * 32L, this.end, this.step);
    }

    @Override
    public Sequential drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (n < this.count) {
            return new LongRange(this.start + this.step * (long)n, this.end, this.step, this.count - n);
        }
        return null;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public Object reduce(IFn f) {
        Object acc = this.start;
        long i = this.start + this.step;
        for (int n = this.count; n > 1; --n) {
            if ((acc = f.invoke(acc, i)) instanceof Reduced) {
                return ((Reduced)acc).deref();
            }
            i += this.step;
        }
        return acc;
    }

    @Override
    public Object reduce(IFn f, Object val2) {
        Object acc = val2;
        int n = this.count;
        long i = this.start;
        do {
            if (RT.isReduced(acc = f.invoke(acc, i))) {
                return ((Reduced)acc).deref();
            }
            i += this.step;
        } while (--n > 0);
        return acc;
    }

    @Override
    public Iterator iterator() {
        return new LongRangeIterator();
    }

    private static class LongChunk
    implements IChunk,
    Serializable {
        final long start;
        final long step;
        final int count;

        public LongChunk(long start2, long step, int count2) {
            this.start = start2;
            this.step = step;
            this.count = count2;
        }

        public long first() {
            return this.start;
        }

        @Override
        public Object nth(int i) {
            return this.start + (long)i * this.step;
        }

        @Override
        public Object nth(int i, Object notFound) {
            if (i >= 0 && i < this.count) {
                return this.start + (long)i * this.step;
            }
            return notFound;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public LongChunk dropFirst() {
            if (this.count <= 1) {
                throw new IllegalStateException("dropFirst of empty chunk");
            }
            return new LongChunk(this.start + this.step, this.step, this.count - 1);
        }

        @Override
        public Object reduce(IFn f, Object init) {
            long x = this.start;
            Object ret = init;
            for (int i = 0; i < this.count; ++i) {
                if (RT.isReduced(ret = f.invoke(ret, x))) {
                    return ret;
                }
                x += this.step;
            }
            return ret;
        }
    }

    class LongRangeIterator
    implements Iterator {
        private long next;
        private int remaining;

        public LongRangeIterator() {
            this.next = LongRange.this.start;
            this.remaining = LongRange.this.count;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        public Object next() {
            if (this.remaining > 0) {
                long ret = this.next;
                this.next += LongRange.this.step;
                --this.remaining;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

