#ifndef itkLaplacianOperatorSwigInterface_h
#define itkLaplacianOperatorSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkLaplacianOperator.h"

using itkLaplacianOperatorF2 = itk::LaplacianOperator< float, 2 >;
using itkLaplacianOperatorD2 = itk::LaplacianOperator< double, 2 >;
using itkLaplacianOperatorF3 = itk::LaplacianOperator< float, 3 >;
using itkLaplacianOperatorD3 = itk::LaplacianOperator< double, 3 >;
using itkLaplacianOperatorF4 = itk::LaplacianOperator< float, 4 >;
using itkLaplacianOperatorD4 = itk::LaplacianOperator< double, 4 >;


#include "itkNeighborhoodOperatorSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkLaplacianOperatorSwigInterface.h"
#endif
