// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// VulnerabilityRisks Vulnerability risks.
type VulnerabilityRisks struct {
	// Vulnerability EPSS severity.
	Epss *EPSS `json:"epss,omitempty"`
	// Vulnerability public exploit availability.
	ExploitAvailable bool `json:"exploit_available"`
	// Vulnerability exploit sources.
	ExploitSources []string `json:"exploit_sources"`
	// Vulnerability exploitation probability.
	ExploitationProbability bool `json:"exploitation_probability"`
	// Vulnerability POC exploit availability.
	PocExploitAvailable bool `json:"poc_exploit_available"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject       map[string]interface{} `json:"-"`
	AdditionalProperties map[string]interface{} `json:"-"`
}

// NewVulnerabilityRisks instantiates a new VulnerabilityRisks object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewVulnerabilityRisks(exploitAvailable bool, exploitSources []string, exploitationProbability bool, pocExploitAvailable bool) *VulnerabilityRisks {
	this := VulnerabilityRisks{}
	this.ExploitAvailable = exploitAvailable
	this.ExploitSources = exploitSources
	this.ExploitationProbability = exploitationProbability
	this.PocExploitAvailable = pocExploitAvailable
	return &this
}

// NewVulnerabilityRisksWithDefaults instantiates a new VulnerabilityRisks object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewVulnerabilityRisksWithDefaults() *VulnerabilityRisks {
	this := VulnerabilityRisks{}
	return &this
}

// GetEpss returns the Epss field value if set, zero value otherwise.
func (o *VulnerabilityRisks) GetEpss() EPSS {
	if o == nil || o.Epss == nil {
		var ret EPSS
		return ret
	}
	return *o.Epss
}

// GetEpssOk returns a tuple with the Epss field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityRisks) GetEpssOk() (*EPSS, bool) {
	if o == nil || o.Epss == nil {
		return nil, false
	}
	return o.Epss, true
}

// HasEpss returns a boolean if a field has been set.
func (o *VulnerabilityRisks) HasEpss() bool {
	return o != nil && o.Epss != nil
}

// SetEpss gets a reference to the given EPSS and assigns it to the Epss field.
func (o *VulnerabilityRisks) SetEpss(v EPSS) {
	o.Epss = &v
}

// GetExploitAvailable returns the ExploitAvailable field value.
func (o *VulnerabilityRisks) GetExploitAvailable() bool {
	if o == nil {
		var ret bool
		return ret
	}
	return o.ExploitAvailable
}

// GetExploitAvailableOk returns a tuple with the ExploitAvailable field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityRisks) GetExploitAvailableOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ExploitAvailable, true
}

// SetExploitAvailable sets field value.
func (o *VulnerabilityRisks) SetExploitAvailable(v bool) {
	o.ExploitAvailable = v
}

// GetExploitSources returns the ExploitSources field value.
func (o *VulnerabilityRisks) GetExploitSources() []string {
	if o == nil {
		var ret []string
		return ret
	}
	return o.ExploitSources
}

// GetExploitSourcesOk returns a tuple with the ExploitSources field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityRisks) GetExploitSourcesOk() (*[]string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ExploitSources, true
}

// SetExploitSources sets field value.
func (o *VulnerabilityRisks) SetExploitSources(v []string) {
	o.ExploitSources = v
}

// GetExploitationProbability returns the ExploitationProbability field value.
func (o *VulnerabilityRisks) GetExploitationProbability() bool {
	if o == nil {
		var ret bool
		return ret
	}
	return o.ExploitationProbability
}

// GetExploitationProbabilityOk returns a tuple with the ExploitationProbability field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityRisks) GetExploitationProbabilityOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ExploitationProbability, true
}

// SetExploitationProbability sets field value.
func (o *VulnerabilityRisks) SetExploitationProbability(v bool) {
	o.ExploitationProbability = v
}

// GetPocExploitAvailable returns the PocExploitAvailable field value.
func (o *VulnerabilityRisks) GetPocExploitAvailable() bool {
	if o == nil {
		var ret bool
		return ret
	}
	return o.PocExploitAvailable
}

// GetPocExploitAvailableOk returns a tuple with the PocExploitAvailable field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityRisks) GetPocExploitAvailableOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.PocExploitAvailable, true
}

// SetPocExploitAvailable sets field value.
func (o *VulnerabilityRisks) SetPocExploitAvailable(v bool) {
	o.PocExploitAvailable = v
}

// MarshalJSON serializes the struct using spec logic.
func (o VulnerabilityRisks) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	if o.Epss != nil {
		toSerialize["epss"] = o.Epss
	}
	toSerialize["exploit_available"] = o.ExploitAvailable
	toSerialize["exploit_sources"] = o.ExploitSources
	toSerialize["exploitation_probability"] = o.ExploitationProbability
	toSerialize["poc_exploit_available"] = o.PocExploitAvailable

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *VulnerabilityRisks) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		Epss                    *EPSS     `json:"epss,omitempty"`
		ExploitAvailable        *bool     `json:"exploit_available"`
		ExploitSources          *[]string `json:"exploit_sources"`
		ExploitationProbability *bool     `json:"exploitation_probability"`
		PocExploitAvailable     *bool     `json:"poc_exploit_available"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	if all.ExploitAvailable == nil {
		return fmt.Errorf("required field exploit_available missing")
	}
	if all.ExploitSources == nil {
		return fmt.Errorf("required field exploit_sources missing")
	}
	if all.ExploitationProbability == nil {
		return fmt.Errorf("required field exploitation_probability missing")
	}
	if all.PocExploitAvailable == nil {
		return fmt.Errorf("required field poc_exploit_available missing")
	}
	additionalProperties := make(map[string]interface{})
	if err = datadog.Unmarshal(bytes, &additionalProperties); err == nil {
		datadog.DeleteKeys(additionalProperties, &[]string{"epss", "exploit_available", "exploit_sources", "exploitation_probability", "poc_exploit_available"})
	} else {
		return err
	}

	hasInvalidField := false
	if all.Epss != nil && all.Epss.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Epss = all.Epss
	o.ExploitAvailable = *all.ExploitAvailable
	o.ExploitSources = *all.ExploitSources
	o.ExploitationProbability = *all.ExploitationProbability
	o.PocExploitAvailable = *all.PocExploitAvailable

	if len(additionalProperties) > 0 {
		o.AdditionalProperties = additionalProperties
	}

	if hasInvalidField {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}

	return nil
}
