/* osd.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from osd.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gtk-layer-shell/gtk-layer-shell.h>
#include <gio/gio.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#define BUDGIE_OSD_SIZE 350
#define BUDGIE_OSD_EXPIRE_TIME 2500
#define BUDGIE_OSD_DBUS_NAME "org.budgie_desktop.BudgieOSD"
#define BUDGIE_OSD_DBUS_OBJECT_PATH "/org/budgie_desktop/BudgieOSD"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_OSD (budgie_osd_get_type ())
#define BUDGIE_OSD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD, BudgieOSD))
#define BUDGIE_OSD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD, BudgieOSDClass))
#define BUDGIE_IS_OSD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD))
#define BUDGIE_IS_OSD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD))
#define BUDGIE_OSD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD, BudgieOSDClass))

typedef struct _BudgieOSD BudgieOSD;
typedef struct _BudgieOSDClass BudgieOSDClass;
typedef struct _BudgieOSDPrivate BudgieOSDPrivate;
enum  {
	BUDGIE_OSD_0_PROPERTY,
	BUDGIE_OSD_OSD_TITLE_PROPERTY,
	BUDGIE_OSD_OSD_ICON_PROPERTY,
	BUDGIE_OSD_NUM_PROPERTIES
};
static GParamSpec* budgie_osd_properties[BUDGIE_OSD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_WAYLAND_CLIENT (budgie_wayland_client_get_type ())
#define BUDGIE_WAYLAND_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClient))
#define BUDGIE_WAYLAND_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClientClass))
#define BUDGIE_IS_WAYLAND_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_WAYLAND_CLIENT))
#define BUDGIE_IS_WAYLAND_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_WAYLAND_CLIENT))
#define BUDGIE_WAYLAND_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClientClass))

typedef struct _BudgieWaylandClient BudgieWaylandClient;
typedef struct _BudgieWaylandClientClass BudgieWaylandClientClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_OSD_MANAGER (budgie_osd_manager_get_type ())
#define BUDGIE_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManager))
#define BUDGIE_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))
#define BUDGIE_IS_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_IS_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_OSD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))

typedef struct _BudgieOSDManager BudgieOSDManager;
typedef struct _BudgieOSDManagerClass BudgieOSDManagerClass;
typedef struct _BudgieOSDManagerPrivate BudgieOSDManagerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _BudgieParamSpecOSDManager BudgieParamSpecOSDManager;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _BudgieOSD {
	GtkWindow parent_instance;
	BudgieOSDPrivate * priv;
	GtkProgressBar* progressbar;
};

struct _BudgieOSDClass {
	GtkWindowClass parent_class;
};

struct _BudgieOSDPrivate {
	GtkLabel* label_title;
	GtkImage* image_icon;
};

struct _BudgieOSDManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieOSDManagerPrivate * priv;
};

struct _BudgieOSDManagerClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieOSDManager *self);
};

struct _BudgieOSDManagerPrivate {
	BudgieOSD* osd_window;
	guint32 expire_timeout;
};

struct _BudgieParamSpecOSDManager {
	GParamSpec parent_instance;
};

static gint BudgieOSD_private_offset;
static gpointer budgie_osd_parent_class = NULL;
static gint BudgieOSDManager_private_offset;
static gpointer budgie_osd_manager_parent_class = NULL;
VALA_EXTERN gboolean budgie_setup;

VALA_EXTERN GType budgie_osd_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieOSD, g_object_unref)
VALA_EXTERN BudgieOSD* budgie_osd_new (void);
VALA_EXTERN BudgieOSD* budgie_osd_construct (GType object_type);
VALA_EXTERN void budgie_osd_set_osd_title (BudgieOSD* self,
                               const gchar* value);
VALA_EXTERN void budgie_osd_set_osd_icon (BudgieOSD* self,
                              const gchar* value);
VALA_EXTERN void budgie_osd_move_osd (BudgieOSD* self);
VALA_EXTERN BudgieWaylandClient* budgie_wayland_client_new (void);
VALA_EXTERN BudgieWaylandClient* budgie_wayland_client_construct (GType object_type);
VALA_EXTERN GType budgie_wayland_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieWaylandClient, g_object_unref)
VALA_EXTERN GdkMonitor* budgie_wayland_client_get_gdk_monitor (BudgieWaylandClient* self);
VALA_EXTERN gchar* budgie_osd_get_osd_title (BudgieOSD* self);
VALA_EXTERN gchar* budgie_osd_get_osd_icon (BudgieOSD* self);
static void budgie_osd_finalize (GObject * obj);
static GType budgie_osd_get_type_once (void);
static void _vala_budgie_osd_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_budgie_osd_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
VALA_EXTERN gpointer budgie_osd_manager_ref (gpointer instance);
VALA_EXTERN void budgie_osd_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_osd_manager (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void budgie_value_set_osd_manager (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void budgie_value_take_osd_manager (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_osd_manager (const GValue* value);
VALA_EXTERN GType budgie_osd_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieOSDManager, budgie_osd_manager_unref)
VALA_EXTERN guint budgie_osd_manager_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN BudgieOSDManager* budgie_osd_manager_new (void);
VALA_EXTERN BudgieOSDManager* budgie_osd_manager_construct (GType object_type);
VALA_EXTERN void budgie_osd_manager_setup_dbus (BudgieOSDManager* self,
                                    gboolean replace);
static void budgie_osd_manager_on_bus_acquired (BudgieOSDManager* self,
                                         GDBusConnection* conn);
static void _budgie_osd_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                 const gchar* name,
                                                                 gpointer self);
static void __lambda36_ (BudgieOSDManager* self);
static void ___lambda36__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
VALA_EXTERN void budgie_DaemonNameLost (GDBusConnection* conn,
                            const gchar* name);
static void _budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                     const gchar* name,
                                                     gpointer self);
VALA_EXTERN void budgie_osd_manager_Show (BudgieOSDManager* self,
                              GHashTable* params,
                              GError** error);
static void budgie_osd_manager_reset_osd_expire (BudgieOSDManager* self,
                                          gint timeout_length);
static gboolean budgie_osd_manager_osd_expire (BudgieOSDManager* self);
static gboolean _budgie_osd_manager_osd_expire_gsource_func (gpointer self);
static void budgie_osd_manager_finalize (BudgieOSDManager * obj);
static GType budgie_osd_manager_get_type_once (void);
static void _dbus_budgie_osd_manager_Show (BudgieOSDManager* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void budgie_osd_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* budgie_osd_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static gboolean budgie_osd_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _budgie_osd_manager_unregister_object (gpointer user_data);

static const GDBusArgInfo _budgie_osd_manager_dbus_arg_info_Show_params = {-1, "params", "a{sv}", NULL};
static const GDBusArgInfo * const _budgie_osd_manager_dbus_arg_info_Show_in[] = {&_budgie_osd_manager_dbus_arg_info_Show_params, NULL};
static const GDBusArgInfo * const _budgie_osd_manager_dbus_arg_info_Show_out[] = {NULL};
static const GDBusMethodInfo _budgie_osd_manager_dbus_method_info_Show = {-1, "Show", (GDBusArgInfo **) (&_budgie_osd_manager_dbus_arg_info_Show_in), (GDBusArgInfo **) (&_budgie_osd_manager_dbus_arg_info_Show_out), NULL};
static const GDBusMethodInfo * const _budgie_osd_manager_dbus_method_info[] = {&_budgie_osd_manager_dbus_method_info_Show, NULL};
static const GDBusSignalInfo * const _budgie_osd_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_osd_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_osd_manager_dbus_interface_info = {-1, "org.budgie_desktop.BudgieOSD", (GDBusMethodInfo **) (&_budgie_osd_manager_dbus_method_info), (GDBusSignalInfo **) (&_budgie_osd_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_osd_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_osd_manager_dbus_interface_vtable = {budgie_osd_manager_dbus_interface_method_call, budgie_osd_manager_dbus_interface_get_property, budgie_osd_manager_dbus_interface_set_property};

static inline gpointer
budgie_osd_get_instance_private (BudgieOSD* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieOSD_private_offset);
}

/**
* Construct a new BudgieOSD widget
*/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BudgieOSD*
budgie_osd_construct (GType object_type)
{
	BudgieOSD * self = NULL;
	GdkVisual* vis = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* _tmp2_;
	GdkVisual* _tmp3_;
	GdkVisual* _tmp4_;
	GtkWidget* _tmp6_;
	self = (BudgieOSD*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "type-hint", GDK_WINDOW_TYPE_HINT_NOTIFICATION, NULL);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_layer_init_for_window ((GtkWindow*) self);
	gtk_layer_set_layer ((GtkWindow*) self, GTK_LAYER_SHELL_LAYER_TOP);
	gtk_layer_set_margin ((GtkWindow*) self, GTK_LAYER_SHELL_EDGE_BOTTOM, 80);
	gtk_layer_set_anchor ((GtkWindow*) self, GTK_LAYER_SHELL_EDGE_BOTTOM, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_stick ((GtkWindow*) self);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_rgba_visual (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	vis = _tmp3_;
	_tmp4_ = vis;
	if (_tmp4_ != NULL) {
		GdkVisual* _tmp5_;
		_tmp5_ = vis;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp5_);
	}
	gtk_window_set_default_size ((GtkWindow*) self, BUDGIE_OSD_SIZE, -1);
	gtk_widget_realize ((GtkWidget*) self);
	budgie_osd_set_osd_title (self, NULL);
	budgie_osd_set_osd_icon (self, NULL);
	_tmp6_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_show_all (_tmp6_);
	gtk_widget_set_visible ((GtkWidget*) self, FALSE);
	budgie_osd_move_osd (self);
	_g_object_unref0 (vis);
	return self;
}

BudgieOSD*
budgie_osd_new (void)
{
	return budgie_osd_construct (BUDGIE_TYPE_OSD);
}

/**
* Move the OSD into the correct position
*/
void
budgie_osd_move_osd (BudgieOSD* self)
{
	BudgieWaylandClient* _tmp0_;
	BudgieWaylandClient* _tmp1_;
	GdkMonitor* _tmp2_;
	GdkMonitor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_wayland_client_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = budgie_wayland_client_get_gdk_monitor (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_layer_set_monitor ((GtkWindow*) self, _tmp3_);
	_g_object_unref0 (_tmp1_);
}

gchar*
budgie_osd_get_osd_title (BudgieOSD* self)
{
	gchar* result;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->label_title;
	if (!gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->label_title;
	_tmp2_ = gtk_label_get_label (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

void
budgie_osd_set_osd_title (BudgieOSD* self,
                          const gchar* value)
{
	gchar* r = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	r = _tmp0_;
	_tmp1_ = r;
	if (_tmp1_ == NULL) {
		GtkLabel* _tmp2_;
		_tmp2_ = self->priv->label_title;
		gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
	} else {
		GtkLabel* _tmp3_;
		GtkLabel* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->label_title;
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
		_tmp4_ = self->priv->label_title;
		_tmp5_ = r;
		gtk_label_set_markup (_tmp4_, _tmp5_);
	}
	_g_free0 (r);
	g_object_notify_by_pspec ((GObject *) self, budgie_osd_properties[BUDGIE_OSD_OSD_TITLE_PROPERTY]);
}

gchar*
budgie_osd_get_osd_icon (BudgieOSD* self)
{
	gchar* result;
	GtkImage* _tmp0_;
	gchar* ret = NULL;
	GtkIconSize _icon_size = 0;
	GtkImage* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GtkIconSize _tmp3_ = 0;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->image_icon;
	if (!gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->image_icon;
	gtk_image_get_icon_name (_tmp1_, &_tmp2_, (GtkIconSize*) (&_tmp3_));
	_g_free0 (ret);
	_tmp4_ = g_strdup (_tmp2_);
	ret = _tmp4_;
	_icon_size = _tmp3_;
	result = ret;
	return result;
}

void
budgie_osd_set_osd_icon (BudgieOSD* self,
                         const gchar* value)
{
	gchar* r = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	r = _tmp0_;
	_tmp1_ = r;
	if (_tmp1_ == NULL) {
		GtkImage* _tmp2_;
		_tmp2_ = self->priv->image_icon;
		gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
	} else {
		GtkImage* _tmp3_;
		const gchar* _tmp4_;
		GtkImage* _tmp5_;
		GtkImage* _tmp6_;
		_tmp3_ = self->priv->image_icon;
		_tmp4_ = r;
		gtk_image_set_from_icon_name (_tmp3_, _tmp4_, (GtkIconSize) GTK_ICON_SIZE_INVALID);
		_tmp5_ = self->priv->image_icon;
		gtk_image_set_pixel_size (_tmp5_, 48);
		_tmp6_ = self->priv->image_icon;
		gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
	}
	_g_free0 (r);
	g_object_notify_by_pspec ((GObject *) self, budgie_osd_properties[BUDGIE_OSD_OSD_ICON_PROPERTY]);
}

static void
budgie_osd_class_init (BudgieOSDClass * klass,
                       gpointer klass_data)
{
	budgie_osd_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieOSD_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_osd_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_osd_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_osd_finalize;
	/**
	* Current text to display. NULL hides the widget.
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_OSD_OSD_TITLE_PROPERTY, budgie_osd_properties[BUDGIE_OSD_OSD_TITLE_PROPERTY] = g_param_spec_string ("osd-title", "osd-title", "osd-title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	* Current icon to display. NULL hides the widget
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_OSD_OSD_ICON_PROPERTY, budgie_osd_properties[BUDGIE_OSD_OSD_ICON_PROPERTY] = g_param_spec_string ("osd-icon", "osd-icon", "osd-icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie/daemon/osd.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_title", FALSE, BudgieOSD_private_offset + G_STRUCT_OFFSET (BudgieOSDPrivate, label_title));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_icon", FALSE, BudgieOSD_private_offset + G_STRUCT_OFFSET (BudgieOSDPrivate, image_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progressbar", FALSE, G_STRUCT_OFFSET (BudgieOSD, progressbar));
}

static void
budgie_osd_instance_init (BudgieOSD * self,
                          gpointer klass)
{
	self->priv = budgie_osd_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
budgie_osd_finalize (GObject * obj)
{
	BudgieOSD * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_OSD, BudgieOSD);
	G_OBJECT_CLASS (budgie_osd_parent_class)->finalize (obj);
}

/**
* The BudgieOSD provides a very simplistic On Screen Display service, complying with the
* private GNOME Settings Daemon -> GNOME Shell protocol.
*
* In short, all elements of the permanently present window should be able to hide or show
* depending on the updated Show message, including support for a progress bar (level),
* icon, optional label.
*
* This OSD is used by gnome-settings-daemon to portray special events, such as brightness/volume
* changes, physical volume changes (disk eject/mount), etc. This special window should remain
* above all other windows and be non-interactive, allowing unobtrosive overlay of information
* even in full screen movies and games.
*
* Each request to Show will reset the expiration timeout for the OSD's current visibility,
* meaning subsequent requests to the OSD will keep it on screen in a natural fashion, allowing
* users to "hold down" the volume change buttons, for example.
*/
static GType
budgie_osd_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieOSDClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_osd_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieOSD), 0, (GInstanceInitFunc) budgie_osd_instance_init, NULL };
	GType budgie_osd_type_id;
	budgie_osd_type_id = g_type_register_static (gtk_window_get_type (), "BudgieOSD", &g_define_type_info, 0);
	BudgieOSD_private_offset = g_type_add_instance_private (budgie_osd_type_id, sizeof (BudgieOSDPrivate));
	return budgie_osd_type_id;
}

GType
budgie_osd_get_type (void)
{
	static volatile gsize budgie_osd_type_id__once = 0;
	if (g_once_init_enter (&budgie_osd_type_id__once)) {
		GType budgie_osd_type_id;
		budgie_osd_type_id = budgie_osd_get_type_once ();
		g_once_init_leave (&budgie_osd_type_id__once, budgie_osd_type_id);
	}
	return budgie_osd_type_id__once;
}

static void
_vala_budgie_osd_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	BudgieOSD * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_OSD, BudgieOSD);
	switch (property_id) {
		case BUDGIE_OSD_OSD_TITLE_PROPERTY:
		g_value_take_string (value, budgie_osd_get_osd_title (self));
		break;
		case BUDGIE_OSD_OSD_ICON_PROPERTY:
		g_value_take_string (value, budgie_osd_get_osd_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_osd_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	BudgieOSD * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_OSD, BudgieOSD);
	switch (property_id) {
		case BUDGIE_OSD_OSD_TITLE_PROPERTY:
		budgie_osd_set_osd_title (self, g_value_get_string (value));
		break;
		case BUDGIE_OSD_OSD_ICON_PROPERTY:
		budgie_osd_set_osd_icon (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_osd_manager_get_instance_private (BudgieOSDManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieOSDManager_private_offset);
}

BudgieOSDManager*
budgie_osd_manager_construct (GType object_type)
{
	BudgieOSDManager* self = NULL;
	BudgieOSD* _tmp0_;
	self = (BudgieOSDManager*) g_type_create_instance (object_type);
	_tmp0_ = budgie_osd_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->osd_window);
	self->priv->osd_window = _tmp0_;
	return self;
}

BudgieOSDManager*
budgie_osd_manager_new (void)
{
	return budgie_osd_manager_construct (BUDGIE_TYPE_OSD_MANAGER);
}

/**
* Own the OSD_DBUS_NAME
*/
static void
_budgie_osd_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                            const gchar* name,
                                                            gpointer self)
{
	budgie_osd_manager_on_bus_acquired ((BudgieOSDManager*) self, connection);
}

static void
__lambda36_ (BudgieOSDManager* self)
{
}

static void
___lambda36__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda36_ ((BudgieOSDManager*) self);
}

static void
_budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self)
{
	budgie_DaemonNameLost (connection, name);
}

void
budgie_osd_manager_setup_dbus (BudgieOSDManager* self,
                               gboolean replace)
{
	GBusNameOwnerFlags flags = 0U;
	g_return_if_fail (self != NULL);
	flags = G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT;
	if (replace) {
		flags |= G_BUS_NAME_OWNER_FLAGS_REPLACE;
	}
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_OSD_DBUS_NAME, flags, (GClosure*) ((_budgie_osd_manager_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_osd_manager_on_bus_acquired_gbus_acquired_callback, budgie_osd_manager_ref (self), (GClosureNotify) budgie_osd_manager_unref)), (GClosure*) ((___lambda36__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda36__gbus_name_acquired_callback, budgie_osd_manager_ref (self), (GClosureNotify) budgie_osd_manager_unref)), (GClosure*) g_cclosure_new ((GCallback) _budgie_DaemonNameLost_gbus_name_lost_callback, NULL, (GClosureNotify) NULL));
}

/**
* Acquired OSD_DBUS_NAME, register ourselves on the bus
*/
static void
budgie_osd_manager_on_bus_acquired (BudgieOSDManager* self,
                                    GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_osd_manager_register_object (self, conn, BUDGIE_OSD_DBUS_OBJECT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "Error registering BudgieOSD: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	budgie_setup = TRUE;
}

/**
* Show the OSD on screen with the given parameters:
* icon: string Icon-name to use
* label: string Text to display, if any
* level: Progress-level to display in the OSD (double or int32 depending on gsd release)
* monitor: int32 The monitor to display the OSD on (currently ignored)
*/
static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
budgie_osd_manager_Show (BudgieOSDManager* self,
                         GHashTable* params,
                         GError** error)
{
	gchar* icon_name = NULL;
	gchar* label = NULL;
	gdouble prog_value = 0.0;
	BudgieOSD* _tmp16_;
	const gchar* _tmp17_;
	BudgieOSD* _tmp18_;
	const gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	icon_name = NULL;
	label = NULL;
	if (g_hash_table_contains (params, "icon")) {
		GVariant* icon_variant = NULL;
		gconstpointer _tmp0_;
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		_tmp0_ = g_hash_table_lookup (params, "icon");
		_tmp1_ = _g_variant_ref0 ((GVariant*) _tmp0_);
		icon_variant = _tmp1_;
		_tmp2_ = icon_variant;
		if (_tmp2_ != NULL) {
			GVariant* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = icon_variant;
			_tmp4_ = g_variant_get_string (_tmp3_, NULL);
			_tmp5_ = g_strdup (_tmp4_);
			_g_free0 (icon_name);
			icon_name = _tmp5_;
		}
		_g_variant_unref0 (icon_variant);
	}
	if (g_hash_table_contains (params, "label")) {
		GVariant* label_variant = NULL;
		gconstpointer _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		_tmp6_ = g_hash_table_lookup (params, "label");
		_tmp7_ = _g_variant_ref0 ((GVariant*) _tmp6_);
		label_variant = _tmp7_;
		_tmp8_ = label_variant;
		if (_tmp8_ != NULL) {
			GVariant* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = label_variant;
			_tmp10_ = g_variant_get_string (_tmp9_, NULL);
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (label);
			label = _tmp11_;
		}
		_g_variant_unref0 (label_variant);
	}
	prog_value = (gdouble) -1;
	if (g_hash_table_contains (params, "level")) {
		GVariant* level_variant = NULL;
		gconstpointer _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		_tmp12_ = g_hash_table_lookup (params, "level");
		_tmp13_ = _g_variant_ref0 ((GVariant*) _tmp12_);
		level_variant = _tmp13_;
		_tmp14_ = level_variant;
		if (_tmp14_ != NULL) {
			GVariant* _tmp15_;
			_tmp15_ = level_variant;
			prog_value = g_variant_get_double (_tmp15_);
		}
		_g_variant_unref0 (level_variant);
	}
	_tmp16_ = self->priv->osd_window;
	_tmp17_ = label;
	budgie_osd_set_osd_title (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->osd_window;
	_tmp19_ = icon_name;
	budgie_osd_set_osd_icon (_tmp18_, _tmp19_);
	if (prog_value < ((gdouble) 0)) {
		BudgieOSD* _tmp20_;
		GtkProgressBar* _tmp21_;
		_tmp20_ = self->priv->osd_window;
		_tmp21_ = _tmp20_->progressbar;
		gtk_widget_set_visible ((GtkWidget*) _tmp21_, FALSE);
	} else {
		BudgieOSD* _tmp22_;
		GtkProgressBar* _tmp23_;
		BudgieOSD* _tmp24_;
		GtkProgressBar* _tmp25_;
		_tmp22_ = self->priv->osd_window;
		_tmp23_ = _tmp22_->progressbar;
		gtk_progress_bar_set_fraction (_tmp23_, prog_value);
		_tmp24_ = self->priv->osd_window;
		_tmp25_ = _tmp24_->progressbar;
		gtk_widget_set_visible ((GtkWidget*) _tmp25_, TRUE);
	}
	budgie_osd_manager_reset_osd_expire (self, BUDGIE_OSD_EXPIRE_TIME);
	_g_free0 (label);
	_g_free0 (icon_name);
}

/**
* Reset and update the expiration for the OSD timeout
*/
static gboolean
_budgie_osd_manager_osd_expire_gsource_func (gpointer self)
{
	gboolean result;
	result = budgie_osd_manager_osd_expire ((BudgieOSDManager*) self);
	return result;
}

static void
budgie_osd_manager_reset_osd_expire (BudgieOSDManager* self,
                                     gint timeout_length)
{
	BudgieOSD* _tmp0_;
	BudgieOSD* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->expire_timeout > ((guint32) 0)) {
		g_source_remove ((guint) self->priv->expire_timeout);
		self->priv->expire_timeout = (guint32) 0;
	}
	_tmp0_ = self->priv->osd_window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->osd_window;
	budgie_osd_move_osd (_tmp1_);
	self->priv->expire_timeout = (guint32) g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) timeout_length, _budgie_osd_manager_osd_expire_gsource_func, budgie_osd_manager_ref (self), budgie_osd_manager_unref);
}

/**
* Expiration timeout was met, so hide the OSD Window
*/
static gboolean
budgie_osd_manager_osd_expire (BudgieOSDManager* self)
{
	BudgieOSD* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->expire_timeout == ((guint32) 0)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->osd_window;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	self->priv->expire_timeout = (guint32) 0;
	result = FALSE;
	return result;
}

static void
budgie_value_osd_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_osd_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_osd_manager_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_osd_manager_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_osd_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_osd_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_osd_manager_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieOSDManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_osd_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_osd_manager_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	BudgieOSDManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_osd_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_osd_manager (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	BudgieParamSpecOSDManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_OSD_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_osd_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_OSD_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_osd_manager (GValue* value,
                              gpointer v_object)
{
	BudgieOSDManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_OSD_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_OSD_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_osd_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_osd_manager_unref (old);
	}
}

void
budgie_value_take_osd_manager (GValue* value,
                               gpointer v_object)
{
	BudgieOSDManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_OSD_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_OSD_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_osd_manager_unref (old);
	}
}

static void
budgie_osd_manager_class_init (BudgieOSDManagerClass * klass,
                               gpointer klass_data)
{
	budgie_osd_manager_parent_class = g_type_class_peek_parent (klass);
	((BudgieOSDManagerClass *) klass)->finalize = budgie_osd_manager_finalize;
	g_type_class_adjust_private_offset (klass, &BudgieOSDManager_private_offset);
}

static void
budgie_osd_manager_instance_init (BudgieOSDManager * self,
                                  gpointer klass)
{
	self->priv = budgie_osd_manager_get_instance_private (self);
	self->priv->osd_window = NULL;
	self->priv->expire_timeout = (guint32) 0;
	self->ref_count = 1;
}

static void
budgie_osd_manager_finalize (BudgieOSDManager * obj)
{
	BudgieOSDManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManager);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->osd_window);
}

/**
* BudgieOSDManager is responsible for managing the BudgieOSD over d-bus, receiving
* requests, for example, from budgie-wm
*/
static GType
budgie_osd_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_osd_manager_init, budgie_value_osd_manager_free_value, budgie_value_osd_manager_copy_value, budgie_value_osd_manager_peek_pointer, "p", budgie_value_osd_manager_collect_value, "p", budgie_value_osd_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieOSDManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_osd_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieOSDManager), 0, (GInstanceInitFunc) budgie_osd_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_osd_manager_type_id;
	budgie_osd_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieOSDManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_set_qdata (budgie_osd_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_osd_manager_register_object);
	BudgieOSDManager_private_offset = g_type_add_instance_private (budgie_osd_manager_type_id, sizeof (BudgieOSDManagerPrivate));
	return budgie_osd_manager_type_id;
}

GType
budgie_osd_manager_get_type (void)
{
	static volatile gsize budgie_osd_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_osd_manager_type_id__once)) {
		GType budgie_osd_manager_type_id;
		budgie_osd_manager_type_id = budgie_osd_manager_get_type_once ();
		g_once_init_leave (&budgie_osd_manager_type_id__once, budgie_osd_manager_type_id);
	}
	return budgie_osd_manager_type_id__once;
}

gpointer
budgie_osd_manager_ref (gpointer instance)
{
	BudgieOSDManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_osd_manager_unref (gpointer instance)
{
	BudgieOSDManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_OSD_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_dbus_budgie_osd_manager_Show (BudgieOSDManager* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* params = NULL;
	GVariant* _tmp49_;
	GHashTable* _tmp50_;
	GVariantIter _tmp51_;
	GVariant* _tmp52_;
	GVariant* _tmp53_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp49_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp50_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp51_, _tmp49_);
	while (g_variant_iter_loop (&_tmp51_, "{?*}", &_tmp52_, &_tmp53_)) {
		g_hash_table_insert (_tmp50_, g_variant_dup_string (_tmp52_, NULL), g_variant_get_variant (_tmp53_));
	}
	params = _tmp50_;
	g_variant_unref (_tmp49_);
	budgie_osd_manager_Show (self, params, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (params);
	;
}

static void
budgie_osd_manager_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Show") == 0) {
		_dbus_budgie_osd_manager_Show (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_osd_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_osd_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_osd_manager_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = budgie_osd_manager_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_osd_manager_dbus_interface_info), &_budgie_osd_manager_dbus_interface_vtable, data, _budgie_osd_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_osd_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	budgie_osd_manager_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

