/* src/bazaar.p/bz-transaction-dialog-result.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-transaction-dialog-result.h"



struct _BzTransactionDialogResult
{
  GObject parent_instance;

  BzEntry *selected_entry;
  gboolean delete_user_data;
  gboolean confirmed;
};

G_DEFINE_FINAL_TYPE (BzTransactionDialogResult, bz_transaction_dialog_result, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_SELECTED_ENTRY,
  PROP_DELETE_USER_DATA,
  PROP_CONFIRMED,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_transaction_dialog_result_dispose (GObject *object)
{
  BzTransactionDialogResult *self = BZ_TRANSACTION_DIALOG_RESULT (object);

  g_clear_pointer (&self->selected_entry, g_object_unref);

  G_OBJECT_CLASS (bz_transaction_dialog_result_parent_class)->dispose (object);
}

static void
bz_transaction_dialog_result_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzTransactionDialogResult *self = BZ_TRANSACTION_DIALOG_RESULT (object);

  switch (prop_id)
    {
    case PROP_SELECTED_ENTRY:
      g_value_set_object (value, bz_transaction_dialog_result_get_selected_entry (self));
      break;
    case PROP_DELETE_USER_DATA:
      g_value_set_boolean (value, bz_transaction_dialog_result_get_delete_user_data (self));
      break;
    case PROP_CONFIRMED:
      g_value_set_boolean (value, bz_transaction_dialog_result_get_confirmed (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_transaction_dialog_result_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzTransactionDialogResult *self = BZ_TRANSACTION_DIALOG_RESULT (object);

  switch (prop_id)
    {
    case PROP_SELECTED_ENTRY:
      bz_transaction_dialog_result_set_selected_entry (self, g_value_get_object (value));
      break;
    case PROP_DELETE_USER_DATA:
      bz_transaction_dialog_result_set_delete_user_data (self, g_value_get_boolean (value));
      break;
    case PROP_CONFIRMED:
      bz_transaction_dialog_result_set_confirmed (self, g_value_get_boolean (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_transaction_dialog_result_class_init (BzTransactionDialogResultClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_transaction_dialog_result_set_property;
  object_class->get_property = bz_transaction_dialog_result_get_property;
  object_class->dispose      = bz_transaction_dialog_result_dispose;

  props[PROP_SELECTED_ENTRY] =
      g_param_spec_object (
          "selected-entry",
          NULL, NULL,
          BZ_TYPE_ENTRY,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DELETE_USER_DATA] =
      g_param_spec_boolean (
          "delete-user-data",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CONFIRMED] =
      g_param_spec_boolean (
          "confirmed",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_transaction_dialog_result_init (BzTransactionDialogResult *self)
{
}

BzTransactionDialogResult *
bz_transaction_dialog_result_new (void){
  return g_object_new (BZ_TYPE_TRANSACTION_DIALOG_RESULT, NULL);
}

BzEntry *
bz_transaction_dialog_result_get_selected_entry (BzTransactionDialogResult *self){
  g_return_val_if_fail (BZ_IS_TRANSACTION_DIALOG_RESULT (self), NULL);
  return self->selected_entry;
}

gboolean
bz_transaction_dialog_result_get_delete_user_data (BzTransactionDialogResult *self){
  g_return_val_if_fail (BZ_IS_TRANSACTION_DIALOG_RESULT (self), FALSE);
  return self->delete_user_data;
}

gboolean
bz_transaction_dialog_result_get_confirmed (BzTransactionDialogResult *self){
  g_return_val_if_fail (BZ_IS_TRANSACTION_DIALOG_RESULT (self), FALSE);
  return self->confirmed;
}

void
bz_transaction_dialog_result_set_selected_entry (BzTransactionDialogResult *self,
    BzEntry *selected_entry){
  g_return_if_fail (BZ_IS_TRANSACTION_DIALOG_RESULT (self));

  if (selected_entry == self->selected_entry)
    return;

  g_clear_pointer (&self->selected_entry, g_object_unref);
  if (selected_entry != NULL)
    self->selected_entry = g_object_ref (selected_entry);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SELECTED_ENTRY]);
}

void
bz_transaction_dialog_result_set_delete_user_data (BzTransactionDialogResult *self,
    gboolean delete_user_data){
  g_return_if_fail (BZ_IS_TRANSACTION_DIALOG_RESULT (self));

  if (!!delete_user_data == !!self->delete_user_data)
    return;

  self->delete_user_data = delete_user_data;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DELETE_USER_DATA]);
}

void
bz_transaction_dialog_result_set_confirmed (BzTransactionDialogResult *self,
    gboolean confirmed){
  g_return_if_fail (BZ_IS_TRANSACTION_DIALOG_RESULT (self));

  if (!!confirmed == !!self->confirmed)
    return;

  self->confirmed = confirmed;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CONFIRMED]);
}

/* End of src/bazaar.p/bz-transaction-dialog-result.c */
