/* src/bazaar.p/bz-hook-dialog.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-hook-dialog.h"



struct _BzHookDialog
{
  GObject parent_instance;

  char *id;
  char *title;
  char *body;
  gboolean body_use_markup;
  GListModel *options;
  char *default_response_id;
};

G_DEFINE_FINAL_TYPE (BzHookDialog, bz_hook_dialog, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_ID,
  PROP_TITLE,
  PROP_BODY,
  PROP_BODY_USE_MARKUP,
  PROP_OPTIONS,
  PROP_DEFAULT_RESPONSE_ID,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_hook_dialog_dispose (GObject *object)
{
  BzHookDialog *self = BZ_HOOK_DIALOG (object);

  g_clear_pointer (&self->id, g_free);
  g_clear_pointer (&self->title, g_free);
  g_clear_pointer (&self->body, g_free);
  g_clear_pointer (&self->options, g_object_unref);
  g_clear_pointer (&self->default_response_id, g_free);

  G_OBJECT_CLASS (bz_hook_dialog_parent_class)->dispose (object);
}

static void
bz_hook_dialog_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzHookDialog *self = BZ_HOOK_DIALOG (object);

  switch (prop_id)
    {
    case PROP_ID:
      g_value_set_string (value, bz_hook_dialog_get_id (self));
      break;
    case PROP_TITLE:
      g_value_set_string (value, bz_hook_dialog_get_title (self));
      break;
    case PROP_BODY:
      g_value_set_string (value, bz_hook_dialog_get_body (self));
      break;
    case PROP_BODY_USE_MARKUP:
      g_value_set_boolean (value, bz_hook_dialog_get_body_use_markup (self));
      break;
    case PROP_OPTIONS:
      g_value_set_object (value, bz_hook_dialog_get_options (self));
      break;
    case PROP_DEFAULT_RESPONSE_ID:
      g_value_set_string (value, bz_hook_dialog_get_default_response_id (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_hook_dialog_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzHookDialog *self = BZ_HOOK_DIALOG (object);

  switch (prop_id)
    {
    case PROP_ID:
      bz_hook_dialog_set_id (self, g_value_get_string (value));
      break;
    case PROP_TITLE:
      bz_hook_dialog_set_title (self, g_value_get_string (value));
      break;
    case PROP_BODY:
      bz_hook_dialog_set_body (self, g_value_get_string (value));
      break;
    case PROP_BODY_USE_MARKUP:
      bz_hook_dialog_set_body_use_markup (self, g_value_get_boolean (value));
      break;
    case PROP_OPTIONS:
      bz_hook_dialog_set_options (self, g_value_get_object (value));
      break;
    case PROP_DEFAULT_RESPONSE_ID:
      bz_hook_dialog_set_default_response_id (self, g_value_get_string (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_hook_dialog_class_init (BzHookDialogClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_ensure (BZ_TYPE_HOOK_DIALOG_OPTION);

  object_class->set_property = bz_hook_dialog_set_property;
  object_class->get_property = bz_hook_dialog_get_property;
  object_class->dispose      = bz_hook_dialog_dispose;

  props[PROP_ID] =
      g_param_spec_string (
          "id",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_TITLE] =
      g_param_spec_string (
          "title",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BODY] =
      g_param_spec_string (
          "body",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BODY_USE_MARKUP] =
      g_param_spec_boolean (
          "body-use-markup",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_OPTIONS] =
      g_param_spec_object (
          "options",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DEFAULT_RESPONSE_ID] =
      g_param_spec_string (
          "default-response-id",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_hook_dialog_init (BzHookDialog *self)
{
}

BzHookDialog *
bz_hook_dialog_new (void){
  return g_object_new (BZ_TYPE_HOOK_DIALOG, NULL);
}

const char *
bz_hook_dialog_get_id (BzHookDialog *self){
  g_return_val_if_fail (BZ_IS_HOOK_DIALOG (self), NULL);
  return self->id;
}

const char *
bz_hook_dialog_get_title (BzHookDialog *self){
  g_return_val_if_fail (BZ_IS_HOOK_DIALOG (self), NULL);
  return self->title;
}

const char *
bz_hook_dialog_get_body (BzHookDialog *self){
  g_return_val_if_fail (BZ_IS_HOOK_DIALOG (self), NULL);
  return self->body;
}

gboolean
bz_hook_dialog_get_body_use_markup (BzHookDialog *self){
  g_return_val_if_fail (BZ_IS_HOOK_DIALOG (self), FALSE);
  return self->body_use_markup;
}

GListModel *
bz_hook_dialog_get_options (BzHookDialog *self){
  g_return_val_if_fail (BZ_IS_HOOK_DIALOG (self), NULL);
  return self->options;
}

const char *
bz_hook_dialog_get_default_response_id (BzHookDialog *self){
  g_return_val_if_fail (BZ_IS_HOOK_DIALOG (self), NULL);
  return self->default_response_id;
}

void
bz_hook_dialog_set_id (BzHookDialog *self,
    const char *id){
  g_return_if_fail (BZ_IS_HOOK_DIALOG (self));

  if (id == self->id || (id != NULL && self->id != NULL && g_strcmp0(id, self->id) == 0))
    return;

  g_clear_pointer (&self->id, g_free);
  if (id != NULL)
    self->id = g_strdup (id);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ID]);
}

void
bz_hook_dialog_set_title (BzHookDialog *self,
    const char *title){
  g_return_if_fail (BZ_IS_HOOK_DIALOG (self));

  if (title == self->title || (title != NULL && self->title != NULL && g_strcmp0(title, self->title) == 0))
    return;

  g_clear_pointer (&self->title, g_free);
  if (title != NULL)
    self->title = g_strdup (title);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TITLE]);
}

void
bz_hook_dialog_set_body (BzHookDialog *self,
    const char *body){
  g_return_if_fail (BZ_IS_HOOK_DIALOG (self));

  if (body == self->body || (body != NULL && self->body != NULL && g_strcmp0(body, self->body) == 0))
    return;

  g_clear_pointer (&self->body, g_free);
  if (body != NULL)
    self->body = g_strdup (body);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BODY]);
}

void
bz_hook_dialog_set_body_use_markup (BzHookDialog *self,
    gboolean body_use_markup){
  g_return_if_fail (BZ_IS_HOOK_DIALOG (self));

  if (!!body_use_markup == !!self->body_use_markup)
    return;

  self->body_use_markup = body_use_markup;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BODY_USE_MARKUP]);
}

void
bz_hook_dialog_set_options (BzHookDialog *self,
    GListModel *options){
  g_return_if_fail (BZ_IS_HOOK_DIALOG (self));

  if (options == self->options)
    return;

  g_clear_pointer (&self->options, g_object_unref);
  if (options != NULL)
    self->options = g_object_ref (options);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_OPTIONS]);
}

void
bz_hook_dialog_set_default_response_id (BzHookDialog *self,
    const char *default_response_id){
  g_return_if_fail (BZ_IS_HOOK_DIALOG (self));

  if (default_response_id == self->default_response_id || (default_response_id != NULL && self->default_response_id != NULL && g_strcmp0(default_response_id, self->default_response_id) == 0))
    return;

  g_clear_pointer (&self->default_response_id, g_free);
  if (default_response_id != NULL)
    self->default_response_id = g_strdup (default_response_id);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DEFAULT_RESPONSE_ID]);
}

/* End of src/bazaar.p/bz-hook-dialog.c */
