// python wrapper for ttkMergeTreeTemporalReduction
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMergeTreeTemporalReduction.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMergeTreeTemporalReduction(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMergeTreeTemporalReduction_ClassNew(); }


static PyObject *
PyttkMergeTreeTemporalReduction_SetEpsilon1UseFarthestSaddle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon1UseFarthestSaddle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon1UseFarthestSaddle(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetEpsilon1UseFarthestSaddle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_GetEpsilon1UseFarthestSaddle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon1UseFarthestSaddle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEpsilon1UseFarthestSaddle() :
      op->ttkMergeTreeTemporalReduction::GetEpsilon1UseFarthestSaddle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetEpsilonTree1_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilonTree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilonTree1(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetEpsilonTree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetEpsilonTree1_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilonTree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->SetEpsilonTree1() :
      op->ttkMergeTreeTemporalReduction::SetEpsilonTree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetEpsilonTree1(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeTemporalReduction_SetEpsilonTree1_s1(self, args);
    case 0:
      return PyttkMergeTreeTemporalReduction_SetEpsilonTree1_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetEpsilonTree1");
  return nullptr;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetEpsilon2Tree1_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon2Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon2Tree1(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetEpsilon2Tree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetEpsilon2Tree1_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon2Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->SetEpsilon2Tree1() :
      op->ttkMergeTreeTemporalReduction::SetEpsilon2Tree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetEpsilon2Tree1(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeTemporalReduction_SetEpsilon2Tree1_s1(self, args);
    case 0:
      return PyttkMergeTreeTemporalReduction_SetEpsilon2Tree1_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetEpsilon2Tree1");
  return nullptr;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetEpsilon3Tree1_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon3Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon3Tree1(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetEpsilon3Tree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetEpsilon3Tree1_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon3Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->SetEpsilon3Tree1() :
      op->ttkMergeTreeTemporalReduction::SetEpsilon3Tree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetEpsilon3Tree1(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeTemporalReduction_SetEpsilon3Tree1_s1(self, args);
    case 0:
      return PyttkMergeTreeTemporalReduction_SetEpsilon3Tree1_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetEpsilon3Tree1");
  return nullptr;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetPersistenceThreshold_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPersistenceThreshold(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetPersistenceThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetPersistenceThreshold_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->SetPersistenceThreshold() :
      op->ttkMergeTreeTemporalReduction::SetPersistenceThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetPersistenceThreshold(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeTemporalReduction_SetPersistenceThreshold_s1(self, args);
    case 0:
      return PyttkMergeTreeTemporalReduction_SetPersistenceThreshold_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetPersistenceThreshold");
  return nullptr;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetUseMinMaxPair_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseMinMaxPair");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseMinMaxPair(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetUseMinMaxPair(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetUseMinMaxPair_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseMinMaxPair");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->SetUseMinMaxPair() :
      op->ttkMergeTreeTemporalReduction::SetUseMinMaxPair());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetUseMinMaxPair(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeTemporalReduction_SetUseMinMaxPair_s1(self, args);
    case 0:
      return PyttkMergeTreeTemporalReduction_SetUseMinMaxPair_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetUseMinMaxPair");
  return nullptr;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetDeleteMultiPersPairs_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeleteMultiPersPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeleteMultiPersPairs(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetDeleteMultiPersPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetDeleteMultiPersPairs_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeleteMultiPersPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->SetDeleteMultiPersPairs() :
      op->ttkMergeTreeTemporalReduction::SetDeleteMultiPersPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeTemporalReduction_SetDeleteMultiPersPairs(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeTemporalReduction_SetDeleteMultiPersPairs_s1(self, args);
    case 0:
      return PyttkMergeTreeTemporalReduction_SetDeleteMultiPersPairs_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetDeleteMultiPersPairs");
  return nullptr;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetAssignmentSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAssignmentSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAssignmentSolver(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetAssignmentSolver(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_GetAssignmentSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAssignmentSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAssignmentSolver() :
      op->ttkMergeTreeTemporalReduction::GetAssignmentSolver());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetRemovalPercentage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRemovalPercentage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRemovalPercentage(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetRemovalPercentage(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_GetRemovalPercentage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRemovalPercentage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetRemovalPercentage() :
      op->ttkMergeTreeTemporalReduction::GetRemovalPercentage());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetUseL2Distance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseL2Distance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseL2Distance(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetUseL2Distance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_GetUseL2Distance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseL2Distance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetUseL2Distance() :
      op->ttkMergeTreeTemporalReduction::GetUseL2Distance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetUseCustomTimeVariable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseCustomTimeVariable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseCustomTimeVariable(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetUseCustomTimeVariable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_GetUseCustomTimeVariable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseCustomTimeVariable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseCustomTimeVariable() :
      op->ttkMergeTreeTemporalReduction::GetUseCustomTimeVariable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SetTimeVariableName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeVariableName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetTimeVariableName(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->ttkMergeTreeTemporalReduction::SetTimeVariableName(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_GetTimeVariableName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeVariableName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetTimeVariableName() :
      op->ttkMergeTreeTemporalReduction::GetTimeVariableName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMergeTreeTemporalReduction::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMergeTreeTemporalReduction::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMergeTreeTemporalReduction *tempr = ttkMergeTreeTemporalReduction::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMergeTreeTemporalReduction *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMergeTreeTemporalReduction::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMergeTreeTemporalReduction::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReduction_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReduction *op = static_cast<ttkMergeTreeTemporalReduction *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMergeTreeTemporalReduction::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMergeTreeTemporalReduction_Methods[] = {
  {"SetEpsilon1UseFarthestSaddle", PyttkMergeTreeTemporalReduction_SetEpsilon1UseFarthestSaddle, METH_VARARGS,
   "SetEpsilon1UseFarthestSaddle(self, epsilon1UseFarthestSaddle:bool)\n     -> None\nC++: void SetEpsilon1UseFarthestSaddle(\n    bool epsilon1UseFarthestSaddle)\n\nAutomatically generate getters and setters of filter parameters\nvia vtkMacros.\n"},
  {"GetEpsilon1UseFarthestSaddle", PyttkMergeTreeTemporalReduction_GetEpsilon1UseFarthestSaddle, METH_VARARGS,
   "GetEpsilon1UseFarthestSaddle(self) -> bool\nC++: bool GetEpsilon1UseFarthestSaddle()\n\n"},
  {"SetEpsilonTree1", PyttkMergeTreeTemporalReduction_SetEpsilonTree1, METH_VARARGS,
   "SetEpsilonTree1(self, epsilonTree1:float) -> None\nC++: void SetEpsilonTree1(double epsilonTree1)\nSetEpsilonTree1(self) -> float\nC++: double SetEpsilonTree1()\n\n"},
  {"SetEpsilon2Tree1", PyttkMergeTreeTemporalReduction_SetEpsilon2Tree1, METH_VARARGS,
   "SetEpsilon2Tree1(self, epsilon2Tree1:float) -> None\nC++: void SetEpsilon2Tree1(double epsilon2Tree1)\nSetEpsilon2Tree1(self) -> float\nC++: double SetEpsilon2Tree1()\n\n"},
  {"SetEpsilon3Tree1", PyttkMergeTreeTemporalReduction_SetEpsilon3Tree1, METH_VARARGS,
   "SetEpsilon3Tree1(self, epsilon3Tree1:float) -> None\nC++: void SetEpsilon3Tree1(double epsilon3Tree1)\nSetEpsilon3Tree1(self) -> float\nC++: double SetEpsilon3Tree1()\n\n"},
  {"SetPersistenceThreshold", PyttkMergeTreeTemporalReduction_SetPersistenceThreshold, METH_VARARGS,
   "SetPersistenceThreshold(self, persistenceThreshold:float) -> None\nC++: void SetPersistenceThreshold(double persistenceThreshold)\nSetPersistenceThreshold(self) -> float\nC++: double SetPersistenceThreshold()\n\n"},
  {"SetUseMinMaxPair", PyttkMergeTreeTemporalReduction_SetUseMinMaxPair, METH_VARARGS,
   "SetUseMinMaxPair(self, useMinMaxPair:bool) -> None\nC++: void SetUseMinMaxPair(bool useMinMaxPair)\nSetUseMinMaxPair(self) -> bool\nC++: bool SetUseMinMaxPair()\n\n"},
  {"SetDeleteMultiPersPairs", PyttkMergeTreeTemporalReduction_SetDeleteMultiPersPairs, METH_VARARGS,
   "SetDeleteMultiPersPairs(self, doDelete:bool) -> None\nC++: void SetDeleteMultiPersPairs(bool doDelete)\nSetDeleteMultiPersPairs(self) -> bool\nC++: bool SetDeleteMultiPersPairs()\n\n"},
  {"SetAssignmentSolver", PyttkMergeTreeTemporalReduction_SetAssignmentSolver, METH_VARARGS,
   "SetAssignmentSolver(self, assignmentSolver:int) -> None\nC++: void SetAssignmentSolver(int assignmentSolver)\n\n"},
  {"GetAssignmentSolver", PyttkMergeTreeTemporalReduction_GetAssignmentSolver, METH_VARARGS,
   "GetAssignmentSolver(self) -> int\nC++: int GetAssignmentSolver()\n\n"},
  {"SetRemovalPercentage", PyttkMergeTreeTemporalReduction_SetRemovalPercentage, METH_VARARGS,
   "SetRemovalPercentage(self, removePerc:float) -> None\nC++: void SetRemovalPercentage(double removePerc)\n\n"},
  {"GetRemovalPercentage", PyttkMergeTreeTemporalReduction_GetRemovalPercentage, METH_VARARGS,
   "GetRemovalPercentage(self) -> float\nC++: double GetRemovalPercentage()\n\n"},
  {"SetUseL2Distance", PyttkMergeTreeTemporalReduction_SetUseL2Distance, METH_VARARGS,
   "SetUseL2Distance(self, useL2:float) -> None\nC++: void SetUseL2Distance(double useL2)\n\n"},
  {"GetUseL2Distance", PyttkMergeTreeTemporalReduction_GetUseL2Distance, METH_VARARGS,
   "GetUseL2Distance(self) -> float\nC++: double GetUseL2Distance()\n\n"},
  {"SetUseCustomTimeVariable", PyttkMergeTreeTemporalReduction_SetUseCustomTimeVariable, METH_VARARGS,
   "SetUseCustomTimeVariable(self, useCustomTime:bool) -> None\nC++: void SetUseCustomTimeVariable(bool useCustomTime)\n\n"},
  {"GetUseCustomTimeVariable", PyttkMergeTreeTemporalReduction_GetUseCustomTimeVariable, METH_VARARGS,
   "GetUseCustomTimeVariable(self) -> bool\nC++: bool GetUseCustomTimeVariable()\n\n"},
  {"SetTimeVariableName", PyttkMergeTreeTemporalReduction_SetTimeVariableName, METH_VARARGS,
   "SetTimeVariableName(self, idx:int, port:int, connection:int,\n    fieldAssociation:int, name:str) -> None\nC++: void SetTimeVariableName(int idx, int port, int connection,\n    int fieldAssociation, const char *name)\n\n"},
  {"GetTimeVariableName", PyttkMergeTreeTemporalReduction_GetTimeVariableName, METH_VARARGS,
   "GetTimeVariableName(self) -> str\nC++: virtual std::string GetTimeVariableName()\n\n"},
  {"IsTypeOf", PyttkMergeTreeTemporalReduction_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMergeTreeTemporalReduction_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMergeTreeTemporalReduction_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkMergeTreeTemporalReduction\nC++: static ttkMergeTreeTemporalReduction *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMergeTreeTemporalReduction_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMergeTreeTemporalReduction\nC++: ttkMergeTreeTemporalReduction *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMergeTreeTemporalReduction_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMergeTreeTemporalReduction_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMergeTreeTemporalReduction_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("epsilon1_use_farthest_saddle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReduction_GetEpsilon1UseFarthestSaddle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetEpsilon1UseFarthestSaddle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetEpsilon1UseFarthestSaddle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon1UseFarthestSaddle/SetEpsilon1UseFarthestSaddle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon_tree1"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetEpsilonTree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetEpsilonTree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEpsilonTree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon2_tree1"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetEpsilon2Tree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetEpsilon2Tree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEpsilon2Tree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon3_tree1"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetEpsilon3Tree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetEpsilon3Tree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEpsilon3Tree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("persistence_threshold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetPersistenceThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetPersistenceThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPersistenceThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_min_max_pair"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetUseMinMaxPair(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetUseMinMaxPair(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseMinMaxPair\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delete_multi_pers_pairs"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetDeleteMultiPersPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetDeleteMultiPersPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDeleteMultiPersPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("assignment_solver"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReduction_GetAssignmentSolver(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetAssignmentSolver(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetAssignmentSolver(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAssignmentSolver/SetAssignmentSolver\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("removal_percentage"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReduction_GetRemovalPercentage(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetRemovalPercentage(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetRemovalPercentage(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRemovalPercentage/SetRemovalPercentage\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_l2_distance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReduction_GetUseL2Distance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetUseL2Distance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetUseL2Distance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseL2Distance/SetUseL2Distance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_custom_time_variable"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReduction_GetUseCustomTimeVariable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReduction_SetUseCustomTimeVariable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReduction_SetUseCustomTimeVariable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseCustomTimeVariable/SetUseCustomTimeVariable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_variable_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReduction_GetTimeVariableName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeVariableName\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMergeTreeTemporalReduction_Doc =
  "ttkMergeTreeTemporalReduction - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Mathieu Pont (mathieu.pont@lip6.fr)\\date 2021.\n\n"
  "TTK VTK-filter that wraps the ttk::MergeTreeTemporalReduction\n"
  "module.\n\n"
  "This VTK filter uses the ttk::MergeTreeTemporalReduction module to\n"
  "compute a temporal reduction of a sequence of merge trees.\n\n"
  "\\param Input vtkMultiBlockDataSet Input trees\n"
  "\\param Output vtkMultiBlockDataSet Key frames.\n"
  "\\param Output vtkTable Interpolation coefficients.\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(),\n"
  "GetOutputDataObject()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::MergeTreeTemporalReduction\n"
  "\\sa ttkAlgorithm\n\n"
  "Related publication\n\n"
  "\"Wasserstein Distances, Geodesics and Barycenters of Merge Trees\"\n\n"
  "Mathieu Pont, Jules Vidal, Julie Delon, Julien Tierny.\n\n"
  "Proc. of IEEE VIS 2021.\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2021\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeTemporalReduction/\"\n"
  "  >Merge Tree Temporal Reduction\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMergeTreeTemporalReduction_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMergeTreeTemporalReduction.ttkMergeTreeTemporalReduction", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMergeTreeTemporalReduction_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMergeTreeTemporalReduction_StaticNew()
{
  return ttkMergeTreeTemporalReduction::New();
}

PyObject *PyttkMergeTreeTemporalReduction_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMergeTreeTemporalReduction_Type, PyttkMergeTreeTemporalReduction_Methods,
    "ttkMergeTreeTemporalReduction",
 &PyttkMergeTreeTemporalReduction_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMergeTreeTemporalReduction_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMergeTreeTemporalReduction(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMergeTreeTemporalReduction_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMergeTreeTemporalReduction", o) != 0)
  {
    Py_DECREF(o);
  }

}

