// python wrapper for ttkArrayPreconditioning
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkArrayPreconditioning.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkArrayPreconditioning(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkArrayPreconditioning_ClassNew(); }


static PyObject *
PyttkArrayPreconditioning_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkArrayPreconditioning::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkArrayPreconditioning::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkArrayPreconditioning *tempr = ttkArrayPreconditioning::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkArrayPreconditioning *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkArrayPreconditioning::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkArrayPreconditioning::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkArrayPreconditioning::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_SetSelectFieldsWithRegexp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectFieldsWithRegexp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSelectFieldsWithRegexp(temp0);
    }
    else
    {
      op->ttkArrayPreconditioning::SetSelectFieldsWithRegexp(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_GetSelectFieldsWithRegexp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectFieldsWithRegexp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSelectFieldsWithRegexp() :
      op->ttkArrayPreconditioning::GetSelectFieldsWithRegexp());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_SetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRegexpString(temp0);
    }
    else
    {
      op->ttkArrayPreconditioning::SetRegexpString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_GetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetRegexpString() :
      op->ttkArrayPreconditioning::GetRegexpString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_SetGlobalOrder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGlobalOrder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGlobalOrder(temp0);
    }
    else
    {
      op->ttkArrayPreconditioning::SetGlobalOrder(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_GetGlobalOrder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGlobalOrder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGlobalOrder() :
      op->ttkArrayPreconditioning::GetGlobalOrder());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_SetChunkSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChunkSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChunkSize(temp0);
    }
    else
    {
      op->ttkArrayPreconditioning::SetChunkSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_GetChunkSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetChunkSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetChunkSize() :
      op->ttkArrayPreconditioning::GetChunkSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayPreconditioning_GetPointDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayPreconditioning *op = static_cast<ttkArrayPreconditioning *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetPointDataArraySelection() :
      op->ttkArrayPreconditioning::GetPointDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkArrayPreconditioning_Methods[] = {
  {"IsTypeOf", PyttkArrayPreconditioning_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkArrayPreconditioning_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkArrayPreconditioning_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkArrayPreconditioning\nC++: static ttkArrayPreconditioning *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkArrayPreconditioning_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkArrayPreconditioning\nC++: ttkArrayPreconditioning *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkArrayPreconditioning_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkArrayPreconditioning_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSelectFieldsWithRegexp", PyttkArrayPreconditioning_SetSelectFieldsWithRegexp, METH_VARARGS,
   "SetSelectFieldsWithRegexp(self, _arg:bool) -> None\nC++: virtual void SetSelectFieldsWithRegexp(bool _arg)\n\n"},
  {"GetSelectFieldsWithRegexp", PyttkArrayPreconditioning_GetSelectFieldsWithRegexp, METH_VARARGS,
   "GetSelectFieldsWithRegexp(self) -> bool\nC++: virtual bool GetSelectFieldsWithRegexp()\n\n"},
  {"SetRegexpString", PyttkArrayPreconditioning_SetRegexpString, METH_VARARGS,
   "SetRegexpString(self, _arg:str) -> None\nC++: virtual void SetRegexpString(const std::string &_arg)\n\n"},
  {"GetRegexpString", PyttkArrayPreconditioning_GetRegexpString, METH_VARARGS,
   "GetRegexpString(self) -> str\nC++: virtual std::string GetRegexpString()\n\n"},
  {"SetGlobalOrder", PyttkArrayPreconditioning_SetGlobalOrder, METH_VARARGS,
   "SetGlobalOrder(self, _arg:bool) -> None\nC++: virtual void SetGlobalOrder(bool _arg)\n\n"},
  {"GetGlobalOrder", PyttkArrayPreconditioning_GetGlobalOrder, METH_VARARGS,
   "GetGlobalOrder(self) -> bool\nC++: virtual bool GetGlobalOrder()\n\n"},
  {"SetChunkSize", PyttkArrayPreconditioning_SetChunkSize, METH_VARARGS,
   "SetChunkSize(self, _arg:int) -> None\nC++: virtual void SetChunkSize(int _arg)\n\n"},
  {"GetChunkSize", PyttkArrayPreconditioning_GetChunkSize, METH_VARARGS,
   "GetChunkSize(self) -> int\nC++: virtual int GetChunkSize()\n\n"},
  {"GetPointDataArraySelection", PyttkArrayPreconditioning_GetPointDataArraySelection, METH_VARARGS,
   "GetPointDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetPointDataArraySelection()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkArrayPreconditioning_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("select_fields_with_regexp"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayPreconditioning_GetSelectFieldsWithRegexp(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayPreconditioning_SetSelectFieldsWithRegexp(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayPreconditioning_SetSelectFieldsWithRegexp(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSelectFieldsWithRegexp/SetSelectFieldsWithRegexp\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("regexp_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayPreconditioning_GetRegexpString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayPreconditioning_SetRegexpString(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayPreconditioning_SetRegexpString(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRegexpString/SetRegexpString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_order"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayPreconditioning_GetGlobalOrder(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayPreconditioning_SetGlobalOrder(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayPreconditioning_SetGlobalOrder(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGlobalOrder/SetGlobalOrder\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("chunk_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayPreconditioning_GetChunkSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayPreconditioning_SetChunkSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayPreconditioning_SetChunkSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetChunkSize/SetChunkSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayPreconditioning_GetPointDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPointDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkArrayPreconditioning_Doc =
  "ttkArrayPreconditioning - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Pierre Guillou <pierre.guillou@lip6.fr>\\date September 2020\n\n"
  "TTK VTK-filter to generate order fields.\n\n"
  "This VTK filter generates order arrays from a selection of scalar\n"
  "field arrays.\n\n"
  "\\param Input vtkDataSet.\n"
  "\\param Output vtkDataSet.\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::ttkArrayPreconditioning\n"
  "\\sa ttkAlgorithm\n\n"
  "Online examples:\n\n"
  "- <a href=\"https://topology-tool-kit.github.io/examples/mpiExample/\">\n"
  "  MPI example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkArrayPreconditioning_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkArrayPreconditioning.ttkArrayPreconditioning", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkArrayPreconditioning_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkArrayPreconditioning_StaticNew()
{
  return ttkArrayPreconditioning::New();
}

PyObject *PyttkArrayPreconditioning_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkArrayPreconditioning_Type, PyttkArrayPreconditioning_Methods,
    "ttkArrayPreconditioning",
 &PyttkArrayPreconditioning_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkArrayPreconditioning_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkArrayPreconditioning(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkArrayPreconditioning_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkArrayPreconditioning", o) != 0)
  {
    Py_DECREF(o);
  }

}

