/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkMinimumMaximumImageFilter.h"
#include "itkMinimumMaximumImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
MinimumMaximumImageFilter::MinimumMaximumImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
MinimumMaximumImageFilter::~MinimumMaximumImageFilter() = default;



//
// ToString
//
std::string MinimumMaximumImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::MinimumMaximumImageFilter\n";
  out << "  Minimum: " << this->m_Minimum << std::endl;
  out << "  Maximum: " << this->m_Maximum << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
void MinimumMaximumImageFilter::Execute ( const Image & image )
{
  const PixelIDValueEnum type = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &image );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
void MinimumMaximumImageFilter::ExecuteInternal ( const Image * inImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;



  using FilterType = itk::MinimumMaximumImageFilter<InputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );






  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();

  this->m_Minimum = filter->GetMinimum();
  this->m_Maximum = filter->GetMaximum();


  return;

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------




}
