#ifndef __SOURCE4_SAMBA_SERVICE_PROTO_H__
#define __SOURCE4_SAMBA_SERVICE_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/samba/service.c  */

NTSTATUS register_server_service(TALLOC_CTX *ctx,
				const char *name,
				const struct service_details *details);
NTSTATUS server_service_startup(struct tevent_context *event_ctx,
				struct loadparm_context *lp_ctx,
				const char *model, const char **server_services,
				int from_parent_fd);

/* The following definitions come from ../../source4/samba/service_stream.c  */

void stream_terminate_connection(struct stream_connection *srv_conn, const char *reason);

/**
  the select loop has indicated that a stream is ready for IO
*/
void stream_io_handler_fde(struct tevent_context *ev, struct tevent_fd *fde,
				  uint16_t flags, void *private_data);
void stream_io_handler_callback(void *private_data, uint16_t flags);
NTSTATUS stream_new_connection_merge(struct tevent_context *ev,
				     struct loadparm_context *lp_ctx,
				     const struct model_ops *model_ops,
				     const struct stream_server_ops *stream_ops,
				     struct imessaging_context *msg_ctx,
				     void *private_data,
				     struct stream_connection **_srv_conn,
				     void *process_context);
NTSTATUS stream_setup_socket(TALLOC_CTX *mem_ctx,
			     struct tevent_context *event_context,
			     struct loadparm_context *lp_ctx,
			     const struct model_ops *model_ops,
			     const struct stream_server_ops *stream_ops,
			     const char *family,
			     const char *sock_addr,
			     uint16_t *port,
			     const char *socket_options,
			     void *private_data,
			     void *process_context);
void stream_connection_set_title(struct stream_connection *conn, const char *title);

/* The following definitions come from ../../source4/samba/service_named_pipe.c  */

NTSTATUS tstream_setup_named_pipe(TALLOC_CTX *mem_ctx,
				  struct tevent_context *event_context,
				  struct loadparm_context *lp_ctx,
				  const struct model_ops *model_ops,
				  const struct stream_server_ops *stream_ops,
				  const char *pipe_name,
				  void *private_data,
				  void *process_context);

/* The following definitions come from ../../source4/samba/service_task.c  */

void task_server_terminate(struct task_server *task, const char *reason, bool fatal);
NTSTATUS task_server_startup(struct tevent_context *event_ctx,
			     struct loadparm_context *lp_ctx,
			     const char *service_name,
			     const struct model_ops *model_ops,
			     const struct service_details *service_details,
			     int from_parent_fd);
void task_server_set_title(struct task_server *task, const char *title);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_SAMBA_SERVICE_PROTO_H__ */

