#ifndef _BARECTF_H
#define _BARECTF_H

/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2020 Philippe Proulx <pproulx@efficios.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *
 * The following code was generated by barectf v3.1.2
 * on 2026-01-28T21:44:38.026483.
 *
 * For more details, see <https://barectf.org/>.
 */

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif


struct barectf_ctx;

uint32_t barectf_packet_size(const void *vctx);
int barectf_packet_is_full(const void *vctx);
int barectf_packet_is_empty(const void *vctx);
uint32_t barectf_packet_events_discarded(const void *vctx);
uint32_t barectf_discarded_event_records_count(const void * const vctx);
uint32_t barectf_packet_sequence_number(const void * const vctx);
uint8_t *barectf_packet_buf(const void *vctx);
uint8_t *barectf_packet_buf_addr(const void * const vctx);
void barectf_packet_set_buf(void *vctx, uint8_t *buf, uint32_t buf_size);
uint32_t barectf_packet_buf_size(const void *vctx);
int barectf_packet_is_open(const void *vctx);
int barectf_is_in_tracing_section(const void *vctx);
volatile const int *barectf_is_in_tracing_section_ptr(const void *vctx);
int barectf_is_tracing_enabled(const void *vctx);
void barectf_enable_tracing(void *vctx, int enable);

/* barectf platform callbacks */
struct barectf_platform_callbacks {
	/* Clock source callbacks */
	uint64_t (*default_clock_get_value)(void *);

	/* Is the back end full? */
	int (*is_backend_full)(void *);

	/* Open packet */
	void (*open_packet)(void *);

	/* Close packet */
	void (*close_packet)(void *);
};

/* Common barectf context */
struct barectf_ctx {
	/* Platform callbacks */
	struct barectf_platform_callbacks cbs;

	/* Platform data (passed to callbacks) */
	void *data;

	/* Output buffer (will contain a CTF binary packet) */
	uint8_t *buf;

	/* Packet's total size (bits) */
	uint32_t packet_size;

	/* Packet's content size (bits) */
	uint32_t content_size;

	/* Current position from beginning of packet (bits) */
	uint32_t at;

	/* Size of packet header + context fields (content offset) */
	uint32_t off_content;

	/* Discarded event records counter snapshot */
	uint32_t events_discarded;

	/* Packet's sequence number */
	uint32_t sequence_number;

	/* Current packet is open? */
	int packet_is_open;

	/* In tracing code? */
	volatile int in_tracing_section;

	/* Tracing is enabled? */
	volatile int is_tracing_enabled;

	/* Use current/last event record timestamp when opening/closing packets */
	int use_cur_last_event_ts;
};

/* Context for data stream type `api_ops` */
struct barectf_api_ops_ctx {
	/* Parent */
	struct barectf_ctx parent;

	/* Config-specific members follow */
	uint32_t off_ph_magic;
	uint32_t off_ph_stream_id;
	uint32_t off_pc_packet_size;
	uint32_t off_pc_content_size;
	uint64_t cur_last_event_ts;
};

/* Context for data stream type `hip_api` */
struct barectf_hip_api_ctx {
	/* Parent */
	struct barectf_ctx parent;

	/* Config-specific members follow */
	uint32_t off_ph_magic;
	uint32_t off_ph_stream_id;
	uint32_t off_pc_packet_size;
	uint32_t off_pc_content_size;
	uint64_t cur_last_event_ts;
};

/* Context for data stream type `hsa_api` */
struct barectf_hsa_api_ctx {
	/* Parent */
	struct barectf_ctx parent;

	/* Config-specific members follow */
	uint32_t off_ph_magic;
	uint32_t off_ph_stream_id;
	uint32_t off_pc_packet_size;
	uint32_t off_pc_content_size;
	uint64_t cur_last_event_ts;
};

/* Context for data stream type `hsa_handles` */
struct barectf_hsa_handles_ctx {
	/* Parent */
	struct barectf_ctx parent;

	/* Config-specific members follow */
	uint32_t off_ph_magic;
	uint32_t off_ph_stream_id;
	uint32_t off_pc_packet_size;
	uint32_t off_pc_content_size;
	uint64_t cur_last_event_ts;
};

/* Context for data stream type `profiler` */
struct barectf_profiler_ctx {
	/* Parent */
	struct barectf_ctx parent;

	/* Config-specific members follow */
	uint32_t off_ph_magic;
	uint32_t off_ph_stream_id;
	uint32_t off_pc_packet_size;
	uint32_t off_pc_content_size;
	uint64_t cur_last_event_ts;
};

/* Context for data stream type `roctx` */
struct barectf_roctx_ctx {
	/* Parent */
	struct barectf_ctx parent;

	/* Config-specific members follow */
	uint32_t off_ph_magic;
	uint32_t off_ph_stream_id;
	uint32_t off_pc_packet_size;
	uint32_t off_pc_content_size;
	uint64_t cur_last_event_ts;
};

/* Initialize context */
void barectf_init(void *vctx,
	uint8_t *buf, uint32_t buf_size,
	const struct barectf_platform_callbacks cbs, void *data);

/* Open packet for data stream type `api_ops` */
void barectf_api_ops_open_packet(
	struct barectf_api_ops_ctx *sctx);

/* Close packet for data stream type `api_ops` */
void barectf_api_ops_close_packet(struct barectf_api_ops_ctx *sctx);

/* Trace (data stream type `api_ops`, event record type `hip_op_begin`) */
void barectf_api_ops_trace_hip_op_begin(struct barectf_api_ops_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *p__kernel_name);

/* Trace (data stream type `api_ops`, event record type `hip_op_end`) */
void barectf_api_ops_trace_hip_op_end(struct barectf_api_ops_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `api_ops`, event record type `hsa_op_begin`) */
void barectf_api_ops_trace_hsa_op_begin(struct barectf_api_ops_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `api_ops`, event record type `hsa_op_end`) */
void barectf_api_ops_trace_hsa_op_end(struct barectf_api_ops_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);
/* Open packet for data stream type `hip_api` */
void barectf_hip_api_open_packet(
	struct barectf_hip_api_ctx *sctx);

/* Close packet for data stream type `hip_api` */
void barectf_hip_api_close_packet(struct barectf_hip_api_ctx *sctx);

/* Trace (data stream type `hip_api`, event record type `__hipPopCallConfigurationBegin`) */
void barectf_hip_api_trace___hipPopCallConfigurationBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__gridDim,
	uint32_t p__gridDim__val__x,
	uint32_t p__gridDim__val__y,
	uint32_t p__gridDim__val__z,
	uint64_t p__blockDim,
	uint32_t p__blockDim__val__x,
	uint32_t p__blockDim__val__y,
	uint32_t p__blockDim__val__z,
	uint64_t p__sharedMem,
	uint64_t p__sharedMem__val,
	uint64_t p__stream,
	uint64_t p__stream__val);

/* Trace (data stream type `hip_api`, event record type `__hipPopCallConfigurationEnd`) */
void barectf_hip_api_trace___hipPopCallConfigurationEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `__hipPushCallConfigurationBegin`) */
void barectf_hip_api_trace___hipPushCallConfigurationBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint32_t p__gridDim__x,
	uint32_t p__gridDim__y,
	uint32_t p__gridDim__z,
	uint32_t p__blockDim__x,
	uint32_t p__blockDim__y,
	uint32_t p__blockDim__z,
	uint64_t p__sharedMem,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `__hipPushCallConfigurationEnd`) */
void barectf_hip_api_trace___hipPushCallConfigurationEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipArray3DCreateBegin`) */
void barectf_hip_api_trace_hipArray3DCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__array,
	uint64_t p__array__val,
	uint64_t p__pAllocateArray,
	uint64_t p__pAllocateArray__val__Width,
	uint64_t p__pAllocateArray__val__Height,
	uint64_t p__pAllocateArray__val__Depth,
	int32_t p__pAllocateArray__val__Format,
	uint32_t p__pAllocateArray__val__NumChannels,
	uint32_t p__pAllocateArray__val__Flags);

/* Trace (data stream type `hip_api`, event record type `hipArray3DCreateEnd`) */
void barectf_hip_api_trace_hipArray3DCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipArray3DGetDescriptorBegin`) */
void barectf_hip_api_trace_hipArray3DGetDescriptorBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pArrayDescriptor,
	uint64_t p__pArrayDescriptor__val__Width,
	uint64_t p__pArrayDescriptor__val__Height,
	uint64_t p__pArrayDescriptor__val__Depth,
	int32_t p__pArrayDescriptor__val__Format,
	uint32_t p__pArrayDescriptor__val__NumChannels,
	uint32_t p__pArrayDescriptor__val__Flags,
	uint64_t p__array);

/* Trace (data stream type `hip_api`, event record type `hipArray3DGetDescriptorEnd`) */
void barectf_hip_api_trace_hipArray3DGetDescriptorEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipArrayCreateBegin`) */
void barectf_hip_api_trace_hipArrayCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pHandle,
	uint64_t p__pHandle__val,
	uint64_t p__pAllocateArray,
	uint64_t p__pAllocateArray__val__Width,
	uint64_t p__pAllocateArray__val__Height,
	int32_t p__pAllocateArray__val__Format,
	uint32_t p__pAllocateArray__val__NumChannels);

/* Trace (data stream type `hip_api`, event record type `hipArrayCreateEnd`) */
void barectf_hip_api_trace_hipArrayCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipArrayDestroyBegin`) */
void barectf_hip_api_trace_hipArrayDestroyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__array);

/* Trace (data stream type `hip_api`, event record type `hipArrayDestroyEnd`) */
void barectf_hip_api_trace_hipArrayDestroyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipArrayGetDescriptorBegin`) */
void barectf_hip_api_trace_hipArrayGetDescriptorBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pArrayDescriptor,
	uint64_t p__pArrayDescriptor__val__Width,
	uint64_t p__pArrayDescriptor__val__Height,
	int32_t p__pArrayDescriptor__val__Format,
	uint32_t p__pArrayDescriptor__val__NumChannels,
	uint64_t p__array);

/* Trace (data stream type `hip_api`, event record type `hipArrayGetDescriptorEnd`) */
void barectf_hip_api_trace_hipArrayGetDescriptorEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipArrayGetInfoBegin`) */
void barectf_hip_api_trace_hipArrayGetInfoBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__desc,
	int32_t p__desc__val__x,
	int32_t p__desc__val__y,
	int32_t p__desc__val__z,
	int32_t p__desc__val__w,
	int32_t p__desc__val__f,
	uint64_t p__extent,
	uint64_t p__extent__val__width,
	uint64_t p__extent__val__height,
	uint64_t p__extent__val__depth,
	uint64_t p__flags,
	uint32_t p__flags__val,
	uint64_t p__array);

/* Trace (data stream type `hip_api`, event record type `hipArrayGetInfoEnd`) */
void barectf_hip_api_trace_hipArrayGetInfoEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipChooseDeviceBegin`) */
void barectf_hip_api_trace_hipChooseDeviceBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipChooseDeviceEnd`) */
void barectf_hip_api_trace_hipChooseDeviceEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipChooseDeviceR0000Begin`) */
void barectf_hip_api_trace_hipChooseDeviceR0000Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__device,
	int32_t p__device__val,
	uint64_t p__prop,
	uint64_t p__prop__val__name,
	uint64_t p__prop__val__totalGlobalMem,
	uint64_t p__prop__val__sharedMemPerBlock,
	int32_t p__prop__val__regsPerBlock,
	int32_t p__prop__val__warpSize,
	int32_t p__prop__val__maxThreadsPerBlock,
	uint64_t p__prop__val__maxThreadsDim,
	uint64_t p__prop__val__maxGridSize,
	int32_t p__prop__val__clockRate,
	int32_t p__prop__val__memoryClockRate,
	int32_t p__prop__val__memoryBusWidth,
	uint64_t p__prop__val__totalConstMem,
	int32_t p__prop__val__major,
	int32_t p__prop__val__minor,
	int32_t p__prop__val__multiProcessorCount,
	int32_t p__prop__val__l2CacheSize,
	int32_t p__prop__val__maxThreadsPerMultiProcessor,
	int32_t p__prop__val__computeMode,
	int32_t p__prop__val__clockInstructionRate,
	uint32_t p__prop__val__arch__hasGlobalInt32Atomics,
	uint32_t p__prop__val__arch__hasGlobalFloatAtomicExch,
	uint32_t p__prop__val__arch__hasSharedInt32Atomics,
	uint32_t p__prop__val__arch__hasSharedFloatAtomicExch,
	uint32_t p__prop__val__arch__hasFloatAtomicAdd,
	uint32_t p__prop__val__arch__hasGlobalInt64Atomics,
	uint32_t p__prop__val__arch__hasSharedInt64Atomics,
	uint32_t p__prop__val__arch__hasDoubles,
	uint32_t p__prop__val__arch__hasWarpVote,
	uint32_t p__prop__val__arch__hasWarpBallot,
	uint32_t p__prop__val__arch__hasWarpShuffle,
	uint32_t p__prop__val__arch__hasFunnelShift,
	uint32_t p__prop__val__arch__hasThreadFenceSystem,
	uint32_t p__prop__val__arch__hasSyncThreadsExt,
	uint32_t p__prop__val__arch__hasSurfaceFuncs,
	uint32_t p__prop__val__arch__has3dGrid,
	uint32_t p__prop__val__arch__hasDynamicParallelism,
	int32_t p__prop__val__concurrentKernels,
	int32_t p__prop__val__pciDomainID,
	int32_t p__prop__val__pciBusID,
	int32_t p__prop__val__pciDeviceID,
	uint64_t p__prop__val__maxSharedMemoryPerMultiProcessor,
	int32_t p__prop__val__isMultiGpuBoard,
	int32_t p__prop__val__canMapHostMemory,
	int32_t p__prop__val__gcnArch,
	uint64_t p__prop__val__gcnArchName,
	int32_t p__prop__val__integrated,
	int32_t p__prop__val__cooperativeLaunch,
	int32_t p__prop__val__cooperativeMultiDeviceLaunch,
	int32_t p__prop__val__maxTexture1DLinear,
	int32_t p__prop__val__maxTexture1D,
	uint64_t p__prop__val__maxTexture2D,
	uint64_t p__prop__val__maxTexture3D,
	uint64_t p__prop__val__hdpMemFlushCntl,
	uint64_t p__prop__val__hdpRegFlushCntl,
	uint64_t p__prop__val__memPitch,
	uint64_t p__prop__val__textureAlignment,
	uint64_t p__prop__val__texturePitchAlignment,
	int32_t p__prop__val__kernelExecTimeoutEnabled,
	int32_t p__prop__val__ECCEnabled,
	int32_t p__prop__val__tccDriver,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedFunc,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedGridDim,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem,
	int32_t p__prop__val__isLargeBar,
	int32_t p__prop__val__asicRevision,
	int32_t p__prop__val__managedMemory,
	int32_t p__prop__val__directManagedMemAccessFromHost,
	int32_t p__prop__val__concurrentManagedAccess,
	int32_t p__prop__val__pageableMemoryAccess,
	int32_t p__prop__val__pageableMemoryAccessUsesHostPageTables);

/* Trace (data stream type `hip_api`, event record type `hipChooseDeviceR0000End`) */
void barectf_hip_api_trace_hipChooseDeviceR0000End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipChooseDeviceR0600Begin`) */
void barectf_hip_api_trace_hipChooseDeviceR0600Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__device,
	int32_t p__device__val,
	uint64_t p__prop,
	uint64_t p__prop__val__name,
	uint64_t p__prop__val__uuid__bytes,
	uint64_t p__prop__val__luid,
	uint32_t p__prop__val__luidDeviceNodeMask,
	uint64_t p__prop__val__totalGlobalMem,
	uint64_t p__prop__val__sharedMemPerBlock,
	int32_t p__prop__val__regsPerBlock,
	int32_t p__prop__val__warpSize,
	uint64_t p__prop__val__memPitch,
	int32_t p__prop__val__maxThreadsPerBlock,
	uint64_t p__prop__val__maxThreadsDim,
	uint64_t p__prop__val__maxGridSize,
	int32_t p__prop__val__clockRate,
	uint64_t p__prop__val__totalConstMem,
	int32_t p__prop__val__major,
	int32_t p__prop__val__minor,
	uint64_t p__prop__val__textureAlignment,
	uint64_t p__prop__val__texturePitchAlignment,
	int32_t p__prop__val__deviceOverlap,
	int32_t p__prop__val__multiProcessorCount,
	int32_t p__prop__val__kernelExecTimeoutEnabled,
	int32_t p__prop__val__integrated,
	int32_t p__prop__val__canMapHostMemory,
	int32_t p__prop__val__computeMode,
	int32_t p__prop__val__maxTexture1D,
	int32_t p__prop__val__maxTexture1DMipmap,
	int32_t p__prop__val__maxTexture1DLinear,
	uint64_t p__prop__val__maxTexture2D,
	uint64_t p__prop__val__maxTexture2DMipmap,
	uint64_t p__prop__val__maxTexture2DLinear,
	uint64_t p__prop__val__maxTexture2DGather,
	uint64_t p__prop__val__maxTexture3D,
	uint64_t p__prop__val__maxTexture3DAlt,
	int32_t p__prop__val__maxTextureCubemap,
	uint64_t p__prop__val__maxTexture1DLayered,
	uint64_t p__prop__val__maxTexture2DLayered,
	uint64_t p__prop__val__maxTextureCubemapLayered,
	int32_t p__prop__val__maxSurface1D,
	uint64_t p__prop__val__maxSurface2D,
	uint64_t p__prop__val__maxSurface3D,
	uint64_t p__prop__val__maxSurface1DLayered,
	uint64_t p__prop__val__maxSurface2DLayered,
	int32_t p__prop__val__maxSurfaceCubemap,
	uint64_t p__prop__val__maxSurfaceCubemapLayered,
	uint64_t p__prop__val__surfaceAlignment,
	int32_t p__prop__val__concurrentKernels,
	int32_t p__prop__val__ECCEnabled,
	int32_t p__prop__val__pciBusID,
	int32_t p__prop__val__pciDeviceID,
	int32_t p__prop__val__pciDomainID,
	int32_t p__prop__val__tccDriver,
	int32_t p__prop__val__asyncEngineCount,
	int32_t p__prop__val__unifiedAddressing,
	int32_t p__prop__val__memoryClockRate,
	int32_t p__prop__val__memoryBusWidth,
	int32_t p__prop__val__l2CacheSize,
	int32_t p__prop__val__persistingL2CacheMaxSize,
	int32_t p__prop__val__maxThreadsPerMultiProcessor,
	int32_t p__prop__val__streamPrioritiesSupported,
	int32_t p__prop__val__globalL1CacheSupported,
	int32_t p__prop__val__localL1CacheSupported,
	uint64_t p__prop__val__sharedMemPerMultiprocessor,
	int32_t p__prop__val__regsPerMultiprocessor,
	int32_t p__prop__val__managedMemory,
	int32_t p__prop__val__isMultiGpuBoard,
	int32_t p__prop__val__multiGpuBoardGroupID,
	int32_t p__prop__val__hostNativeAtomicSupported,
	int32_t p__prop__val__singleToDoublePrecisionPerfRatio,
	int32_t p__prop__val__pageableMemoryAccess,
	int32_t p__prop__val__concurrentManagedAccess,
	int32_t p__prop__val__computePreemptionSupported,
	int32_t p__prop__val__canUseHostPointerForRegisteredMem,
	int32_t p__prop__val__cooperativeLaunch,
	int32_t p__prop__val__cooperativeMultiDeviceLaunch,
	uint64_t p__prop__val__sharedMemPerBlockOptin,
	int32_t p__prop__val__pageableMemoryAccessUsesHostPageTables,
	int32_t p__prop__val__directManagedMemAccessFromHost,
	int32_t p__prop__val__maxBlocksPerMultiProcessor,
	int32_t p__prop__val__accessPolicyMaxWindowSize,
	uint64_t p__prop__val__reservedSharedMemPerBlock,
	int32_t p__prop__val__hostRegisterSupported,
	int32_t p__prop__val__sparseHipArraySupported,
	int32_t p__prop__val__hostRegisterReadOnlySupported,
	int32_t p__prop__val__timelineSemaphoreInteropSupported,
	int32_t p__prop__val__memoryPoolsSupported,
	int32_t p__prop__val__gpuDirectRDMASupported,
	uint32_t p__prop__val__gpuDirectRDMAFlushWritesOptions,
	int32_t p__prop__val__gpuDirectRDMAWritesOrdering,
	uint32_t p__prop__val__memoryPoolSupportedHandleTypes,
	int32_t p__prop__val__deferredMappingHipArraySupported,
	int32_t p__prop__val__ipcEventSupported,
	int32_t p__prop__val__clusterLaunch,
	int32_t p__prop__val__unifiedFunctionPointers,
	uint64_t p__prop__val__reserved,
	uint64_t p__prop__val__hipReserved,
	uint64_t p__prop__val__gcnArchName,
	uint64_t p__prop__val__maxSharedMemoryPerMultiProcessor,
	int32_t p__prop__val__clockInstructionRate,
	uint32_t p__prop__val__arch__hasGlobalInt32Atomics,
	uint32_t p__prop__val__arch__hasGlobalFloatAtomicExch,
	uint32_t p__prop__val__arch__hasSharedInt32Atomics,
	uint32_t p__prop__val__arch__hasSharedFloatAtomicExch,
	uint32_t p__prop__val__arch__hasFloatAtomicAdd,
	uint32_t p__prop__val__arch__hasGlobalInt64Atomics,
	uint32_t p__prop__val__arch__hasSharedInt64Atomics,
	uint32_t p__prop__val__arch__hasDoubles,
	uint32_t p__prop__val__arch__hasWarpVote,
	uint32_t p__prop__val__arch__hasWarpBallot,
	uint32_t p__prop__val__arch__hasWarpShuffle,
	uint32_t p__prop__val__arch__hasFunnelShift,
	uint32_t p__prop__val__arch__hasThreadFenceSystem,
	uint32_t p__prop__val__arch__hasSyncThreadsExt,
	uint32_t p__prop__val__arch__hasSurfaceFuncs,
	uint32_t p__prop__val__arch__has3dGrid,
	uint32_t p__prop__val__arch__hasDynamicParallelism,
	uint64_t p__prop__val__hdpMemFlushCntl,
	uint64_t p__prop__val__hdpRegFlushCntl,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedFunc,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedGridDim,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem,
	int32_t p__prop__val__isLargeBar,
	int32_t p__prop__val__asicRevision);

/* Trace (data stream type `hip_api`, event record type `hipChooseDeviceR0600End`) */
void barectf_hip_api_trace_hipChooseDeviceR0600End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipConfigureCallBegin`) */
void barectf_hip_api_trace_hipConfigureCallBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint32_t p__gridDim__x,
	uint32_t p__gridDim__y,
	uint32_t p__gridDim__z,
	uint32_t p__blockDim__x,
	uint32_t p__blockDim__y,
	uint32_t p__blockDim__z,
	uint64_t p__sharedMem,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipConfigureCallEnd`) */
void barectf_hip_api_trace_hipConfigureCallEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCreateSurfaceObjectBegin`) */
void barectf_hip_api_trace_hipCreateSurfaceObjectBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pSurfObject,
	uint64_t p__pSurfObject__val,
	uint64_t p__pResDesc,
	int32_t p__pResDesc__val__resType);

/* Trace (data stream type `hip_api`, event record type `hipCreateSurfaceObjectEnd`) */
void barectf_hip_api_trace_hipCreateSurfaceObjectEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxCreateBegin`) */
void barectf_hip_api_trace_hipCtxCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ctx,
	uint64_t p__ctx__val,
	uint32_t p__flags,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipCtxCreateEnd`) */
void barectf_hip_api_trace_hipCtxCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxDestroyBegin`) */
void barectf_hip_api_trace_hipCtxDestroyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ctx);

/* Trace (data stream type `hip_api`, event record type `hipCtxDestroyEnd`) */
void barectf_hip_api_trace_hipCtxDestroyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxDisablePeerAccessBegin`) */
void barectf_hip_api_trace_hipCtxDisablePeerAccessBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__peerCtx);

/* Trace (data stream type `hip_api`, event record type `hipCtxDisablePeerAccessEnd`) */
void barectf_hip_api_trace_hipCtxDisablePeerAccessEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxEnablePeerAccessBegin`) */
void barectf_hip_api_trace_hipCtxEnablePeerAccessBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__peerCtx,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipCtxEnablePeerAccessEnd`) */
void barectf_hip_api_trace_hipCtxEnablePeerAccessEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetApiVersionBegin`) */
void barectf_hip_api_trace_hipCtxGetApiVersionBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ctx,
	uint64_t p__apiVersion,
	uint32_t p__apiVersion__val);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetApiVersionEnd`) */
void barectf_hip_api_trace_hipCtxGetApiVersionEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetCacheConfigBegin`) */
void barectf_hip_api_trace_hipCtxGetCacheConfigBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__cacheConfig,
	int32_t p__cacheConfig__val);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetCacheConfigEnd`) */
void barectf_hip_api_trace_hipCtxGetCacheConfigEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetCurrentBegin`) */
void barectf_hip_api_trace_hipCtxGetCurrentBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ctx,
	uint64_t p__ctx__val);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetCurrentEnd`) */
void barectf_hip_api_trace_hipCtxGetCurrentEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetDeviceBegin`) */
void barectf_hip_api_trace_hipCtxGetDeviceBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__device,
	int32_t p__device__val);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetDeviceEnd`) */
void barectf_hip_api_trace_hipCtxGetDeviceEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetFlagsBegin`) */
void barectf_hip_api_trace_hipCtxGetFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__flags,
	uint32_t p__flags__val);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetFlagsEnd`) */
void barectf_hip_api_trace_hipCtxGetFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetSharedMemConfigBegin`) */
void barectf_hip_api_trace_hipCtxGetSharedMemConfigBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pConfig,
	int32_t p__pConfig__val);

/* Trace (data stream type `hip_api`, event record type `hipCtxGetSharedMemConfigEnd`) */
void barectf_hip_api_trace_hipCtxGetSharedMemConfigEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxPopCurrentBegin`) */
void barectf_hip_api_trace_hipCtxPopCurrentBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ctx,
	uint64_t p__ctx__val);

/* Trace (data stream type `hip_api`, event record type `hipCtxPopCurrentEnd`) */
void barectf_hip_api_trace_hipCtxPopCurrentEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxPushCurrentBegin`) */
void barectf_hip_api_trace_hipCtxPushCurrentBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ctx);

/* Trace (data stream type `hip_api`, event record type `hipCtxPushCurrentEnd`) */
void barectf_hip_api_trace_hipCtxPushCurrentEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxSetCacheConfigBegin`) */
void barectf_hip_api_trace_hipCtxSetCacheConfigBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__cacheConfig);

/* Trace (data stream type `hip_api`, event record type `hipCtxSetCacheConfigEnd`) */
void barectf_hip_api_trace_hipCtxSetCacheConfigEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxSetCurrentBegin`) */
void barectf_hip_api_trace_hipCtxSetCurrentBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ctx);

/* Trace (data stream type `hip_api`, event record type `hipCtxSetCurrentEnd`) */
void barectf_hip_api_trace_hipCtxSetCurrentEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxSetSharedMemConfigBegin`) */
void barectf_hip_api_trace_hipCtxSetSharedMemConfigBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__config);

/* Trace (data stream type `hip_api`, event record type `hipCtxSetSharedMemConfigEnd`) */
void barectf_hip_api_trace_hipCtxSetSharedMemConfigEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxSynchronizeBegin`) */
void barectf_hip_api_trace_hipCtxSynchronizeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipCtxSynchronizeEnd`) */
void barectf_hip_api_trace_hipCtxSynchronizeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDestroyExternalMemoryBegin`) */
void barectf_hip_api_trace_hipDestroyExternalMemoryBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__extMem);

/* Trace (data stream type `hip_api`, event record type `hipDestroyExternalMemoryEnd`) */
void barectf_hip_api_trace_hipDestroyExternalMemoryEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDestroyExternalSemaphoreBegin`) */
void barectf_hip_api_trace_hipDestroyExternalSemaphoreBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__extSem);

/* Trace (data stream type `hip_api`, event record type `hipDestroyExternalSemaphoreEnd`) */
void barectf_hip_api_trace_hipDestroyExternalSemaphoreEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDestroySurfaceObjectBegin`) */
void barectf_hip_api_trace_hipDestroySurfaceObjectBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__surfaceObject);

/* Trace (data stream type `hip_api`, event record type `hipDestroySurfaceObjectEnd`) */
void barectf_hip_api_trace_hipDestroySurfaceObjectEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceCanAccessPeerBegin`) */
void barectf_hip_api_trace_hipDeviceCanAccessPeerBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__canAccessPeer,
	int32_t p__canAccessPeer__val,
	int32_t p__deviceId,
	int32_t p__peerDeviceId);

/* Trace (data stream type `hip_api`, event record type `hipDeviceCanAccessPeerEnd`) */
void barectf_hip_api_trace_hipDeviceCanAccessPeerEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceComputeCapabilityBegin`) */
void barectf_hip_api_trace_hipDeviceComputeCapabilityBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__major,
	int32_t p__major__val,
	uint64_t p__minor,
	int32_t p__minor__val,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipDeviceComputeCapabilityEnd`) */
void barectf_hip_api_trace_hipDeviceComputeCapabilityEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceDisablePeerAccessBegin`) */
void barectf_hip_api_trace_hipDeviceDisablePeerAccessBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__peerDeviceId);

/* Trace (data stream type `hip_api`, event record type `hipDeviceDisablePeerAccessEnd`) */
void barectf_hip_api_trace_hipDeviceDisablePeerAccessEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceEnablePeerAccessBegin`) */
void barectf_hip_api_trace_hipDeviceEnablePeerAccessBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__peerDeviceId,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipDeviceEnablePeerAccessEnd`) */
void barectf_hip_api_trace_hipDeviceEnablePeerAccessEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetAttributeBegin`) */
void barectf_hip_api_trace_hipDeviceGetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pi,
	int32_t p__pi__val,
	int32_t p__attr,
	int32_t p__deviceId);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetAttributeEnd`) */
void barectf_hip_api_trace_hipDeviceGetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetBegin`) */
void barectf_hip_api_trace_hipDeviceGetBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__device,
	int32_t p__device__val,
	int32_t p__ordinal);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetByPCIBusIdBegin`) */
void barectf_hip_api_trace_hipDeviceGetByPCIBusIdBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__device,
	int32_t p__device__val,
	const char *p__pciBusId,
	int8_t p__pciBusId__val);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetByPCIBusIdEnd`) */
void barectf_hip_api_trace_hipDeviceGetByPCIBusIdEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetCacheConfigBegin`) */
void barectf_hip_api_trace_hipDeviceGetCacheConfigBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__cacheConfig,
	int32_t p__cacheConfig__val);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetCacheConfigEnd`) */
void barectf_hip_api_trace_hipDeviceGetCacheConfigEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetDefaultMemPoolBegin`) */
void barectf_hip_api_trace_hipDeviceGetDefaultMemPoolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mem_pool,
	uint64_t p__mem_pool__val,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetDefaultMemPoolEnd`) */
void barectf_hip_api_trace_hipDeviceGetDefaultMemPoolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetEnd`) */
void barectf_hip_api_trace_hipDeviceGetEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetGraphMemAttributeBegin`) */
void barectf_hip_api_trace_hipDeviceGetGraphMemAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__device,
	int32_t p__attr,
	uint64_t p__value);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetGraphMemAttributeEnd`) */
void barectf_hip_api_trace_hipDeviceGetGraphMemAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetLimitBegin`) */
void barectf_hip_api_trace_hipDeviceGetLimitBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pValue,
	uint64_t p__pValue__val,
	int32_t p__limit);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetLimitEnd`) */
void barectf_hip_api_trace_hipDeviceGetLimitEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetMemPoolBegin`) */
void barectf_hip_api_trace_hipDeviceGetMemPoolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mem_pool,
	uint64_t p__mem_pool__val,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetMemPoolEnd`) */
void barectf_hip_api_trace_hipDeviceGetMemPoolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetNameBegin`) */
void barectf_hip_api_trace_hipDeviceGetNameBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	const char *p__name,
	int8_t p__name__val,
	int32_t p__len,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetNameEnd`) */
void barectf_hip_api_trace_hipDeviceGetNameEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetP2PAttributeBegin`) */
void barectf_hip_api_trace_hipDeviceGetP2PAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__value,
	int32_t p__value__val,
	int32_t p__attr,
	int32_t p__srcDevice,
	int32_t p__dstDevice);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetP2PAttributeEnd`) */
void barectf_hip_api_trace_hipDeviceGetP2PAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetPCIBusIdBegin`) */
void barectf_hip_api_trace_hipDeviceGetPCIBusIdBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	const char *p__pciBusId,
	int8_t p__pciBusId__val,
	int32_t p__len,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetPCIBusIdEnd`) */
void barectf_hip_api_trace_hipDeviceGetPCIBusIdEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetSharedMemConfigBegin`) */
void barectf_hip_api_trace_hipDeviceGetSharedMemConfigBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pConfig,
	int32_t p__pConfig__val);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetSharedMemConfigEnd`) */
void barectf_hip_api_trace_hipDeviceGetSharedMemConfigEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetStreamPriorityRangeBegin`) */
void barectf_hip_api_trace_hipDeviceGetStreamPriorityRangeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__leastPriority,
	int32_t p__leastPriority__val,
	uint64_t p__greatestPriority,
	int32_t p__greatestPriority__val);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetStreamPriorityRangeEnd`) */
void barectf_hip_api_trace_hipDeviceGetStreamPriorityRangeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetUuidBegin`) */
void barectf_hip_api_trace_hipDeviceGetUuidBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__uuid,
	uint64_t p__uuid__val__bytes,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGetUuidEnd`) */
void barectf_hip_api_trace_hipDeviceGetUuidEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGraphMemTrimBegin`) */
void barectf_hip_api_trace_hipDeviceGraphMemTrimBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipDeviceGraphMemTrimEnd`) */
void barectf_hip_api_trace_hipDeviceGraphMemTrimEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDevicePrimaryCtxGetStateBegin`) */
void barectf_hip_api_trace_hipDevicePrimaryCtxGetStateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__dev,
	uint64_t p__flags,
	uint32_t p__flags__val,
	uint64_t p__active,
	int32_t p__active__val);

/* Trace (data stream type `hip_api`, event record type `hipDevicePrimaryCtxGetStateEnd`) */
void barectf_hip_api_trace_hipDevicePrimaryCtxGetStateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDevicePrimaryCtxReleaseBegin`) */
void barectf_hip_api_trace_hipDevicePrimaryCtxReleaseBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__dev);

/* Trace (data stream type `hip_api`, event record type `hipDevicePrimaryCtxReleaseEnd`) */
void barectf_hip_api_trace_hipDevicePrimaryCtxReleaseEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDevicePrimaryCtxResetBegin`) */
void barectf_hip_api_trace_hipDevicePrimaryCtxResetBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__dev);

/* Trace (data stream type `hip_api`, event record type `hipDevicePrimaryCtxResetEnd`) */
void barectf_hip_api_trace_hipDevicePrimaryCtxResetEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDevicePrimaryCtxRetainBegin`) */
void barectf_hip_api_trace_hipDevicePrimaryCtxRetainBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pctx,
	uint64_t p__pctx__val,
	int32_t p__dev);

/* Trace (data stream type `hip_api`, event record type `hipDevicePrimaryCtxRetainEnd`) */
void barectf_hip_api_trace_hipDevicePrimaryCtxRetainEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDevicePrimaryCtxSetFlagsBegin`) */
void barectf_hip_api_trace_hipDevicePrimaryCtxSetFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__dev,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipDevicePrimaryCtxSetFlagsEnd`) */
void barectf_hip_api_trace_hipDevicePrimaryCtxSetFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceResetBegin`) */
void barectf_hip_api_trace_hipDeviceResetBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceResetEnd`) */
void barectf_hip_api_trace_hipDeviceResetEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSetCacheConfigBegin`) */
void barectf_hip_api_trace_hipDeviceSetCacheConfigBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__cacheConfig);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSetCacheConfigEnd`) */
void barectf_hip_api_trace_hipDeviceSetCacheConfigEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSetGraphMemAttributeBegin`) */
void barectf_hip_api_trace_hipDeviceSetGraphMemAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__device,
	int32_t p__attr,
	uint64_t p__value);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSetGraphMemAttributeEnd`) */
void barectf_hip_api_trace_hipDeviceSetGraphMemAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSetLimitBegin`) */
void barectf_hip_api_trace_hipDeviceSetLimitBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__limit,
	uint64_t p__value);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSetLimitEnd`) */
void barectf_hip_api_trace_hipDeviceSetLimitEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSetMemPoolBegin`) */
void barectf_hip_api_trace_hipDeviceSetMemPoolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__device,
	uint64_t p__mem_pool);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSetMemPoolEnd`) */
void barectf_hip_api_trace_hipDeviceSetMemPoolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSetSharedMemConfigBegin`) */
void barectf_hip_api_trace_hipDeviceSetSharedMemConfigBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__config);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSetSharedMemConfigEnd`) */
void barectf_hip_api_trace_hipDeviceSetSharedMemConfigEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSynchronizeBegin`) */
void barectf_hip_api_trace_hipDeviceSynchronizeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceSynchronizeEnd`) */
void barectf_hip_api_trace_hipDeviceSynchronizeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDeviceTotalMemBegin`) */
void barectf_hip_api_trace_hipDeviceTotalMemBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__bytes,
	uint64_t p__bytes__val,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipDeviceTotalMemEnd`) */
void barectf_hip_api_trace_hipDeviceTotalMemEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDriverGetVersionBegin`) */
void barectf_hip_api_trace_hipDriverGetVersionBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__driverVersion,
	int32_t p__driverVersion__val);

/* Trace (data stream type `hip_api`, event record type `hipDriverGetVersionEnd`) */
void barectf_hip_api_trace_hipDriverGetVersionEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphAddMemFreeNodeBegin`) */
void barectf_hip_api_trace_hipDrvGraphAddMemFreeNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__phGraphNode,
	uint64_t p__phGraphNode__val,
	uint64_t p__hGraph,
	uint64_t p__dependencies,
	uint64_t p__dependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__dptr);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphAddMemFreeNodeEnd`) */
void barectf_hip_api_trace_hipDrvGraphAddMemFreeNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphAddMemcpyNodeBegin`) */
void barectf_hip_api_trace_hipDrvGraphAddMemcpyNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__phGraphNode,
	uint64_t p__phGraphNode__val,
	uint64_t p__hGraph,
	uint64_t p__dependencies,
	uint64_t p__dependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__copyParams,
	uint64_t p__copyParams__val__srcXInBytes,
	uint64_t p__copyParams__val__srcY,
	uint64_t p__copyParams__val__srcZ,
	uint64_t p__copyParams__val__srcLOD,
	int32_t p__copyParams__val__srcMemoryType,
	uint64_t p__copyParams__val__srcHost,
	uint64_t p__copyParams__val__srcDevice,
	uint64_t p__copyParams__val__srcArray,
	uint64_t p__copyParams__val__srcPitch,
	uint64_t p__copyParams__val__srcHeight,
	uint64_t p__copyParams__val__dstXInBytes,
	uint64_t p__copyParams__val__dstY,
	uint64_t p__copyParams__val__dstZ,
	uint64_t p__copyParams__val__dstLOD,
	int32_t p__copyParams__val__dstMemoryType,
	uint64_t p__copyParams__val__dstHost,
	uint64_t p__copyParams__val__dstDevice,
	uint64_t p__copyParams__val__dstArray,
	uint64_t p__copyParams__val__dstPitch,
	uint64_t p__copyParams__val__dstHeight,
	uint64_t p__copyParams__val__WidthInBytes,
	uint64_t p__copyParams__val__Height,
	uint64_t p__copyParams__val__Depth,
	uint64_t p__ctx);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphAddMemcpyNodeEnd`) */
void barectf_hip_api_trace_hipDrvGraphAddMemcpyNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphAddMemsetNodeBegin`) */
void barectf_hip_api_trace_hipDrvGraphAddMemsetNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__phGraphNode,
	uint64_t p__phGraphNode__val,
	uint64_t p__hGraph,
	uint64_t p__dependencies,
	uint64_t p__dependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__memsetParams,
	uint64_t p__memsetParams__val__dst,
	uint32_t p__memsetParams__val__elementSize,
	uint64_t p__memsetParams__val__height,
	uint64_t p__memsetParams__val__pitch,
	uint32_t p__memsetParams__val__value,
	uint64_t p__memsetParams__val__width,
	uint64_t p__ctx);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphAddMemsetNodeEnd`) */
void barectf_hip_api_trace_hipDrvGraphAddMemsetNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphExecMemcpyNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipDrvGraphExecMemcpyNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__hNode,
	uint64_t p__copyParams,
	uint64_t p__copyParams__val__srcXInBytes,
	uint64_t p__copyParams__val__srcY,
	uint64_t p__copyParams__val__srcZ,
	uint64_t p__copyParams__val__srcLOD,
	int32_t p__copyParams__val__srcMemoryType,
	uint64_t p__copyParams__val__srcHost,
	uint64_t p__copyParams__val__srcDevice,
	uint64_t p__copyParams__val__srcArray,
	uint64_t p__copyParams__val__srcPitch,
	uint64_t p__copyParams__val__srcHeight,
	uint64_t p__copyParams__val__dstXInBytes,
	uint64_t p__copyParams__val__dstY,
	uint64_t p__copyParams__val__dstZ,
	uint64_t p__copyParams__val__dstLOD,
	int32_t p__copyParams__val__dstMemoryType,
	uint64_t p__copyParams__val__dstHost,
	uint64_t p__copyParams__val__dstDevice,
	uint64_t p__copyParams__val__dstArray,
	uint64_t p__copyParams__val__dstPitch,
	uint64_t p__copyParams__val__dstHeight,
	uint64_t p__copyParams__val__WidthInBytes,
	uint64_t p__copyParams__val__Height,
	uint64_t p__copyParams__val__Depth,
	uint64_t p__ctx);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphExecMemcpyNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipDrvGraphExecMemcpyNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphExecMemsetNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipDrvGraphExecMemsetNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__hNode,
	uint64_t p__memsetParams,
	uint64_t p__memsetParams__val__dst,
	uint32_t p__memsetParams__val__elementSize,
	uint64_t p__memsetParams__val__height,
	uint64_t p__memsetParams__val__pitch,
	uint32_t p__memsetParams__val__value,
	uint64_t p__memsetParams__val__width,
	uint64_t p__ctx);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphExecMemsetNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipDrvGraphExecMemsetNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphMemcpyNodeGetParamsBegin`) */
void barectf_hip_api_trace_hipDrvGraphMemcpyNodeGetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hNode,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__srcXInBytes,
	uint64_t p__nodeParams__val__srcY,
	uint64_t p__nodeParams__val__srcZ,
	uint64_t p__nodeParams__val__srcLOD,
	int32_t p__nodeParams__val__srcMemoryType,
	uint64_t p__nodeParams__val__srcHost,
	uint64_t p__nodeParams__val__srcDevice,
	uint64_t p__nodeParams__val__srcArray,
	uint64_t p__nodeParams__val__srcPitch,
	uint64_t p__nodeParams__val__srcHeight,
	uint64_t p__nodeParams__val__dstXInBytes,
	uint64_t p__nodeParams__val__dstY,
	uint64_t p__nodeParams__val__dstZ,
	uint64_t p__nodeParams__val__dstLOD,
	int32_t p__nodeParams__val__dstMemoryType,
	uint64_t p__nodeParams__val__dstHost,
	uint64_t p__nodeParams__val__dstDevice,
	uint64_t p__nodeParams__val__dstArray,
	uint64_t p__nodeParams__val__dstPitch,
	uint64_t p__nodeParams__val__dstHeight,
	uint64_t p__nodeParams__val__WidthInBytes,
	uint64_t p__nodeParams__val__Height,
	uint64_t p__nodeParams__val__Depth);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphMemcpyNodeGetParamsEnd`) */
void barectf_hip_api_trace_hipDrvGraphMemcpyNodeGetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphMemcpyNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipDrvGraphMemcpyNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hNode,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__srcXInBytes,
	uint64_t p__nodeParams__val__srcY,
	uint64_t p__nodeParams__val__srcZ,
	uint64_t p__nodeParams__val__srcLOD,
	int32_t p__nodeParams__val__srcMemoryType,
	uint64_t p__nodeParams__val__srcHost,
	uint64_t p__nodeParams__val__srcDevice,
	uint64_t p__nodeParams__val__srcArray,
	uint64_t p__nodeParams__val__srcPitch,
	uint64_t p__nodeParams__val__srcHeight,
	uint64_t p__nodeParams__val__dstXInBytes,
	uint64_t p__nodeParams__val__dstY,
	uint64_t p__nodeParams__val__dstZ,
	uint64_t p__nodeParams__val__dstLOD,
	int32_t p__nodeParams__val__dstMemoryType,
	uint64_t p__nodeParams__val__dstHost,
	uint64_t p__nodeParams__val__dstDevice,
	uint64_t p__nodeParams__val__dstArray,
	uint64_t p__nodeParams__val__dstPitch,
	uint64_t p__nodeParams__val__dstHeight,
	uint64_t p__nodeParams__val__WidthInBytes,
	uint64_t p__nodeParams__val__Height,
	uint64_t p__nodeParams__val__Depth);

/* Trace (data stream type `hip_api`, event record type `hipDrvGraphMemcpyNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipDrvGraphMemcpyNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvLaunchKernelExBegin`) */
void barectf_hip_api_trace_hipDrvLaunchKernelExBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__config,
	uint32_t p__config__val__gridDimX,
	uint32_t p__config__val__gridDimY,
	uint32_t p__config__val__gridDimZ,
	uint32_t p__config__val__blockDimX,
	uint32_t p__config__val__blockDimY,
	uint32_t p__config__val__blockDimZ,
	uint32_t p__config__val__sharedMemBytes,
	uint64_t p__config__val__hStream,
	uint64_t p__config__val__attrs,
	uint32_t p__config__val__numAttrs,
	uint64_t p__f,
	uint64_t p__params,
	uint64_t p__params__val,
	uint64_t p__extra,
	uint64_t p__extra__val);

/* Trace (data stream type `hip_api`, event record type `hipDrvLaunchKernelExEnd`) */
void barectf_hip_api_trace_hipDrvLaunchKernelExEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvMemcpy2DUnalignedBegin`) */
void barectf_hip_api_trace_hipDrvMemcpy2DUnalignedBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pCopy,
	uint64_t p__pCopy__val__srcXInBytes,
	uint64_t p__pCopy__val__srcY,
	int32_t p__pCopy__val__srcMemoryType,
	uint64_t p__pCopy__val__srcHost,
	uint64_t p__pCopy__val__srcDevice,
	uint64_t p__pCopy__val__srcArray,
	uint64_t p__pCopy__val__srcPitch,
	uint64_t p__pCopy__val__dstXInBytes,
	uint64_t p__pCopy__val__dstY,
	int32_t p__pCopy__val__dstMemoryType,
	uint64_t p__pCopy__val__dstHost,
	uint64_t p__pCopy__val__dstDevice,
	uint64_t p__pCopy__val__dstArray,
	uint64_t p__pCopy__val__dstPitch,
	uint64_t p__pCopy__val__WidthInBytes,
	uint64_t p__pCopy__val__Height);

/* Trace (data stream type `hip_api`, event record type `hipDrvMemcpy2DUnalignedEnd`) */
void barectf_hip_api_trace_hipDrvMemcpy2DUnalignedEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvMemcpy3DAsyncBegin`) */
void barectf_hip_api_trace_hipDrvMemcpy3DAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pCopy,
	uint64_t p__pCopy__val__srcXInBytes,
	uint64_t p__pCopy__val__srcY,
	uint64_t p__pCopy__val__srcZ,
	uint64_t p__pCopy__val__srcLOD,
	int32_t p__pCopy__val__srcMemoryType,
	uint64_t p__pCopy__val__srcHost,
	uint64_t p__pCopy__val__srcDevice,
	uint64_t p__pCopy__val__srcArray,
	uint64_t p__pCopy__val__srcPitch,
	uint64_t p__pCopy__val__srcHeight,
	uint64_t p__pCopy__val__dstXInBytes,
	uint64_t p__pCopy__val__dstY,
	uint64_t p__pCopy__val__dstZ,
	uint64_t p__pCopy__val__dstLOD,
	int32_t p__pCopy__val__dstMemoryType,
	uint64_t p__pCopy__val__dstHost,
	uint64_t p__pCopy__val__dstDevice,
	uint64_t p__pCopy__val__dstArray,
	uint64_t p__pCopy__val__dstPitch,
	uint64_t p__pCopy__val__dstHeight,
	uint64_t p__pCopy__val__WidthInBytes,
	uint64_t p__pCopy__val__Height,
	uint64_t p__pCopy__val__Depth,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipDrvMemcpy3DAsyncEnd`) */
void barectf_hip_api_trace_hipDrvMemcpy3DAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvMemcpy3DBegin`) */
void barectf_hip_api_trace_hipDrvMemcpy3DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pCopy,
	uint64_t p__pCopy__val__srcXInBytes,
	uint64_t p__pCopy__val__srcY,
	uint64_t p__pCopy__val__srcZ,
	uint64_t p__pCopy__val__srcLOD,
	int32_t p__pCopy__val__srcMemoryType,
	uint64_t p__pCopy__val__srcHost,
	uint64_t p__pCopy__val__srcDevice,
	uint64_t p__pCopy__val__srcArray,
	uint64_t p__pCopy__val__srcPitch,
	uint64_t p__pCopy__val__srcHeight,
	uint64_t p__pCopy__val__dstXInBytes,
	uint64_t p__pCopy__val__dstY,
	uint64_t p__pCopy__val__dstZ,
	uint64_t p__pCopy__val__dstLOD,
	int32_t p__pCopy__val__dstMemoryType,
	uint64_t p__pCopy__val__dstHost,
	uint64_t p__pCopy__val__dstDevice,
	uint64_t p__pCopy__val__dstArray,
	uint64_t p__pCopy__val__dstPitch,
	uint64_t p__pCopy__val__dstHeight,
	uint64_t p__pCopy__val__WidthInBytes,
	uint64_t p__pCopy__val__Height,
	uint64_t p__pCopy__val__Depth);

/* Trace (data stream type `hip_api`, event record type `hipDrvMemcpy3DEnd`) */
void barectf_hip_api_trace_hipDrvMemcpy3DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipDrvPointerGetAttributesBegin`) */
void barectf_hip_api_trace_hipDrvPointerGetAttributesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint32_t p__numAttributes,
	uint64_t p__attributes,
	int32_t p__attributes__val,
	uint64_t p__data,
	uint64_t p__data__val,
	uint64_t p__ptr);

/* Trace (data stream type `hip_api`, event record type `hipDrvPointerGetAttributesEnd`) */
void barectf_hip_api_trace_hipDrvPointerGetAttributesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipEventCreateBegin`) */
void barectf_hip_api_trace_hipEventCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__event,
	uint64_t p__event__val);

/* Trace (data stream type `hip_api`, event record type `hipEventCreateEnd`) */
void barectf_hip_api_trace_hipEventCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipEventCreateWithFlagsBegin`) */
void barectf_hip_api_trace_hipEventCreateWithFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__event,
	uint64_t p__event__val,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipEventCreateWithFlagsEnd`) */
void barectf_hip_api_trace_hipEventCreateWithFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipEventDestroyBegin`) */
void barectf_hip_api_trace_hipEventDestroyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__event);

/* Trace (data stream type `hip_api`, event record type `hipEventDestroyEnd`) */
void barectf_hip_api_trace_hipEventDestroyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipEventElapsedTimeBegin`) */
void barectf_hip_api_trace_hipEventElapsedTimeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ms,
	uint64_t p__ms__val,
	uint64_t p__start,
	uint64_t p__stop);

/* Trace (data stream type `hip_api`, event record type `hipEventElapsedTimeEnd`) */
void barectf_hip_api_trace_hipEventElapsedTimeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipEventQueryBegin`) */
void barectf_hip_api_trace_hipEventQueryBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__event);

/* Trace (data stream type `hip_api`, event record type `hipEventQueryEnd`) */
void barectf_hip_api_trace_hipEventQueryEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipEventRecordBegin`) */
void barectf_hip_api_trace_hipEventRecordBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__event,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipEventRecordEnd`) */
void barectf_hip_api_trace_hipEventRecordEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipEventRecordWithFlagsBegin`) */
void barectf_hip_api_trace_hipEventRecordWithFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__event,
	uint64_t p__stream,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipEventRecordWithFlagsEnd`) */
void barectf_hip_api_trace_hipEventRecordWithFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipEventSynchronizeBegin`) */
void barectf_hip_api_trace_hipEventSynchronizeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__event);

/* Trace (data stream type `hip_api`, event record type `hipEventSynchronizeEnd`) */
void barectf_hip_api_trace_hipEventSynchronizeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExtGetLastErrorBegin`) */
void barectf_hip_api_trace_hipExtGetLastErrorBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExtGetLastErrorEnd`) */
void barectf_hip_api_trace_hipExtGetLastErrorEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExtGetLinkTypeAndHopCountBegin`) */
void barectf_hip_api_trace_hipExtGetLinkTypeAndHopCountBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__device1,
	int32_t p__device2,
	uint64_t p__linktype,
	uint32_t p__linktype__val,
	uint64_t p__hopcount,
	uint32_t p__hopcount__val);

/* Trace (data stream type `hip_api`, event record type `hipExtGetLinkTypeAndHopCountEnd`) */
void barectf_hip_api_trace_hipExtGetLinkTypeAndHopCountEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExtLaunchKernelBegin`) */
void barectf_hip_api_trace_hipExtLaunchKernelBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__function_address,
	uint32_t p__numBlocks__x,
	uint32_t p__numBlocks__y,
	uint32_t p__numBlocks__z,
	uint32_t p__dimBlocks__x,
	uint32_t p__dimBlocks__y,
	uint32_t p__dimBlocks__z,
	uint64_t p__args,
	uint64_t p__args__val,
	uint64_t p__sharedMemBytes,
	uint64_t p__stream,
	uint64_t p__startEvent,
	uint64_t p__stopEvent,
	int32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipExtLaunchKernelEnd`) */
void barectf_hip_api_trace_hipExtLaunchKernelEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExtLaunchMultiKernelMultiDeviceBegin`) */
void barectf_hip_api_trace_hipExtLaunchMultiKernelMultiDeviceBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__launchParamsList,
	uint64_t p__launchParamsList__val__func,
	uint32_t p__launchParamsList__val__gridDim__x,
	uint32_t p__launchParamsList__val__gridDim__y,
	uint32_t p__launchParamsList__val__gridDim__z,
	uint32_t p__launchParamsList__val__blockDim__x,
	uint32_t p__launchParamsList__val__blockDim__y,
	uint32_t p__launchParamsList__val__blockDim__z,
	uint64_t p__launchParamsList__val__args,
	uint64_t p__launchParamsList__val__sharedMem,
	uint64_t p__launchParamsList__val__stream,
	int32_t p__numDevices,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipExtLaunchMultiKernelMultiDeviceEnd`) */
void barectf_hip_api_trace_hipExtLaunchMultiKernelMultiDeviceEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExtMallocWithFlagsBegin`) */
void barectf_hip_api_trace_hipExtMallocWithFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__ptr__val,
	uint64_t p__sizeBytes,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipExtMallocWithFlagsEnd`) */
void barectf_hip_api_trace_hipExtMallocWithFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExtModuleLaunchKernelBegin`) */
void barectf_hip_api_trace_hipExtModuleLaunchKernelBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__f,
	uint32_t p__globalWorkSizeX,
	uint32_t p__globalWorkSizeY,
	uint32_t p__globalWorkSizeZ,
	uint32_t p__localWorkSizeX,
	uint32_t p__localWorkSizeY,
	uint32_t p__localWorkSizeZ,
	uint64_t p__sharedMemBytes,
	uint64_t p__hStream,
	uint64_t p__kernelParams,
	uint64_t p__kernelParams__val,
	uint64_t p__extra,
	uint64_t p__extra__val,
	uint64_t p__startEvent,
	uint64_t p__stopEvent,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipExtModuleLaunchKernelEnd`) */
void barectf_hip_api_trace_hipExtModuleLaunchKernelEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExtStreamCreateWithCUMaskBegin`) */
void barectf_hip_api_trace_hipExtStreamCreateWithCUMaskBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__stream__val,
	uint32_t p__cuMaskSize,
	uint64_t p__cuMask,
	uint32_t p__cuMask__val);

/* Trace (data stream type `hip_api`, event record type `hipExtStreamCreateWithCUMaskEnd`) */
void barectf_hip_api_trace_hipExtStreamCreateWithCUMaskEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExtStreamGetCUMaskBegin`) */
void barectf_hip_api_trace_hipExtStreamGetCUMaskBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint32_t p__cuMaskSize,
	uint64_t p__cuMask,
	uint32_t p__cuMask__val);

/* Trace (data stream type `hip_api`, event record type `hipExtStreamGetCUMaskEnd`) */
void barectf_hip_api_trace_hipExtStreamGetCUMaskEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExternalMemoryGetMappedBufferBegin`) */
void barectf_hip_api_trace_hipExternalMemoryGetMappedBufferBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__devPtr,
	uint64_t p__devPtr__val,
	uint64_t p__extMem,
	uint64_t p__bufferDesc,
	uint64_t p__bufferDesc__val__offset,
	uint64_t p__bufferDesc__val__size,
	uint32_t p__bufferDesc__val__flags,
	uint64_t p__bufferDesc__val__reserved);

/* Trace (data stream type `hip_api`, event record type `hipExternalMemoryGetMappedBufferEnd`) */
void barectf_hip_api_trace_hipExternalMemoryGetMappedBufferEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipExternalMemoryGetMappedMipmappedArrayBegin`) */
void barectf_hip_api_trace_hipExternalMemoryGetMappedMipmappedArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mipmap,
	uint64_t p__mipmap__val,
	uint64_t p__extMem,
	uint64_t p__mipmapDesc,
	uint64_t p__mipmapDesc__val__offset,
	int32_t p__mipmapDesc__val__formatDesc__x,
	int32_t p__mipmapDesc__val__formatDesc__y,
	int32_t p__mipmapDesc__val__formatDesc__z,
	int32_t p__mipmapDesc__val__formatDesc__w,
	int32_t p__mipmapDesc__val__formatDesc__f,
	uint64_t p__mipmapDesc__val__extent__width,
	uint64_t p__mipmapDesc__val__extent__height,
	uint64_t p__mipmapDesc__val__extent__depth,
	uint32_t p__mipmapDesc__val__flags,
	uint32_t p__mipmapDesc__val__numLevels);

/* Trace (data stream type `hip_api`, event record type `hipExternalMemoryGetMappedMipmappedArrayEnd`) */
void barectf_hip_api_trace_hipExternalMemoryGetMappedMipmappedArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipFreeArrayBegin`) */
void barectf_hip_api_trace_hipFreeArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__array);

/* Trace (data stream type `hip_api`, event record type `hipFreeArrayEnd`) */
void barectf_hip_api_trace_hipFreeArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipFreeAsyncBegin`) */
void barectf_hip_api_trace_hipFreeAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dev_ptr,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipFreeAsyncEnd`) */
void barectf_hip_api_trace_hipFreeAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipFreeBegin`) */
void barectf_hip_api_trace_hipFreeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr);

/* Trace (data stream type `hip_api`, event record type `hipFreeEnd`) */
void barectf_hip_api_trace_hipFreeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipFreeHostBegin`) */
void barectf_hip_api_trace_hipFreeHostBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr);

/* Trace (data stream type `hip_api`, event record type `hipFreeHostEnd`) */
void barectf_hip_api_trace_hipFreeHostEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipFreeMipmappedArrayBegin`) */
void barectf_hip_api_trace_hipFreeMipmappedArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mipmappedArray);

/* Trace (data stream type `hip_api`, event record type `hipFreeMipmappedArrayEnd`) */
void barectf_hip_api_trace_hipFreeMipmappedArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipFuncGetAttributeBegin`) */
void barectf_hip_api_trace_hipFuncGetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__value,
	int32_t p__value__val,
	int32_t p__attrib,
	uint64_t p__hfunc);

/* Trace (data stream type `hip_api`, event record type `hipFuncGetAttributeEnd`) */
void barectf_hip_api_trace_hipFuncGetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipFuncGetAttributesBegin`) */
void barectf_hip_api_trace_hipFuncGetAttributesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__attr,
	int32_t p__attr__val__binaryVersion,
	int32_t p__attr__val__cacheModeCA,
	uint64_t p__attr__val__constSizeBytes,
	uint64_t p__attr__val__localSizeBytes,
	int32_t p__attr__val__maxDynamicSharedSizeBytes,
	int32_t p__attr__val__maxThreadsPerBlock,
	int32_t p__attr__val__numRegs,
	int32_t p__attr__val__preferredShmemCarveout,
	int32_t p__attr__val__ptxVersion,
	uint64_t p__attr__val__sharedSizeBytes,
	uint64_t p__func);

/* Trace (data stream type `hip_api`, event record type `hipFuncGetAttributesEnd`) */
void barectf_hip_api_trace_hipFuncGetAttributesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipFuncSetAttributeBegin`) */
void barectf_hip_api_trace_hipFuncSetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__func,
	int32_t p__attr,
	int32_t p__value);

/* Trace (data stream type `hip_api`, event record type `hipFuncSetAttributeEnd`) */
void barectf_hip_api_trace_hipFuncSetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipFuncSetCacheConfigBegin`) */
void barectf_hip_api_trace_hipFuncSetCacheConfigBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__func,
	int32_t p__config);

/* Trace (data stream type `hip_api`, event record type `hipFuncSetCacheConfigEnd`) */
void barectf_hip_api_trace_hipFuncSetCacheConfigEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipFuncSetSharedMemConfigBegin`) */
void barectf_hip_api_trace_hipFuncSetSharedMemConfigBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__func,
	int32_t p__config);

/* Trace (data stream type `hip_api`, event record type `hipFuncSetSharedMemConfigEnd`) */
void barectf_hip_api_trace_hipFuncSetSharedMemConfigEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGLGetDevicesBegin`) */
void barectf_hip_api_trace_hipGLGetDevicesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pHipDeviceCount,
	uint32_t p__pHipDeviceCount__val,
	uint64_t p__pHipDevices,
	int32_t p__pHipDevices__val,
	uint32_t p__hipDeviceCount,
	int32_t p__deviceList);

/* Trace (data stream type `hip_api`, event record type `hipGLGetDevicesEnd`) */
void barectf_hip_api_trace_hipGLGetDevicesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetChannelDescBegin`) */
void barectf_hip_api_trace_hipGetChannelDescBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__desc,
	int32_t p__desc__val__x,
	int32_t p__desc__val__y,
	int32_t p__desc__val__z,
	int32_t p__desc__val__w,
	int32_t p__desc__val__f,
	uint64_t p__array);

/* Trace (data stream type `hip_api`, event record type `hipGetChannelDescEnd`) */
void barectf_hip_api_trace_hipGetChannelDescEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetDeviceBegin`) */
void barectf_hip_api_trace_hipGetDeviceBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__deviceId,
	int32_t p__deviceId__val);

/* Trace (data stream type `hip_api`, event record type `hipGetDeviceCountBegin`) */
void barectf_hip_api_trace_hipGetDeviceCountBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__count,
	int32_t p__count__val);

/* Trace (data stream type `hip_api`, event record type `hipGetDeviceCountEnd`) */
void barectf_hip_api_trace_hipGetDeviceCountEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetDeviceEnd`) */
void barectf_hip_api_trace_hipGetDeviceEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetDeviceFlagsBegin`) */
void barectf_hip_api_trace_hipGetDeviceFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__flags,
	uint32_t p__flags__val);

/* Trace (data stream type `hip_api`, event record type `hipGetDeviceFlagsEnd`) */
void barectf_hip_api_trace_hipGetDeviceFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetDevicePropertiesBegin`) */
void barectf_hip_api_trace_hipGetDevicePropertiesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetDevicePropertiesEnd`) */
void barectf_hip_api_trace_hipGetDevicePropertiesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetDevicePropertiesR0000Begin`) */
void barectf_hip_api_trace_hipGetDevicePropertiesR0000Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__prop,
	uint64_t p__prop__val__name,
	uint64_t p__prop__val__totalGlobalMem,
	uint64_t p__prop__val__sharedMemPerBlock,
	int32_t p__prop__val__regsPerBlock,
	int32_t p__prop__val__warpSize,
	int32_t p__prop__val__maxThreadsPerBlock,
	uint64_t p__prop__val__maxThreadsDim,
	uint64_t p__prop__val__maxGridSize,
	int32_t p__prop__val__clockRate,
	int32_t p__prop__val__memoryClockRate,
	int32_t p__prop__val__memoryBusWidth,
	uint64_t p__prop__val__totalConstMem,
	int32_t p__prop__val__major,
	int32_t p__prop__val__minor,
	int32_t p__prop__val__multiProcessorCount,
	int32_t p__prop__val__l2CacheSize,
	int32_t p__prop__val__maxThreadsPerMultiProcessor,
	int32_t p__prop__val__computeMode,
	int32_t p__prop__val__clockInstructionRate,
	uint32_t p__prop__val__arch__hasGlobalInt32Atomics,
	uint32_t p__prop__val__arch__hasGlobalFloatAtomicExch,
	uint32_t p__prop__val__arch__hasSharedInt32Atomics,
	uint32_t p__prop__val__arch__hasSharedFloatAtomicExch,
	uint32_t p__prop__val__arch__hasFloatAtomicAdd,
	uint32_t p__prop__val__arch__hasGlobalInt64Atomics,
	uint32_t p__prop__val__arch__hasSharedInt64Atomics,
	uint32_t p__prop__val__arch__hasDoubles,
	uint32_t p__prop__val__arch__hasWarpVote,
	uint32_t p__prop__val__arch__hasWarpBallot,
	uint32_t p__prop__val__arch__hasWarpShuffle,
	uint32_t p__prop__val__arch__hasFunnelShift,
	uint32_t p__prop__val__arch__hasThreadFenceSystem,
	uint32_t p__prop__val__arch__hasSyncThreadsExt,
	uint32_t p__prop__val__arch__hasSurfaceFuncs,
	uint32_t p__prop__val__arch__has3dGrid,
	uint32_t p__prop__val__arch__hasDynamicParallelism,
	int32_t p__prop__val__concurrentKernels,
	int32_t p__prop__val__pciDomainID,
	int32_t p__prop__val__pciBusID,
	int32_t p__prop__val__pciDeviceID,
	uint64_t p__prop__val__maxSharedMemoryPerMultiProcessor,
	int32_t p__prop__val__isMultiGpuBoard,
	int32_t p__prop__val__canMapHostMemory,
	int32_t p__prop__val__gcnArch,
	uint64_t p__prop__val__gcnArchName,
	int32_t p__prop__val__integrated,
	int32_t p__prop__val__cooperativeLaunch,
	int32_t p__prop__val__cooperativeMultiDeviceLaunch,
	int32_t p__prop__val__maxTexture1DLinear,
	int32_t p__prop__val__maxTexture1D,
	uint64_t p__prop__val__maxTexture2D,
	uint64_t p__prop__val__maxTexture3D,
	uint64_t p__prop__val__hdpMemFlushCntl,
	uint64_t p__prop__val__hdpRegFlushCntl,
	uint64_t p__prop__val__memPitch,
	uint64_t p__prop__val__textureAlignment,
	uint64_t p__prop__val__texturePitchAlignment,
	int32_t p__prop__val__kernelExecTimeoutEnabled,
	int32_t p__prop__val__ECCEnabled,
	int32_t p__prop__val__tccDriver,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedFunc,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedGridDim,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem,
	int32_t p__prop__val__isLargeBar,
	int32_t p__prop__val__asicRevision,
	int32_t p__prop__val__managedMemory,
	int32_t p__prop__val__directManagedMemAccessFromHost,
	int32_t p__prop__val__concurrentManagedAccess,
	int32_t p__prop__val__pageableMemoryAccess,
	int32_t p__prop__val__pageableMemoryAccessUsesHostPageTables,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipGetDevicePropertiesR0000End`) */
void barectf_hip_api_trace_hipGetDevicePropertiesR0000End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetDevicePropertiesR0600Begin`) */
void barectf_hip_api_trace_hipGetDevicePropertiesR0600Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__prop,
	uint64_t p__prop__val__name,
	uint64_t p__prop__val__uuid__bytes,
	uint64_t p__prop__val__luid,
	uint32_t p__prop__val__luidDeviceNodeMask,
	uint64_t p__prop__val__totalGlobalMem,
	uint64_t p__prop__val__sharedMemPerBlock,
	int32_t p__prop__val__regsPerBlock,
	int32_t p__prop__val__warpSize,
	uint64_t p__prop__val__memPitch,
	int32_t p__prop__val__maxThreadsPerBlock,
	uint64_t p__prop__val__maxThreadsDim,
	uint64_t p__prop__val__maxGridSize,
	int32_t p__prop__val__clockRate,
	uint64_t p__prop__val__totalConstMem,
	int32_t p__prop__val__major,
	int32_t p__prop__val__minor,
	uint64_t p__prop__val__textureAlignment,
	uint64_t p__prop__val__texturePitchAlignment,
	int32_t p__prop__val__deviceOverlap,
	int32_t p__prop__val__multiProcessorCount,
	int32_t p__prop__val__kernelExecTimeoutEnabled,
	int32_t p__prop__val__integrated,
	int32_t p__prop__val__canMapHostMemory,
	int32_t p__prop__val__computeMode,
	int32_t p__prop__val__maxTexture1D,
	int32_t p__prop__val__maxTexture1DMipmap,
	int32_t p__prop__val__maxTexture1DLinear,
	uint64_t p__prop__val__maxTexture2D,
	uint64_t p__prop__val__maxTexture2DMipmap,
	uint64_t p__prop__val__maxTexture2DLinear,
	uint64_t p__prop__val__maxTexture2DGather,
	uint64_t p__prop__val__maxTexture3D,
	uint64_t p__prop__val__maxTexture3DAlt,
	int32_t p__prop__val__maxTextureCubemap,
	uint64_t p__prop__val__maxTexture1DLayered,
	uint64_t p__prop__val__maxTexture2DLayered,
	uint64_t p__prop__val__maxTextureCubemapLayered,
	int32_t p__prop__val__maxSurface1D,
	uint64_t p__prop__val__maxSurface2D,
	uint64_t p__prop__val__maxSurface3D,
	uint64_t p__prop__val__maxSurface1DLayered,
	uint64_t p__prop__val__maxSurface2DLayered,
	int32_t p__prop__val__maxSurfaceCubemap,
	uint64_t p__prop__val__maxSurfaceCubemapLayered,
	uint64_t p__prop__val__surfaceAlignment,
	int32_t p__prop__val__concurrentKernels,
	int32_t p__prop__val__ECCEnabled,
	int32_t p__prop__val__pciBusID,
	int32_t p__prop__val__pciDeviceID,
	int32_t p__prop__val__pciDomainID,
	int32_t p__prop__val__tccDriver,
	int32_t p__prop__val__asyncEngineCount,
	int32_t p__prop__val__unifiedAddressing,
	int32_t p__prop__val__memoryClockRate,
	int32_t p__prop__val__memoryBusWidth,
	int32_t p__prop__val__l2CacheSize,
	int32_t p__prop__val__persistingL2CacheMaxSize,
	int32_t p__prop__val__maxThreadsPerMultiProcessor,
	int32_t p__prop__val__streamPrioritiesSupported,
	int32_t p__prop__val__globalL1CacheSupported,
	int32_t p__prop__val__localL1CacheSupported,
	uint64_t p__prop__val__sharedMemPerMultiprocessor,
	int32_t p__prop__val__regsPerMultiprocessor,
	int32_t p__prop__val__managedMemory,
	int32_t p__prop__val__isMultiGpuBoard,
	int32_t p__prop__val__multiGpuBoardGroupID,
	int32_t p__prop__val__hostNativeAtomicSupported,
	int32_t p__prop__val__singleToDoublePrecisionPerfRatio,
	int32_t p__prop__val__pageableMemoryAccess,
	int32_t p__prop__val__concurrentManagedAccess,
	int32_t p__prop__val__computePreemptionSupported,
	int32_t p__prop__val__canUseHostPointerForRegisteredMem,
	int32_t p__prop__val__cooperativeLaunch,
	int32_t p__prop__val__cooperativeMultiDeviceLaunch,
	uint64_t p__prop__val__sharedMemPerBlockOptin,
	int32_t p__prop__val__pageableMemoryAccessUsesHostPageTables,
	int32_t p__prop__val__directManagedMemAccessFromHost,
	int32_t p__prop__val__maxBlocksPerMultiProcessor,
	int32_t p__prop__val__accessPolicyMaxWindowSize,
	uint64_t p__prop__val__reservedSharedMemPerBlock,
	int32_t p__prop__val__hostRegisterSupported,
	int32_t p__prop__val__sparseHipArraySupported,
	int32_t p__prop__val__hostRegisterReadOnlySupported,
	int32_t p__prop__val__timelineSemaphoreInteropSupported,
	int32_t p__prop__val__memoryPoolsSupported,
	int32_t p__prop__val__gpuDirectRDMASupported,
	uint32_t p__prop__val__gpuDirectRDMAFlushWritesOptions,
	int32_t p__prop__val__gpuDirectRDMAWritesOrdering,
	uint32_t p__prop__val__memoryPoolSupportedHandleTypes,
	int32_t p__prop__val__deferredMappingHipArraySupported,
	int32_t p__prop__val__ipcEventSupported,
	int32_t p__prop__val__clusterLaunch,
	int32_t p__prop__val__unifiedFunctionPointers,
	uint64_t p__prop__val__reserved,
	uint64_t p__prop__val__hipReserved,
	uint64_t p__prop__val__gcnArchName,
	uint64_t p__prop__val__maxSharedMemoryPerMultiProcessor,
	int32_t p__prop__val__clockInstructionRate,
	uint32_t p__prop__val__arch__hasGlobalInt32Atomics,
	uint32_t p__prop__val__arch__hasGlobalFloatAtomicExch,
	uint32_t p__prop__val__arch__hasSharedInt32Atomics,
	uint32_t p__prop__val__arch__hasSharedFloatAtomicExch,
	uint32_t p__prop__val__arch__hasFloatAtomicAdd,
	uint32_t p__prop__val__arch__hasGlobalInt64Atomics,
	uint32_t p__prop__val__arch__hasSharedInt64Atomics,
	uint32_t p__prop__val__arch__hasDoubles,
	uint32_t p__prop__val__arch__hasWarpVote,
	uint32_t p__prop__val__arch__hasWarpBallot,
	uint32_t p__prop__val__arch__hasWarpShuffle,
	uint32_t p__prop__val__arch__hasFunnelShift,
	uint32_t p__prop__val__arch__hasThreadFenceSystem,
	uint32_t p__prop__val__arch__hasSyncThreadsExt,
	uint32_t p__prop__val__arch__hasSurfaceFuncs,
	uint32_t p__prop__val__arch__has3dGrid,
	uint32_t p__prop__val__arch__hasDynamicParallelism,
	uint64_t p__prop__val__hdpMemFlushCntl,
	uint64_t p__prop__val__hdpRegFlushCntl,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedFunc,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedGridDim,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedBlockDim,
	int32_t p__prop__val__cooperativeMultiDeviceUnmatchedSharedMem,
	int32_t p__prop__val__isLargeBar,
	int32_t p__prop__val__asicRevision,
	int32_t p__deviceId);

/* Trace (data stream type `hip_api`, event record type `hipGetDevicePropertiesR0600End`) */
void barectf_hip_api_trace_hipGetDevicePropertiesR0600End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetDriverEntryPointBegin`) */
void barectf_hip_api_trace_hipGetDriverEntryPointBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	const char *p__symbol,
	int8_t p__symbol__val,
	uint64_t p__funcPtr,
	uint64_t p__funcPtr__val,
	uint64_t p__flags,
	uint64_t p__driverStatus,
	int32_t p__driverStatus__val);

/* Trace (data stream type `hip_api`, event record type `hipGetDriverEntryPointEnd`) */
void barectf_hip_api_trace_hipGetDriverEntryPointEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetFuncBySymbolBegin`) */
void barectf_hip_api_trace_hipGetFuncBySymbolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__functionPtr,
	uint64_t p__functionPtr__val,
	uint64_t p__symbolPtr);

/* Trace (data stream type `hip_api`, event record type `hipGetFuncBySymbolEnd`) */
void barectf_hip_api_trace_hipGetFuncBySymbolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetLastErrorBegin`) */
void barectf_hip_api_trace_hipGetLastErrorBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetLastErrorEnd`) */
void barectf_hip_api_trace_hipGetLastErrorEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetMipmappedArrayLevelBegin`) */
void barectf_hip_api_trace_hipGetMipmappedArrayLevelBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__levelArray,
	uint64_t p__levelArray__val,
	uint64_t p__mipmappedArray,
	uint32_t p__level);

/* Trace (data stream type `hip_api`, event record type `hipGetMipmappedArrayLevelEnd`) */
void barectf_hip_api_trace_hipGetMipmappedArrayLevelEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetProcAddressBegin`) */
void barectf_hip_api_trace_hipGetProcAddressBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	const char *p__symbol,
	int8_t p__symbol__val,
	uint64_t p__pfn,
	uint64_t p__pfn__val,
	int32_t p__hipVersion,
	uint64_t p__flags,
	uint64_t p__symbolStatus,
	int32_t p__symbolStatus__val);

/* Trace (data stream type `hip_api`, event record type `hipGetProcAddressEnd`) */
void barectf_hip_api_trace_hipGetProcAddressEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetSymbolAddressBegin`) */
void barectf_hip_api_trace_hipGetSymbolAddressBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__devPtr,
	uint64_t p__devPtr__val,
	uint64_t p__symbol);

/* Trace (data stream type `hip_api`, event record type `hipGetSymbolAddressEnd`) */
void barectf_hip_api_trace_hipGetSymbolAddressEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGetSymbolSizeBegin`) */
void barectf_hip_api_trace_hipGetSymbolSizeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__size,
	uint64_t p__size__val,
	uint64_t p__symbol);

/* Trace (data stream type `hip_api`, event record type `hipGetSymbolSizeEnd`) */
void barectf_hip_api_trace_hipGetSymbolSizeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddBatchMemOpNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddBatchMemOpNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__phGraphNode,
	uint64_t p__phGraphNode__val,
	uint64_t p__hGraph,
	uint64_t p__dependencies,
	uint64_t p__dependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__ctx,
	uint32_t p__nodeParams__val__count,
	uint64_t p__nodeParams__val__paramArray,
	uint32_t p__nodeParams__val__flags);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddBatchMemOpNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddBatchMemOpNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddChildGraphNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddChildGraphNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__childGraph);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddChildGraphNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddChildGraphNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddDependenciesBegin`) */
void barectf_hip_api_trace_hipGraphAddDependenciesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graph,
	uint64_t p__from,
	uint64_t p__from__val,
	uint64_t p__to,
	uint64_t p__to__val,
	uint64_t p__numDependencies);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddDependenciesEnd`) */
void barectf_hip_api_trace_hipGraphAddDependenciesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddEmptyNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddEmptyNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddEmptyNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddEmptyNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddEventRecordNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddEventRecordNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__event);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddEventRecordNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddEventRecordNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddEventWaitNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddEventWaitNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__event);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddEventWaitNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddEventWaitNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddExternalSemaphoresSignalNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddExternalSemaphoresSignalNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__extSemArray,
	uint64_t p__nodeParams__val__paramsArray,
	uint32_t p__nodeParams__val__numExtSems);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddExternalSemaphoresSignalNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddExternalSemaphoresSignalNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddExternalSemaphoresWaitNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddExternalSemaphoresWaitNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__extSemArray,
	uint64_t p__nodeParams__val__paramsArray,
	uint32_t p__nodeParams__val__numExtSems);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddExternalSemaphoresWaitNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddExternalSemaphoresWaitNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddHostNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddHostNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__pNodeParams,
	uint64_t p__pNodeParams__val__fn,
	uint64_t p__pNodeParams__val__userData);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddHostNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddHostNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddKernelNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddKernelNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__pNodeParams,
	uint32_t p__pNodeParams__val__blockDim__x,
	uint32_t p__pNodeParams__val__blockDim__y,
	uint32_t p__pNodeParams__val__blockDim__z,
	uint64_t p__pNodeParams__val__extra,
	uint64_t p__pNodeParams__val__func,
	uint32_t p__pNodeParams__val__gridDim__x,
	uint32_t p__pNodeParams__val__gridDim__y,
	uint32_t p__pNodeParams__val__gridDim__z,
	uint64_t p__pNodeParams__val__kernelParams,
	uint32_t p__pNodeParams__val__sharedMemBytes);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddKernelNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddKernelNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemAllocNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddMemAllocNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__pNodeParams,
	int32_t p__pNodeParams__val__poolProps__allocType,
	int32_t p__pNodeParams__val__poolProps__handleTypes,
	int32_t p__pNodeParams__val__poolProps__location__type,
	int32_t p__pNodeParams__val__poolProps__location__id,
	uint64_t p__pNodeParams__val__poolProps__win32SecurityAttributes,
	uint64_t p__pNodeParams__val__poolProps__maxSize,
	uint64_t p__pNodeParams__val__poolProps__reserved,
	uint64_t p__pNodeParams__val__accessDescs,
	uint64_t p__pNodeParams__val__accessDescCount,
	uint64_t p__pNodeParams__val__bytesize,
	uint64_t p__pNodeParams__val__dptr);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemAllocNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddMemAllocNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemFreeNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddMemFreeNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__dev_ptr);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemFreeNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddMemFreeNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemcpyNode1DBegin`) */
void barectf_hip_api_trace_hipGraphAddMemcpyNode1DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__count,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemcpyNode1DEnd`) */
void barectf_hip_api_trace_hipGraphAddMemcpyNode1DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemcpyNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddMemcpyNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__pCopyParams,
	uint64_t p__pCopyParams__val__srcArray,
	uint64_t p__pCopyParams__val__srcPos__x,
	uint64_t p__pCopyParams__val__srcPos__y,
	uint64_t p__pCopyParams__val__srcPos__z,
	uint64_t p__pCopyParams__val__srcPtr__ptr,
	uint64_t p__pCopyParams__val__srcPtr__pitch,
	uint64_t p__pCopyParams__val__srcPtr__xsize,
	uint64_t p__pCopyParams__val__srcPtr__ysize,
	uint64_t p__pCopyParams__val__dstArray,
	uint64_t p__pCopyParams__val__dstPos__x,
	uint64_t p__pCopyParams__val__dstPos__y,
	uint64_t p__pCopyParams__val__dstPos__z,
	uint64_t p__pCopyParams__val__dstPtr__ptr,
	uint64_t p__pCopyParams__val__dstPtr__pitch,
	uint64_t p__pCopyParams__val__dstPtr__xsize,
	uint64_t p__pCopyParams__val__dstPtr__ysize,
	uint64_t p__pCopyParams__val__extent__width,
	uint64_t p__pCopyParams__val__extent__height,
	uint64_t p__pCopyParams__val__extent__depth,
	int32_t p__pCopyParams__val__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemcpyNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddMemcpyNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemcpyNodeFromSymbolBegin`) */
void barectf_hip_api_trace_hipGraphAddMemcpyNodeFromSymbolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__dst,
	uint64_t p__symbol,
	uint64_t p__count,
	uint64_t p__offset,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemcpyNodeFromSymbolEnd`) */
void barectf_hip_api_trace_hipGraphAddMemcpyNodeFromSymbolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemcpyNodeToSymbolBegin`) */
void barectf_hip_api_trace_hipGraphAddMemcpyNodeToSymbolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__symbol,
	uint64_t p__src,
	uint64_t p__count,
	uint64_t p__offset,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemcpyNodeToSymbolEnd`) */
void barectf_hip_api_trace_hipGraphAddMemcpyNodeToSymbolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemsetNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddMemsetNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__pMemsetParams,
	uint64_t p__pMemsetParams__val__dst,
	uint32_t p__pMemsetParams__val__elementSize,
	uint64_t p__pMemsetParams__val__height,
	uint64_t p__pMemsetParams__val__pitch,
	uint32_t p__pMemsetParams__val__value,
	uint64_t p__pMemsetParams__val__width);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddMemsetNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddMemsetNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddNodeBegin`) */
void barectf_hip_api_trace_hipGraphAddNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphNode,
	uint64_t p__pGraphNode__val,
	uint64_t p__graph,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__numDependencies,
	uint64_t p__nodeParams,
	int32_t p__nodeParams__val__type,
	uint64_t p__nodeParams__val__reserved0,
	int64_t p__nodeParams__val__reserved2);

/* Trace (data stream type `hip_api`, event record type `hipGraphAddNodeEnd`) */
void barectf_hip_api_trace_hipGraphAddNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphBatchMemOpNodeGetParamsBegin`) */
void barectf_hip_api_trace_hipGraphBatchMemOpNodeGetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hNode,
	uint64_t p__nodeParams_out,
	uint64_t p__nodeParams_out__val__ctx,
	uint32_t p__nodeParams_out__val__count,
	uint64_t p__nodeParams_out__val__paramArray,
	uint32_t p__nodeParams_out__val__flags);

/* Trace (data stream type `hip_api`, event record type `hipGraphBatchMemOpNodeGetParamsEnd`) */
void barectf_hip_api_trace_hipGraphBatchMemOpNodeGetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphBatchMemOpNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphBatchMemOpNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hNode,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__ctx,
	uint32_t p__nodeParams__val__count,
	uint64_t p__nodeParams__val__paramArray,
	uint32_t p__nodeParams__val__flags);

/* Trace (data stream type `hip_api`, event record type `hipGraphBatchMemOpNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphBatchMemOpNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphChildGraphNodeGetGraphBegin`) */
void barectf_hip_api_trace_hipGraphChildGraphNodeGetGraphBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pGraph,
	uint64_t p__pGraph__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphChildGraphNodeGetGraphEnd`) */
void barectf_hip_api_trace_hipGraphChildGraphNodeGetGraphEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphCloneBegin`) */
void barectf_hip_api_trace_hipGraphCloneBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphClone,
	uint64_t p__pGraphClone__val,
	uint64_t p__originalGraph);

/* Trace (data stream type `hip_api`, event record type `hipGraphCloneEnd`) */
void barectf_hip_api_trace_hipGraphCloneEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphCreateBegin`) */
void barectf_hip_api_trace_hipGraphCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraph,
	uint64_t p__pGraph__val,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipGraphCreateEnd`) */
void barectf_hip_api_trace_hipGraphCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphDebugDotPrintBegin`) */
void barectf_hip_api_trace_hipGraphDebugDotPrintBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graph,
	const char *p__path,
	int8_t p__path__val,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipGraphDebugDotPrintEnd`) */
void barectf_hip_api_trace_hipGraphDebugDotPrintEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphDestroyBegin`) */
void barectf_hip_api_trace_hipGraphDestroyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graph);

/* Trace (data stream type `hip_api`, event record type `hipGraphDestroyEnd`) */
void barectf_hip_api_trace_hipGraphDestroyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphDestroyNodeBegin`) */
void barectf_hip_api_trace_hipGraphDestroyNodeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node);

/* Trace (data stream type `hip_api`, event record type `hipGraphDestroyNodeEnd`) */
void barectf_hip_api_trace_hipGraphDestroyNodeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphEventRecordNodeGetEventBegin`) */
void barectf_hip_api_trace_hipGraphEventRecordNodeGetEventBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__event_out,
	uint64_t p__event_out__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphEventRecordNodeGetEventEnd`) */
void barectf_hip_api_trace_hipGraphEventRecordNodeGetEventEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphEventRecordNodeSetEventBegin`) */
void barectf_hip_api_trace_hipGraphEventRecordNodeSetEventBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__event);

/* Trace (data stream type `hip_api`, event record type `hipGraphEventRecordNodeSetEventEnd`) */
void barectf_hip_api_trace_hipGraphEventRecordNodeSetEventEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphEventWaitNodeGetEventBegin`) */
void barectf_hip_api_trace_hipGraphEventWaitNodeGetEventBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__event_out,
	uint64_t p__event_out__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphEventWaitNodeGetEventEnd`) */
void barectf_hip_api_trace_hipGraphEventWaitNodeGetEventEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphEventWaitNodeSetEventBegin`) */
void barectf_hip_api_trace_hipGraphEventWaitNodeSetEventBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__event);

/* Trace (data stream type `hip_api`, event record type `hipGraphEventWaitNodeSetEventEnd`) */
void barectf_hip_api_trace_hipGraphEventWaitNodeSetEventEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecBatchMemOpNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExecBatchMemOpNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__hNode,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__ctx,
	uint32_t p__nodeParams__val__count,
	uint64_t p__nodeParams__val__paramArray,
	uint32_t p__nodeParams__val__flags);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecBatchMemOpNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExecBatchMemOpNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecChildGraphNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExecChildGraphNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__node,
	uint64_t p__childGraph);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecChildGraphNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExecChildGraphNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecDestroyBegin`) */
void barectf_hip_api_trace_hipGraphExecDestroyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graphExec);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecDestroyEnd`) */
void barectf_hip_api_trace_hipGraphExecDestroyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecEventRecordNodeSetEventBegin`) */
void barectf_hip_api_trace_hipGraphExecEventRecordNodeSetEventBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__hNode,
	uint64_t p__event);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecEventRecordNodeSetEventEnd`) */
void barectf_hip_api_trace_hipGraphExecEventRecordNodeSetEventEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecEventWaitNodeSetEventBegin`) */
void barectf_hip_api_trace_hipGraphExecEventWaitNodeSetEventBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__hNode,
	uint64_t p__event);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecEventWaitNodeSetEventEnd`) */
void barectf_hip_api_trace_hipGraphExecEventWaitNodeSetEventEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecExternalSemaphoresSignalNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExecExternalSemaphoresSignalNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__hNode,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__extSemArray,
	uint64_t p__nodeParams__val__paramsArray,
	uint32_t p__nodeParams__val__numExtSems);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecExternalSemaphoresSignalNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExecExternalSemaphoresSignalNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecExternalSemaphoresWaitNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExecExternalSemaphoresWaitNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__hNode,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__extSemArray,
	uint64_t p__nodeParams__val__paramsArray,
	uint32_t p__nodeParams__val__numExtSems);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecExternalSemaphoresWaitNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExecExternalSemaphoresWaitNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecGetFlagsBegin`) */
void barectf_hip_api_trace_hipGraphExecGetFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graphExec,
	uint64_t p__flags,
	uint64_t p__flags__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecGetFlagsEnd`) */
void barectf_hip_api_trace_hipGraphExecGetFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecHostNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExecHostNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint64_t p__pNodeParams__val__fn,
	uint64_t p__pNodeParams__val__userData);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecHostNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExecHostNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecKernelNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExecKernelNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint32_t p__pNodeParams__val__blockDim__x,
	uint32_t p__pNodeParams__val__blockDim__y,
	uint32_t p__pNodeParams__val__blockDim__z,
	uint64_t p__pNodeParams__val__extra,
	uint64_t p__pNodeParams__val__func,
	uint32_t p__pNodeParams__val__gridDim__x,
	uint32_t p__pNodeParams__val__gridDim__y,
	uint32_t p__pNodeParams__val__gridDim__z,
	uint64_t p__pNodeParams__val__kernelParams,
	uint32_t p__pNodeParams__val__sharedMemBytes);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecKernelNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExecKernelNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecMemcpyNodeSetParams1DBegin`) */
void barectf_hip_api_trace_hipGraphExecMemcpyNodeSetParams1DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__node,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__count,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecMemcpyNodeSetParams1DEnd`) */
void barectf_hip_api_trace_hipGraphExecMemcpyNodeSetParams1DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecMemcpyNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExecMemcpyNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint64_t p__pNodeParams__val__srcArray,
	uint64_t p__pNodeParams__val__srcPos__x,
	uint64_t p__pNodeParams__val__srcPos__y,
	uint64_t p__pNodeParams__val__srcPos__z,
	uint64_t p__pNodeParams__val__srcPtr__ptr,
	uint64_t p__pNodeParams__val__srcPtr__pitch,
	uint64_t p__pNodeParams__val__srcPtr__xsize,
	uint64_t p__pNodeParams__val__srcPtr__ysize,
	uint64_t p__pNodeParams__val__dstArray,
	uint64_t p__pNodeParams__val__dstPos__x,
	uint64_t p__pNodeParams__val__dstPos__y,
	uint64_t p__pNodeParams__val__dstPos__z,
	uint64_t p__pNodeParams__val__dstPtr__ptr,
	uint64_t p__pNodeParams__val__dstPtr__pitch,
	uint64_t p__pNodeParams__val__dstPtr__xsize,
	uint64_t p__pNodeParams__val__dstPtr__ysize,
	uint64_t p__pNodeParams__val__extent__width,
	uint64_t p__pNodeParams__val__extent__height,
	uint64_t p__pNodeParams__val__extent__depth,
	int32_t p__pNodeParams__val__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecMemcpyNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExecMemcpyNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecMemcpyNodeSetParamsFromSymbolBegin`) */
void barectf_hip_api_trace_hipGraphExecMemcpyNodeSetParamsFromSymbolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__node,
	uint64_t p__dst,
	uint64_t p__symbol,
	uint64_t p__count,
	uint64_t p__offset,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecMemcpyNodeSetParamsFromSymbolEnd`) */
void barectf_hip_api_trace_hipGraphExecMemcpyNodeSetParamsFromSymbolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecMemcpyNodeSetParamsToSymbolBegin`) */
void barectf_hip_api_trace_hipGraphExecMemcpyNodeSetParamsToSymbolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__node,
	uint64_t p__symbol,
	uint64_t p__src,
	uint64_t p__count,
	uint64_t p__offset,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecMemcpyNodeSetParamsToSymbolEnd`) */
void barectf_hip_api_trace_hipGraphExecMemcpyNodeSetParamsToSymbolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecMemsetNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExecMemsetNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint64_t p__pNodeParams__val__dst,
	uint32_t p__pNodeParams__val__elementSize,
	uint64_t p__pNodeParams__val__height,
	uint64_t p__pNodeParams__val__pitch,
	uint32_t p__pNodeParams__val__value,
	uint64_t p__pNodeParams__val__width);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecMemsetNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExecMemsetNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExecNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graphExec,
	uint64_t p__node,
	uint64_t p__nodeParams,
	int32_t p__nodeParams__val__type,
	uint64_t p__nodeParams__val__reserved0,
	int64_t p__nodeParams__val__reserved2);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExecNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecUpdateBegin`) */
void barectf_hip_api_trace_hipGraphExecUpdateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__hGraph,
	uint64_t p__hErrorNode_out,
	uint64_t p__hErrorNode_out__val,
	uint64_t p__updateResult_out,
	int32_t p__updateResult_out__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphExecUpdateEnd`) */
void barectf_hip_api_trace_hipGraphExecUpdateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExternalSemaphoresSignalNodeGetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExternalSemaphoresSignalNodeGetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hNode,
	uint64_t p__params_out,
	uint64_t p__params_out__val__extSemArray,
	uint64_t p__params_out__val__paramsArray,
	uint32_t p__params_out__val__numExtSems);

/* Trace (data stream type `hip_api`, event record type `hipGraphExternalSemaphoresSignalNodeGetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExternalSemaphoresSignalNodeGetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExternalSemaphoresSignalNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExternalSemaphoresSignalNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hNode,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__extSemArray,
	uint64_t p__nodeParams__val__paramsArray,
	uint32_t p__nodeParams__val__numExtSems);

/* Trace (data stream type `hip_api`, event record type `hipGraphExternalSemaphoresSignalNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExternalSemaphoresSignalNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExternalSemaphoresWaitNodeGetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExternalSemaphoresWaitNodeGetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hNode,
	uint64_t p__params_out,
	uint64_t p__params_out__val__extSemArray,
	uint64_t p__params_out__val__paramsArray,
	uint32_t p__params_out__val__numExtSems);

/* Trace (data stream type `hip_api`, event record type `hipGraphExternalSemaphoresWaitNodeGetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExternalSemaphoresWaitNodeGetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphExternalSemaphoresWaitNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphExternalSemaphoresWaitNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hNode,
	uint64_t p__nodeParams,
	uint64_t p__nodeParams__val__extSemArray,
	uint64_t p__nodeParams__val__paramsArray,
	uint32_t p__nodeParams__val__numExtSems);

/* Trace (data stream type `hip_api`, event record type `hipGraphExternalSemaphoresWaitNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphExternalSemaphoresWaitNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphGetEdgesBegin`) */
void barectf_hip_api_trace_hipGraphGetEdgesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graph,
	uint64_t p__from,
	uint64_t p__from__val,
	uint64_t p__to,
	uint64_t p__to__val,
	uint64_t p__numEdges,
	uint64_t p__numEdges__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphGetEdgesEnd`) */
void barectf_hip_api_trace_hipGraphGetEdgesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphGetNodesBegin`) */
void barectf_hip_api_trace_hipGraphGetNodesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graph,
	uint64_t p__nodes,
	uint64_t p__nodes__val,
	uint64_t p__numNodes,
	uint64_t p__numNodes__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphGetNodesEnd`) */
void barectf_hip_api_trace_hipGraphGetNodesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphGetRootNodesBegin`) */
void barectf_hip_api_trace_hipGraphGetRootNodesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graph,
	uint64_t p__pRootNodes,
	uint64_t p__pRootNodes__val,
	uint64_t p__pNumRootNodes,
	uint64_t p__pNumRootNodes__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphGetRootNodesEnd`) */
void barectf_hip_api_trace_hipGraphGetRootNodesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphHostNodeGetParamsBegin`) */
void barectf_hip_api_trace_hipGraphHostNodeGetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint64_t p__pNodeParams__val__fn,
	uint64_t p__pNodeParams__val__userData);

/* Trace (data stream type `hip_api`, event record type `hipGraphHostNodeGetParamsEnd`) */
void barectf_hip_api_trace_hipGraphHostNodeGetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphHostNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphHostNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint64_t p__pNodeParams__val__fn,
	uint64_t p__pNodeParams__val__userData);

/* Trace (data stream type `hip_api`, event record type `hipGraphHostNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphHostNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphInstantiateBegin`) */
void barectf_hip_api_trace_hipGraphInstantiateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphExec,
	uint64_t p__pGraphExec__val,
	uint64_t p__graph,
	uint64_t p__pErrorNode,
	uint64_t p__pErrorNode__val,
	const char *p__pLogBuffer,
	int8_t p__pLogBuffer__val,
	uint64_t p__bufferSize);

/* Trace (data stream type `hip_api`, event record type `hipGraphInstantiateEnd`) */
void barectf_hip_api_trace_hipGraphInstantiateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphInstantiateWithFlagsBegin`) */
void barectf_hip_api_trace_hipGraphInstantiateWithFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphExec,
	uint64_t p__pGraphExec__val,
	uint64_t p__graph,
	uint64_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipGraphInstantiateWithFlagsEnd`) */
void barectf_hip_api_trace_hipGraphInstantiateWithFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphInstantiateWithParamsBegin`) */
void barectf_hip_api_trace_hipGraphInstantiateWithParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pGraphExec,
	uint64_t p__pGraphExec__val,
	uint64_t p__graph,
	uint64_t p__instantiateParams,
	uint64_t p__instantiateParams__val__errNode_out,
	uint64_t p__instantiateParams__val__flags,
	int32_t p__instantiateParams__val__result_out,
	uint64_t p__instantiateParams__val__uploadStream);

/* Trace (data stream type `hip_api`, event record type `hipGraphInstantiateWithParamsEnd`) */
void barectf_hip_api_trace_hipGraphInstantiateWithParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphKernelNodeCopyAttributesBegin`) */
void barectf_hip_api_trace_hipGraphKernelNodeCopyAttributesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hSrc,
	uint64_t p__hDst);

/* Trace (data stream type `hip_api`, event record type `hipGraphKernelNodeCopyAttributesEnd`) */
void barectf_hip_api_trace_hipGraphKernelNodeCopyAttributesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphKernelNodeGetAttributeBegin`) */
void barectf_hip_api_trace_hipGraphKernelNodeGetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hNode,
	int32_t p__attr,
	uint64_t p__value,
	uint64_t p__value__val__pad,
	uint64_t p__value__val__accessPolicyWindow__base_ptr,
	int32_t p__value__val__accessPolicyWindow__hitProp,
	uint64_t p__value__val__accessPolicyWindow__hitRatio,
	int32_t p__value__val__accessPolicyWindow__missProp,
	uint64_t p__value__val__accessPolicyWindow__num_bytes,
	int32_t p__value__val__cooperative,
	int32_t p__value__val__priority,
	int32_t p__value__val__syncPolicy,
	uint8_t p__value__val__memSyncDomainMap__default_,
	uint8_t p__value__val__memSyncDomainMap__remote,
	int32_t p__value__val__memSyncDomain);

/* Trace (data stream type `hip_api`, event record type `hipGraphKernelNodeGetAttributeEnd`) */
void barectf_hip_api_trace_hipGraphKernelNodeGetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphKernelNodeGetParamsBegin`) */
void barectf_hip_api_trace_hipGraphKernelNodeGetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint32_t p__pNodeParams__val__blockDim__x,
	uint32_t p__pNodeParams__val__blockDim__y,
	uint32_t p__pNodeParams__val__blockDim__z,
	uint64_t p__pNodeParams__val__extra,
	uint64_t p__pNodeParams__val__func,
	uint32_t p__pNodeParams__val__gridDim__x,
	uint32_t p__pNodeParams__val__gridDim__y,
	uint32_t p__pNodeParams__val__gridDim__z,
	uint64_t p__pNodeParams__val__kernelParams,
	uint32_t p__pNodeParams__val__sharedMemBytes);

/* Trace (data stream type `hip_api`, event record type `hipGraphKernelNodeGetParamsEnd`) */
void barectf_hip_api_trace_hipGraphKernelNodeGetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphKernelNodeSetAttributeBegin`) */
void barectf_hip_api_trace_hipGraphKernelNodeSetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hNode,
	int32_t p__attr,
	uint64_t p__value,
	uint64_t p__value__val__pad,
	uint64_t p__value__val__accessPolicyWindow__base_ptr,
	int32_t p__value__val__accessPolicyWindow__hitProp,
	uint64_t p__value__val__accessPolicyWindow__hitRatio,
	int32_t p__value__val__accessPolicyWindow__missProp,
	uint64_t p__value__val__accessPolicyWindow__num_bytes,
	int32_t p__value__val__cooperative,
	int32_t p__value__val__priority,
	int32_t p__value__val__syncPolicy,
	uint8_t p__value__val__memSyncDomainMap__default_,
	uint8_t p__value__val__memSyncDomainMap__remote,
	int32_t p__value__val__memSyncDomain);

/* Trace (data stream type `hip_api`, event record type `hipGraphKernelNodeSetAttributeEnd`) */
void barectf_hip_api_trace_hipGraphKernelNodeSetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphKernelNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphKernelNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint32_t p__pNodeParams__val__blockDim__x,
	uint32_t p__pNodeParams__val__blockDim__y,
	uint32_t p__pNodeParams__val__blockDim__z,
	uint64_t p__pNodeParams__val__extra,
	uint64_t p__pNodeParams__val__func,
	uint32_t p__pNodeParams__val__gridDim__x,
	uint32_t p__pNodeParams__val__gridDim__y,
	uint32_t p__pNodeParams__val__gridDim__z,
	uint64_t p__pNodeParams__val__kernelParams,
	uint32_t p__pNodeParams__val__sharedMemBytes);

/* Trace (data stream type `hip_api`, event record type `hipGraphKernelNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphKernelNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphLaunchBegin`) */
void barectf_hip_api_trace_hipGraphLaunchBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graphExec,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipGraphLaunchEnd`) */
void barectf_hip_api_trace_hipGraphLaunchEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemAllocNodeGetParamsBegin`) */
void barectf_hip_api_trace_hipGraphMemAllocNodeGetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	int32_t p__pNodeParams__val__poolProps__allocType,
	int32_t p__pNodeParams__val__poolProps__handleTypes,
	int32_t p__pNodeParams__val__poolProps__location__type,
	int32_t p__pNodeParams__val__poolProps__location__id,
	uint64_t p__pNodeParams__val__poolProps__win32SecurityAttributes,
	uint64_t p__pNodeParams__val__poolProps__maxSize,
	uint64_t p__pNodeParams__val__poolProps__reserved,
	uint64_t p__pNodeParams__val__accessDescs,
	uint64_t p__pNodeParams__val__accessDescCount,
	uint64_t p__pNodeParams__val__bytesize,
	uint64_t p__pNodeParams__val__dptr);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemAllocNodeGetParamsEnd`) */
void barectf_hip_api_trace_hipGraphMemAllocNodeGetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemFreeNodeGetParamsBegin`) */
void barectf_hip_api_trace_hipGraphMemFreeNodeGetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__dev_ptr);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemFreeNodeGetParamsEnd`) */
void barectf_hip_api_trace_hipGraphMemFreeNodeGetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemcpyNodeGetParamsBegin`) */
void barectf_hip_api_trace_hipGraphMemcpyNodeGetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint64_t p__pNodeParams__val__srcArray,
	uint64_t p__pNodeParams__val__srcPos__x,
	uint64_t p__pNodeParams__val__srcPos__y,
	uint64_t p__pNodeParams__val__srcPos__z,
	uint64_t p__pNodeParams__val__srcPtr__ptr,
	uint64_t p__pNodeParams__val__srcPtr__pitch,
	uint64_t p__pNodeParams__val__srcPtr__xsize,
	uint64_t p__pNodeParams__val__srcPtr__ysize,
	uint64_t p__pNodeParams__val__dstArray,
	uint64_t p__pNodeParams__val__dstPos__x,
	uint64_t p__pNodeParams__val__dstPos__y,
	uint64_t p__pNodeParams__val__dstPos__z,
	uint64_t p__pNodeParams__val__dstPtr__ptr,
	uint64_t p__pNodeParams__val__dstPtr__pitch,
	uint64_t p__pNodeParams__val__dstPtr__xsize,
	uint64_t p__pNodeParams__val__dstPtr__ysize,
	uint64_t p__pNodeParams__val__extent__width,
	uint64_t p__pNodeParams__val__extent__height,
	uint64_t p__pNodeParams__val__extent__depth,
	int32_t p__pNodeParams__val__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemcpyNodeGetParamsEnd`) */
void barectf_hip_api_trace_hipGraphMemcpyNodeGetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemcpyNodeSetParams1DBegin`) */
void barectf_hip_api_trace_hipGraphMemcpyNodeSetParams1DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__count,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemcpyNodeSetParams1DEnd`) */
void barectf_hip_api_trace_hipGraphMemcpyNodeSetParams1DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemcpyNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphMemcpyNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint64_t p__pNodeParams__val__srcArray,
	uint64_t p__pNodeParams__val__srcPos__x,
	uint64_t p__pNodeParams__val__srcPos__y,
	uint64_t p__pNodeParams__val__srcPos__z,
	uint64_t p__pNodeParams__val__srcPtr__ptr,
	uint64_t p__pNodeParams__val__srcPtr__pitch,
	uint64_t p__pNodeParams__val__srcPtr__xsize,
	uint64_t p__pNodeParams__val__srcPtr__ysize,
	uint64_t p__pNodeParams__val__dstArray,
	uint64_t p__pNodeParams__val__dstPos__x,
	uint64_t p__pNodeParams__val__dstPos__y,
	uint64_t p__pNodeParams__val__dstPos__z,
	uint64_t p__pNodeParams__val__dstPtr__ptr,
	uint64_t p__pNodeParams__val__dstPtr__pitch,
	uint64_t p__pNodeParams__val__dstPtr__xsize,
	uint64_t p__pNodeParams__val__dstPtr__ysize,
	uint64_t p__pNodeParams__val__extent__width,
	uint64_t p__pNodeParams__val__extent__height,
	uint64_t p__pNodeParams__val__extent__depth,
	int32_t p__pNodeParams__val__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemcpyNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphMemcpyNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemcpyNodeSetParamsFromSymbolBegin`) */
void barectf_hip_api_trace_hipGraphMemcpyNodeSetParamsFromSymbolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__dst,
	uint64_t p__symbol,
	uint64_t p__count,
	uint64_t p__offset,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemcpyNodeSetParamsFromSymbolEnd`) */
void barectf_hip_api_trace_hipGraphMemcpyNodeSetParamsFromSymbolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemcpyNodeSetParamsToSymbolBegin`) */
void barectf_hip_api_trace_hipGraphMemcpyNodeSetParamsToSymbolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__symbol,
	uint64_t p__src,
	uint64_t p__count,
	uint64_t p__offset,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemcpyNodeSetParamsToSymbolEnd`) */
void barectf_hip_api_trace_hipGraphMemcpyNodeSetParamsToSymbolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemsetNodeGetParamsBegin`) */
void barectf_hip_api_trace_hipGraphMemsetNodeGetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint64_t p__pNodeParams__val__dst,
	uint32_t p__pNodeParams__val__elementSize,
	uint64_t p__pNodeParams__val__height,
	uint64_t p__pNodeParams__val__pitch,
	uint32_t p__pNodeParams__val__value,
	uint64_t p__pNodeParams__val__width);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemsetNodeGetParamsEnd`) */
void barectf_hip_api_trace_hipGraphMemsetNodeGetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemsetNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphMemsetNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pNodeParams,
	uint64_t p__pNodeParams__val__dst,
	uint32_t p__pNodeParams__val__elementSize,
	uint64_t p__pNodeParams__val__height,
	uint64_t p__pNodeParams__val__pitch,
	uint32_t p__pNodeParams__val__value,
	uint64_t p__pNodeParams__val__width);

/* Trace (data stream type `hip_api`, event record type `hipGraphMemsetNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphMemsetNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeFindInCloneBegin`) */
void barectf_hip_api_trace_hipGraphNodeFindInCloneBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pNode,
	uint64_t p__pNode__val,
	uint64_t p__originalNode,
	uint64_t p__clonedGraph);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeFindInCloneEnd`) */
void barectf_hip_api_trace_hipGraphNodeFindInCloneEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeGetDependenciesBegin`) */
void barectf_hip_api_trace_hipGraphNodeGetDependenciesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pDependencies,
	uint64_t p__pDependencies__val,
	uint64_t p__pNumDependencies,
	uint64_t p__pNumDependencies__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeGetDependenciesEnd`) */
void barectf_hip_api_trace_hipGraphNodeGetDependenciesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeGetDependentNodesBegin`) */
void barectf_hip_api_trace_hipGraphNodeGetDependentNodesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pDependentNodes,
	uint64_t p__pDependentNodes__val,
	uint64_t p__pNumDependentNodes,
	uint64_t p__pNumDependentNodes__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeGetDependentNodesEnd`) */
void barectf_hip_api_trace_hipGraphNodeGetDependentNodesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeGetEnabledBegin`) */
void barectf_hip_api_trace_hipGraphNodeGetEnabledBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__hNode,
	uint64_t p__isEnabled,
	uint32_t p__isEnabled__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeGetEnabledEnd`) */
void barectf_hip_api_trace_hipGraphNodeGetEnabledEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeGetTypeBegin`) */
void barectf_hip_api_trace_hipGraphNodeGetTypeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__pType,
	int32_t p__pType__val);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeGetTypeEnd`) */
void barectf_hip_api_trace_hipGraphNodeGetTypeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeSetEnabledBegin`) */
void barectf_hip_api_trace_hipGraphNodeSetEnabledBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hGraphExec,
	uint64_t p__hNode,
	uint32_t p__isEnabled);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeSetEnabledEnd`) */
void barectf_hip_api_trace_hipGraphNodeSetEnabledEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeSetParamsBegin`) */
void barectf_hip_api_trace_hipGraphNodeSetParamsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__node,
	uint64_t p__nodeParams,
	int32_t p__nodeParams__val__type,
	uint64_t p__nodeParams__val__reserved0,
	int64_t p__nodeParams__val__reserved2);

/* Trace (data stream type `hip_api`, event record type `hipGraphNodeSetParamsEnd`) */
void barectf_hip_api_trace_hipGraphNodeSetParamsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphReleaseUserObjectBegin`) */
void barectf_hip_api_trace_hipGraphReleaseUserObjectBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graph,
	uint64_t p__object,
	uint32_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipGraphReleaseUserObjectEnd`) */
void barectf_hip_api_trace_hipGraphReleaseUserObjectEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphRemoveDependenciesBegin`) */
void barectf_hip_api_trace_hipGraphRemoveDependenciesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graph,
	uint64_t p__from,
	uint64_t p__from__val,
	uint64_t p__to,
	uint64_t p__to__val,
	uint64_t p__numDependencies);

/* Trace (data stream type `hip_api`, event record type `hipGraphRemoveDependenciesEnd`) */
void barectf_hip_api_trace_hipGraphRemoveDependenciesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphRetainUserObjectBegin`) */
void barectf_hip_api_trace_hipGraphRetainUserObjectBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graph,
	uint64_t p__object,
	uint32_t p__count,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipGraphRetainUserObjectEnd`) */
void barectf_hip_api_trace_hipGraphRetainUserObjectEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphUploadBegin`) */
void barectf_hip_api_trace_hipGraphUploadBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__graphExec,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipGraphUploadEnd`) */
void barectf_hip_api_trace_hipGraphUploadEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsGLRegisterBufferBegin`) */
void barectf_hip_api_trace_hipGraphicsGLRegisterBufferBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__resource,
	uint64_t p__resource__val,
	int32_t p__buffer,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsGLRegisterBufferEnd`) */
void barectf_hip_api_trace_hipGraphicsGLRegisterBufferEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsGLRegisterImageBegin`) */
void barectf_hip_api_trace_hipGraphicsGLRegisterImageBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__resource,
	uint64_t p__resource__val,
	int32_t p__image,
	int32_t p__target,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsGLRegisterImageEnd`) */
void barectf_hip_api_trace_hipGraphicsGLRegisterImageEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsMapResourcesBegin`) */
void barectf_hip_api_trace_hipGraphicsMapResourcesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__count,
	uint64_t p__resources,
	uint64_t p__resources__val,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsMapResourcesEnd`) */
void barectf_hip_api_trace_hipGraphicsMapResourcesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsResourceGetMappedPointerBegin`) */
void barectf_hip_api_trace_hipGraphicsResourceGetMappedPointerBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__devPtr,
	uint64_t p__devPtr__val,
	uint64_t p__size,
	uint64_t p__size__val,
	uint64_t p__resource);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsResourceGetMappedPointerEnd`) */
void barectf_hip_api_trace_hipGraphicsResourceGetMappedPointerEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsSubResourceGetMappedArrayBegin`) */
void barectf_hip_api_trace_hipGraphicsSubResourceGetMappedArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__array,
	uint64_t p__array__val,
	uint64_t p__resource,
	uint32_t p__arrayIndex,
	uint32_t p__mipLevel);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsSubResourceGetMappedArrayEnd`) */
void barectf_hip_api_trace_hipGraphicsSubResourceGetMappedArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsUnmapResourcesBegin`) */
void barectf_hip_api_trace_hipGraphicsUnmapResourcesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__count,
	uint64_t p__resources,
	uint64_t p__resources__val,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsUnmapResourcesEnd`) */
void barectf_hip_api_trace_hipGraphicsUnmapResourcesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsUnregisterResourceBegin`) */
void barectf_hip_api_trace_hipGraphicsUnregisterResourceBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__resource);

/* Trace (data stream type `hip_api`, event record type `hipGraphicsUnregisterResourceEnd`) */
void barectf_hip_api_trace_hipGraphicsUnregisterResourceEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipHccModuleLaunchKernelBegin`) */
void barectf_hip_api_trace_hipHccModuleLaunchKernelBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__f,
	uint32_t p__globalWorkSizeX,
	uint32_t p__globalWorkSizeY,
	uint32_t p__globalWorkSizeZ,
	uint32_t p__blockDimX,
	uint32_t p__blockDimY,
	uint32_t p__blockDimZ,
	uint64_t p__sharedMemBytes,
	uint64_t p__hStream,
	uint64_t p__kernelParams,
	uint64_t p__kernelParams__val,
	uint64_t p__extra,
	uint64_t p__extra__val,
	uint64_t p__startEvent,
	uint64_t p__stopEvent);

/* Trace (data stream type `hip_api`, event record type `hipHccModuleLaunchKernelEnd`) */
void barectf_hip_api_trace_hipHccModuleLaunchKernelEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipHostAllocBegin`) */
void barectf_hip_api_trace_hipHostAllocBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__ptr__val,
	uint64_t p__size,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipHostAllocEnd`) */
void barectf_hip_api_trace_hipHostAllocEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipHostFreeBegin`) */
void barectf_hip_api_trace_hipHostFreeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr);

/* Trace (data stream type `hip_api`, event record type `hipHostFreeEnd`) */
void barectf_hip_api_trace_hipHostFreeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipHostGetDevicePointerBegin`) */
void barectf_hip_api_trace_hipHostGetDevicePointerBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__devPtr,
	uint64_t p__devPtr__val,
	uint64_t p__hstPtr,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipHostGetDevicePointerEnd`) */
void barectf_hip_api_trace_hipHostGetDevicePointerEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipHostGetFlagsBegin`) */
void barectf_hip_api_trace_hipHostGetFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__flagsPtr,
	uint32_t p__flagsPtr__val,
	uint64_t p__hostPtr);

/* Trace (data stream type `hip_api`, event record type `hipHostGetFlagsEnd`) */
void barectf_hip_api_trace_hipHostGetFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipHostMallocBegin`) */
void barectf_hip_api_trace_hipHostMallocBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__ptr__val,
	uint64_t p__size,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipHostMallocEnd`) */
void barectf_hip_api_trace_hipHostMallocEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipHostRegisterBegin`) */
void barectf_hip_api_trace_hipHostRegisterBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hostPtr,
	uint64_t p__sizeBytes,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipHostRegisterEnd`) */
void barectf_hip_api_trace_hipHostRegisterEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipHostUnregisterBegin`) */
void barectf_hip_api_trace_hipHostUnregisterBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hostPtr);

/* Trace (data stream type `hip_api`, event record type `hipHostUnregisterEnd`) */
void barectf_hip_api_trace_hipHostUnregisterEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipImportExternalMemoryBegin`) */
void barectf_hip_api_trace_hipImportExternalMemoryBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__extMem_out,
	uint64_t p__extMem_out__val,
	uint64_t p__memHandleDesc,
	int32_t p__memHandleDesc__val__type,
	uint64_t p__memHandleDesc__val__size,
	uint32_t p__memHandleDesc__val__flags,
	uint64_t p__memHandleDesc__val__reserved);

/* Trace (data stream type `hip_api`, event record type `hipImportExternalMemoryEnd`) */
void barectf_hip_api_trace_hipImportExternalMemoryEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipImportExternalSemaphoreBegin`) */
void barectf_hip_api_trace_hipImportExternalSemaphoreBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__extSem_out,
	uint64_t p__extSem_out__val,
	uint64_t p__semHandleDesc,
	int32_t p__semHandleDesc__val__type,
	uint32_t p__semHandleDesc__val__flags,
	uint64_t p__semHandleDesc__val__reserved);

/* Trace (data stream type `hip_api`, event record type `hipImportExternalSemaphoreEnd`) */
void barectf_hip_api_trace_hipImportExternalSemaphoreEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipInitBegin`) */
void barectf_hip_api_trace_hipInitBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipInitEnd`) */
void barectf_hip_api_trace_hipInitEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipIpcCloseMemHandleBegin`) */
void barectf_hip_api_trace_hipIpcCloseMemHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__devPtr);

/* Trace (data stream type `hip_api`, event record type `hipIpcCloseMemHandleEnd`) */
void barectf_hip_api_trace_hipIpcCloseMemHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipIpcGetEventHandleBegin`) */
void barectf_hip_api_trace_hipIpcGetEventHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__handle,
	uint64_t p__handle__val__reserved,
	uint64_t p__event);

/* Trace (data stream type `hip_api`, event record type `hipIpcGetEventHandleEnd`) */
void barectf_hip_api_trace_hipIpcGetEventHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipIpcGetMemHandleBegin`) */
void barectf_hip_api_trace_hipIpcGetMemHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__handle,
	uint64_t p__handle__val__reserved,
	uint64_t p__devPtr);

/* Trace (data stream type `hip_api`, event record type `hipIpcGetMemHandleEnd`) */
void barectf_hip_api_trace_hipIpcGetMemHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipIpcOpenEventHandleBegin`) */
void barectf_hip_api_trace_hipIpcOpenEventHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__event,
	uint64_t p__event__val,
	uint64_t p__handle__reserved);

/* Trace (data stream type `hip_api`, event record type `hipIpcOpenEventHandleEnd`) */
void barectf_hip_api_trace_hipIpcOpenEventHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipIpcOpenMemHandleBegin`) */
void barectf_hip_api_trace_hipIpcOpenMemHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__devPtr,
	uint64_t p__devPtr__val,
	uint64_t p__handle__reserved,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipIpcOpenMemHandleEnd`) */
void barectf_hip_api_trace_hipIpcOpenMemHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipKernelGetLibraryBegin`) */
void barectf_hip_api_trace_hipKernelGetLibraryBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__library,
	uint64_t p__library__val,
	uint64_t p__kernel);

/* Trace (data stream type `hip_api`, event record type `hipKernelGetLibraryEnd`) */
void barectf_hip_api_trace_hipKernelGetLibraryEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipKernelGetNameBegin`) */
void barectf_hip_api_trace_hipKernelGetNameBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__name,
	const char *p__name__val,
	uint64_t p__kernel);

/* Trace (data stream type `hip_api`, event record type `hipKernelGetNameEnd`) */
void barectf_hip_api_trace_hipKernelGetNameEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLaunchByPtrBegin`) */
void barectf_hip_api_trace_hipLaunchByPtrBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hostFunction);

/* Trace (data stream type `hip_api`, event record type `hipLaunchByPtrEnd`) */
void barectf_hip_api_trace_hipLaunchByPtrEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLaunchCooperativeKernelBegin`) */
void barectf_hip_api_trace_hipLaunchCooperativeKernelBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__f,
	uint32_t p__gridDim__x,
	uint32_t p__gridDim__y,
	uint32_t p__gridDim__z,
	uint32_t p__blockDimX__x,
	uint32_t p__blockDimX__y,
	uint32_t p__blockDimX__z,
	uint64_t p__kernelParams,
	uint64_t p__kernelParams__val,
	uint32_t p__sharedMemBytes,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipLaunchCooperativeKernelEnd`) */
void barectf_hip_api_trace_hipLaunchCooperativeKernelEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLaunchCooperativeKernelMultiDeviceBegin`) */
void barectf_hip_api_trace_hipLaunchCooperativeKernelMultiDeviceBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__launchParamsList,
	uint64_t p__launchParamsList__val__func,
	uint32_t p__launchParamsList__val__gridDim__x,
	uint32_t p__launchParamsList__val__gridDim__y,
	uint32_t p__launchParamsList__val__gridDim__z,
	uint32_t p__launchParamsList__val__blockDim__x,
	uint32_t p__launchParamsList__val__blockDim__y,
	uint32_t p__launchParamsList__val__blockDim__z,
	uint64_t p__launchParamsList__val__args,
	uint64_t p__launchParamsList__val__sharedMem,
	uint64_t p__launchParamsList__val__stream,
	int32_t p__numDevices,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipLaunchCooperativeKernelMultiDeviceEnd`) */
void barectf_hip_api_trace_hipLaunchCooperativeKernelMultiDeviceEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLaunchHostFuncBegin`) */
void barectf_hip_api_trace_hipLaunchHostFuncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__fn,
	uint64_t p__userData);

/* Trace (data stream type `hip_api`, event record type `hipLaunchHostFuncEnd`) */
void barectf_hip_api_trace_hipLaunchHostFuncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLaunchKernelBegin`) */
void barectf_hip_api_trace_hipLaunchKernelBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__function_address,
	uint32_t p__numBlocks__x,
	uint32_t p__numBlocks__y,
	uint32_t p__numBlocks__z,
	uint32_t p__dimBlocks__x,
	uint32_t p__dimBlocks__y,
	uint32_t p__dimBlocks__z,
	uint64_t p__args,
	uint64_t p__args__val,
	uint64_t p__sharedMemBytes,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipLaunchKernelEnd`) */
void barectf_hip_api_trace_hipLaunchKernelEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLaunchKernelExCBegin`) */
void barectf_hip_api_trace_hipLaunchKernelExCBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__config,
	uint32_t p__config__val__gridDim__x,
	uint32_t p__config__val__gridDim__y,
	uint32_t p__config__val__gridDim__z,
	uint32_t p__config__val__blockDim__x,
	uint32_t p__config__val__blockDim__y,
	uint32_t p__config__val__blockDim__z,
	uint64_t p__config__val__dynamicSmemBytes,
	uint64_t p__config__val__stream,
	uint64_t p__config__val__attrs,
	uint32_t p__config__val__numAttrs,
	uint64_t p__fPtr,
	uint64_t p__args,
	uint64_t p__args__val);

/* Trace (data stream type `hip_api`, event record type `hipLaunchKernelExCEnd`) */
void barectf_hip_api_trace_hipLaunchKernelExCEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLibraryEnumerateKernelsBegin`) */
void barectf_hip_api_trace_hipLibraryEnumerateKernelsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__kernels,
	uint64_t p__kernels__val,
	uint32_t p__numKernels,
	uint64_t p__library);

/* Trace (data stream type `hip_api`, event record type `hipLibraryEnumerateKernelsEnd`) */
void barectf_hip_api_trace_hipLibraryEnumerateKernelsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLibraryGetKernelBegin`) */
void barectf_hip_api_trace_hipLibraryGetKernelBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pKernel,
	uint64_t p__pKernel__val,
	uint64_t p__library,
	const char *p__name,
	int8_t p__name__val);

/* Trace (data stream type `hip_api`, event record type `hipLibraryGetKernelCountBegin`) */
void barectf_hip_api_trace_hipLibraryGetKernelCountBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__count,
	uint32_t p__count__val,
	uint64_t p__library);

/* Trace (data stream type `hip_api`, event record type `hipLibraryGetKernelCountEnd`) */
void barectf_hip_api_trace_hipLibraryGetKernelCountEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLibraryGetKernelEnd`) */
void barectf_hip_api_trace_hipLibraryGetKernelEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLibraryLoadDataBegin`) */
void barectf_hip_api_trace_hipLibraryLoadDataBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__library,
	uint64_t p__library__val,
	uint64_t p__code,
	uint64_t p__jitOptions,
	int32_t p__jitOptions__val,
	uint64_t p__jitOptionsValues,
	uint64_t p__jitOptionsValues__val,
	uint32_t p__numJitOptions,
	uint64_t p__libraryOptions,
	int32_t p__libraryOptions__val,
	uint64_t p__libraryOptionValues,
	uint64_t p__libraryOptionValues__val,
	uint32_t p__numLibraryOptions);

/* Trace (data stream type `hip_api`, event record type `hipLibraryLoadDataEnd`) */
void barectf_hip_api_trace_hipLibraryLoadDataEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLibraryLoadFromFileBegin`) */
void barectf_hip_api_trace_hipLibraryLoadFromFileBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__library,
	uint64_t p__library__val,
	const char *p__fileName,
	int8_t p__fileName__val,
	uint64_t p__jitOptions,
	int32_t p__jitOptions__val,
	uint64_t p__jitOptionsValues,
	uint64_t p__jitOptionsValues__val,
	uint32_t p__numJitOptions,
	uint64_t p__libraryOptions,
	int32_t p__libraryOptions__val,
	uint64_t p__libraryOptionValues,
	uint64_t p__libraryOptionValues__val,
	uint32_t p__numLibraryOptions);

/* Trace (data stream type `hip_api`, event record type `hipLibraryLoadFromFileEnd`) */
void barectf_hip_api_trace_hipLibraryLoadFromFileEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLibraryUnloadBegin`) */
void barectf_hip_api_trace_hipLibraryUnloadBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__library);

/* Trace (data stream type `hip_api`, event record type `hipLibraryUnloadEnd`) */
void barectf_hip_api_trace_hipLibraryUnloadEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLinkAddDataBegin`) */
void barectf_hip_api_trace_hipLinkAddDataBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__state,
	int32_t p__type,
	uint64_t p__data,
	uint64_t p__size,
	const char *p__name,
	int8_t p__name__val,
	uint32_t p__numOptions,
	uint64_t p__options,
	int32_t p__options__val,
	uint64_t p__optionValues,
	uint64_t p__optionValues__val);

/* Trace (data stream type `hip_api`, event record type `hipLinkAddDataEnd`) */
void barectf_hip_api_trace_hipLinkAddDataEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLinkAddFileBegin`) */
void barectf_hip_api_trace_hipLinkAddFileBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__state,
	int32_t p__type,
	const char *p__path,
	int8_t p__path__val,
	uint32_t p__numOptions,
	uint64_t p__options,
	int32_t p__options__val,
	uint64_t p__optionValues,
	uint64_t p__optionValues__val);

/* Trace (data stream type `hip_api`, event record type `hipLinkAddFileEnd`) */
void barectf_hip_api_trace_hipLinkAddFileEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLinkCompleteBegin`) */
void barectf_hip_api_trace_hipLinkCompleteBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__state,
	uint64_t p__hipBinOut,
	uint64_t p__hipBinOut__val,
	uint64_t p__sizeOut,
	uint64_t p__sizeOut__val);

/* Trace (data stream type `hip_api`, event record type `hipLinkCompleteEnd`) */
void barectf_hip_api_trace_hipLinkCompleteEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLinkCreateBegin`) */
void barectf_hip_api_trace_hipLinkCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint32_t p__numOptions,
	uint64_t p__options,
	int32_t p__options__val,
	uint64_t p__optionValues,
	uint64_t p__optionValues__val,
	uint64_t p__stateOut,
	uint64_t p__stateOut__val);

/* Trace (data stream type `hip_api`, event record type `hipLinkCreateEnd`) */
void barectf_hip_api_trace_hipLinkCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipLinkDestroyBegin`) */
void barectf_hip_api_trace_hipLinkDestroyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__state);

/* Trace (data stream type `hip_api`, event record type `hipLinkDestroyEnd`) */
void barectf_hip_api_trace_hipLinkDestroyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMalloc3DArrayBegin`) */
void barectf_hip_api_trace_hipMalloc3DArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__array,
	uint64_t p__array__val,
	uint64_t p__desc,
	int32_t p__desc__val__x,
	int32_t p__desc__val__y,
	int32_t p__desc__val__z,
	int32_t p__desc__val__w,
	int32_t p__desc__val__f,
	uint64_t p__extent__width,
	uint64_t p__extent__height,
	uint64_t p__extent__depth,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMalloc3DArrayEnd`) */
void barectf_hip_api_trace_hipMalloc3DArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMalloc3DBegin`) */
void barectf_hip_api_trace_hipMalloc3DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pitchedDevPtr,
	uint64_t p__pitchedDevPtr__val__ptr,
	uint64_t p__pitchedDevPtr__val__pitch,
	uint64_t p__pitchedDevPtr__val__xsize,
	uint64_t p__pitchedDevPtr__val__ysize,
	uint64_t p__extent__width,
	uint64_t p__extent__height,
	uint64_t p__extent__depth);

/* Trace (data stream type `hip_api`, event record type `hipMalloc3DEnd`) */
void barectf_hip_api_trace_hipMalloc3DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMallocArrayBegin`) */
void barectf_hip_api_trace_hipMallocArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__array,
	uint64_t p__array__val,
	uint64_t p__desc,
	int32_t p__desc__val__x,
	int32_t p__desc__val__y,
	int32_t p__desc__val__z,
	int32_t p__desc__val__w,
	int32_t p__desc__val__f,
	uint64_t p__width,
	uint64_t p__height,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMallocArrayEnd`) */
void barectf_hip_api_trace_hipMallocArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMallocAsyncBegin`) */
void barectf_hip_api_trace_hipMallocAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dev_ptr,
	uint64_t p__dev_ptr__val,
	uint64_t p__size,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMallocAsyncEnd`) */
void barectf_hip_api_trace_hipMallocAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMallocBegin`) */
void barectf_hip_api_trace_hipMallocBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__ptr__val,
	uint64_t p__size);

/* Trace (data stream type `hip_api`, event record type `hipMallocEnd`) */
void barectf_hip_api_trace_hipMallocEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMallocFromPoolAsyncBegin`) */
void barectf_hip_api_trace_hipMallocFromPoolAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dev_ptr,
	uint64_t p__dev_ptr__val,
	uint64_t p__size,
	uint64_t p__mem_pool,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMallocFromPoolAsyncEnd`) */
void barectf_hip_api_trace_hipMallocFromPoolAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMallocHostBegin`) */
void barectf_hip_api_trace_hipMallocHostBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__ptr__val,
	uint64_t p__size);

/* Trace (data stream type `hip_api`, event record type `hipMallocHostEnd`) */
void barectf_hip_api_trace_hipMallocHostEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMallocManagedBegin`) */
void barectf_hip_api_trace_hipMallocManagedBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dev_ptr,
	uint64_t p__dev_ptr__val,
	uint64_t p__size,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMallocManagedEnd`) */
void barectf_hip_api_trace_hipMallocManagedEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMallocMipmappedArrayBegin`) */
void barectf_hip_api_trace_hipMallocMipmappedArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mipmappedArray,
	uint64_t p__mipmappedArray__val,
	uint64_t p__desc,
	int32_t p__desc__val__x,
	int32_t p__desc__val__y,
	int32_t p__desc__val__z,
	int32_t p__desc__val__w,
	int32_t p__desc__val__f,
	uint64_t p__extent__width,
	uint64_t p__extent__height,
	uint64_t p__extent__depth,
	uint32_t p__numLevels,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMallocMipmappedArrayEnd`) */
void barectf_hip_api_trace_hipMallocMipmappedArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMallocPitchBegin`) */
void barectf_hip_api_trace_hipMallocPitchBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__ptr__val,
	uint64_t p__pitch,
	uint64_t p__pitch__val,
	uint64_t p__width,
	uint64_t p__height);

/* Trace (data stream type `hip_api`, event record type `hipMallocPitchEnd`) */
void barectf_hip_api_trace_hipMallocPitchEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemAddressFreeBegin`) */
void barectf_hip_api_trace_hipMemAddressFreeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__devPtr,
	uint64_t p__size);

/* Trace (data stream type `hip_api`, event record type `hipMemAddressFreeEnd`) */
void barectf_hip_api_trace_hipMemAddressFreeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemAddressReserveBegin`) */
void barectf_hip_api_trace_hipMemAddressReserveBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__ptr__val,
	uint64_t p__size,
	uint64_t p__alignment,
	uint64_t p__addr,
	uint64_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMemAddressReserveEnd`) */
void barectf_hip_api_trace_hipMemAddressReserveEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemAdviseBegin`) */
void barectf_hip_api_trace_hipMemAdviseBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dev_ptr,
	uint64_t p__count,
	int32_t p__advice,
	int32_t p__device);

/* Trace (data stream type `hip_api`, event record type `hipMemAdviseEnd`) */
void barectf_hip_api_trace_hipMemAdviseEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemAdvise_v2Begin`) */
void barectf_hip_api_trace_hipMemAdvise_v2Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dev_ptr,
	uint64_t p__count,
	int32_t p__advice,
	int32_t p__location__type,
	int32_t p__location__id);

/* Trace (data stream type `hip_api`, event record type `hipMemAdvise_v2End`) */
void barectf_hip_api_trace_hipMemAdvise_v2End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemAllocHostBegin`) */
void barectf_hip_api_trace_hipMemAllocHostBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__ptr__val,
	uint64_t p__size);

/* Trace (data stream type `hip_api`, event record type `hipMemAllocHostEnd`) */
void barectf_hip_api_trace_hipMemAllocHostEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemAllocPitchBegin`) */
void barectf_hip_api_trace_hipMemAllocPitchBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dptr,
	uint64_t p__dptr__val,
	uint64_t p__pitch,
	uint64_t p__pitch__val,
	uint64_t p__widthInBytes,
	uint64_t p__height,
	uint32_t p__elementSizeBytes);

/* Trace (data stream type `hip_api`, event record type `hipMemAllocPitchEnd`) */
void barectf_hip_api_trace_hipMemAllocPitchEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemCreateBegin`) */
void barectf_hip_api_trace_hipMemCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__handle,
	uint64_t p__handle__val,
	uint64_t p__size,
	uint64_t p__prop,
	int32_t p__prop__val__type,
	int32_t p__prop__val__location__type,
	int32_t p__prop__val__location__id,
	uint64_t p__prop__val__win32HandleMetaData,
	uint64_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMemCreateEnd`) */
void barectf_hip_api_trace_hipMemCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemExportToShareableHandleBegin`) */
void barectf_hip_api_trace_hipMemExportToShareableHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__shareableHandle,
	uint64_t p__handle,
	int32_t p__handleType,
	uint64_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMemExportToShareableHandleEnd`) */
void barectf_hip_api_trace_hipMemExportToShareableHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemGetAccessBegin`) */
void barectf_hip_api_trace_hipMemGetAccessBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__flags,
	uint64_t p__flags__val,
	uint64_t p__location,
	int32_t p__location__val__type,
	int32_t p__location__val__id,
	uint64_t p__ptr);

/* Trace (data stream type `hip_api`, event record type `hipMemGetAccessEnd`) */
void barectf_hip_api_trace_hipMemGetAccessEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemGetAddressRangeBegin`) */
void barectf_hip_api_trace_hipMemGetAddressRangeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pbase,
	uint64_t p__pbase__val,
	uint64_t p__psize,
	uint64_t p__psize__val,
	uint64_t p__dptr);

/* Trace (data stream type `hip_api`, event record type `hipMemGetAddressRangeEnd`) */
void barectf_hip_api_trace_hipMemGetAddressRangeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemGetAllocationGranularityBegin`) */
void barectf_hip_api_trace_hipMemGetAllocationGranularityBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__granularity,
	uint64_t p__granularity__val,
	uint64_t p__prop,
	int32_t p__prop__val__type,
	int32_t p__prop__val__location__type,
	int32_t p__prop__val__location__id,
	uint64_t p__prop__val__win32HandleMetaData,
	int32_t p__option);

/* Trace (data stream type `hip_api`, event record type `hipMemGetAllocationGranularityEnd`) */
void barectf_hip_api_trace_hipMemGetAllocationGranularityEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemGetAllocationPropertiesFromHandleBegin`) */
void barectf_hip_api_trace_hipMemGetAllocationPropertiesFromHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__prop,
	int32_t p__prop__val__type,
	int32_t p__prop__val__location__type,
	int32_t p__prop__val__location__id,
	uint64_t p__prop__val__win32HandleMetaData,
	uint64_t p__handle);

/* Trace (data stream type `hip_api`, event record type `hipMemGetAllocationPropertiesFromHandleEnd`) */
void barectf_hip_api_trace_hipMemGetAllocationPropertiesFromHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemGetHandleForAddressRangeBegin`) */
void barectf_hip_api_trace_hipMemGetHandleForAddressRangeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__handle,
	uint64_t p__dptr,
	uint64_t p__size,
	int32_t p__handleType,
	uint64_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMemGetHandleForAddressRangeEnd`) */
void barectf_hip_api_trace_hipMemGetHandleForAddressRangeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemGetInfoBegin`) */
void barectf_hip_api_trace_hipMemGetInfoBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__free,
	uint64_t p__free__val,
	uint64_t p__total,
	uint64_t p__total__val);

/* Trace (data stream type `hip_api`, event record type `hipMemGetInfoEnd`) */
void barectf_hip_api_trace_hipMemGetInfoEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemImportFromShareableHandleBegin`) */
void barectf_hip_api_trace_hipMemImportFromShareableHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__handle,
	uint64_t p__handle__val,
	uint64_t p__osHandle,
	int32_t p__shHandleType);

/* Trace (data stream type `hip_api`, event record type `hipMemImportFromShareableHandleEnd`) */
void barectf_hip_api_trace_hipMemImportFromShareableHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemMapArrayAsyncBegin`) */
void barectf_hip_api_trace_hipMemMapArrayAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mapInfoList,
	int32_t p__mapInfoList__val__resourceType,
	int32_t p__mapInfoList__val__subresourceType,
	int32_t p__mapInfoList__val__memOperationType,
	int32_t p__mapInfoList__val__memHandleType,
	uint64_t p__mapInfoList__val__offset,
	uint32_t p__mapInfoList__val__deviceBitMask,
	uint32_t p__mapInfoList__val__flags,
	uint64_t p__mapInfoList__val__reserved,
	uint32_t p__count,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemMapArrayAsyncEnd`) */
void barectf_hip_api_trace_hipMemMapArrayAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemMapBegin`) */
void barectf_hip_api_trace_hipMemMapBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__size,
	uint64_t p__offset,
	uint64_t p__handle,
	uint64_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMemMapEnd`) */
void barectf_hip_api_trace_hipMemMapEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolCreateBegin`) */
void barectf_hip_api_trace_hipMemPoolCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mem_pool,
	uint64_t p__mem_pool__val,
	uint64_t p__pool_props,
	int32_t p__pool_props__val__allocType,
	int32_t p__pool_props__val__handleTypes,
	int32_t p__pool_props__val__location__type,
	int32_t p__pool_props__val__location__id,
	uint64_t p__pool_props__val__win32SecurityAttributes,
	uint64_t p__pool_props__val__maxSize,
	uint64_t p__pool_props__val__reserved);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolCreateEnd`) */
void barectf_hip_api_trace_hipMemPoolCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolDestroyBegin`) */
void barectf_hip_api_trace_hipMemPoolDestroyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mem_pool);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolDestroyEnd`) */
void barectf_hip_api_trace_hipMemPoolDestroyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolExportPointerBegin`) */
void barectf_hip_api_trace_hipMemPoolExportPointerBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__export_data,
	uint64_t p__export_data__val__reserved,
	uint64_t p__dev_ptr);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolExportPointerEnd`) */
void barectf_hip_api_trace_hipMemPoolExportPointerEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolExportToShareableHandleBegin`) */
void barectf_hip_api_trace_hipMemPoolExportToShareableHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__shared_handle,
	uint64_t p__mem_pool,
	int32_t p__handle_type,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolExportToShareableHandleEnd`) */
void barectf_hip_api_trace_hipMemPoolExportToShareableHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolGetAccessBegin`) */
void barectf_hip_api_trace_hipMemPoolGetAccessBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__flags,
	int32_t p__flags__val,
	uint64_t p__mem_pool,
	uint64_t p__location,
	int32_t p__location__val__type,
	int32_t p__location__val__id);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolGetAccessEnd`) */
void barectf_hip_api_trace_hipMemPoolGetAccessEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolGetAttributeBegin`) */
void barectf_hip_api_trace_hipMemPoolGetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mem_pool,
	int32_t p__attr,
	uint64_t p__value);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolGetAttributeEnd`) */
void barectf_hip_api_trace_hipMemPoolGetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolImportFromShareableHandleBegin`) */
void barectf_hip_api_trace_hipMemPoolImportFromShareableHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mem_pool,
	uint64_t p__mem_pool__val,
	uint64_t p__shared_handle,
	int32_t p__handle_type,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolImportFromShareableHandleEnd`) */
void barectf_hip_api_trace_hipMemPoolImportFromShareableHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolImportPointerBegin`) */
void barectf_hip_api_trace_hipMemPoolImportPointerBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dev_ptr,
	uint64_t p__dev_ptr__val,
	uint64_t p__mem_pool,
	uint64_t p__export_data,
	uint64_t p__export_data__val__reserved);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolImportPointerEnd`) */
void barectf_hip_api_trace_hipMemPoolImportPointerEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolSetAccessBegin`) */
void barectf_hip_api_trace_hipMemPoolSetAccessBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mem_pool,
	uint64_t p__desc_list,
	int32_t p__desc_list__val__location__type,
	int32_t p__desc_list__val__location__id,
	int32_t p__desc_list__val__flags,
	uint64_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolSetAccessEnd`) */
void barectf_hip_api_trace_hipMemPoolSetAccessEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolSetAttributeBegin`) */
void barectf_hip_api_trace_hipMemPoolSetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mem_pool,
	int32_t p__attr,
	uint64_t p__value);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolSetAttributeEnd`) */
void barectf_hip_api_trace_hipMemPoolSetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolTrimToBegin`) */
void barectf_hip_api_trace_hipMemPoolTrimToBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mem_pool,
	uint64_t p__min_bytes_to_hold);

/* Trace (data stream type `hip_api`, event record type `hipMemPoolTrimToEnd`) */
void barectf_hip_api_trace_hipMemPoolTrimToEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPrefetchAsyncBegin`) */
void barectf_hip_api_trace_hipMemPrefetchAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dev_ptr,
	uint64_t p__count,
	int32_t p__device,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemPrefetchAsyncEnd`) */
void barectf_hip_api_trace_hipMemPrefetchAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPrefetchAsync_v2Begin`) */
void barectf_hip_api_trace_hipMemPrefetchAsync_v2Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dev_ptr,
	uint64_t p__count,
	int32_t p__location__type,
	int32_t p__location__id,
	uint32_t p__flags,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemPrefetchAsync_v2End`) */
void barectf_hip_api_trace_hipMemPrefetchAsync_v2End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemPtrGetInfoBegin`) */
void barectf_hip_api_trace_hipMemPtrGetInfoBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__size,
	uint64_t p__size__val);

/* Trace (data stream type `hip_api`, event record type `hipMemPtrGetInfoEnd`) */
void barectf_hip_api_trace_hipMemPtrGetInfoEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemRangeGetAttributeBegin`) */
void barectf_hip_api_trace_hipMemRangeGetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__data,
	uint64_t p__data_size,
	int32_t p__attribute,
	uint64_t p__dev_ptr,
	uint64_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipMemRangeGetAttributeEnd`) */
void barectf_hip_api_trace_hipMemRangeGetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemRangeGetAttributesBegin`) */
void barectf_hip_api_trace_hipMemRangeGetAttributesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__data,
	uint64_t p__data__val,
	uint64_t p__data_sizes,
	uint64_t p__data_sizes__val,
	uint64_t p__attributes,
	int32_t p__attributes__val,
	uint64_t p__num_attributes,
	uint64_t p__dev_ptr,
	uint64_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipMemRangeGetAttributesEnd`) */
void barectf_hip_api_trace_hipMemRangeGetAttributesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemReleaseBegin`) */
void barectf_hip_api_trace_hipMemReleaseBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__handle);

/* Trace (data stream type `hip_api`, event record type `hipMemReleaseEnd`) */
void barectf_hip_api_trace_hipMemReleaseEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemRetainAllocationHandleBegin`) */
void barectf_hip_api_trace_hipMemRetainAllocationHandleBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__handle,
	uint64_t p__handle__val,
	uint64_t p__addr);

/* Trace (data stream type `hip_api`, event record type `hipMemRetainAllocationHandleEnd`) */
void barectf_hip_api_trace_hipMemRetainAllocationHandleEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemSetAccessBegin`) */
void barectf_hip_api_trace_hipMemSetAccessBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__size,
	uint64_t p__desc,
	int32_t p__desc__val__location__type,
	int32_t p__desc__val__location__id,
	int32_t p__desc__val__flags,
	uint64_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipMemSetAccessEnd`) */
void barectf_hip_api_trace_hipMemSetAccessEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemUnmapBegin`) */
void barectf_hip_api_trace_hipMemUnmapBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ptr,
	uint64_t p__size);

/* Trace (data stream type `hip_api`, event record type `hipMemUnmapEnd`) */
void barectf_hip_api_trace_hipMemUnmapEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DArrayToArrayBegin`) */
void barectf_hip_api_trace_hipMemcpy2DArrayToArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__wOffsetDst,
	uint64_t p__hOffsetDst,
	uint64_t p__src,
	uint64_t p__wOffsetSrc,
	uint64_t p__hOffsetSrc,
	uint64_t p__width,
	uint64_t p__height,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DArrayToArrayEnd`) */
void barectf_hip_api_trace_hipMemcpy2DArrayToArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpy2DAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__dpitch,
	uint64_t p__src,
	uint64_t p__spitch,
	uint64_t p__width,
	uint64_t p__height,
	int32_t p__kind,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpy2DAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DBegin`) */
void barectf_hip_api_trace_hipMemcpy2DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__dpitch,
	uint64_t p__src,
	uint64_t p__spitch,
	uint64_t p__width,
	uint64_t p__height,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DEnd`) */
void barectf_hip_api_trace_hipMemcpy2DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DFromArrayAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpy2DFromArrayAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__dpitch,
	uint64_t p__src,
	uint64_t p__wOffset,
	uint64_t p__hOffset,
	uint64_t p__width,
	uint64_t p__height,
	int32_t p__kind,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DFromArrayAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpy2DFromArrayAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DFromArrayBegin`) */
void barectf_hip_api_trace_hipMemcpy2DFromArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__dpitch,
	uint64_t p__src,
	uint64_t p__wOffset,
	uint64_t p__hOffset,
	uint64_t p__width,
	uint64_t p__height,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DFromArrayEnd`) */
void barectf_hip_api_trace_hipMemcpy2DFromArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DToArrayAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpy2DToArrayAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__wOffset,
	uint64_t p__hOffset,
	uint64_t p__src,
	uint64_t p__spitch,
	uint64_t p__width,
	uint64_t p__height,
	int32_t p__kind,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DToArrayAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpy2DToArrayAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DToArrayBegin`) */
void barectf_hip_api_trace_hipMemcpy2DToArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__wOffset,
	uint64_t p__hOffset,
	uint64_t p__src,
	uint64_t p__spitch,
	uint64_t p__width,
	uint64_t p__height,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy2DToArrayEnd`) */
void barectf_hip_api_trace_hipMemcpy2DToArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy3DAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpy3DAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__p,
	uint64_t p__p__val__srcArray,
	uint64_t p__p__val__srcPos__x,
	uint64_t p__p__val__srcPos__y,
	uint64_t p__p__val__srcPos__z,
	uint64_t p__p__val__srcPtr__ptr,
	uint64_t p__p__val__srcPtr__pitch,
	uint64_t p__p__val__srcPtr__xsize,
	uint64_t p__p__val__srcPtr__ysize,
	uint64_t p__p__val__dstArray,
	uint64_t p__p__val__dstPos__x,
	uint64_t p__p__val__dstPos__y,
	uint64_t p__p__val__dstPos__z,
	uint64_t p__p__val__dstPtr__ptr,
	uint64_t p__p__val__dstPtr__pitch,
	uint64_t p__p__val__dstPtr__xsize,
	uint64_t p__p__val__dstPtr__ysize,
	uint64_t p__p__val__extent__width,
	uint64_t p__p__val__extent__height,
	uint64_t p__p__val__extent__depth,
	int32_t p__p__val__kind,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy3DAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpy3DAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy3DBatchAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpy3DBatchAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__numOps,
	uint64_t p__opList,
	int32_t p__opList__val__src__type,
	int32_t p__opList__val__dst__type,
	uint64_t p__opList__val__extent__width,
	uint64_t p__opList__val__extent__height,
	uint64_t p__opList__val__extent__depth,
	int32_t p__opList__val__srcAccessOrder,
	uint32_t p__opList__val__flags,
	uint64_t p__failIdx,
	uint64_t p__failIdx__val,
	uint64_t p__flags,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy3DBatchAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpy3DBatchAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy3DBegin`) */
void barectf_hip_api_trace_hipMemcpy3DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__p,
	uint64_t p__p__val__srcArray,
	uint64_t p__p__val__srcPos__x,
	uint64_t p__p__val__srcPos__y,
	uint64_t p__p__val__srcPos__z,
	uint64_t p__p__val__srcPtr__ptr,
	uint64_t p__p__val__srcPtr__pitch,
	uint64_t p__p__val__srcPtr__xsize,
	uint64_t p__p__val__srcPtr__ysize,
	uint64_t p__p__val__dstArray,
	uint64_t p__p__val__dstPos__x,
	uint64_t p__p__val__dstPos__y,
	uint64_t p__p__val__dstPos__z,
	uint64_t p__p__val__dstPtr__ptr,
	uint64_t p__p__val__dstPtr__pitch,
	uint64_t p__p__val__dstPtr__xsize,
	uint64_t p__p__val__dstPtr__ysize,
	uint64_t p__p__val__extent__width,
	uint64_t p__p__val__extent__height,
	uint64_t p__p__val__extent__depth,
	int32_t p__p__val__kind);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy3DEnd`) */
void barectf_hip_api_trace_hipMemcpy3DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy3DPeerAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpy3DPeerAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__p,
	uint64_t p__p__val__srcArray,
	uint64_t p__p__val__srcPos__x,
	uint64_t p__p__val__srcPos__y,
	uint64_t p__p__val__srcPos__z,
	uint64_t p__p__val__srcPtr__ptr,
	uint64_t p__p__val__srcPtr__pitch,
	uint64_t p__p__val__srcPtr__xsize,
	uint64_t p__p__val__srcPtr__ysize,
	int32_t p__p__val__srcDevice,
	uint64_t p__p__val__dstArray,
	uint64_t p__p__val__dstPos__x,
	uint64_t p__p__val__dstPos__y,
	uint64_t p__p__val__dstPos__z,
	uint64_t p__p__val__dstPtr__ptr,
	uint64_t p__p__val__dstPtr__pitch,
	uint64_t p__p__val__dstPtr__xsize,
	uint64_t p__p__val__dstPtr__ysize,
	int32_t p__p__val__dstDevice,
	uint64_t p__p__val__extent__width,
	uint64_t p__p__val__extent__height,
	uint64_t p__p__val__extent__depth,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy3DPeerAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpy3DPeerAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy3DPeerBegin`) */
void barectf_hip_api_trace_hipMemcpy3DPeerBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__p,
	uint64_t p__p__val__srcArray,
	uint64_t p__p__val__srcPos__x,
	uint64_t p__p__val__srcPos__y,
	uint64_t p__p__val__srcPos__z,
	uint64_t p__p__val__srcPtr__ptr,
	uint64_t p__p__val__srcPtr__pitch,
	uint64_t p__p__val__srcPtr__xsize,
	uint64_t p__p__val__srcPtr__ysize,
	int32_t p__p__val__srcDevice,
	uint64_t p__p__val__dstArray,
	uint64_t p__p__val__dstPos__x,
	uint64_t p__p__val__dstPos__y,
	uint64_t p__p__val__dstPos__z,
	uint64_t p__p__val__dstPtr__ptr,
	uint64_t p__p__val__dstPtr__pitch,
	uint64_t p__p__val__dstPtr__xsize,
	uint64_t p__p__val__dstPtr__ysize,
	int32_t p__p__val__dstDevice,
	uint64_t p__p__val__extent__width,
	uint64_t p__p__val__extent__height,
	uint64_t p__p__val__extent__depth);

/* Trace (data stream type `hip_api`, event record type `hipMemcpy3DPeerEnd`) */
void barectf_hip_api_trace_hipMemcpy3DPeerEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__sizeBytes,
	int32_t p__kind,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyAtoABegin`) */
void barectf_hip_api_trace_hipMemcpyAtoABegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dstArray,
	uint64_t p__dstOffset,
	uint64_t p__srcArray,
	uint64_t p__srcOffset,
	uint64_t p__ByteCount);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyAtoAEnd`) */
void barectf_hip_api_trace_hipMemcpyAtoAEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyAtoDBegin`) */
void barectf_hip_api_trace_hipMemcpyAtoDBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dstDevice,
	uint64_t p__srcArray,
	uint64_t p__srcOffset,
	uint64_t p__ByteCount);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyAtoDEnd`) */
void barectf_hip_api_trace_hipMemcpyAtoDEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyAtoHAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyAtoHAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dstHost,
	uint64_t p__srcArray,
	uint64_t p__srcOffset,
	uint64_t p__ByteCount,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyAtoHAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyAtoHAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyAtoHBegin`) */
void barectf_hip_api_trace_hipMemcpyAtoHBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__srcArray,
	uint64_t p__srcOffset,
	uint64_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyAtoHEnd`) */
void barectf_hip_api_trace_hipMemcpyAtoHEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyBatchAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyBatchAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dsts,
	uint64_t p__dsts__val,
	uint64_t p__srcs,
	uint64_t p__srcs__val,
	uint64_t p__sizes,
	uint64_t p__sizes__val,
	uint64_t p__count,
	uint64_t p__attrs,
	int32_t p__attrs__val__srcAccessOrder,
	int32_t p__attrs__val__srcLocHint__type,
	int32_t p__attrs__val__srcLocHint__id,
	int32_t p__attrs__val__dstLocHint__type,
	int32_t p__attrs__val__dstLocHint__id,
	uint32_t p__attrs__val__flags,
	uint64_t p__attrsIdxs,
	uint64_t p__attrsIdxs__val,
	uint64_t p__numAttrs,
	uint64_t p__failIdx,
	uint64_t p__failIdx__val,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyBatchAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyBatchAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyBegin`) */
void barectf_hip_api_trace_hipMemcpyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__sizeBytes,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyDtoABegin`) */
void barectf_hip_api_trace_hipMemcpyDtoABegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dstArray,
	uint64_t p__dstOffset,
	uint64_t p__srcDevice,
	uint64_t p__ByteCount);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyDtoAEnd`) */
void barectf_hip_api_trace_hipMemcpyDtoAEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyDtoDAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyDtoDAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__sizeBytes,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyDtoDAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyDtoDAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyDtoDBegin`) */
void barectf_hip_api_trace_hipMemcpyDtoDBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__sizeBytes);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyDtoDEnd`) */
void barectf_hip_api_trace_hipMemcpyDtoDEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyDtoHAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyDtoHAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__sizeBytes,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyDtoHAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyDtoHAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyDtoHBegin`) */
void barectf_hip_api_trace_hipMemcpyDtoHBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__sizeBytes);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyDtoHEnd`) */
void barectf_hip_api_trace_hipMemcpyDtoHEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyEnd`) */
void barectf_hip_api_trace_hipMemcpyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyFromArrayBegin`) */
void barectf_hip_api_trace_hipMemcpyFromArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__srcArray,
	uint64_t p__wOffset,
	uint64_t p__hOffset,
	uint64_t p__count,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyFromArrayEnd`) */
void barectf_hip_api_trace_hipMemcpyFromArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyFromSymbolAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyFromSymbolAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__symbol,
	uint64_t p__sizeBytes,
	uint64_t p__offset,
	int32_t p__kind,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyFromSymbolAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyFromSymbolAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyFromSymbolBegin`) */
void barectf_hip_api_trace_hipMemcpyFromSymbolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__symbol,
	uint64_t p__sizeBytes,
	uint64_t p__offset,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyFromSymbolEnd`) */
void barectf_hip_api_trace_hipMemcpyFromSymbolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyHtoAAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyHtoAAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dstArray,
	uint64_t p__dstOffset,
	uint64_t p__srcHost,
	uint64_t p__ByteCount,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyHtoAAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyHtoAAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyHtoABegin`) */
void barectf_hip_api_trace_hipMemcpyHtoABegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dstArray,
	uint64_t p__dstOffset,
	uint64_t p__srcHost,
	uint64_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyHtoAEnd`) */
void barectf_hip_api_trace_hipMemcpyHtoAEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyHtoDAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyHtoDAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__sizeBytes,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyHtoDAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyHtoDAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyHtoDBegin`) */
void barectf_hip_api_trace_hipMemcpyHtoDBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__sizeBytes);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyHtoDEnd`) */
void barectf_hip_api_trace_hipMemcpyHtoDEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyParam2DAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyParam2DAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pCopy,
	uint64_t p__pCopy__val__srcXInBytes,
	uint64_t p__pCopy__val__srcY,
	int32_t p__pCopy__val__srcMemoryType,
	uint64_t p__pCopy__val__srcHost,
	uint64_t p__pCopy__val__srcDevice,
	uint64_t p__pCopy__val__srcArray,
	uint64_t p__pCopy__val__srcPitch,
	uint64_t p__pCopy__val__dstXInBytes,
	uint64_t p__pCopy__val__dstY,
	int32_t p__pCopy__val__dstMemoryType,
	uint64_t p__pCopy__val__dstHost,
	uint64_t p__pCopy__val__dstDevice,
	uint64_t p__pCopy__val__dstArray,
	uint64_t p__pCopy__val__dstPitch,
	uint64_t p__pCopy__val__WidthInBytes,
	uint64_t p__pCopy__val__Height,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyParam2DAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyParam2DAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyParam2DBegin`) */
void barectf_hip_api_trace_hipMemcpyParam2DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pCopy,
	uint64_t p__pCopy__val__srcXInBytes,
	uint64_t p__pCopy__val__srcY,
	int32_t p__pCopy__val__srcMemoryType,
	uint64_t p__pCopy__val__srcHost,
	uint64_t p__pCopy__val__srcDevice,
	uint64_t p__pCopy__val__srcArray,
	uint64_t p__pCopy__val__srcPitch,
	uint64_t p__pCopy__val__dstXInBytes,
	uint64_t p__pCopy__val__dstY,
	int32_t p__pCopy__val__dstMemoryType,
	uint64_t p__pCopy__val__dstHost,
	uint64_t p__pCopy__val__dstDevice,
	uint64_t p__pCopy__val__dstArray,
	uint64_t p__pCopy__val__dstPitch,
	uint64_t p__pCopy__val__WidthInBytes,
	uint64_t p__pCopy__val__Height);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyParam2DEnd`) */
void barectf_hip_api_trace_hipMemcpyParam2DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyPeerAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyPeerAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	int32_t p__dstDeviceId,
	uint64_t p__src,
	int32_t p__srcDevice,
	uint64_t p__sizeBytes,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyPeerAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyPeerAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyPeerBegin`) */
void barectf_hip_api_trace_hipMemcpyPeerBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	int32_t p__dstDeviceId,
	uint64_t p__src,
	int32_t p__srcDeviceId,
	uint64_t p__sizeBytes);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyPeerEnd`) */
void barectf_hip_api_trace_hipMemcpyPeerEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyToArrayBegin`) */
void barectf_hip_api_trace_hipMemcpyToArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__wOffset,
	uint64_t p__hOffset,
	uint64_t p__src,
	uint64_t p__count,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyToArrayEnd`) */
void barectf_hip_api_trace_hipMemcpyToArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyToSymbolAsyncBegin`) */
void barectf_hip_api_trace_hipMemcpyToSymbolAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__symbol,
	uint64_t p__src,
	uint64_t p__sizeBytes,
	uint64_t p__offset,
	int32_t p__kind,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyToSymbolAsyncEnd`) */
void barectf_hip_api_trace_hipMemcpyToSymbolAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyToSymbolBegin`) */
void barectf_hip_api_trace_hipMemcpyToSymbolBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__symbol,
	uint64_t p__src,
	uint64_t p__sizeBytes,
	uint64_t p__offset,
	int32_t p__kind);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyToSymbolEnd`) */
void barectf_hip_api_trace_hipMemcpyToSymbolEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyWithStreamBegin`) */
void barectf_hip_api_trace_hipMemcpyWithStreamBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__sizeBytes,
	int32_t p__kind,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemcpyWithStreamEnd`) */
void barectf_hip_api_trace_hipMemcpyWithStreamEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemset2DAsyncBegin`) */
void barectf_hip_api_trace_hipMemset2DAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__pitch,
	int32_t p__value,
	uint64_t p__width,
	uint64_t p__height,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemset2DAsyncEnd`) */
void barectf_hip_api_trace_hipMemset2DAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemset2DBegin`) */
void barectf_hip_api_trace_hipMemset2DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__pitch,
	int32_t p__value,
	uint64_t p__width,
	uint64_t p__height);

/* Trace (data stream type `hip_api`, event record type `hipMemset2DEnd`) */
void barectf_hip_api_trace_hipMemset2DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemset3DAsyncBegin`) */
void barectf_hip_api_trace_hipMemset3DAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pitchedDevPtr__ptr,
	uint64_t p__pitchedDevPtr__pitch,
	uint64_t p__pitchedDevPtr__xsize,
	uint64_t p__pitchedDevPtr__ysize,
	int32_t p__value,
	uint64_t p__extent__width,
	uint64_t p__extent__height,
	uint64_t p__extent__depth,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemset3DAsyncEnd`) */
void barectf_hip_api_trace_hipMemset3DAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemset3DBegin`) */
void barectf_hip_api_trace_hipMemset3DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pitchedDevPtr__ptr,
	uint64_t p__pitchedDevPtr__pitch,
	uint64_t p__pitchedDevPtr__xsize,
	uint64_t p__pitchedDevPtr__ysize,
	int32_t p__value,
	uint64_t p__extent__width,
	uint64_t p__extent__height,
	uint64_t p__extent__depth);

/* Trace (data stream type `hip_api`, event record type `hipMemset3DEnd`) */
void barectf_hip_api_trace_hipMemset3DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetAsyncBegin`) */
void barectf_hip_api_trace_hipMemsetAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	int32_t p__value,
	uint64_t p__sizeBytes,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemsetAsyncEnd`) */
void barectf_hip_api_trace_hipMemsetAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetBegin`) */
void barectf_hip_api_trace_hipMemsetBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	int32_t p__value,
	uint64_t p__sizeBytes);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD16AsyncBegin`) */
void barectf_hip_api_trace_hipMemsetD16AsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dest,
	uint16_t p__value,
	uint64_t p__count,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD16AsyncEnd`) */
void barectf_hip_api_trace_hipMemsetD16AsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD16Begin`) */
void barectf_hip_api_trace_hipMemsetD16Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dest,
	uint16_t p__value,
	uint64_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD16End`) */
void barectf_hip_api_trace_hipMemsetD16End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D16AsyncBegin`) */
void barectf_hip_api_trace_hipMemsetD2D16AsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__dstPitch,
	uint16_t p__value,
	uint64_t p__width,
	uint64_t p__height,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D16AsyncEnd`) */
void barectf_hip_api_trace_hipMemsetD2D16AsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D16Begin`) */
void barectf_hip_api_trace_hipMemsetD2D16Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__dstPitch,
	uint16_t p__value,
	uint64_t p__width,
	uint64_t p__height);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D16End`) */
void barectf_hip_api_trace_hipMemsetD2D16End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D32AsyncBegin`) */
void barectf_hip_api_trace_hipMemsetD2D32AsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__dstPitch,
	uint32_t p__value,
	uint64_t p__width,
	uint64_t p__height,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D32AsyncEnd`) */
void barectf_hip_api_trace_hipMemsetD2D32AsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D32Begin`) */
void barectf_hip_api_trace_hipMemsetD2D32Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__dstPitch,
	uint32_t p__value,
	uint64_t p__width,
	uint64_t p__height);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D32End`) */
void barectf_hip_api_trace_hipMemsetD2D32End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D8AsyncBegin`) */
void barectf_hip_api_trace_hipMemsetD2D8AsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__dstPitch,
	uint8_t p__value,
	uint64_t p__width,
	uint64_t p__height,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D8AsyncEnd`) */
void barectf_hip_api_trace_hipMemsetD2D8AsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D8Begin`) */
void barectf_hip_api_trace_hipMemsetD2D8Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__dstPitch,
	uint8_t p__value,
	uint64_t p__width,
	uint64_t p__height);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD2D8End`) */
void barectf_hip_api_trace_hipMemsetD2D8End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD32AsyncBegin`) */
void barectf_hip_api_trace_hipMemsetD32AsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	int32_t p__value,
	uint64_t p__count,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD32AsyncEnd`) */
void barectf_hip_api_trace_hipMemsetD32AsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD32Begin`) */
void barectf_hip_api_trace_hipMemsetD32Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dest,
	int32_t p__value,
	uint64_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD32End`) */
void barectf_hip_api_trace_hipMemsetD32End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD8AsyncBegin`) */
void barectf_hip_api_trace_hipMemsetD8AsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dest,
	uint8_t p__value,
	uint64_t p__count,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD8AsyncEnd`) */
void barectf_hip_api_trace_hipMemsetD8AsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD8Begin`) */
void barectf_hip_api_trace_hipMemsetD8Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dest,
	uint8_t p__value,
	uint64_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipMemsetD8End`) */
void barectf_hip_api_trace_hipMemsetD8End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMemsetEnd`) */
void barectf_hip_api_trace_hipMemsetEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMipmappedArrayCreateBegin`) */
void barectf_hip_api_trace_hipMipmappedArrayCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pHandle,
	uint64_t p__pHandle__val,
	uint64_t p__pMipmappedArrayDesc,
	uint64_t p__pMipmappedArrayDesc__val__Width,
	uint64_t p__pMipmappedArrayDesc__val__Height,
	uint64_t p__pMipmappedArrayDesc__val__Depth,
	int32_t p__pMipmappedArrayDesc__val__Format,
	uint32_t p__pMipmappedArrayDesc__val__NumChannels,
	uint32_t p__pMipmappedArrayDesc__val__Flags,
	uint32_t p__numMipmapLevels);

/* Trace (data stream type `hip_api`, event record type `hipMipmappedArrayCreateEnd`) */
void barectf_hip_api_trace_hipMipmappedArrayCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMipmappedArrayDestroyBegin`) */
void barectf_hip_api_trace_hipMipmappedArrayDestroyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__hMipmappedArray);

/* Trace (data stream type `hip_api`, event record type `hipMipmappedArrayDestroyEnd`) */
void barectf_hip_api_trace_hipMipmappedArrayDestroyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipMipmappedArrayGetLevelBegin`) */
void barectf_hip_api_trace_hipMipmappedArrayGetLevelBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pLevelArray,
	uint64_t p__pLevelArray__val,
	uint64_t p__hMipMappedArray,
	uint32_t p__level);

/* Trace (data stream type `hip_api`, event record type `hipMipmappedArrayGetLevelEnd`) */
void barectf_hip_api_trace_hipMipmappedArrayGetLevelEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleGetFunctionBegin`) */
void barectf_hip_api_trace_hipModuleGetFunctionBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__function,
	uint64_t p__function__val,
	uint64_t p__module,
	const char *p__kname,
	int8_t p__kname__val);

/* Trace (data stream type `hip_api`, event record type `hipModuleGetFunctionCountBegin`) */
void barectf_hip_api_trace_hipModuleGetFunctionCountBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__count,
	uint32_t p__count__val,
	uint64_t p__mod);

/* Trace (data stream type `hip_api`, event record type `hipModuleGetFunctionCountEnd`) */
void barectf_hip_api_trace_hipModuleGetFunctionCountEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleGetFunctionEnd`) */
void barectf_hip_api_trace_hipModuleGetFunctionEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleGetGlobalBegin`) */
void barectf_hip_api_trace_hipModuleGetGlobalBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dptr,
	uint64_t p__dptr__val,
	uint64_t p__bytes,
	uint64_t p__bytes__val,
	uint64_t p__hmod,
	const char *p__name,
	int8_t p__name__val);

/* Trace (data stream type `hip_api`, event record type `hipModuleGetGlobalEnd`) */
void barectf_hip_api_trace_hipModuleGetGlobalEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleGetTexRefBegin`) */
void barectf_hip_api_trace_hipModuleGetTexRefBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__texRef,
	uint64_t p__texRef__val,
	uint64_t p__hmod,
	const char *p__name,
	int8_t p__name__val);

/* Trace (data stream type `hip_api`, event record type `hipModuleGetTexRefEnd`) */
void barectf_hip_api_trace_hipModuleGetTexRefEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleLaunchCooperativeKernelBegin`) */
void barectf_hip_api_trace_hipModuleLaunchCooperativeKernelBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__f,
	uint32_t p__gridDimX,
	uint32_t p__gridDimY,
	uint32_t p__gridDimZ,
	uint32_t p__blockDimX,
	uint32_t p__blockDimY,
	uint32_t p__blockDimZ,
	uint32_t p__sharedMemBytes,
	uint64_t p__stream,
	uint64_t p__kernelParams,
	uint64_t p__kernelParams__val);

/* Trace (data stream type `hip_api`, event record type `hipModuleLaunchCooperativeKernelEnd`) */
void barectf_hip_api_trace_hipModuleLaunchCooperativeKernelEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleLaunchCooperativeKernelMultiDeviceBegin`) */
void barectf_hip_api_trace_hipModuleLaunchCooperativeKernelMultiDeviceBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__launchParamsList,
	uint64_t p__launchParamsList__val__function,
	uint32_t p__launchParamsList__val__gridDimX,
	uint32_t p__launchParamsList__val__gridDimY,
	uint32_t p__launchParamsList__val__gridDimZ,
	uint32_t p__launchParamsList__val__blockDimX,
	uint32_t p__launchParamsList__val__blockDimY,
	uint32_t p__launchParamsList__val__blockDimZ,
	uint32_t p__launchParamsList__val__sharedMemBytes,
	uint64_t p__launchParamsList__val__hStream,
	uint64_t p__launchParamsList__val__kernelParams,
	uint32_t p__numDevices,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipModuleLaunchCooperativeKernelMultiDeviceEnd`) */
void barectf_hip_api_trace_hipModuleLaunchCooperativeKernelMultiDeviceEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleLaunchKernelBegin`) */
void barectf_hip_api_trace_hipModuleLaunchKernelBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__f,
	uint32_t p__gridDimX,
	uint32_t p__gridDimY,
	uint32_t p__gridDimZ,
	uint32_t p__blockDimX,
	uint32_t p__blockDimY,
	uint32_t p__blockDimZ,
	uint32_t p__sharedMemBytes,
	uint64_t p__stream,
	uint64_t p__kernelParams,
	uint64_t p__kernelParams__val,
	uint64_t p__extra,
	uint64_t p__extra__val);

/* Trace (data stream type `hip_api`, event record type `hipModuleLaunchKernelEnd`) */
void barectf_hip_api_trace_hipModuleLaunchKernelEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleLoadBegin`) */
void barectf_hip_api_trace_hipModuleLoadBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__module,
	uint64_t p__module__val,
	const char *p__fname,
	int8_t p__fname__val);

/* Trace (data stream type `hip_api`, event record type `hipModuleLoadDataBegin`) */
void barectf_hip_api_trace_hipModuleLoadDataBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__module,
	uint64_t p__module__val,
	uint64_t p__image);

/* Trace (data stream type `hip_api`, event record type `hipModuleLoadDataEnd`) */
void barectf_hip_api_trace_hipModuleLoadDataEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleLoadDataExBegin`) */
void barectf_hip_api_trace_hipModuleLoadDataExBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__module,
	uint64_t p__module__val,
	uint64_t p__image,
	uint32_t p__numOptions,
	uint64_t p__options,
	int32_t p__options__val,
	uint64_t p__optionsValues,
	uint64_t p__optionsValues__val);

/* Trace (data stream type `hip_api`, event record type `hipModuleLoadDataExEnd`) */
void barectf_hip_api_trace_hipModuleLoadDataExEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleLoadEnd`) */
void barectf_hip_api_trace_hipModuleLoadEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleLoadFatBinaryBegin`) */
void barectf_hip_api_trace_hipModuleLoadFatBinaryBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__module,
	uint64_t p__module__val,
	uint64_t p__fatbin);

/* Trace (data stream type `hip_api`, event record type `hipModuleLoadFatBinaryEnd`) */
void barectf_hip_api_trace_hipModuleLoadFatBinaryEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleOccupancyMaxActiveBlocksPerMultiprocessorBegin`) */
void barectf_hip_api_trace_hipModuleOccupancyMaxActiveBlocksPerMultiprocessorBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__numBlocks,
	int32_t p__numBlocks__val,
	uint64_t p__f,
	int32_t p__blockSize,
	uint64_t p__dynSharedMemPerBlk);

/* Trace (data stream type `hip_api`, event record type `hipModuleOccupancyMaxActiveBlocksPerMultiprocessorEnd`) */
void barectf_hip_api_trace_hipModuleOccupancyMaxActiveBlocksPerMultiprocessorEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsBegin`) */
void barectf_hip_api_trace_hipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__numBlocks,
	int32_t p__numBlocks__val,
	uint64_t p__f,
	int32_t p__blockSize,
	uint64_t p__dynSharedMemPerBlk,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsEnd`) */
void barectf_hip_api_trace_hipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleOccupancyMaxPotentialBlockSizeBegin`) */
void barectf_hip_api_trace_hipModuleOccupancyMaxPotentialBlockSizeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__gridSize,
	int32_t p__gridSize__val,
	uint64_t p__blockSize,
	int32_t p__blockSize__val,
	uint64_t p__f,
	uint64_t p__dynSharedMemPerBlk,
	int32_t p__blockSizeLimit);

/* Trace (data stream type `hip_api`, event record type `hipModuleOccupancyMaxPotentialBlockSizeEnd`) */
void barectf_hip_api_trace_hipModuleOccupancyMaxPotentialBlockSizeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleOccupancyMaxPotentialBlockSizeWithFlagsBegin`) */
void barectf_hip_api_trace_hipModuleOccupancyMaxPotentialBlockSizeWithFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__gridSize,
	int32_t p__gridSize__val,
	uint64_t p__blockSize,
	int32_t p__blockSize__val,
	uint64_t p__f,
	uint64_t p__dynSharedMemPerBlk,
	int32_t p__blockSizeLimit,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipModuleOccupancyMaxPotentialBlockSizeWithFlagsEnd`) */
void barectf_hip_api_trace_hipModuleOccupancyMaxPotentialBlockSizeWithFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipModuleUnloadBegin`) */
void barectf_hip_api_trace_hipModuleUnloadBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__module);

/* Trace (data stream type `hip_api`, event record type `hipModuleUnloadEnd`) */
void barectf_hip_api_trace_hipModuleUnloadEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipOccupancyAvailableDynamicSMemPerBlockBegin`) */
void barectf_hip_api_trace_hipOccupancyAvailableDynamicSMemPerBlockBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dynamicSmemSize,
	uint64_t p__dynamicSmemSize__val,
	uint64_t p__f,
	int32_t p__numBlocks,
	int32_t p__blockSize);

/* Trace (data stream type `hip_api`, event record type `hipOccupancyAvailableDynamicSMemPerBlockEnd`) */
void barectf_hip_api_trace_hipOccupancyAvailableDynamicSMemPerBlockEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipOccupancyMaxActiveBlocksPerMultiprocessorBegin`) */
void barectf_hip_api_trace_hipOccupancyMaxActiveBlocksPerMultiprocessorBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__numBlocks,
	int32_t p__numBlocks__val,
	uint64_t p__f,
	int32_t p__blockSize,
	uint64_t p__dynamicSMemSize);

/* Trace (data stream type `hip_api`, event record type `hipOccupancyMaxActiveBlocksPerMultiprocessorEnd`) */
void barectf_hip_api_trace_hipOccupancyMaxActiveBlocksPerMultiprocessorEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsBegin`) */
void barectf_hip_api_trace_hipOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__numBlocks,
	int32_t p__numBlocks__val,
	uint64_t p__f,
	int32_t p__blockSize,
	uint64_t p__dynamicSMemSize,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsEnd`) */
void barectf_hip_api_trace_hipOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipOccupancyMaxPotentialBlockSizeBegin`) */
void barectf_hip_api_trace_hipOccupancyMaxPotentialBlockSizeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__gridSize,
	int32_t p__gridSize__val,
	uint64_t p__blockSize,
	int32_t p__blockSize__val,
	uint64_t p__f,
	uint64_t p__dynSharedMemPerBlk,
	int32_t p__blockSizeLimit);

/* Trace (data stream type `hip_api`, event record type `hipOccupancyMaxPotentialBlockSizeEnd`) */
void barectf_hip_api_trace_hipOccupancyMaxPotentialBlockSizeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipPeekAtLastErrorBegin`) */
void barectf_hip_api_trace_hipPeekAtLastErrorBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipPeekAtLastErrorEnd`) */
void barectf_hip_api_trace_hipPeekAtLastErrorEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipPointerGetAttributeBegin`) */
void barectf_hip_api_trace_hipPointerGetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__data,
	int32_t p__attribute,
	uint64_t p__ptr);

/* Trace (data stream type `hip_api`, event record type `hipPointerGetAttributeEnd`) */
void barectf_hip_api_trace_hipPointerGetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipPointerGetAttributesBegin`) */
void barectf_hip_api_trace_hipPointerGetAttributesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__attributes,
	int32_t p__attributes__val__type,
	int32_t p__attributes__val__device,
	uint64_t p__attributes__val__devicePointer,
	uint64_t p__attributes__val__hostPointer,
	int32_t p__attributes__val__isManaged,
	uint32_t p__attributes__val__allocationFlags,
	uint64_t p__ptr);

/* Trace (data stream type `hip_api`, event record type `hipPointerGetAttributesEnd`) */
void barectf_hip_api_trace_hipPointerGetAttributesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipPointerSetAttributeBegin`) */
void barectf_hip_api_trace_hipPointerSetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__value,
	int32_t p__attribute,
	uint64_t p__ptr);

/* Trace (data stream type `hip_api`, event record type `hipPointerSetAttributeEnd`) */
void barectf_hip_api_trace_hipPointerSetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipProfilerStartBegin`) */
void barectf_hip_api_trace_hipProfilerStartBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipProfilerStartEnd`) */
void barectf_hip_api_trace_hipProfilerStartEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipProfilerStopBegin`) */
void barectf_hip_api_trace_hipProfilerStopBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipProfilerStopEnd`) */
void barectf_hip_api_trace_hipProfilerStopEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipRuntimeGetVersionBegin`) */
void barectf_hip_api_trace_hipRuntimeGetVersionBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__runtimeVersion,
	int32_t p__runtimeVersion__val);

/* Trace (data stream type `hip_api`, event record type `hipRuntimeGetVersionEnd`) */
void barectf_hip_api_trace_hipRuntimeGetVersionEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipSetDeviceBegin`) */
void barectf_hip_api_trace_hipSetDeviceBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	int32_t p__deviceId);

/* Trace (data stream type `hip_api`, event record type `hipSetDeviceEnd`) */
void barectf_hip_api_trace_hipSetDeviceEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipSetDeviceFlagsBegin`) */
void barectf_hip_api_trace_hipSetDeviceFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipSetDeviceFlagsEnd`) */
void barectf_hip_api_trace_hipSetDeviceFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipSetValidDevicesBegin`) */
void barectf_hip_api_trace_hipSetValidDevicesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__device_arr,
	int32_t p__device_arr__val,
	int32_t p__len);

/* Trace (data stream type `hip_api`, event record type `hipSetValidDevicesEnd`) */
void barectf_hip_api_trace_hipSetValidDevicesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipSetupArgumentBegin`) */
void barectf_hip_api_trace_hipSetupArgumentBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__arg,
	uint64_t p__size,
	uint64_t p__offset);

/* Trace (data stream type `hip_api`, event record type `hipSetupArgumentEnd`) */
void barectf_hip_api_trace_hipSetupArgumentEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipSignalExternalSemaphoresAsyncBegin`) */
void barectf_hip_api_trace_hipSignalExternalSemaphoresAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__extSemArray,
	uint64_t p__extSemArray__val,
	uint64_t p__paramsArray,
	uint32_t p__paramsArray__val__flags,
	uint64_t p__paramsArray__val__reserved,
	uint32_t p__numExtSems,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipSignalExternalSemaphoresAsyncEnd`) */
void barectf_hip_api_trace_hipSignalExternalSemaphoresAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamAddCallbackBegin`) */
void barectf_hip_api_trace_hipStreamAddCallbackBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__callback,
	uint64_t p__userData,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipStreamAddCallbackEnd`) */
void barectf_hip_api_trace_hipStreamAddCallbackEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamAttachMemAsyncBegin`) */
void barectf_hip_api_trace_hipStreamAttachMemAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__dev_ptr,
	uint64_t p__length,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipStreamAttachMemAsyncEnd`) */
void barectf_hip_api_trace_hipStreamAttachMemAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamBatchMemOpBegin`) */
void barectf_hip_api_trace_hipStreamBatchMemOpBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint32_t p__count,
	uint64_t p__paramArray,
	int32_t p__paramArray__val__operation,
	int32_t p__paramArray__val__waitValue__operation,
	uint64_t p__paramArray__val__waitValue__address,
	uint32_t p__paramArray__val__waitValue__flags,
	uint64_t p__paramArray__val__waitValue__alias,
	int32_t p__paramArray__val__writeValue__operation,
	uint64_t p__paramArray__val__writeValue__address,
	uint32_t p__paramArray__val__writeValue__flags,
	uint64_t p__paramArray__val__writeValue__alias,
	int32_t p__paramArray__val__flushRemoteWrites__operation,
	uint32_t p__paramArray__val__flushRemoteWrites__flags,
	int32_t p__paramArray__val__memoryBarrier__operation,
	uint32_t p__paramArray__val__memoryBarrier__flags,
	uint64_t p__paramArray__val__pad,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipStreamBatchMemOpEnd`) */
void barectf_hip_api_trace_hipStreamBatchMemOpEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamBeginCaptureBegin`) */
void barectf_hip_api_trace_hipStreamBeginCaptureBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	int32_t p__mode);

/* Trace (data stream type `hip_api`, event record type `hipStreamBeginCaptureEnd`) */
void barectf_hip_api_trace_hipStreamBeginCaptureEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamBeginCaptureToGraphBegin`) */
void barectf_hip_api_trace_hipStreamBeginCaptureToGraphBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__graph,
	uint64_t p__dependencies,
	uint64_t p__dependencies__val,
	uint64_t p__dependencyData,
	uint8_t p__dependencyData__val__from_port,
	uint64_t p__dependencyData__val__reserved,
	uint8_t p__dependencyData__val__to_port,
	uint8_t p__dependencyData__val__type,
	uint64_t p__numDependencies,
	int32_t p__mode);

/* Trace (data stream type `hip_api`, event record type `hipStreamBeginCaptureToGraphEnd`) */
void barectf_hip_api_trace_hipStreamBeginCaptureToGraphEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamCopyAttributesBegin`) */
void barectf_hip_api_trace_hipStreamCopyAttributesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dst,
	uint64_t p__src);

/* Trace (data stream type `hip_api`, event record type `hipStreamCopyAttributesEnd`) */
void barectf_hip_api_trace_hipStreamCopyAttributesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamCreateBegin`) */
void barectf_hip_api_trace_hipStreamCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__stream__val);

/* Trace (data stream type `hip_api`, event record type `hipStreamCreateEnd`) */
void barectf_hip_api_trace_hipStreamCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamCreateWithFlagsBegin`) */
void barectf_hip_api_trace_hipStreamCreateWithFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__stream__val,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipStreamCreateWithFlagsEnd`) */
void barectf_hip_api_trace_hipStreamCreateWithFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamCreateWithPriorityBegin`) */
void barectf_hip_api_trace_hipStreamCreateWithPriorityBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__stream__val,
	uint32_t p__flags,
	int32_t p__priority);

/* Trace (data stream type `hip_api`, event record type `hipStreamCreateWithPriorityEnd`) */
void barectf_hip_api_trace_hipStreamCreateWithPriorityEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamDestroyBegin`) */
void barectf_hip_api_trace_hipStreamDestroyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipStreamDestroyEnd`) */
void barectf_hip_api_trace_hipStreamDestroyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamEndCaptureBegin`) */
void barectf_hip_api_trace_hipStreamEndCaptureBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__pGraph,
	uint64_t p__pGraph__val);

/* Trace (data stream type `hip_api`, event record type `hipStreamEndCaptureEnd`) */
void barectf_hip_api_trace_hipStreamEndCaptureEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetAttributeBegin`) */
void barectf_hip_api_trace_hipStreamGetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	int32_t p__attr,
	uint64_t p__value_out,
	uint64_t p__value_out__val__pad,
	uint64_t p__value_out__val__accessPolicyWindow__base_ptr,
	int32_t p__value_out__val__accessPolicyWindow__hitProp,
	uint64_t p__value_out__val__accessPolicyWindow__hitRatio,
	int32_t p__value_out__val__accessPolicyWindow__missProp,
	uint64_t p__value_out__val__accessPolicyWindow__num_bytes,
	int32_t p__value_out__val__cooperative,
	int32_t p__value_out__val__priority,
	int32_t p__value_out__val__syncPolicy,
	uint8_t p__value_out__val__memSyncDomainMap__default_,
	uint8_t p__value_out__val__memSyncDomainMap__remote,
	int32_t p__value_out__val__memSyncDomain);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetAttributeEnd`) */
void barectf_hip_api_trace_hipStreamGetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetCaptureInfoBegin`) */
void barectf_hip_api_trace_hipStreamGetCaptureInfoBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__pCaptureStatus,
	int32_t p__pCaptureStatus__val,
	uint64_t p__pId,
	uint64_t p__pId__val);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetCaptureInfoEnd`) */
void barectf_hip_api_trace_hipStreamGetCaptureInfoEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetCaptureInfo_v2Begin`) */
void barectf_hip_api_trace_hipStreamGetCaptureInfo_v2Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__captureStatus_out,
	int32_t p__captureStatus_out__val,
	uint64_t p__id_out,
	uint64_t p__id_out__val,
	uint64_t p__graph_out,
	uint64_t p__graph_out__val,
	uint64_t p__dependencies_out,
	uint64_t p__dependencies_out__val,
	uint64_t p__numDependencies_out,
	uint64_t p__numDependencies_out__val);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetCaptureInfo_v2End`) */
void barectf_hip_api_trace_hipStreamGetCaptureInfo_v2End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetDeviceBegin`) */
void barectf_hip_api_trace_hipStreamGetDeviceBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__device,
	int32_t p__device__val);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetDeviceEnd`) */
void barectf_hip_api_trace_hipStreamGetDeviceEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetFlagsBegin`) */
void barectf_hip_api_trace_hipStreamGetFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__flags,
	uint32_t p__flags__val);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetFlagsEnd`) */
void barectf_hip_api_trace_hipStreamGetFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetIdBegin`) */
void barectf_hip_api_trace_hipStreamGetIdBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__streamId,
	uint64_t p__streamId__val);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetIdEnd`) */
void barectf_hip_api_trace_hipStreamGetIdEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetPriorityBegin`) */
void barectf_hip_api_trace_hipStreamGetPriorityBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__priority,
	int32_t p__priority__val);

/* Trace (data stream type `hip_api`, event record type `hipStreamGetPriorityEnd`) */
void barectf_hip_api_trace_hipStreamGetPriorityEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamIsCapturingBegin`) */
void barectf_hip_api_trace_hipStreamIsCapturingBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__pCaptureStatus,
	int32_t p__pCaptureStatus__val);

/* Trace (data stream type `hip_api`, event record type `hipStreamIsCapturingEnd`) */
void barectf_hip_api_trace_hipStreamIsCapturingEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamQueryBegin`) */
void barectf_hip_api_trace_hipStreamQueryBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipStreamQueryEnd`) */
void barectf_hip_api_trace_hipStreamQueryEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamSetAttributeBegin`) */
void barectf_hip_api_trace_hipStreamSetAttributeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	int32_t p__attr,
	uint64_t p__value,
	uint64_t p__value__val__pad,
	uint64_t p__value__val__accessPolicyWindow__base_ptr,
	int32_t p__value__val__accessPolicyWindow__hitProp,
	uint64_t p__value__val__accessPolicyWindow__hitRatio,
	int32_t p__value__val__accessPolicyWindow__missProp,
	uint64_t p__value__val__accessPolicyWindow__num_bytes,
	int32_t p__value__val__cooperative,
	int32_t p__value__val__priority,
	int32_t p__value__val__syncPolicy,
	uint8_t p__value__val__memSyncDomainMap__default_,
	uint8_t p__value__val__memSyncDomainMap__remote,
	int32_t p__value__val__memSyncDomain);

/* Trace (data stream type `hip_api`, event record type `hipStreamSetAttributeEnd`) */
void barectf_hip_api_trace_hipStreamSetAttributeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamSynchronizeBegin`) */
void barectf_hip_api_trace_hipStreamSynchronizeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipStreamSynchronizeEnd`) */
void barectf_hip_api_trace_hipStreamSynchronizeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamUpdateCaptureDependenciesBegin`) */
void barectf_hip_api_trace_hipStreamUpdateCaptureDependenciesBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__dependencies,
	uint64_t p__dependencies__val,
	uint64_t p__numDependencies,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipStreamUpdateCaptureDependenciesEnd`) */
void barectf_hip_api_trace_hipStreamUpdateCaptureDependenciesEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamWaitEventBegin`) */
void barectf_hip_api_trace_hipStreamWaitEventBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__event,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipStreamWaitEventEnd`) */
void barectf_hip_api_trace_hipStreamWaitEventEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamWaitValue32Begin`) */
void barectf_hip_api_trace_hipStreamWaitValue32Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__ptr,
	uint32_t p__value,
	uint32_t p__flags,
	uint32_t p__mask);

/* Trace (data stream type `hip_api`, event record type `hipStreamWaitValue32End`) */
void barectf_hip_api_trace_hipStreamWaitValue32End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamWaitValue64Begin`) */
void barectf_hip_api_trace_hipStreamWaitValue64Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__ptr,
	uint64_t p__value,
	uint32_t p__flags,
	uint64_t p__mask);

/* Trace (data stream type `hip_api`, event record type `hipStreamWaitValue64End`) */
void barectf_hip_api_trace_hipStreamWaitValue64End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamWriteValue32Begin`) */
void barectf_hip_api_trace_hipStreamWriteValue32Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__ptr,
	uint32_t p__value,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipStreamWriteValue32End`) */
void barectf_hip_api_trace_hipStreamWriteValue32End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipStreamWriteValue64Begin`) */
void barectf_hip_api_trace_hipStreamWriteValue64Begin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__stream,
	uint64_t p__ptr,
	uint64_t p__value,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipStreamWriteValue64End`) */
void barectf_hip_api_trace_hipStreamWriteValue64End(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetAddressBegin`) */
void barectf_hip_api_trace_hipTexRefGetAddressBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__dev_ptr,
	uint64_t p__dev_ptr__val,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetAddressEnd`) */
void barectf_hip_api_trace_hipTexRefGetAddressEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetArrayBegin`) */
void barectf_hip_api_trace_hipTexRefGetArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pArray,
	uint64_t p__pArray__val,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetArrayEnd`) */
void barectf_hip_api_trace_hipTexRefGetArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetBorderColorBegin`) */
void barectf_hip_api_trace_hipTexRefGetBorderColorBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pBorderColor,
	uint64_t p__pBorderColor__val,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetBorderColorEnd`) */
void barectf_hip_api_trace_hipTexRefGetBorderColorEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetFlagsBegin`) */
void barectf_hip_api_trace_hipTexRefGetFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pFlags,
	uint32_t p__pFlags__val,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetFlagsEnd`) */
void barectf_hip_api_trace_hipTexRefGetFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetFormatBegin`) */
void barectf_hip_api_trace_hipTexRefGetFormatBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pFormat,
	int32_t p__pFormat__val,
	uint64_t p__pNumChannels,
	int32_t p__pNumChannels__val,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetFormatEnd`) */
void barectf_hip_api_trace_hipTexRefGetFormatEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetMaxAnisotropyBegin`) */
void barectf_hip_api_trace_hipTexRefGetMaxAnisotropyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pmaxAnsio,
	int32_t p__pmaxAnsio__val,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetMaxAnisotropyEnd`) */
void barectf_hip_api_trace_hipTexRefGetMaxAnisotropyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetMipMappedArrayBegin`) */
void barectf_hip_api_trace_hipTexRefGetMipMappedArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pArray,
	uint64_t p__pArray__val,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetMipMappedArrayEnd`) */
void barectf_hip_api_trace_hipTexRefGetMipMappedArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetMipmapLevelBiasBegin`) */
void barectf_hip_api_trace_hipTexRefGetMipmapLevelBiasBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pbias,
	uint64_t p__pbias__val,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetMipmapLevelBiasEnd`) */
void barectf_hip_api_trace_hipTexRefGetMipmapLevelBiasEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetMipmapLevelClampBegin`) */
void barectf_hip_api_trace_hipTexRefGetMipmapLevelClampBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__pminMipmapLevelClamp,
	uint64_t p__pminMipmapLevelClamp__val,
	uint64_t p__pmaxMipmapLevelClamp,
	uint64_t p__pmaxMipmapLevelClamp__val,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format);

/* Trace (data stream type `hip_api`, event record type `hipTexRefGetMipmapLevelClampEnd`) */
void barectf_hip_api_trace_hipTexRefGetMipmapLevelClampEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetAddress2DBegin`) */
void barectf_hip_api_trace_hipTexRefSetAddress2DBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format,
	uint64_t p__desc,
	uint64_t p__desc__val__Width,
	uint64_t p__desc__val__Height,
	int32_t p__desc__val__Format,
	uint32_t p__desc__val__NumChannels,
	uint64_t p__dptr,
	uint64_t p__Pitch);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetAddress2DEnd`) */
void barectf_hip_api_trace_hipTexRefSetAddress2DEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetAddressBegin`) */
void barectf_hip_api_trace_hipTexRefSetAddressBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__ByteOffset,
	uint64_t p__ByteOffset__val,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format,
	uint64_t p__dptr,
	uint64_t p__bytes);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetAddressEnd`) */
void barectf_hip_api_trace_hipTexRefSetAddressEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetArrayBegin`) */
void barectf_hip_api_trace_hipTexRefSetArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__tex,
	int32_t p__tex__val__normalized,
	int32_t p__tex__val__readMode,
	int32_t p__tex__val__filterMode,
	int32_t p__tex__val__channelDesc__x,
	int32_t p__tex__val__channelDesc__y,
	int32_t p__tex__val__channelDesc__z,
	int32_t p__tex__val__channelDesc__w,
	int32_t p__tex__val__channelDesc__f,
	int32_t p__tex__val__sRGB,
	uint32_t p__tex__val__maxAnisotropy,
	int32_t p__tex__val__mipmapFilterMode,
	uint64_t p__tex__val__mipmapLevelBias,
	uint64_t p__tex__val__minMipmapLevelClamp,
	uint64_t p__tex__val__maxMipmapLevelClamp,
	uint64_t p__tex__val__textureObject,
	int32_t p__tex__val__numChannels,
	int32_t p__tex__val__format,
	uint64_t p__array,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetArrayEnd`) */
void barectf_hip_api_trace_hipTexRefSetArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetBorderColorBegin`) */
void barectf_hip_api_trace_hipTexRefSetBorderColorBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format,
	uint64_t p__pBorderColor,
	uint64_t p__pBorderColor__val);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetBorderColorEnd`) */
void barectf_hip_api_trace_hipTexRefSetBorderColorEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetFlagsBegin`) */
void barectf_hip_api_trace_hipTexRefSetFlagsBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format,
	uint32_t p__Flags);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetFlagsEnd`) */
void barectf_hip_api_trace_hipTexRefSetFlagsEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetFormatBegin`) */
void barectf_hip_api_trace_hipTexRefSetFormatBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format,
	int32_t p__fmt,
	int32_t p__NumPackedComponents);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetFormatEnd`) */
void barectf_hip_api_trace_hipTexRefSetFormatEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetMaxAnisotropyBegin`) */
void barectf_hip_api_trace_hipTexRefSetMaxAnisotropyBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format,
	uint32_t p__maxAniso);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetMaxAnisotropyEnd`) */
void barectf_hip_api_trace_hipTexRefSetMaxAnisotropyEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetMipmapLevelBiasBegin`) */
void barectf_hip_api_trace_hipTexRefSetMipmapLevelBiasBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format,
	uint64_t p__bias);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetMipmapLevelBiasEnd`) */
void barectf_hip_api_trace_hipTexRefSetMipmapLevelBiasEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetMipmapLevelClampBegin`) */
void barectf_hip_api_trace_hipTexRefSetMipmapLevelClampBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format,
	uint64_t p__minMipMapLevelClamp,
	uint64_t p__maxMipMapLevelClamp);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetMipmapLevelClampEnd`) */
void barectf_hip_api_trace_hipTexRefSetMipmapLevelClampEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetMipmappedArrayBegin`) */
void barectf_hip_api_trace_hipTexRefSetMipmappedArrayBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__texRef,
	int32_t p__texRef__val__normalized,
	int32_t p__texRef__val__readMode,
	int32_t p__texRef__val__filterMode,
	int32_t p__texRef__val__channelDesc__x,
	int32_t p__texRef__val__channelDesc__y,
	int32_t p__texRef__val__channelDesc__z,
	int32_t p__texRef__val__channelDesc__w,
	int32_t p__texRef__val__channelDesc__f,
	int32_t p__texRef__val__sRGB,
	uint32_t p__texRef__val__maxAnisotropy,
	int32_t p__texRef__val__mipmapFilterMode,
	uint64_t p__texRef__val__mipmapLevelBias,
	uint64_t p__texRef__val__minMipmapLevelClamp,
	uint64_t p__texRef__val__maxMipmapLevelClamp,
	uint64_t p__texRef__val__textureObject,
	int32_t p__texRef__val__numChannels,
	int32_t p__texRef__val__format,
	uint64_t p__mipmappedArray,
	uint64_t p__mipmappedArray__val__data,
	int32_t p__mipmappedArray__val__desc__x,
	int32_t p__mipmappedArray__val__desc__y,
	int32_t p__mipmappedArray__val__desc__z,
	int32_t p__mipmappedArray__val__desc__w,
	int32_t p__mipmappedArray__val__desc__f,
	uint32_t p__mipmappedArray__val__type,
	uint32_t p__mipmappedArray__val__width,
	uint32_t p__mipmappedArray__val__height,
	uint32_t p__mipmappedArray__val__depth,
	uint32_t p__mipmappedArray__val__min_mipmap_level,
	uint32_t p__mipmappedArray__val__max_mipmap_level,
	uint32_t p__mipmappedArray__val__flags,
	int32_t p__mipmappedArray__val__format,
	uint32_t p__mipmappedArray__val__num_channels,
	uint32_t p__Flags);

/* Trace (data stream type `hip_api`, event record type `hipTexRefSetMipmappedArrayEnd`) */
void barectf_hip_api_trace_hipTexRefSetMipmappedArrayEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipThreadExchangeStreamCaptureModeBegin`) */
void barectf_hip_api_trace_hipThreadExchangeStreamCaptureModeBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__mode,
	int32_t p__mode__val);

/* Trace (data stream type `hip_api`, event record type `hipThreadExchangeStreamCaptureModeEnd`) */
void barectf_hip_api_trace_hipThreadExchangeStreamCaptureModeEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipUserObjectCreateBegin`) */
void barectf_hip_api_trace_hipUserObjectCreateBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__object_out,
	uint64_t p__object_out__val,
	uint64_t p__ptr,
	uint64_t p__destroy,
	uint32_t p__initialRefcount,
	uint32_t p__flags);

/* Trace (data stream type `hip_api`, event record type `hipUserObjectCreateEnd`) */
void barectf_hip_api_trace_hipUserObjectCreateEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipUserObjectReleaseBegin`) */
void barectf_hip_api_trace_hipUserObjectReleaseBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__object,
	uint32_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipUserObjectReleaseEnd`) */
void barectf_hip_api_trace_hipUserObjectReleaseEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipUserObjectRetainBegin`) */
void barectf_hip_api_trace_hipUserObjectRetainBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__object,
	uint32_t p__count);

/* Trace (data stream type `hip_api`, event record type `hipUserObjectRetainEnd`) */
void barectf_hip_api_trace_hipUserObjectRetainEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);

/* Trace (data stream type `hip_api`, event record type `hipWaitExternalSemaphoresAsyncBegin`) */
void barectf_hip_api_trace_hipWaitExternalSemaphoresAsyncBegin(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name,
	uint64_t p__extSemArray,
	uint64_t p__extSemArray__val,
	uint64_t p__paramsArray,
	uint32_t p__paramsArray__val__flags,
	uint64_t p__paramsArray__val__reserved,
	uint32_t p__numExtSems,
	uint64_t p__stream);

/* Trace (data stream type `hip_api`, event record type `hipWaitExternalSemaphoresAsyncEnd`) */
void barectf_hip_api_trace_hipWaitExternalSemaphoresAsyncEnd(struct barectf_hip_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *cc__kernel_name);
/* Open packet for data stream type `hsa_api` */
void barectf_hsa_api_open_packet(
	struct barectf_hsa_api_ctx *sctx);

/* Close packet for data stream type `hsa_api` */
void barectf_hsa_api_close_packet(struct barectf_hsa_api_ctx *sctx);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_extension_supported_begin`) */
void barectf_hsa_api_trace_hsa_agent_extension_supported_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint16_t p__extension,
	uint64_t p__agent__handle,
	uint16_t p__version_major,
	uint16_t p__version_minor,
	uint64_t p__result);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_extension_supported_end`) */
void barectf_hsa_api_trace_hsa_agent_extension_supported_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_get_exception_policies_begin`) */
void barectf_hsa_api_trace_hsa_agent_get_exception_policies_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	int32_t p__profile,
	uint64_t p__mask);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_get_exception_policies_end`) */
void barectf_hsa_api_trace_hsa_agent_get_exception_policies_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_get_info_begin`) */
void barectf_hsa_api_trace_hsa_agent_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_get_info_end`) */
void barectf_hsa_api_trace_hsa_agent_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_iterate_caches_begin`) */
void barectf_hsa_api_trace_hsa_agent_iterate_caches_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_iterate_caches_end`) */
void barectf_hsa_api_trace_hsa_agent_iterate_caches_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_iterate_isas_begin`) */
void barectf_hsa_api_trace_hsa_agent_iterate_isas_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_iterate_isas_end`) */
void barectf_hsa_api_trace_hsa_agent_iterate_isas_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_iterate_regions_begin`) */
void barectf_hsa_api_trace_hsa_agent_iterate_regions_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_iterate_regions_end`) */
void barectf_hsa_api_trace_hsa_agent_iterate_regions_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_major_extension_supported_begin`) */
void barectf_hsa_api_trace_hsa_agent_major_extension_supported_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint16_t p__extension,
	uint64_t p__agent__handle,
	uint16_t p__version_major,
	uint64_t p__version_minor,
	uint64_t p__result);

/* Trace (data stream type `hsa_api`, event record type `hsa_agent_major_extension_supported_end`) */
void barectf_hsa_api_trace_hsa_agent_major_extension_supported_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_agent_iterate_memory_pools_begin`) */
void barectf_hsa_api_trace_hsa_amd_agent_iterate_memory_pools_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_agent_iterate_memory_pools_end`) */
void barectf_hsa_api_trace_hsa_amd_agent_iterate_memory_pools_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_agent_memory_pool_get_info_begin`) */
void barectf_hsa_api_trace_hsa_amd_agent_memory_pool_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__memory_pool__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_agent_memory_pool_get_info_end`) */
void barectf_hsa_api_trace_hsa_amd_agent_memory_pool_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_agent_set_async_scratch_limit_begin`) */
void barectf_hsa_api_trace_hsa_amd_agent_set_async_scratch_limit_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__threshold);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_agent_set_async_scratch_limit_end`) */
void barectf_hsa_api_trace_hsa_amd_agent_set_async_scratch_limit_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_agents_allow_access_begin`) */
void barectf_hsa_api_trace_hsa_amd_agents_allow_access_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint32_t p__num_agents,
	uint64_t p__agents,
	uint64_t p__flags,
	uint64_t p__ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_agents_allow_access_end`) */
void barectf_hsa_api_trace_hsa_amd_agents_allow_access_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ais_file_read_begin`) */
void barectf_hsa_api_trace_hsa_amd_ais_file_read_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__devicePtr,
	uint64_t p__size,
	int64_t p__file_offset,
	uint64_t p__size_copied,
	uint64_t p__status);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ais_file_read_end`) */
void barectf_hsa_api_trace_hsa_amd_ais_file_read_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ais_file_write_begin`) */
void barectf_hsa_api_trace_hsa_amd_ais_file_write_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__devicePtr,
	uint64_t p__size,
	int64_t p__file_offset,
	uint64_t p__size_copied,
	uint64_t p__status);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ais_file_write_end`) */
void barectf_hsa_api_trace_hsa_amd_ais_file_write_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_async_function_begin`) */
void barectf_hsa_api_trace_hsa_amd_async_function_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__callback,
	uint64_t p__arg);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_async_function_end`) */
void barectf_hsa_api_trace_hsa_amd_async_function_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_coherency_get_type_begin`) */
void barectf_hsa_api_trace_hsa_amd_coherency_get_type_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__type);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_coherency_get_type_end`) */
void barectf_hsa_api_trace_hsa_amd_coherency_get_type_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_coherency_set_type_begin`) */
void barectf_hsa_api_trace_hsa_amd_coherency_set_type_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	int32_t p__type);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_coherency_set_type_end`) */
void barectf_hsa_api_trace_hsa_amd_coherency_set_type_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_deregister_deallocation_callback_begin`) */
void barectf_hsa_api_trace_hsa_amd_deregister_deallocation_callback_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__callback);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_deregister_deallocation_callback_end`) */
void barectf_hsa_api_trace_hsa_amd_deregister_deallocation_callback_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_enable_logging_begin`) */
void barectf_hsa_api_trace_hsa_amd_enable_logging_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__flags,
	uint64_t p__file);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_enable_logging_end`) */
void barectf_hsa_api_trace_hsa_amd_enable_logging_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_image_create_begin`) */
void barectf_hsa_api_trace_hsa_amd_image_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__image_descriptor,
	uint64_t p__image_layout,
	uint64_t p__image_data,
	int32_t p__access_permission,
	uint64_t p__image);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_image_create_end`) */
void barectf_hsa_api_trace_hsa_amd_image_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_interop_map_buffer_begin`) */
void barectf_hsa_api_trace_hsa_amd_interop_map_buffer_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint32_t p__num_agents,
	uint64_t p__agents,
	int32_t p__interop_handle,
	uint32_t p__flags,
	uint64_t p__size,
	uint64_t p__ptr,
	uint64_t p__metadata_size,
	uint64_t p__metadata);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_interop_map_buffer_end`) */
void barectf_hsa_api_trace_hsa_amd_interop_map_buffer_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_interop_unmap_buffer_begin`) */
void barectf_hsa_api_trace_hsa_amd_interop_unmap_buffer_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_interop_unmap_buffer_end`) */
void barectf_hsa_api_trace_hsa_amd_interop_unmap_buffer_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ipc_memory_attach_begin`) */
void barectf_hsa_api_trace_hsa_amd_ipc_memory_attach_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__handle,
	uint64_t p__len,
	uint32_t p__num_agents,
	uint64_t p__mapping_agents,
	uint64_t p__mapped_ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ipc_memory_attach_end`) */
void barectf_hsa_api_trace_hsa_amd_ipc_memory_attach_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ipc_memory_create_begin`) */
void barectf_hsa_api_trace_hsa_amd_ipc_memory_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__len,
	uint64_t p__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ipc_memory_create_end`) */
void barectf_hsa_api_trace_hsa_amd_ipc_memory_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ipc_memory_detach_begin`) */
void barectf_hsa_api_trace_hsa_amd_ipc_memory_detach_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__mapped_ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ipc_memory_detach_end`) */
void barectf_hsa_api_trace_hsa_amd_ipc_memory_detach_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ipc_signal_attach_begin`) */
void barectf_hsa_api_trace_hsa_amd_ipc_signal_attach_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__handle,
	uint64_t p__signal);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ipc_signal_attach_end`) */
void barectf_hsa_api_trace_hsa_amd_ipc_signal_attach_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ipc_signal_create_begin`) */
void barectf_hsa_api_trace_hsa_amd_ipc_signal_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	uint64_t p__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_ipc_signal_create_end`) */
void barectf_hsa_api_trace_hsa_amd_ipc_signal_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_async_copy_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_async_copy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__dst,
	uint64_t p__dst_agent__handle,
	uint64_t p__src,
	uint64_t p__src_agent__handle,
	uint64_t p__size,
	uint32_t p__num_dep_signals,
	uint64_t p__dep_signals,
	uint64_t p__completion_signal__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_async_copy_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_async_copy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_async_copy_on_engine_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_async_copy_on_engine_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__dst,
	uint64_t p__dst_agent__handle,
	uint64_t p__src,
	uint64_t p__src_agent__handle,
	uint64_t p__size,
	uint32_t p__num_dep_signals,
	uint64_t p__dep_signals,
	uint64_t p__completion_signal__handle,
	int32_t p__engine_id,
	int32_t p__force_copy_on_sdma);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_async_copy_on_engine_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_async_copy_on_engine_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_async_copy_rect_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_async_copy_rect_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__dst,
	uint64_t p__dst_offset,
	uint64_t p__src,
	uint64_t p__src_offset,
	uint64_t p__range,
	uint32_t p__range__val__x,
	uint32_t p__range__val__y,
	uint32_t p__range__val__z,
	uint64_t p__copy_agent__handle,
	int32_t p__dir,
	uint32_t p__num_dep_signals,
	uint64_t p__dep_signals,
	uint64_t p__completion_signal__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_async_copy_rect_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_async_copy_rect_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_copy_engine_status_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_copy_engine_status_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__dst_agent__handle,
	uint64_t p__src_agent__handle,
	uint64_t p__engine_ids_mask);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_copy_engine_status_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_copy_engine_status_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_fill_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_fill_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint32_t p__value,
	uint64_t p__count);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_fill_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_fill_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_get_preferred_copy_engine_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_get_preferred_copy_engine_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__dst_agent__handle,
	uint64_t p__src_agent__handle,
	uint64_t p__recommended_ids_mask);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_get_preferred_copy_engine_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_get_preferred_copy_engine_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_lock_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_lock_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__host_ptr,
	uint64_t p__size,
	uint64_t p__agents,
	int32_t p__num_agent,
	uint64_t p__agent_ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_lock_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_lock_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_lock_to_pool_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_lock_to_pool_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__host_ptr,
	uint64_t p__size,
	uint64_t p__agents,
	int32_t p__num_agent,
	uint64_t p__pool__handle,
	uint32_t p__flags,
	uint64_t p__agent_ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_lock_to_pool_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_lock_to_pool_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_migrate_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_migrate_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__memory_pool__handle,
	uint32_t p__flags);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_migrate_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_migrate_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_pool_allocate_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_pool_allocate_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__memory_pool__handle,
	uint64_t p__size,
	uint32_t p__flags,
	uint64_t p__ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_pool_allocate_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_pool_allocate_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_pool_can_migrate_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_pool_can_migrate_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__src_memory_pool__handle,
	uint64_t p__dst_memory_pool__handle,
	uint64_t p__result);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_pool_can_migrate_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_pool_can_migrate_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_pool_free_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_pool_free_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_pool_free_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_pool_free_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_pool_get_info_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_pool_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__memory_pool__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_pool_get_info_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_pool_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_unlock_begin`) */
void barectf_hsa_api_trace_hsa_amd_memory_unlock_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__host_ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_memory_unlock_end`) */
void barectf_hsa_api_trace_hsa_amd_memory_unlock_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_pointer_info_begin`) */
void barectf_hsa_api_trace_hsa_amd_pointer_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__info,
	uint64_t p__alloc,
	uint64_t p__num_agents_accessible,
	uint64_t p__accessible);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_pointer_info_end`) */
void barectf_hsa_api_trace_hsa_amd_pointer_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_pointer_info_set_userdata_begin`) */
void barectf_hsa_api_trace_hsa_amd_pointer_info_set_userdata_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__userdata);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_pointer_info_set_userdata_end`) */
void barectf_hsa_api_trace_hsa_amd_pointer_info_set_userdata_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_portable_close_dmabuf_begin`) */
void barectf_hsa_api_trace_hsa_amd_portable_close_dmabuf_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__dmabuf);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_portable_close_dmabuf_end`) */
void barectf_hsa_api_trace_hsa_amd_portable_close_dmabuf_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_portable_export_dmabuf_begin`) */
void barectf_hsa_api_trace_hsa_amd_portable_export_dmabuf_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__size,
	uint64_t p__dmabuf,
	uint64_t p__offset);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_portable_export_dmabuf_end`) */
void barectf_hsa_api_trace_hsa_amd_portable_export_dmabuf_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_portable_export_dmabuf_v2_begin`) */
void barectf_hsa_api_trace_hsa_amd_portable_export_dmabuf_v2_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__size,
	uint64_t p__dmabuf,
	uint64_t p__offset,
	uint64_t p__flags);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_portable_export_dmabuf_v2_end`) */
void barectf_hsa_api_trace_hsa_amd_portable_export_dmabuf_v2_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_profiling_async_copy_enable_begin`) */
void barectf_hsa_api_trace_hsa_amd_profiling_async_copy_enable_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__enable);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_profiling_async_copy_enable_end`) */
void barectf_hsa_api_trace_hsa_amd_profiling_async_copy_enable_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_profiling_convert_tick_to_system_domain_begin`) */
void barectf_hsa_api_trace_hsa_amd_profiling_convert_tick_to_system_domain_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__agent_tick,
	uint64_t p__system_tick);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_profiling_convert_tick_to_system_domain_end`) */
void barectf_hsa_api_trace_hsa_amd_profiling_convert_tick_to_system_domain_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_profiling_get_async_copy_time_begin`) */
void barectf_hsa_api_trace_hsa_amd_profiling_get_async_copy_time_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	uint64_t p__time);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_profiling_get_async_copy_time_end`) */
void barectf_hsa_api_trace_hsa_amd_profiling_get_async_copy_time_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_profiling_get_dispatch_time_begin`) */
void barectf_hsa_api_trace_hsa_amd_profiling_get_dispatch_time_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__signal__handle,
	uint64_t p__time);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_profiling_get_dispatch_time_end`) */
void barectf_hsa_api_trace_hsa_amd_profiling_get_dispatch_time_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_profiling_set_profiler_enabled_begin`) */
void barectf_hsa_api_trace_hsa_amd_profiling_set_profiler_enabled_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	int32_t p__enable);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_profiling_set_profiler_enabled_end`) */
void barectf_hsa_api_trace_hsa_amd_profiling_set_profiler_enabled_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_cu_get_mask_begin`) */
void barectf_hsa_api_trace_hsa_amd_queue_cu_get_mask_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint32_t p__num_cu_mask_count,
	uint64_t p__cu_mask);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_cu_get_mask_end`) */
void barectf_hsa_api_trace_hsa_amd_queue_cu_get_mask_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_cu_set_mask_begin`) */
void barectf_hsa_api_trace_hsa_amd_queue_cu_set_mask_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint32_t p__num_cu_mask_count,
	uint64_t p__cu_mask);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_cu_set_mask_end`) */
void barectf_hsa_api_trace_hsa_amd_queue_cu_set_mask_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_get_info_begin`) */
void barectf_hsa_api_trace_hsa_amd_queue_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_get_info_end`) */
void barectf_hsa_api_trace_hsa_amd_queue_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_intercept_create_begin`) */
void barectf_hsa_api_trace_hsa_amd_queue_intercept_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent_handle__handle,
	uint32_t p__size,
	uint32_t p__type,
	uint64_t p__callback,
	uint64_t p__data,
	uint32_t p__private_segment_size,
	uint32_t p__group_segment_size,
	uint64_t p__queue);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_intercept_create_end`) */
void barectf_hsa_api_trace_hsa_amd_queue_intercept_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_intercept_register_begin`) */
void barectf_hsa_api_trace_hsa_amd_queue_intercept_register_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__callback,
	uint64_t p__user_data);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_intercept_register_end`) */
void barectf_hsa_api_trace_hsa_amd_queue_intercept_register_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_set_priority_begin`) */
void barectf_hsa_api_trace_hsa_amd_queue_set_priority_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	int32_t p__priority);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_queue_set_priority_end`) */
void barectf_hsa_api_trace_hsa_amd_queue_set_priority_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_register_deallocation_callback_begin`) */
void barectf_hsa_api_trace_hsa_amd_register_deallocation_callback_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__callback,
	uint64_t p__user_data);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_register_deallocation_callback_end`) */
void barectf_hsa_api_trace_hsa_amd_register_deallocation_callback_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_register_system_event_handler_begin`) */
void barectf_hsa_api_trace_hsa_amd_register_system_event_handler_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_register_system_event_handler_end`) */
void barectf_hsa_api_trace_hsa_amd_register_system_event_handler_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_runtime_queue_create_register_begin`) */
void barectf_hsa_api_trace_hsa_amd_runtime_queue_create_register_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__callback,
	uint64_t p__user_data);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_runtime_queue_create_register_end`) */
void barectf_hsa_api_trace_hsa_amd_runtime_queue_create_register_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_signal_async_handler_begin`) */
void barectf_hsa_api_trace_hsa_amd_signal_async_handler_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int32_t p__cond,
	int64_t p__value,
	uint64_t p__handler,
	uint64_t p__arg);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_signal_async_handler_end`) */
void barectf_hsa_api_trace_hsa_amd_signal_async_handler_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_signal_create_begin`) */
void barectf_hsa_api_trace_hsa_amd_signal_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int64_t p__initial_value,
	uint32_t p__num_consumers,
	uint64_t p__consumers,
	uint64_t p__attributes,
	uint64_t p__signal);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_signal_create_end`) */
void barectf_hsa_api_trace_hsa_amd_signal_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_signal_value_pointer_begin`) */
void barectf_hsa_api_trace_hsa_amd_signal_value_pointer_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	uint64_t p__value_ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_signal_value_pointer_end`) */
void barectf_hsa_api_trace_hsa_amd_signal_value_pointer_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_signal_wait_all_begin`) */
void barectf_hsa_api_trace_hsa_amd_signal_wait_all_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint32_t p__signal_count,
	uint64_t p__signals,
	uint64_t p__conds,
	uint64_t p__values,
	uint64_t p__timeout_hint,
	int32_t p__wait_hint,
	uint64_t p__satisfying_values);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_signal_wait_all_end`) */
void barectf_hsa_api_trace_hsa_amd_signal_wait_all_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_signal_wait_any_begin`) */
void barectf_hsa_api_trace_hsa_amd_signal_wait_any_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint32_t p__signal_count,
	uint64_t p__signals,
	uint64_t p__conds,
	uint64_t p__values,
	uint64_t p__timeout_hint,
	int32_t p__wait_hint,
	uint64_t p__satisfying_value);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_signal_wait_any_end`) */
void barectf_hsa_api_trace_hsa_amd_signal_wait_any_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_spm_acquire_begin`) */
void barectf_hsa_api_trace_hsa_amd_spm_acquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__preferred_agent__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_spm_acquire_end`) */
void barectf_hsa_api_trace_hsa_amd_spm_acquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_spm_release_begin`) */
void barectf_hsa_api_trace_hsa_amd_spm_release_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__preferred_agent__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_spm_release_end`) */
void barectf_hsa_api_trace_hsa_amd_spm_release_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_spm_set_dest_buffer_begin`) */
void barectf_hsa_api_trace_hsa_amd_spm_set_dest_buffer_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__preferred_agent__handle,
	uint64_t p__size_in_bytes,
	uint64_t p__timeout,
	uint64_t p__size_copied,
	uint64_t p__dest,
	uint64_t p__is_data_loss);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_spm_set_dest_buffer_end`) */
void barectf_hsa_api_trace_hsa_amd_spm_set_dest_buffer_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_svm_attributes_get_begin`) */
void barectf_hsa_api_trace_hsa_amd_svm_attributes_get_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__size,
	uint64_t p__attribute_list,
	uint64_t p__attribute_count);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_svm_attributes_get_end`) */
void barectf_hsa_api_trace_hsa_amd_svm_attributes_get_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_svm_attributes_set_begin`) */
void barectf_hsa_api_trace_hsa_amd_svm_attributes_set_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__size,
	uint64_t p__attribute_list,
	uint64_t p__attribute_count);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_svm_attributes_set_end`) */
void barectf_hsa_api_trace_hsa_amd_svm_attributes_set_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_svm_prefetch_async_begin`) */
void barectf_hsa_api_trace_hsa_amd_svm_prefetch_async_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__size,
	uint64_t p__agent__handle,
	uint32_t p__num_dep_signals,
	uint64_t p__dep_signals,
	uint64_t p__completion_signal__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_svm_prefetch_async_end`) */
void barectf_hsa_api_trace_hsa_amd_svm_prefetch_async_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_address_free_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_address_free_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__va,
	uint64_t p__size);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_address_free_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_address_free_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_address_reserve_align_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_address_reserve_align_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__va,
	uint64_t p__size,
	uint64_t p__address,
	uint64_t p__alignment,
	uint64_t p__flags);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_address_reserve_align_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_address_reserve_align_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_address_reserve_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_address_reserve_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__va,
	uint64_t p__size,
	uint64_t p__address,
	uint64_t p__flags);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_address_reserve_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_address_reserve_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_export_shareable_handle_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_export_shareable_handle_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__dmabuf_fd,
	uint64_t p__handle__handle,
	uint64_t p__flags);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_export_shareable_handle_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_export_shareable_handle_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_get_access_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_get_access_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__va,
	uint64_t p__perms,
	uint64_t p__agent_handle__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_get_access_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_get_access_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_get_alloc_properties_from_handle_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_get_alloc_properties_from_handle_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__memory_handle__handle,
	uint64_t p__pool,
	uint64_t p__type);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_get_alloc_properties_from_handle_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_get_alloc_properties_from_handle_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_handle_create_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_handle_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__pool__handle,
	uint64_t p__size,
	int32_t p__type,
	uint64_t p__flags,
	uint64_t p__memory_handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_handle_create_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_handle_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_handle_release_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_handle_release_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__memory_handle__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_handle_release_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_handle_release_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_import_shareable_handle_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_import_shareable_handle_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__dmabuf_fd,
	uint64_t p__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_import_shareable_handle_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_import_shareable_handle_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_map_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_map_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__va,
	uint64_t p__size,
	uint64_t p__in_offset,
	uint64_t p__memory_handle__handle,
	uint64_t p__flags);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_map_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_map_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_retain_alloc_handle_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_retain_alloc_handle_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__memory_handle,
	uint64_t p__addr);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_retain_alloc_handle_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_retain_alloc_handle_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_set_access_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_set_access_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__va,
	uint64_t p__size,
	uint64_t p__desc,
	uint64_t p__desc_cnt);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_set_access_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_set_access_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_unmap_begin`) */
void barectf_hsa_api_trace_hsa_amd_vmem_unmap_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__va,
	uint64_t p__size);

/* Trace (data stream type `hsa_api`, event record type `hsa_amd_vmem_unmap_end`) */
void barectf_hsa_api_trace_hsa_amd_vmem_unmap_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_cache_get_info_begin`) */
void barectf_hsa_api_trace_hsa_cache_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__cache__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_cache_get_info_end`) */
void barectf_hsa_api_trace_hsa_cache_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_deserialize_begin`) */
void barectf_hsa_api_trace_hsa_code_object_deserialize_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__serialized_code_object,
	uint64_t p__serialized_code_object_size,
	const char *p__options,
	uint64_t p__code_object);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_deserialize_end`) */
void barectf_hsa_api_trace_hsa_code_object_deserialize_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_destroy_begin`) */
void barectf_hsa_api_trace_hsa_code_object_destroy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__code_object__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_destroy_end`) */
void barectf_hsa_api_trace_hsa_code_object_destroy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_get_info_begin`) */
void barectf_hsa_api_trace_hsa_code_object_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__code_object__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_get_info_end`) */
void barectf_hsa_api_trace_hsa_code_object_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_get_symbol_begin`) */
void barectf_hsa_api_trace_hsa_code_object_get_symbol_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__code_object__handle,
	const char *p__symbol_name,
	uint64_t p__symbol);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_get_symbol_end`) */
void barectf_hsa_api_trace_hsa_code_object_get_symbol_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_get_symbol_from_name_begin`) */
void barectf_hsa_api_trace_hsa_code_object_get_symbol_from_name_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__code_object__handle,
	const char *p__module_name,
	const char *p__symbol_name,
	uint64_t p__symbol);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_get_symbol_from_name_end`) */
void barectf_hsa_api_trace_hsa_code_object_get_symbol_from_name_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_iterate_symbols_begin`) */
void barectf_hsa_api_trace_hsa_code_object_iterate_symbols_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__code_object__handle,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_iterate_symbols_end`) */
void barectf_hsa_api_trace_hsa_code_object_iterate_symbols_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_reader_create_from_file_begin`) */
void barectf_hsa_api_trace_hsa_code_object_reader_create_from_file_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__file,
	uint64_t p__code_object_reader);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_reader_create_from_file_end`) */
void barectf_hsa_api_trace_hsa_code_object_reader_create_from_file_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_reader_create_from_memory_begin`) */
void barectf_hsa_api_trace_hsa_code_object_reader_create_from_memory_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__code_object,
	uint64_t p__size,
	uint64_t p__code_object_reader);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_reader_create_from_memory_end`) */
void barectf_hsa_api_trace_hsa_code_object_reader_create_from_memory_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_reader_destroy_begin`) */
void barectf_hsa_api_trace_hsa_code_object_reader_destroy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__code_object_reader__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_reader_destroy_end`) */
void barectf_hsa_api_trace_hsa_code_object_reader_destroy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_serialize_begin`) */
void barectf_hsa_api_trace_hsa_code_object_serialize_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__code_object__handle,
	uint64_t p__alloc_callback,
	uint64_t p__callback_data__handle,
	const char *p__options,
	uint64_t p__serialized_code_object,
	uint64_t p__serialized_code_object_size);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_object_serialize_end`) */
void barectf_hsa_api_trace_hsa_code_object_serialize_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_symbol_get_info_begin`) */
void barectf_hsa_api_trace_hsa_code_symbol_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__code_symbol__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_code_symbol_get_info_end`) */
void barectf_hsa_api_trace_hsa_code_symbol_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_agent_global_variable_define_begin`) */
void barectf_hsa_api_trace_hsa_executable_agent_global_variable_define_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	uint64_t p__agent__handle,
	const char *p__variable_name,
	uint64_t p__address);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_agent_global_variable_define_end`) */
void barectf_hsa_api_trace_hsa_executable_agent_global_variable_define_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_create_alt_begin`) */
void barectf_hsa_api_trace_hsa_executable_create_alt_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__profile,
	int32_t p__default_float_rounding_mode,
	const char *p__options,
	uint64_t p__executable);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_create_alt_end`) */
void barectf_hsa_api_trace_hsa_executable_create_alt_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_create_begin`) */
void barectf_hsa_api_trace_hsa_executable_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__profile,
	int32_t p__executable_state,
	const char *p__options,
	uint64_t p__executable);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_create_end`) */
void barectf_hsa_api_trace_hsa_executable_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_destroy_begin`) */
void barectf_hsa_api_trace_hsa_executable_destroy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_destroy_end`) */
void barectf_hsa_api_trace_hsa_executable_destroy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_freeze_begin`) */
void barectf_hsa_api_trace_hsa_executable_freeze_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	const char *p__options);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_freeze_end`) */
void barectf_hsa_api_trace_hsa_executable_freeze_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_get_info_begin`) */
void barectf_hsa_api_trace_hsa_executable_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_get_info_end`) */
void barectf_hsa_api_trace_hsa_executable_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_get_symbol_begin`) */
void barectf_hsa_api_trace_hsa_executable_get_symbol_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	const char *p__module_name,
	const char *p__symbol_name,
	uint64_t p__agent__handle,
	int32_t p__call_convention,
	uint64_t p__symbol);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_get_symbol_by_name_begin`) */
void barectf_hsa_api_trace_hsa_executable_get_symbol_by_name_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	const char *p__symbol_name,
	uint64_t p__agent,
	uint64_t p__symbol);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_get_symbol_by_name_end`) */
void barectf_hsa_api_trace_hsa_executable_get_symbol_by_name_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_get_symbol_end`) */
void barectf_hsa_api_trace_hsa_executable_get_symbol_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_global_variable_define_begin`) */
void barectf_hsa_api_trace_hsa_executable_global_variable_define_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	const char *p__variable_name,
	uint64_t p__address);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_global_variable_define_end`) */
void barectf_hsa_api_trace_hsa_executable_global_variable_define_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_iterate_agent_symbols_begin`) */
void barectf_hsa_api_trace_hsa_executable_iterate_agent_symbols_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	uint64_t p__agent__handle,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_iterate_agent_symbols_end`) */
void barectf_hsa_api_trace_hsa_executable_iterate_agent_symbols_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_iterate_program_symbols_begin`) */
void barectf_hsa_api_trace_hsa_executable_iterate_program_symbols_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_iterate_program_symbols_end`) */
void barectf_hsa_api_trace_hsa_executable_iterate_program_symbols_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_iterate_symbols_begin`) */
void barectf_hsa_api_trace_hsa_executable_iterate_symbols_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_iterate_symbols_end`) */
void barectf_hsa_api_trace_hsa_executable_iterate_symbols_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_load_agent_code_object_begin`) */
void barectf_hsa_api_trace_hsa_executable_load_agent_code_object_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	uint64_t p__agent__handle,
	uint64_t p__code_object_reader__handle,
	const char *p__options,
	uint64_t p__loaded_code_object);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_load_agent_code_object_end`) */
void barectf_hsa_api_trace_hsa_executable_load_agent_code_object_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_load_code_object_begin`) */
void barectf_hsa_api_trace_hsa_executable_load_code_object_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	uint64_t p__agent__handle,
	uint64_t p__code_object__handle,
	const char *p__options);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_load_code_object_end`) */
void barectf_hsa_api_trace_hsa_executable_load_code_object_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_load_program_code_object_begin`) */
void barectf_hsa_api_trace_hsa_executable_load_program_code_object_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	uint64_t p__code_object_reader__handle,
	const char *p__options,
	uint64_t p__loaded_code_object);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_load_program_code_object_end`) */
void barectf_hsa_api_trace_hsa_executable_load_program_code_object_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_readonly_variable_define_begin`) */
void barectf_hsa_api_trace_hsa_executable_readonly_variable_define_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	uint64_t p__agent__handle,
	const char *p__variable_name,
	uint64_t p__address);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_readonly_variable_define_end`) */
void barectf_hsa_api_trace_hsa_executable_readonly_variable_define_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_symbol_get_info_begin`) */
void barectf_hsa_api_trace_hsa_executable_symbol_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable_symbol__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_symbol_get_info_end`) */
void barectf_hsa_api_trace_hsa_executable_symbol_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_validate_alt_begin`) */
void barectf_hsa_api_trace_hsa_executable_validate_alt_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	const char *p__options,
	uint64_t p__result);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_validate_alt_end`) */
void barectf_hsa_api_trace_hsa_executable_validate_alt_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_validate_begin`) */
void barectf_hsa_api_trace_hsa_executable_validate_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__executable__handle,
	uint64_t p__result);

/* Trace (data stream type `hsa_api`, event record type `hsa_executable_validate_end`) */
void barectf_hsa_api_trace_hsa_executable_validate_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_clear_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_clear_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__image__handle,
	uint64_t p__data,
	uint64_t p__image_region);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_clear_end`) */
void barectf_hsa_api_trace_hsa_ext_image_clear_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_copy_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_copy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__src_image__handle,
	uint64_t p__src_offset,
	uint64_t p__dst_image__handle,
	uint64_t p__dst_offset,
	uint64_t p__range);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_copy_end`) */
void barectf_hsa_api_trace_hsa_ext_image_copy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_create_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__image_descriptor,
	uint64_t p__image_data,
	int32_t p__access_permission,
	uint64_t p__image);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_create_end`) */
void barectf_hsa_api_trace_hsa_ext_image_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_create_with_layout_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_create_with_layout_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__image_descriptor,
	uint64_t p__image_data,
	int32_t p__access_permission,
	int32_t p__image_data_layout,
	uint64_t p__image_data_row_pitch,
	uint64_t p__image_data_slice_pitch,
	uint64_t p__image);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_create_with_layout_end`) */
void barectf_hsa_api_trace_hsa_ext_image_create_with_layout_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_data_get_info_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_data_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__image_descriptor,
	int32_t p__access_permission,
	uint64_t p__image_data_info);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_data_get_info_end`) */
void barectf_hsa_api_trace_hsa_ext_image_data_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_data_get_info_with_layout_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_data_get_info_with_layout_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__image_descriptor,
	int32_t p__access_permission,
	int32_t p__image_data_layout,
	uint64_t p__image_data_row_pitch,
	uint64_t p__image_data_slice_pitch,
	uint64_t p__image_data_info);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_data_get_info_with_layout_end`) */
void barectf_hsa_api_trace_hsa_ext_image_data_get_info_with_layout_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_destroy_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_destroy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__image__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_destroy_end`) */
void barectf_hsa_api_trace_hsa_ext_image_destroy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_export_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_export_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__src_image__handle,
	uint64_t p__dst_memory,
	uint64_t p__dst_row_pitch,
	uint64_t p__dst_slice_pitch,
	uint64_t p__image_region);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_export_end`) */
void barectf_hsa_api_trace_hsa_ext_image_export_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_get_capability_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_get_capability_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	int32_t p__geometry,
	uint64_t p__image_format,
	uint64_t p__capability_mask);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_get_capability_end`) */
void barectf_hsa_api_trace_hsa_ext_image_get_capability_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_get_capability_with_layout_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_get_capability_with_layout_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	int32_t p__geometry,
	uint64_t p__image_format,
	int32_t p__image_data_layout,
	uint64_t p__capability_mask);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_get_capability_with_layout_end`) */
void barectf_hsa_api_trace_hsa_ext_image_get_capability_with_layout_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_import_begin`) */
void barectf_hsa_api_trace_hsa_ext_image_import_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__src_memory,
	uint64_t p__src_row_pitch,
	uint64_t p__src_slice_pitch,
	uint64_t p__dst_image__handle,
	uint64_t p__image_region);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_image_import_end`) */
void barectf_hsa_api_trace_hsa_ext_image_import_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_sampler_create_begin`) */
void barectf_hsa_api_trace_hsa_ext_sampler_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__sampler_descriptor,
	uint64_t p__sampler);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_sampler_create_end`) */
void barectf_hsa_api_trace_hsa_ext_sampler_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_sampler_create_v2_begin`) */
void barectf_hsa_api_trace_hsa_ext_sampler_create_v2_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__sampler_descriptor,
	uint64_t p__sampler);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_sampler_create_v2_end`) */
void barectf_hsa_api_trace_hsa_ext_sampler_create_v2_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_sampler_destroy_begin`) */
void barectf_hsa_api_trace_hsa_ext_sampler_destroy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint64_t p__sampler__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_ext_sampler_destroy_end`) */
void barectf_hsa_api_trace_hsa_ext_sampler_destroy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_extension_get_name_begin`) */
void barectf_hsa_api_trace_hsa_extension_get_name_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint16_t p__extension,
	uint64_t p__name);

/* Trace (data stream type `hsa_api`, event record type `hsa_extension_get_name_end`) */
void barectf_hsa_api_trace_hsa_extension_get_name_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_init_begin`) */
void barectf_hsa_api_trace_hsa_init_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_init_end`) */
void barectf_hsa_api_trace_hsa_init_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_compatible_begin`) */
void barectf_hsa_api_trace_hsa_isa_compatible_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__code_object_isa__handle,
	uint64_t p__agent_isa__handle,
	uint64_t p__result);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_compatible_end`) */
void barectf_hsa_api_trace_hsa_isa_compatible_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_from_name_begin`) */
void barectf_hsa_api_trace_hsa_isa_from_name_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	const char *p__name,
	uint64_t p__isa);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_from_name_end`) */
void barectf_hsa_api_trace_hsa_isa_from_name_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_get_exception_policies_begin`) */
void barectf_hsa_api_trace_hsa_isa_get_exception_policies_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__isa__handle,
	int32_t p__profile,
	uint64_t p__mask);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_get_exception_policies_end`) */
void barectf_hsa_api_trace_hsa_isa_get_exception_policies_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_get_info_alt_begin`) */
void barectf_hsa_api_trace_hsa_isa_get_info_alt_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__isa__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_get_info_alt_end`) */
void barectf_hsa_api_trace_hsa_isa_get_info_alt_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_get_info_begin`) */
void barectf_hsa_api_trace_hsa_isa_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__isa__handle,
	int32_t p__attribute,
	uint32_t p__index,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_get_info_end`) */
void barectf_hsa_api_trace_hsa_isa_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_get_round_method_begin`) */
void barectf_hsa_api_trace_hsa_isa_get_round_method_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__isa__handle,
	int32_t p__fp_type,
	int32_t p__flush_mode,
	uint64_t p__round_method);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_get_round_method_end`) */
void barectf_hsa_api_trace_hsa_isa_get_round_method_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_iterate_wavefronts_begin`) */
void barectf_hsa_api_trace_hsa_isa_iterate_wavefronts_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__isa__handle,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_isa_iterate_wavefronts_end`) */
void barectf_hsa_api_trace_hsa_isa_iterate_wavefronts_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_iterate_agents_begin`) */
void barectf_hsa_api_trace_hsa_iterate_agents_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__callback,
	uint64_t p__data);

/* Trace (data stream type `hsa_api`, event record type `hsa_iterate_agents_end`) */
void barectf_hsa_api_trace_hsa_iterate_agents_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_allocate_begin`) */
void barectf_hsa_api_trace_hsa_memory_allocate_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__region__handle,
	uint64_t p__size,
	uint64_t p__ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_allocate_end`) */
void barectf_hsa_api_trace_hsa_memory_allocate_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_assign_agent_begin`) */
void barectf_hsa_api_trace_hsa_memory_assign_agent_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__agent__handle,
	int32_t p__access);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_assign_agent_end`) */
void barectf_hsa_api_trace_hsa_memory_assign_agent_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_copy_begin`) */
void barectf_hsa_api_trace_hsa_memory_copy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__dst,
	uint64_t p__src,
	uint64_t p__size);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_copy_end`) */
void barectf_hsa_api_trace_hsa_memory_copy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_deregister_begin`) */
void barectf_hsa_api_trace_hsa_memory_deregister_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__size);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_deregister_end`) */
void barectf_hsa_api_trace_hsa_memory_deregister_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_free_begin`) */
void barectf_hsa_api_trace_hsa_memory_free_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_free_end`) */
void barectf_hsa_api_trace_hsa_memory_free_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_register_begin`) */
void barectf_hsa_api_trace_hsa_memory_register_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__ptr,
	uint64_t p__size);

/* Trace (data stream type `hsa_api`, event record type `hsa_memory_register_end`) */
void barectf_hsa_api_trace_hsa_memory_register_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_add_write_index_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_queue_add_write_index_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_add_write_index_relaxed_end`) */
void barectf_hsa_api_trace_hsa_queue_add_write_index_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_add_write_index_scacq_screl_begin`) */
void barectf_hsa_api_trace_hsa_queue_add_write_index_scacq_screl_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_add_write_index_scacq_screl_end`) */
void barectf_hsa_api_trace_hsa_queue_add_write_index_scacq_screl_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_add_write_index_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_queue_add_write_index_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_add_write_index_scacquire_end`) */
void barectf_hsa_api_trace_hsa_queue_add_write_index_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_add_write_index_screlease_begin`) */
void barectf_hsa_api_trace_hsa_queue_add_write_index_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_add_write_index_screlease_end`) */
void barectf_hsa_api_trace_hsa_queue_add_write_index_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_cas_write_index_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_queue_cas_write_index_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__expected,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_cas_write_index_relaxed_end`) */
void barectf_hsa_api_trace_hsa_queue_cas_write_index_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_cas_write_index_scacq_screl_begin`) */
void barectf_hsa_api_trace_hsa_queue_cas_write_index_scacq_screl_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__expected,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_cas_write_index_scacq_screl_end`) */
void barectf_hsa_api_trace_hsa_queue_cas_write_index_scacq_screl_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_cas_write_index_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_queue_cas_write_index_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__expected,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_cas_write_index_scacquire_end`) */
void barectf_hsa_api_trace_hsa_queue_cas_write_index_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_cas_write_index_screlease_begin`) */
void barectf_hsa_api_trace_hsa_queue_cas_write_index_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__expected,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_cas_write_index_screlease_end`) */
void barectf_hsa_api_trace_hsa_queue_cas_write_index_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_create_begin`) */
void barectf_hsa_api_trace_hsa_queue_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__agent__handle,
	uint32_t p__size,
	uint32_t p__type,
	uint64_t p__callback,
	uint64_t p__data,
	uint32_t p__private_segment_size,
	uint32_t p__group_segment_size,
	uint64_t p__queue);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_create_end`) */
void barectf_hsa_api_trace_hsa_queue_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_destroy_begin`) */
void barectf_hsa_api_trace_hsa_queue_destroy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_destroy_end`) */
void barectf_hsa_api_trace_hsa_queue_destroy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_inactivate_begin`) */
void barectf_hsa_api_trace_hsa_queue_inactivate_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_inactivate_end`) */
void barectf_hsa_api_trace_hsa_queue_inactivate_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_load_read_index_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_queue_load_read_index_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_load_read_index_relaxed_end`) */
void barectf_hsa_api_trace_hsa_queue_load_read_index_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_load_read_index_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_queue_load_read_index_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_load_read_index_scacquire_end`) */
void barectf_hsa_api_trace_hsa_queue_load_read_index_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_load_write_index_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_queue_load_write_index_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_load_write_index_relaxed_end`) */
void barectf_hsa_api_trace_hsa_queue_load_write_index_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_load_write_index_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_queue_load_write_index_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_load_write_index_scacquire_end`) */
void barectf_hsa_api_trace_hsa_queue_load_write_index_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_store_read_index_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_queue_store_read_index_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_store_read_index_relaxed_end`) */
void barectf_hsa_api_trace_hsa_queue_store_read_index_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_store_read_index_screlease_begin`) */
void barectf_hsa_api_trace_hsa_queue_store_read_index_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_store_read_index_screlease_end`) */
void barectf_hsa_api_trace_hsa_queue_store_read_index_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_store_write_index_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_queue_store_write_index_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_store_write_index_relaxed_end`) */
void barectf_hsa_api_trace_hsa_queue_store_write_index_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_store_write_index_screlease_begin`) */
void barectf_hsa_api_trace_hsa_queue_store_write_index_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__queue,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_queue_store_write_index_screlease_end`) */
void barectf_hsa_api_trace_hsa_queue_store_write_index_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_region_get_info_begin`) */
void barectf_hsa_api_trace_hsa_region_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__region__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_region_get_info_end`) */
void barectf_hsa_api_trace_hsa_region_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_shut_down_begin`) */
void barectf_hsa_api_trace_hsa_shut_down_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_shut_down_end`) */
void barectf_hsa_api_trace_hsa_shut_down_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_add_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_add_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_add_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_add_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_add_scacq_screl_begin`) */
void barectf_hsa_api_trace_hsa_signal_add_scacq_screl_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_add_scacq_screl_end`) */
void barectf_hsa_api_trace_hsa_signal_add_scacq_screl_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_add_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_signal_add_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_add_scacquire_end`) */
void barectf_hsa_api_trace_hsa_signal_add_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_add_screlease_begin`) */
void barectf_hsa_api_trace_hsa_signal_add_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_add_screlease_end`) */
void barectf_hsa_api_trace_hsa_signal_add_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_and_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_and_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_and_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_and_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_and_scacq_screl_begin`) */
void barectf_hsa_api_trace_hsa_signal_and_scacq_screl_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_and_scacq_screl_end`) */
void barectf_hsa_api_trace_hsa_signal_and_scacq_screl_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_and_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_signal_and_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_and_scacquire_end`) */
void barectf_hsa_api_trace_hsa_signal_and_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_and_screlease_begin`) */
void barectf_hsa_api_trace_hsa_signal_and_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_and_screlease_end`) */
void barectf_hsa_api_trace_hsa_signal_and_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_cas_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_cas_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__expected,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_cas_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_cas_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_cas_scacq_screl_begin`) */
void barectf_hsa_api_trace_hsa_signal_cas_scacq_screl_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__expected,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_cas_scacq_screl_end`) */
void barectf_hsa_api_trace_hsa_signal_cas_scacq_screl_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_cas_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_signal_cas_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__expected,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_cas_scacquire_end`) */
void barectf_hsa_api_trace_hsa_signal_cas_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_cas_screlease_begin`) */
void barectf_hsa_api_trace_hsa_signal_cas_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__expected,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_cas_screlease_end`) */
void barectf_hsa_api_trace_hsa_signal_cas_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_create_begin`) */
void barectf_hsa_api_trace_hsa_signal_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int64_t p__initial_value,
	uint32_t p__num_consumers,
	uint64_t p__consumers,
	uint64_t p__signal);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_create_end`) */
void barectf_hsa_api_trace_hsa_signal_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_destroy_begin`) */
void barectf_hsa_api_trace_hsa_signal_destroy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_destroy_end`) */
void barectf_hsa_api_trace_hsa_signal_destroy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_exchange_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_exchange_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_exchange_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_exchange_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_exchange_scacq_screl_begin`) */
void barectf_hsa_api_trace_hsa_signal_exchange_scacq_screl_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_exchange_scacq_screl_end`) */
void barectf_hsa_api_trace_hsa_signal_exchange_scacq_screl_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_exchange_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_signal_exchange_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_exchange_scacquire_end`) */
void barectf_hsa_api_trace_hsa_signal_exchange_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_exchange_screlease_begin`) */
void barectf_hsa_api_trace_hsa_signal_exchange_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_exchange_screlease_end`) */
void barectf_hsa_api_trace_hsa_signal_exchange_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_group_create_begin`) */
void barectf_hsa_api_trace_hsa_signal_group_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint32_t p__num_signals,
	uint64_t p__signals,
	uint32_t p__num_consumers,
	uint64_t p__consumers,
	uint64_t p__signal_group);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_group_create_end`) */
void barectf_hsa_api_trace_hsa_signal_group_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_group_destroy_begin`) */
void barectf_hsa_api_trace_hsa_signal_group_destroy_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal_group__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_group_destroy_end`) */
void barectf_hsa_api_trace_hsa_signal_group_destroy_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_group_wait_any_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_group_wait_any_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal_group__handle,
	uint64_t p__conditions,
	uint64_t p__compare_values,
	int32_t p__wait_state_hint,
	uint64_t p__signal,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_group_wait_any_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_group_wait_any_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_group_wait_any_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_signal_group_wait_any_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal_group__handle,
	uint64_t p__conditions,
	uint64_t p__compare_values,
	int32_t p__wait_state_hint,
	uint64_t p__signal,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_group_wait_any_scacquire_end`) */
void barectf_hsa_api_trace_hsa_signal_group_wait_any_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_load_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_load_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_load_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_load_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_load_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_signal_load_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_load_scacquire_end`) */
void barectf_hsa_api_trace_hsa_signal_load_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_or_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_or_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_or_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_or_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_or_scacq_screl_begin`) */
void barectf_hsa_api_trace_hsa_signal_or_scacq_screl_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_or_scacq_screl_end`) */
void barectf_hsa_api_trace_hsa_signal_or_scacq_screl_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_or_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_signal_or_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_or_scacquire_end`) */
void barectf_hsa_api_trace_hsa_signal_or_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_or_screlease_begin`) */
void barectf_hsa_api_trace_hsa_signal_or_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_or_screlease_end`) */
void barectf_hsa_api_trace_hsa_signal_or_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_silent_store_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_silent_store_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_silent_store_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_silent_store_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_silent_store_screlease_begin`) */
void barectf_hsa_api_trace_hsa_signal_silent_store_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_silent_store_screlease_end`) */
void barectf_hsa_api_trace_hsa_signal_silent_store_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_store_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_store_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_store_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_store_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_store_screlease_begin`) */
void barectf_hsa_api_trace_hsa_signal_store_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_store_screlease_end`) */
void barectf_hsa_api_trace_hsa_signal_store_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_subtract_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_subtract_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_subtract_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_subtract_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_subtract_scacq_screl_begin`) */
void barectf_hsa_api_trace_hsa_signal_subtract_scacq_screl_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_subtract_scacq_screl_end`) */
void barectf_hsa_api_trace_hsa_signal_subtract_scacq_screl_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_subtract_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_signal_subtract_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_subtract_scacquire_end`) */
void barectf_hsa_api_trace_hsa_signal_subtract_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_subtract_screlease_begin`) */
void barectf_hsa_api_trace_hsa_signal_subtract_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_subtract_screlease_end`) */
void barectf_hsa_api_trace_hsa_signal_subtract_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_wait_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_wait_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int32_t p__condition,
	int64_t p__compare_value,
	uint64_t p__timeout_hint,
	int32_t p__wait_state_hint);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_wait_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_wait_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_wait_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_signal_wait_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int32_t p__condition,
	int64_t p__compare_value,
	uint64_t p__timeout_hint,
	int32_t p__wait_state_hint);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_wait_scacquire_end`) */
void barectf_hsa_api_trace_hsa_signal_wait_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_xor_relaxed_begin`) */
void barectf_hsa_api_trace_hsa_signal_xor_relaxed_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_xor_relaxed_end`) */
void barectf_hsa_api_trace_hsa_signal_xor_relaxed_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_xor_scacq_screl_begin`) */
void barectf_hsa_api_trace_hsa_signal_xor_scacq_screl_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_xor_scacq_screl_end`) */
void barectf_hsa_api_trace_hsa_signal_xor_scacq_screl_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_xor_scacquire_begin`) */
void barectf_hsa_api_trace_hsa_signal_xor_scacquire_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_xor_scacquire_end`) */
void barectf_hsa_api_trace_hsa_signal_xor_scacquire_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_xor_screlease_begin`) */
void barectf_hsa_api_trace_hsa_signal_xor_screlease_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__signal__handle,
	int64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_signal_xor_screlease_end`) */
void barectf_hsa_api_trace_hsa_signal_xor_screlease_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id);

/* Trace (data stream type `hsa_api`, event record type `hsa_soft_queue_create_begin`) */
void barectf_hsa_api_trace_hsa_soft_queue_create_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__region__handle,
	uint32_t p__size,
	uint32_t p__type,
	uint32_t p__features,
	uint64_t p__doorbell_signal__handle,
	uint64_t p__queue);

/* Trace (data stream type `hsa_api`, event record type `hsa_soft_queue_create_end`) */
void barectf_hsa_api_trace_hsa_soft_queue_create_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_status_string_begin`) */
void barectf_hsa_api_trace_hsa_status_string_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__status,
	uint64_t p__status_string);

/* Trace (data stream type `hsa_api`, event record type `hsa_status_string_end`) */
void barectf_hsa_api_trace_hsa_status_string_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_system_extension_supported_begin`) */
void barectf_hsa_api_trace_hsa_system_extension_supported_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint16_t p__extension,
	uint16_t p__version_major,
	uint16_t p__version_minor,
	uint64_t p__result);

/* Trace (data stream type `hsa_api`, event record type `hsa_system_extension_supported_end`) */
void barectf_hsa_api_trace_hsa_system_extension_supported_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_system_get_extension_table_begin`) */
void barectf_hsa_api_trace_hsa_system_get_extension_table_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint16_t p__extension,
	uint16_t p__version_major,
	uint16_t p__version_minor,
	uint64_t p__table);

/* Trace (data stream type `hsa_api`, event record type `hsa_system_get_extension_table_end`) */
void barectf_hsa_api_trace_hsa_system_get_extension_table_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_system_get_info_begin`) */
void barectf_hsa_api_trace_hsa_system_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_system_get_info_end`) */
void barectf_hsa_api_trace_hsa_system_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_system_get_major_extension_table_begin`) */
void barectf_hsa_api_trace_hsa_system_get_major_extension_table_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint16_t p__extension,
	uint16_t p__version_major,
	uint64_t p__table_length,
	uint64_t p__table);

/* Trace (data stream type `hsa_api`, event record type `hsa_system_get_major_extension_table_end`) */
void barectf_hsa_api_trace_hsa_system_get_major_extension_table_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_system_major_extension_supported_begin`) */
void barectf_hsa_api_trace_hsa_system_major_extension_supported_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint16_t p__extension,
	uint16_t p__version_major,
	uint64_t p__version_minor,
	uint64_t p__result);

/* Trace (data stream type `hsa_api`, event record type `hsa_system_major_extension_supported_end`) */
void barectf_hsa_api_trace_hsa_system_major_extension_supported_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);

/* Trace (data stream type `hsa_api`, event record type `hsa_wavefront_get_info_begin`) */
void barectf_hsa_api_trace_hsa_wavefront_get_info_begin(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	uint64_t p__wavefront__handle,
	int32_t p__attribute,
	uint64_t p__value);

/* Trace (data stream type `hsa_api`, event record type `hsa_wavefront_get_info_end`) */
void barectf_hsa_api_trace_hsa_wavefront_get_info_end(struct barectf_hsa_api_ctx *sctx,
	uint32_t cc__thread_id,
	uint32_t cc__queue_id,
	uint32_t cc__agent_id,
	uint64_t cc__correlation_id,
	int32_t p__retval);
/* Open packet for data stream type `hsa_handles` */
void barectf_hsa_handles_open_packet(
	struct barectf_hsa_handles_ctx *sctx);

/* Close packet for data stream type `hsa_handles` */
void barectf_hsa_handles_close_packet(struct barectf_hsa_handles_ctx *sctx);

/* Trace (data stream type `hsa_handles`, event record type `hsa_handle_type`) */
void barectf_hsa_handles_trace_hsa_handle_type(struct barectf_hsa_handles_ctx *sctx,
	uint64_t p__handle,
	uint8_t p__type);
/* Open packet for data stream type `profiler` */
void barectf_profiler_open_packet(
	struct barectf_profiler_ctx *sctx);

/* Close packet for data stream type `profiler` */
void barectf_profiler_close_packet(struct barectf_profiler_ctx *sctx);

/* Trace (data stream type `profiler`, event record type `profiler_record`) */
void barectf_profiler_trace_profiler_record(struct barectf_profiler_ctx *sctx,
	uint64_t cc__dispatch,
	uint64_t cc__gpu_id,
	uint64_t cc__queue_id,
	uint64_t cc__queue_index,
	uint32_t cc__process_id,
	uint32_t cc__thread_id,
	uint64_t cc__kernel_id,
	const char *cc__kernel_name,
	uint32_t cc____counter_names_len,
	const char * const *cc__counter_names,
	uint32_t cc____counter_values_len,
	const uint64_t *cc__counter_values);

/* Trace (data stream type `profiler`, event record type `profiler_record_with_kernel_properties`) */
void barectf_profiler_trace_profiler_record_with_kernel_properties(struct barectf_profiler_ctx *sctx,
	uint64_t cc__dispatch,
	uint64_t cc__gpu_id,
	uint64_t cc__queue_id,
	uint64_t cc__queue_index,
	uint32_t cc__process_id,
	uint32_t cc__thread_id,
	uint64_t cc__kernel_id,
	const char *cc__kernel_name,
	uint32_t cc____counter_names_len,
	const char * const *cc__counter_names,
	uint32_t cc____counter_values_len,
	const uint64_t *cc__counter_values,
	uint64_t p__grid_size,
	uint64_t p__workgroup_size,
	uint64_t p__lds_size,
	uint64_t p__scratch_size,
	uint64_t p__arch_vgpr_count,
	uint64_t p__accum_vgpr_count,
	uint64_t p__sgpr_count,
	uint64_t p__wave_size,
	uint64_t p__signal_handle);
/* Open packet for data stream type `roctx` */
void barectf_roctx_open_packet(
	struct barectf_roctx_ctx *sctx);

/* Close packet for data stream type `roctx` */
void barectf_roctx_close_packet(struct barectf_roctx_ctx *sctx);

/* Trace (data stream type `roctx`, event record type `roctx`) */
void barectf_roctx_trace_roctx(struct barectf_roctx_ctx *sctx,
	uint32_t cc__thread_id,
	int64_t p__id,
	const char *p__msg);

#ifdef __cplusplus
}
#endif

#endif /* _BARECTF_H */
