/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtNetwork.h"

#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtNetwork/qnetworkinformation.sip"
#include <qnetworkinformation.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"

#line 25 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstringview.sip"
#include <qstringview.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 154 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 47 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 50 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 53 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 277 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 56 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 254 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 59 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qobject.sip"
#include <qobject.h>
#line 62 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 65 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 68 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 71 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 135 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 74 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 154 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qtextstream.sip"
#include <qtextstream.h>
#line 79 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qthread.sip"
#include <qthread.h>
#line 82 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qanystringview.sip"
#include <qanystringview.h>
#line 85 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 25 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 88 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qregularexpression.sip"
#include <qregularexpression.h>
#line 91 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 94 "/build/pyqt6/src/pyqt6-6.10.1/build/QtNetwork/sipQtNetworkQNetworkInformation.cpp"


PyDoc_STRVAR(doc_QNetworkInformation_reachability, "reachability(self) -> QNetworkInformation.Reachability");

extern "C" {static PyObject *meth_QNetworkInformation_reachability(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_reachability(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInformation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInformation, &sipCpp))
        {
            ::QNetworkInformation::Reachability sipRes;

            sipRes = sipCpp->reachability();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QNetworkInformation_Reachability);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_reachability, doc_QNetworkInformation_reachability);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_backendName, "backendName(self) -> str");

extern "C" {static PyObject *meth_QNetworkInformation_backendName(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_backendName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInformation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInformation, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->backendName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_backendName, doc_QNetworkInformation_backendName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_supports, "supports(self, features: QNetworkInformation.Feature) -> bool");

extern "C" {static PyObject *meth_QNetworkInformation_supports(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_supports(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkInformation::Features* a0;
        int a0State = 0;
        const ::QNetworkInformation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QNetworkInformation, &sipCpp, sipType_QFlags_0100QNetworkInformation_Feature, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->supports(*a0);
            sipReleaseType(a0, sipType_QFlags_0100QNetworkInformation_Feature, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_supports, doc_QNetworkInformation_supports);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_load, "load(backend: str) -> bool\n"
"load(features: QNetworkInformation.Feature) -> bool");

extern "C" {static PyObject *meth_QNetworkInformation_load(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_load(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QStringView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1", &sipSelf, sipType_QStringView, &a0, &a0State, &a0UserState))
        {
            bool sipRes;

            sipRes = ::QNetworkInformation::load(*a0);
            sipReleaseTypeUS(a0, sipType_QStringView, a0State, a0UserState);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        ::QNetworkInformation::Features* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1", &sipSelf, sipType_QFlags_0100QNetworkInformation_Feature, &a0, &a0State))
        {
            bool sipRes;

            sipRes = ::QNetworkInformation::load(*a0);
            sipReleaseType(a0, sipType_QFlags_0100QNetworkInformation_Feature, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_load, doc_QNetworkInformation_load);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_availableBackends, "availableBackends() -> list[str]");

extern "C" {static PyObject *meth_QNetworkInformation_availableBackends(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_availableBackends(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(::QNetworkInformation::availableBackends());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_availableBackends, doc_QNetworkInformation_availableBackends);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_instance, "instance() -> QNetworkInformation|None");

extern "C" {static PyObject *meth_QNetworkInformation_instance(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_instance(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            ::QNetworkInformation*sipRes;

            sipRes = ::QNetworkInformation::instance();

            return sipConvertFromType(sipRes, sipType_QNetworkInformation, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_instance, doc_QNetworkInformation_instance);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_isBehindCaptivePortal, "isBehindCaptivePortal(self) -> bool");

extern "C" {static PyObject *meth_QNetworkInformation_isBehindCaptivePortal(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_isBehindCaptivePortal(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInformation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInformation, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isBehindCaptivePortal();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_isBehindCaptivePortal, doc_QNetworkInformation_isBehindCaptivePortal);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_transportMedium, "transportMedium(self) -> QNetworkInformation.TransportMedium");

extern "C" {static PyObject *meth_QNetworkInformation_transportMedium(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_transportMedium(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInformation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInformation, &sipCpp))
        {
            ::QNetworkInformation::TransportMedium sipRes;

            sipRes = sipCpp->transportMedium();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QNetworkInformation_TransportMedium);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_transportMedium, doc_QNetworkInformation_transportMedium);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_isMetered, "isMetered(self) -> bool");

extern "C" {static PyObject *meth_QNetworkInformation_isMetered(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_isMetered(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInformation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInformation, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isMetered();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_isMetered, doc_QNetworkInformation_isMetered);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_supportedFeatures, "supportedFeatures(self) -> QNetworkInformation.Feature");

extern "C" {static PyObject *meth_QNetworkInformation_supportedFeatures(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_supportedFeatures(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkInformation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkInformation, &sipCpp))
        {
            ::QNetworkInformation::Features*sipRes;

            sipRes = new ::QNetworkInformation::Features(sipCpp->supportedFeatures());

            return sipConvertFromNewType(sipRes, sipType_QFlags_0100QNetworkInformation_Feature, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_supportedFeatures, doc_QNetworkInformation_supportedFeatures);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_loadDefaultBackend, "loadDefaultBackend() -> bool");

extern "C" {static PyObject *meth_QNetworkInformation_loadDefaultBackend(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_loadDefaultBackend(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            bool sipRes;

            sipRes = ::QNetworkInformation::loadDefaultBackend();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_loadDefaultBackend, doc_QNetworkInformation_loadDefaultBackend);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_loadBackendByName, "loadBackendByName(backend: str) -> bool");

extern "C" {static PyObject *meth_QNetworkInformation_loadBackendByName(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_loadBackendByName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QStringView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1", &sipSelf, sipType_QStringView, &a0, &a0State, &a0UserState))
        {
            bool sipRes;

            sipRes = ::QNetworkInformation::loadBackendByName(*a0);
            sipReleaseTypeUS(a0, sipType_QStringView, a0State, a0UserState);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_loadBackendByName, doc_QNetworkInformation_loadBackendByName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkInformation_loadBackendByFeatures, "loadBackendByFeatures(features: QNetworkInformation.Feature) -> bool");

extern "C" {static PyObject *meth_QNetworkInformation_loadBackendByFeatures(PyObject *, PyObject *);}
static PyObject *meth_QNetworkInformation_loadBackendByFeatures(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkInformation::Features* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1", &sipSelf, sipType_QFlags_0100QNetworkInformation_Feature, &a0, &a0State))
        {
            bool sipRes;

            sipRes = ::QNetworkInformation::loadBackendByFeatures(*a0);
            sipReleaseType(a0, sipType_QFlags_0100QNetworkInformation_Feature, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkInformation, sipName_loadBackendByFeatures, doc_QNetworkInformation_loadBackendByFeatures);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QNetworkInformation(void *, const sipTypeDef *);}
static void *cast_QNetworkInformation(void *sipCppV, const sipTypeDef *targetType)
{
    ::QNetworkInformation *sipCpp = reinterpret_cast< ::QNetworkInformation *>(sipCppV);

    if (targetType == sipType_QNetworkInformation)
        return sipCppV;

    if (targetType == sipType_QObject)
        return static_cast< ::QObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QNetworkInformation(void *, int);}
static void release_QNetworkInformation(void *, int)
{
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QNetworkInformation[] = {{19, 0, 1}};


static PyMethodDef methods_QNetworkInformation[] = {
    {sipName_availableBackends, meth_QNetworkInformation_availableBackends, METH_VARARGS, doc_QNetworkInformation_availableBackends},
    {sipName_backendName, meth_QNetworkInformation_backendName, METH_VARARGS, doc_QNetworkInformation_backendName},
    {sipName_instance, meth_QNetworkInformation_instance, METH_VARARGS, doc_QNetworkInformation_instance},
    {sipName_isBehindCaptivePortal, meth_QNetworkInformation_isBehindCaptivePortal, METH_VARARGS, doc_QNetworkInformation_isBehindCaptivePortal},
    {sipName_isMetered, meth_QNetworkInformation_isMetered, METH_VARARGS, doc_QNetworkInformation_isMetered},
    {sipName_load, meth_QNetworkInformation_load, METH_VARARGS, doc_QNetworkInformation_load},
    {sipName_loadBackendByFeatures, meth_QNetworkInformation_loadBackendByFeatures, METH_VARARGS, doc_QNetworkInformation_loadBackendByFeatures},
    {sipName_loadBackendByName, meth_QNetworkInformation_loadBackendByName, METH_VARARGS, doc_QNetworkInformation_loadBackendByName},
    {sipName_loadDefaultBackend, meth_QNetworkInformation_loadDefaultBackend, METH_VARARGS, doc_QNetworkInformation_loadDefaultBackend},
    {sipName_reachability, meth_QNetworkInformation_reachability, METH_VARARGS, doc_QNetworkInformation_reachability},
    {sipName_supportedFeatures, meth_QNetworkInformation_supportedFeatures, METH_VARARGS, doc_QNetworkInformation_supportedFeatures},
    {sipName_supports, meth_QNetworkInformation_supports, METH_VARARGS, doc_QNetworkInformation_supports},
    {sipName_transportMedium, meth_QNetworkInformation_transportMedium, METH_VARARGS, doc_QNetworkInformation_transportMedium}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QNetworkInformation[] = {
    {sipName_Reachability, static_cast<int>(::QNetworkInformation::Feature::Reachability)},
    {sipName_CaptivePortal, static_cast<int>(::QNetworkInformation::Feature::CaptivePortal)},
    {sipName_TransportMedium, static_cast<int>(::QNetworkInformation::Feature::TransportMedium)},
    {sipName_Metered, static_cast<int>(::QNetworkInformation::Feature::Metered)},
    {sipName_Unknown, static_cast<int>(::QNetworkInformation::Reachability::Unknown)},
    {sipName_Disconnected, static_cast<int>(::QNetworkInformation::Reachability::Disconnected)},
    {sipName_Local, static_cast<int>(::QNetworkInformation::Reachability::Local)},
    {sipName_Site, static_cast<int>(::QNetworkInformation::Reachability::Site)},
    {sipName_Online, static_cast<int>(::QNetworkInformation::Reachability::Online)},
    {sipName_Unknown, static_cast<int>(::QNetworkInformation::TransportMedium::Unknown)},
    {sipName_Ethernet, static_cast<int>(::QNetworkInformation::TransportMedium::Ethernet)},
    {sipName_Cellular, static_cast<int>(::QNetworkInformation::TransportMedium::Cellular)},
    {sipName_WiFi, static_cast<int>(::QNetworkInformation::TransportMedium::WiFi)},
    {sipName_Bluetooth, static_cast<int>(::QNetworkInformation::TransportMedium::Bluetooth)},
    {0, 0}
};


/* Define this type's signals. */
static const pyqt6QtSignal signals_QNetworkInformation[] = {
    {"isMeteredChanged(bool)", "\1isMeteredChanged(self, isMetered: bool)", SIP_NULLPTR, SIP_NULLPTR},
    {"transportMediumChanged(QNetworkInformation::TransportMedium)", "\1transportMediumChanged(self, current: QNetworkInformation.TransportMedium)", SIP_NULLPTR, SIP_NULLPTR},
    {"isBehindCaptivePortalChanged(bool)", "\1isBehindCaptivePortalChanged(self, state: bool)", SIP_NULLPTR, SIP_NULLPTR},
    {"reachabilityChanged(QNetworkInformation::Reachability)", "\1reachabilityChanged(self, newReachability: QNetworkInformation.Reachability)", SIP_NULLPTR, SIP_NULLPTR},
    {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
};


static pyqt6ClassPluginDef plugin_QNetworkInformation = {
    &::QNetworkInformation::staticMetaObject,
    signals_QNetworkInformation,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtNetwork_QNetworkInformation = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QNetworkInformation,
        SIP_NULLPTR,
        &plugin_QNetworkInformation,
    },
    {
        sipNameNr_QNetworkInformation,
        {0, 0, 1},
        13, methods_QNetworkInformation,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QNetworkInformation, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    SIP_NULLPTR,
    -1,
    -1,
    supers_QNetworkInformation,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QNetworkInformation,
    cast_QNetworkInformation,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
