/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qlockfile.sip"
#include <qlockfile.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQLockFile.cpp"

#line 24 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQLockFile.cpp"


PyDoc_STRVAR(doc_QLockFile_lock, "lock(self) -> bool");

extern "C" {static PyObject *meth_QLockFile_lock(PyObject *, PyObject *);}
static PyObject *meth_QLockFile_lock(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QLockFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLockFile, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lock();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLockFile, sipName_lock, doc_QLockFile_lock);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLockFile_tryLock, "tryLock(self, timeout: int = 0) -> bool");

extern "C" {static PyObject *meth_QLockFile_tryLock(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QLockFile_tryLock(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0 = 0;
        ::QLockFile *sipCpp;

        static const char *sipKwdList[] = {
            sipName_timeout,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QLockFile, &sipCpp, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->tryLock(a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLockFile, sipName_tryLock, doc_QLockFile_tryLock);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLockFile_unlock, "unlock(self)");

extern "C" {static PyObject *meth_QLockFile_unlock(PyObject *, PyObject *);}
static PyObject *meth_QLockFile_unlock(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QLockFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLockFile, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->unlock();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QLockFile, sipName_unlock, doc_QLockFile_unlock);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLockFile_setStaleLockTime, "setStaleLockTime(self, a0: int)");

extern "C" {static PyObject *meth_QLockFile_setStaleLockTime(PyObject *, PyObject *);}
static PyObject *meth_QLockFile_setStaleLockTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QLockFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QLockFile, &sipCpp, &a0))
        {
            sipCpp->setStaleLockTime(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QLockFile, sipName_setStaleLockTime, doc_QLockFile_setStaleLockTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLockFile_staleLockTime, "staleLockTime(self) -> int");

extern "C" {static PyObject *meth_QLockFile_staleLockTime(PyObject *, PyObject *);}
static PyObject *meth_QLockFile_staleLockTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLockFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLockFile, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->staleLockTime();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLockFile, sipName_staleLockTime, doc_QLockFile_staleLockTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLockFile_isLocked, "isLocked(self) -> bool");

extern "C" {static PyObject *meth_QLockFile_isLocked(PyObject *, PyObject *);}
static PyObject *meth_QLockFile_isLocked(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLockFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLockFile, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isLocked();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLockFile, sipName_isLocked, doc_QLockFile_isLocked);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLockFile_getLockInfo, "getLockInfo(self) -> (bool, int, str, str)");

extern "C" {static PyObject *meth_QLockFile_getLockInfo(PyObject *, PyObject *);}
static PyObject *meth_QLockFile_getLockInfo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        ::QString* a1;
        ::QString* a2;
        const ::QLockFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLockFile, &sipCpp))
        {
            bool sipRes;
            a1 = new ::QString();
            a2 = new ::QString();

            sipRes = sipCpp->getLockInfo(&a0, a1, a2);

            return sipBuildResult(0, "(bnNN)", sipRes, a0, a1, sipType_QString, SIP_NULLPTR, a2, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLockFile, sipName_getLockInfo, doc_QLockFile_getLockInfo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLockFile_removeStaleLockFile, "removeStaleLockFile(self) -> bool");

extern "C" {static PyObject *meth_QLockFile_removeStaleLockFile(PyObject *, PyObject *);}
static PyObject *meth_QLockFile_removeStaleLockFile(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QLockFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLockFile, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->removeStaleLockFile();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLockFile, sipName_removeStaleLockFile, doc_QLockFile_removeStaleLockFile);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLockFile_error, "error(self) -> QLockFile.LockError");

extern "C" {static PyObject *meth_QLockFile_error(PyObject *, PyObject *);}
static PyObject *meth_QLockFile_error(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLockFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLockFile, &sipCpp))
        {
            ::QLockFile::LockError sipRes;

            sipRes = sipCpp->error();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QLockFile_LockError);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLockFile, sipName_error, doc_QLockFile_error);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLockFile_fileName, "fileName(self) -> str");

extern "C" {static PyObject *meth_QLockFile_fileName(PyObject *, PyObject *);}
static PyObject *meth_QLockFile_fileName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLockFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLockFile, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->fileName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLockFile, sipName_fileName, doc_QLockFile_fileName);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QLockFile(void *, int);}
static void release_QLockFile(void *sipCppV, int)
{
    delete reinterpret_cast< ::QLockFile *>(sipCppV);
}


extern "C" {static void dealloc_QLockFile(sipSimpleWrapper *);}
static void dealloc_QLockFile(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QLockFile(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QLockFile(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QLockFile(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QLockFile *sipCpp = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QString, &a0, &a0State))
        {
            sipCpp = new ::QLockFile(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QLockFile[] = {
    {sipName_error, meth_QLockFile_error, METH_VARARGS, doc_QLockFile_error},
    {sipName_fileName, meth_QLockFile_fileName, METH_VARARGS, doc_QLockFile_fileName},
    {sipName_getLockInfo, meth_QLockFile_getLockInfo, METH_VARARGS, doc_QLockFile_getLockInfo},
    {sipName_isLocked, meth_QLockFile_isLocked, METH_VARARGS, doc_QLockFile_isLocked},
    {sipName_lock, meth_QLockFile_lock, METH_VARARGS, doc_QLockFile_lock},
    {sipName_removeStaleLockFile, meth_QLockFile_removeStaleLockFile, METH_VARARGS, doc_QLockFile_removeStaleLockFile},
    {sipName_setStaleLockTime, meth_QLockFile_setStaleLockTime, METH_VARARGS, doc_QLockFile_setStaleLockTime},
    {sipName_staleLockTime, meth_QLockFile_staleLockTime, METH_VARARGS, doc_QLockFile_staleLockTime},
    {sipName_tryLock, SIP_MLMETH_CAST(meth_QLockFile_tryLock), METH_VARARGS|METH_KEYWORDS, doc_QLockFile_tryLock},
    {sipName_unlock, meth_QLockFile_unlock, METH_VARARGS, doc_QLockFile_unlock}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QLockFile[] = {
    {sipName_NoError, static_cast<int>(::QLockFile::NoError)},
    {sipName_LockFailedError, static_cast<int>(::QLockFile::LockFailedError)},
    {sipName_PermissionError, static_cast<int>(::QLockFile::PermissionError)},
    {sipName_UnknownError, static_cast<int>(::QLockFile::UnknownError)},
    {0, 0}
};

PyDoc_STRVAR(doc_QLockFile, "\1QLockFile(fileName: str|None)");


sipClassTypeDef sipTypeDef_QtCore_QLockFile = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QLockFile,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QLockFile,
        {0, 0, 1},
        10, methods_QLockFile,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QLockFile, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QLockFile,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QLockFile,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QLockFile,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QLockFile,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QLockFile),
};
