/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qtimezone.sip"
#include <qtimezone.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQTimeZone.cpp"

#line 30 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQTimeZone.cpp"
#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQTimeZone.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qlocale.sip"
#include <qlocale.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQTimeZone.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQTimeZone.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQTimeZone.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qtimezone.sip"
#include <qtimezone.h>
#line 50 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qtimezone.sip"
#include <qtimezone.h>
#line 50 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQTimeZone.cpp"
#line 360 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 53 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQTimeZone.cpp"


PyDoc_STRVAR(doc_QTimeZone_swap, "swap(self, other: QTimeZone)");

extern "C" {static PyObject *meth_QTimeZone_swap(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QTimeZone* a0;
        ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QTimeZone, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_swap, doc_QTimeZone_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QTimeZone_isValid(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTimeZone, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_isValid, doc_QTimeZone_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_id, "id(self) -> QByteArray");

extern "C" {static PyObject *meth_QTimeZone_id(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_id(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTimeZone, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->id());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_id, doc_QTimeZone_id);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_country, "country(self) -> QLocale.Country");

extern "C" {static PyObject *meth_QTimeZone_country(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_country(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTimeZone, &sipCpp))
        {
            ::QLocale::Country sipRes;

            sipRes = sipCpp->country();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QLocale_Country);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_country, doc_QTimeZone_country);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_comment, "comment(self) -> str");

extern "C" {static PyObject *meth_QTimeZone_comment(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_comment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTimeZone, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->comment());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_comment, doc_QTimeZone_comment);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_displayName, "displayName(self, atDateTime: QDateTime|datetime.datetime, nameType: QTimeZone.NameType = QTimeZone.DefaultName, locale: QLocale = QLocale()) -> str\n"
"displayName(self, timeType: QTimeZone.TimeType, nameType: QTimeZone.NameType = QTimeZone.DefaultName, locale: QLocale = QLocale()) -> str");

extern "C" {static PyObject *meth_QTimeZone_displayName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_displayName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDateTime* a0;
        int a0State = 0;
        ::QTimeZone::NameType a1 = QTimeZone::DefaultName;
        const ::QLocale& a2def = QLocale();
        const ::QLocale* a2 = &a2def;
        const ::QTimeZone *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_nameType,
            sipName_locale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|EJ9", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QDateTime, &a0, &a0State, sipType_QTimeZone_NameType, &a1, sipType_QLocale, &a2))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->displayName(*a0, a1, *a2));
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    {
        ::QTimeZone::TimeType a0;
        ::QTimeZone::NameType a1 = QTimeZone::DefaultName;
        const ::QLocale& a2def = QLocale();
        const ::QLocale* a2 = &a2def;
        const ::QTimeZone *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_nameType,
            sipName_locale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE|EJ9", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QTimeZone_TimeType, &a0, sipType_QTimeZone_NameType, &a1, sipType_QLocale, &a2))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->displayName(a0, a1, *a2));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_displayName, doc_QTimeZone_displayName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_abbreviation, "abbreviation(self, atDateTime: QDateTime|datetime.datetime) -> str");

extern "C" {static PyObject *meth_QTimeZone_abbreviation(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_abbreviation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDateTime* a0;
        int a0State = 0;
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->abbreviation(*a0));
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_abbreviation, doc_QTimeZone_abbreviation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_offsetFromUtc, "offsetFromUtc(self, atDateTime: QDateTime|datetime.datetime) -> int");

extern "C" {static PyObject *meth_QTimeZone_offsetFromUtc(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_offsetFromUtc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDateTime* a0;
        int a0State = 0;
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
            int sipRes;

            sipRes = sipCpp->offsetFromUtc(*a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_offsetFromUtc, doc_QTimeZone_offsetFromUtc);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_standardTimeOffset, "standardTimeOffset(self, atDateTime: QDateTime|datetime.datetime) -> int");

extern "C" {static PyObject *meth_QTimeZone_standardTimeOffset(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_standardTimeOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDateTime* a0;
        int a0State = 0;
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
            int sipRes;

            sipRes = sipCpp->standardTimeOffset(*a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_standardTimeOffset, doc_QTimeZone_standardTimeOffset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_daylightTimeOffset, "daylightTimeOffset(self, atDateTime: QDateTime|datetime.datetime) -> int");

extern "C" {static PyObject *meth_QTimeZone_daylightTimeOffset(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_daylightTimeOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDateTime* a0;
        int a0State = 0;
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
            int sipRes;

            sipRes = sipCpp->daylightTimeOffset(*a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_daylightTimeOffset, doc_QTimeZone_daylightTimeOffset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_hasDaylightTime, "hasDaylightTime(self) -> bool");

extern "C" {static PyObject *meth_QTimeZone_hasDaylightTime(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_hasDaylightTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTimeZone, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->hasDaylightTime();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_hasDaylightTime, doc_QTimeZone_hasDaylightTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_isDaylightTime, "isDaylightTime(self, atDateTime: QDateTime|datetime.datetime) -> bool");

extern "C" {static PyObject *meth_QTimeZone_isDaylightTime(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_isDaylightTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDateTime* a0;
        int a0State = 0;
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->isDaylightTime(*a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_isDaylightTime, doc_QTimeZone_isDaylightTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_offsetData, "offsetData(self, forDateTime: QDateTime|datetime.datetime) -> QTimeZone.OffsetData");

extern "C" {static PyObject *meth_QTimeZone_offsetData(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_offsetData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDateTime* a0;
        int a0State = 0;
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
            ::QTimeZone::OffsetData*sipRes;

            sipRes = new ::QTimeZone::OffsetData(sipCpp->offsetData(*a0));
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return sipConvertFromNewType(sipRes, sipType_QTimeZone_OffsetData, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_offsetData, doc_QTimeZone_offsetData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_hasTransitions, "hasTransitions(self) -> bool");

extern "C" {static PyObject *meth_QTimeZone_hasTransitions(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_hasTransitions(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QTimeZone, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->hasTransitions();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_hasTransitions, doc_QTimeZone_hasTransitions);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_nextTransition, "nextTransition(self, afterDateTime: QDateTime|datetime.datetime) -> QTimeZone.OffsetData");

extern "C" {static PyObject *meth_QTimeZone_nextTransition(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_nextTransition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDateTime* a0;
        int a0State = 0;
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
            ::QTimeZone::OffsetData*sipRes;

            sipRes = new ::QTimeZone::OffsetData(sipCpp->nextTransition(*a0));
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return sipConvertFromNewType(sipRes, sipType_QTimeZone_OffsetData, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_nextTransition, doc_QTimeZone_nextTransition);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_previousTransition, "previousTransition(self, beforeDateTime: QDateTime|datetime.datetime) -> QTimeZone.OffsetData");

extern "C" {static PyObject *meth_QTimeZone_previousTransition(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_previousTransition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDateTime* a0;
        int a0State = 0;
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
            ::QTimeZone::OffsetData*sipRes;

            sipRes = new ::QTimeZone::OffsetData(sipCpp->previousTransition(*a0));
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return sipConvertFromNewType(sipRes, sipType_QTimeZone_OffsetData, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_previousTransition, doc_QTimeZone_previousTransition);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_transitions, "transitions(self, fromDateTime: QDateTime|datetime.datetime, toDateTime: QDateTime|datetime.datetime) -> list[QTimeZone.OffsetData]");

extern "C" {static PyObject *meth_QTimeZone_transitions(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_transitions(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDateTime* a0;
        int a0State = 0;
        const ::QDateTime* a1;
        int a1State = 0;
        const ::QTimeZone *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QTimeZone, &sipCpp, sipType_QDateTime, &a0, &a0State, sipType_QDateTime, &a1, &a1State))
        {
            ::QTimeZone::OffsetDataList*sipRes;

            sipRes = new ::QTimeZone::OffsetDataList(sipCpp->transitions(*a0, *a1));
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);
            sipReleaseType(const_cast< ::QDateTime *>(a1), sipType_QDateTime, a1State);

            return sipConvertFromNewType(sipRes, sipType_QVector_0100QTimeZone_OffsetData, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_transitions, doc_QTimeZone_transitions);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_systemTimeZoneId, "systemTimeZoneId() -> QByteArray");

extern "C" {static PyObject *meth_QTimeZone_systemTimeZoneId(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_systemTimeZoneId(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QTimeZone::systemTimeZoneId());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_systemTimeZoneId, doc_QTimeZone_systemTimeZoneId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_isTimeZoneIdAvailable, "isTimeZoneIdAvailable(ianaId: QByteArray|bytes|bytearray) -> bool");

extern "C" {static PyObject *meth_QTimeZone_isTimeZoneIdAvailable(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_isTimeZoneIdAvailable(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = ::QTimeZone::isTimeZoneIdAvailable(*a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_isTimeZoneIdAvailable, doc_QTimeZone_isTimeZoneIdAvailable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_availableTimeZoneIds, "availableTimeZoneIds() -> list[QByteArray]\n"
"availableTimeZoneIds(country: QLocale.Country) -> list[QByteArray]\n"
"availableTimeZoneIds(offsetSeconds: int) -> list[QByteArray]");

extern "C" {static PyObject *meth_QTimeZone_availableTimeZoneIds(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_availableTimeZoneIds(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            QList< ::QByteArray>*sipRes;

            sipRes = new QList< ::QByteArray>(::QTimeZone::availableTimeZoneIds());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    {
        ::QLocale::Country a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "XE", sipType_QLocale_Country, &a0))
        {
            QList< ::QByteArray>*sipRes;

            sipRes = new QList< ::QByteArray>(::QTimeZone::availableTimeZoneIds(a0));

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            QList< ::QByteArray>*sipRes;

            sipRes = new QList< ::QByteArray>(::QTimeZone::availableTimeZoneIds(a0));

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_availableTimeZoneIds, doc_QTimeZone_availableTimeZoneIds);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_ianaIdToWindowsId, "ianaIdToWindowsId(ianaId: QByteArray|bytes|bytearray) -> QByteArray");

extern "C" {static PyObject *meth_QTimeZone_ianaIdToWindowsId(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_ianaIdToWindowsId(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QByteArray, &a0, &a0State))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QTimeZone::ianaIdToWindowsId(*a0));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_ianaIdToWindowsId, doc_QTimeZone_ianaIdToWindowsId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_windowsIdToDefaultIanaId, "windowsIdToDefaultIanaId(windowsId: QByteArray|bytes|bytearray) -> QByteArray\n"
"windowsIdToDefaultIanaId(windowsId: QByteArray|bytes|bytearray, country: QLocale.Country) -> QByteArray");

extern "C" {static PyObject *meth_QTimeZone_windowsIdToDefaultIanaId(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_windowsIdToDefaultIanaId(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QByteArray, &a0, &a0State))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QTimeZone::windowsIdToDefaultIanaId(*a0));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QLocale::Country a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1E", sipType_QByteArray, &a0, &a0State, sipType_QLocale_Country, &a1))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QTimeZone::windowsIdToDefaultIanaId(*a0, a1));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_windowsIdToDefaultIanaId, doc_QTimeZone_windowsIdToDefaultIanaId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_windowsIdToIanaIds, "windowsIdToIanaIds(windowsId: QByteArray|bytes|bytearray) -> list[QByteArray]\n"
"windowsIdToIanaIds(windowsId: QByteArray|bytes|bytearray, country: QLocale.Country) -> list[QByteArray]");

extern "C" {static PyObject *meth_QTimeZone_windowsIdToIanaIds(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_windowsIdToIanaIds(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QByteArray, &a0, &a0State))
        {
            QList< ::QByteArray>*sipRes;

            sipRes = new QList< ::QByteArray>(::QTimeZone::windowsIdToIanaIds(*a0));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QLocale::Country a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1E", sipType_QByteArray, &a0, &a0State, sipType_QLocale_Country, &a1))
        {
            QList< ::QByteArray>*sipRes;

            sipRes = new QList< ::QByteArray>(::QTimeZone::windowsIdToIanaIds(*a0, a1));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_windowsIdToIanaIds, doc_QTimeZone_windowsIdToIanaIds);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_systemTimeZone, "systemTimeZone() -> QTimeZone");

extern "C" {static PyObject *meth_QTimeZone_systemTimeZone(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_systemTimeZone(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QTimeZone*sipRes;

            sipRes = new ::QTimeZone(::QTimeZone::systemTimeZone());

            return sipConvertFromNewType(sipRes, sipType_QTimeZone, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_systemTimeZone, doc_QTimeZone_systemTimeZone);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QTimeZone_utc, "utc() -> QTimeZone");

extern "C" {static PyObject *meth_QTimeZone_utc(PyObject *, PyObject *);}
static PyObject *meth_QTimeZone_utc(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QTimeZone*sipRes;

            sipRes = new ::QTimeZone(::QTimeZone::utc());

            return sipConvertFromNewType(sipRes, sipType_QTimeZone, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QTimeZone, sipName_utc, doc_QTimeZone_utc);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QTimeZone___ne__(PyObject *, PyObject *);}
static PyObject *slot_QTimeZone___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QTimeZone *sipCpp = reinterpret_cast< ::QTimeZone *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QTimeZone));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTimeZone* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QTimeZone, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QTimeZone::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QTimeZone, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QTimeZone___eq__(PyObject *, PyObject *);}
static PyObject *slot_QTimeZone___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QTimeZone *sipCpp = reinterpret_cast< ::QTimeZone *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QTimeZone));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QTimeZone* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QTimeZone, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QTimeZone::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QTimeZone, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QTimeZone(void *, int);}
static void release_QTimeZone(void *sipCppV, int)
{
    delete reinterpret_cast< ::QTimeZone *>(sipCppV);
}


extern "C" {static void *array_QTimeZone(Py_ssize_t);}
static void *array_QTimeZone(Py_ssize_t sipNrElem)
{
    return new ::QTimeZone[sipNrElem];
}


extern "C" {static void array_delete_QTimeZone(void *);}
static void array_delete_QTimeZone(void *sipCpp)
{
    delete[] reinterpret_cast< ::QTimeZone *>(sipCpp);
}


extern "C" {static void assign_QTimeZone(void *, Py_ssize_t, void *);}
static void assign_QTimeZone(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QTimeZone *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QTimeZone *>(sipSrc);
}


extern "C" {static void *copy_QTimeZone(const void *, Py_ssize_t);}
static void *copy_QTimeZone(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QTimeZone(reinterpret_cast<const ::QTimeZone *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QTimeZone(sipSimpleWrapper *);}
static void dealloc_QTimeZone(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QTimeZone(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QTimeZone(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QTimeZone(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QTimeZone *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QTimeZone();

            return sipCpp;
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QByteArray, &a0, &a0State))
        {
            sipCpp = new ::QTimeZone(*a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipCpp;
        }
    }

    {
        int a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "i", &a0))
        {
            sipCpp = new ::QTimeZone(a0);

            return sipCpp;
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;
        int a1;
        const ::QString* a2;
        int a2State = 0;
        const ::QString* a3;
        int a3State = 0;
        ::QLocale::Country a4 = QLocale::AnyCountry;
        const ::QString& a5def = QString();
        const ::QString* a5 = &a5def;
        int a5State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_country,
            sipName_comment,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1iJ1J1|EJ1", sipType_QByteArray, &a0, &a0State, &a1, sipType_QString, &a2, &a2State, sipType_QString, &a3, &a3State, sipType_QLocale_Country, &a4, sipType_QString, &a5, &a5State))
        {
            sipCpp = new ::QTimeZone(*a0, a1, *a2, *a3, a4, *a5);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);
            sipReleaseType(const_cast< ::QString *>(a3), sipType_QString, a3State);
            sipReleaseType(const_cast< ::QString *>(a5), sipType_QString, a5State);

            return sipCpp;
        }
    }

    {
        const ::QTimeZone* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QTimeZone, &a0))
        {
            sipCpp = new ::QTimeZone(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QTimeZone[] = {
    {(void *)slot_QTimeZone___ne__, ne_slot},
    {(void *)slot_QTimeZone___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QTimeZone[] = {
    {sipName_abbreviation, meth_QTimeZone_abbreviation, METH_VARARGS, doc_QTimeZone_abbreviation},
    {sipName_availableTimeZoneIds, meth_QTimeZone_availableTimeZoneIds, METH_VARARGS, doc_QTimeZone_availableTimeZoneIds},
    {sipName_comment, meth_QTimeZone_comment, METH_VARARGS, doc_QTimeZone_comment},
    {sipName_country, meth_QTimeZone_country, METH_VARARGS, doc_QTimeZone_country},
    {sipName_daylightTimeOffset, meth_QTimeZone_daylightTimeOffset, METH_VARARGS, doc_QTimeZone_daylightTimeOffset},
    {sipName_displayName, SIP_MLMETH_CAST(meth_QTimeZone_displayName), METH_VARARGS|METH_KEYWORDS, doc_QTimeZone_displayName},
    {sipName_hasDaylightTime, meth_QTimeZone_hasDaylightTime, METH_VARARGS, doc_QTimeZone_hasDaylightTime},
    {sipName_hasTransitions, meth_QTimeZone_hasTransitions, METH_VARARGS, doc_QTimeZone_hasTransitions},
    {sipName_ianaIdToWindowsId, meth_QTimeZone_ianaIdToWindowsId, METH_VARARGS, doc_QTimeZone_ianaIdToWindowsId},
    {sipName_id, meth_QTimeZone_id, METH_VARARGS, doc_QTimeZone_id},
    {sipName_isDaylightTime, meth_QTimeZone_isDaylightTime, METH_VARARGS, doc_QTimeZone_isDaylightTime},
    {sipName_isTimeZoneIdAvailable, meth_QTimeZone_isTimeZoneIdAvailable, METH_VARARGS, doc_QTimeZone_isTimeZoneIdAvailable},
    {sipName_isValid, meth_QTimeZone_isValid, METH_VARARGS, doc_QTimeZone_isValid},
    {sipName_nextTransition, meth_QTimeZone_nextTransition, METH_VARARGS, doc_QTimeZone_nextTransition},
    {sipName_offsetData, meth_QTimeZone_offsetData, METH_VARARGS, doc_QTimeZone_offsetData},
    {sipName_offsetFromUtc, meth_QTimeZone_offsetFromUtc, METH_VARARGS, doc_QTimeZone_offsetFromUtc},
    {sipName_previousTransition, meth_QTimeZone_previousTransition, METH_VARARGS, doc_QTimeZone_previousTransition},
    {sipName_standardTimeOffset, meth_QTimeZone_standardTimeOffset, METH_VARARGS, doc_QTimeZone_standardTimeOffset},
    {sipName_swap, meth_QTimeZone_swap, METH_VARARGS, doc_QTimeZone_swap},
    {sipName_systemTimeZone, meth_QTimeZone_systemTimeZone, METH_VARARGS, doc_QTimeZone_systemTimeZone},
    {sipName_systemTimeZoneId, meth_QTimeZone_systemTimeZoneId, METH_VARARGS, doc_QTimeZone_systemTimeZoneId},
    {sipName_transitions, meth_QTimeZone_transitions, METH_VARARGS, doc_QTimeZone_transitions},
    {sipName_utc, meth_QTimeZone_utc, METH_VARARGS, doc_QTimeZone_utc},
    {sipName_windowsIdToDefaultIanaId, meth_QTimeZone_windowsIdToDefaultIanaId, METH_VARARGS, doc_QTimeZone_windowsIdToDefaultIanaId},
    {sipName_windowsIdToIanaIds, meth_QTimeZone_windowsIdToIanaIds, METH_VARARGS, doc_QTimeZone_windowsIdToIanaIds}
};

static sipEnumMemberDef enummembers_QTimeZone[] = {
    {sipName_DaylightTime, static_cast<int>(::QTimeZone::DaylightTime), 305},
    {sipName_DefaultName, static_cast<int>(::QTimeZone::DefaultName), 303},
    {sipName_GenericTime, static_cast<int>(::QTimeZone::GenericTime), 305},
    {sipName_LongName, static_cast<int>(::QTimeZone::LongName), 303},
    {sipName_OffsetName, static_cast<int>(::QTimeZone::OffsetName), 303},
    {sipName_ShortName, static_cast<int>(::QTimeZone::ShortName), 303},
    {sipName_StandardTime, static_cast<int>(::QTimeZone::StandardTime), 305},
};

PyDoc_STRVAR(doc_QTimeZone, "\1QTimeZone()\n"
"QTimeZone(ianaId: QByteArray|bytes|bytearray)\n"
"QTimeZone(offsetSeconds: int)\n"
"QTimeZone(zoneId: QByteArray|bytes|bytearray, offsetSeconds: int, name: str|None, abbreviation: str|None, country: QLocale.Country = QLocale.AnyCountry, comment: str|None = '')\n"
"QTimeZone(other: QTimeZone)");


static pyqt5ClassPluginDef plugin_QTimeZone = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtCore_QTimeZone = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QTimeZone,
        SIP_NULLPTR,
        &plugin_QTimeZone,
    },
    {
        sipNameNr_QTimeZone,
        {0, 0, 1},
        25, methods_QTimeZone,
        7, enummembers_QTimeZone,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QTimeZone,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QTimeZone,
    init_type_QTimeZone,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QTimeZone,
    assign_QTimeZone,
    array_QTimeZone,
    copy_QTimeZone,
    release_QTimeZone,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QTimeZone,
    sizeof (::QTimeZone),
};
